<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Fetch claims
$sql = "SELECT 
    b.claim_no,
    b.invoice_no,
    b.invoice_date,
    b.invoiced_amount,
    b.vet_status,
    m.surname,
    m.first_name,
    c.corporate,
    p.provider_name,
    b.service
FROM bills b
LEFT JOIN member_info m ON b.member_no = m.member_no
LEFT JOIN corporate c ON b.corp_id = c.corp_id
LEFT JOIN providers p ON b.provider = p.provider_id
ORDER BY b.claim_no, b.invoice_no";

$result = $conn->query($sql);
$claims = [];
while($row = $result->fetch_assoc()) {
    $claims[] = $row;
}
?>

<!DOCTYPE html>
<html>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Claims List')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" rel="stylesheet">
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Claims', 'title' => 'Claims List')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0 flex-grow-1">Claims List</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="claims-table" class="table table-striped table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Claim No</th>
                                                    <th>Invoice No</th>
                                                    <th>Member</th>
                                                    <th>Corporate</th>
                                                    <th>Provider</th>
                                                    <th>Invoice Date</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($claims as $claim): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($claim['claim_no']); ?></td>
                                                        <td><?php echo htmlspecialchars($claim['invoice_no']); ?></td>
                                                        <td><?php echo htmlspecialchars($claim['surname'] . ' ' . $claim['first_name']); ?></td>
                                                        <td><?php echo htmlspecialchars($claim['corporate']); ?></td>
                                                        <td><?php echo htmlspecialchars($claim['provider_name']); ?></td>
                                                        <td><?php echo date('d M Y', strtotime($claim['invoice_date'])); ?></td>
                                                        <td class="text-end"><?php echo number_format($claim['invoiced_amount'], 2); ?></td>
                                                        <td>
                                                            <?php 
                                                            $status_class = '';
                                                            $status_text = '';
                                                            switch($claim['vet_status']) {
                                                                case 1:
                                                                    $status_class = 'bg-success';
                                                                    $status_text = 'Approved';
                                                                    break;
                                                                case 2:
                                                                    $status_class = 'bg-danger';
                                                                    $status_text = 'Rejected';
                                                                    break;
                                                                case 3:
                                                                    $status_class = 'bg-warning';
                                                                    $status_text = 'Deferred';
                                                                    break;
                                                                default:
                                                                    $status_class = 'bg-info';
                                                                    $status_text = 'Pending';
                                                            }
                                                            ?>
                                                            <span class="badge <?php echo $status_class; ?>">
                                                                <?php echo htmlspecialchars($claim['invoice_no'] . ' - ' . $status_text); ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <div class="dropdown">
                                                                <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown">
                                                                    <i class="ri-more-fill align-middle"></i>
                                                                </button>
                                                                <ul class="dropdown-menu dropdown-menu-end">
                                                                    <?php if (empty($claim['vet_status']) || $claim['vet_status'] == 0): ?>
                                                                        <li>
                                                                            <a class="dropdown-item" href="vet_claim.php?claim_no=<?php echo urlencode($claim['claim_no']); ?>&invoice_no=<?php echo urlencode($claim['invoice_no']); ?>">
                                                                                <i class="ri-check-double-line align-middle me-1"></i> Vet Invoice
                                                                            </a>
                                                                        </li>
                                                                    <?php endif; ?>
                                                                    <li>
                                                                        <a class="dropdown-item" href="view_claim.php?id=<?php echo urlencode($claim['claim_no']); ?>">
                                                                            <i class="ri-eye-fill align-middle me-1"></i> View Details
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

    <!-- For Export Buttons -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="assets/js/app.js"></script>
    <script>
        $(document).ready(function() {
            $('#claims-table').DataTable({
                pageLength: 25,
                order: [[5, 'desc']], // Sort by invoice date
                columnDefs: [
                    { orderable: false, targets: [8] } // Disable sorting on action column
                ]
            });
        });
    </script>
</body>
</html>