-- Database Backup
-- Generated: 2025-05-26 08:20:40

SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `active_corporate_discounts`;
CREATE ALGORITHM=UNDEFINED DEFINER=`homecar1`@`localhost` SQL SECURITY DEFINER VIEW `active_corporate_discounts` AS select `cd`.`discount_id` AS `discount_id`,`cd`.`corp_id` AS `corp_id`,`cd`.`benefit` AS `benefit`,`cd`.`min_members` AS `min_members`,`cd`.`discount_percent` AS `discount_percent`,`cd`.`start_date` AS `start_date`,`cd`.`end_date` AS `end_date`,`cd`.`status` AS `status`,`cd`.`created_by` AS `created_by`,`cd`.`created_at` AS `created_at`,`cd`.`modified_by` AS `modified_by`,`cd`.`modified_at` AS `modified_at`,`c`.`corporate` AS `corporate`,`b`.`benefit` AS `benefit_name` from ((`corporate_discounts` `cd` join `corporate` `c` on((`cd`.`corp_id` = `c`.`corp_id`))) left join `benefit` `b` on((`cd`.`benefit` = `b`.`code`))) where ((`cd`.`status` = 'ACTIVE') and ((`cd`.`start_date` is null) or (`cd`.`start_date` <= curdate())) and ((`cd`.`end_date` is null) or (`cd`.`end_date` >= curdate())));

DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE `activity_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `action` enum('CREATE','UPDATE','DELETE','LOGIN','LOGOUT') COLLATE utf8mb4_general_ci NOT NULL,
  `table_name` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `record_id` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `old_values` text COLLATE utf8mb4_general_ci,
  `new_values` text COLLATE utf8mb4_general_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `action_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `additional_info` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`log_id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_action` (`action`),
  KEY `idx_table` (`table_name`),
  KEY `idx_date` (`action_date`)
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `activity_logs`;
CREATE TABLE `activity_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `activity_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `related_to` varchar(50) DEFAULT NULL,
  `related_id` int DEFAULT NULL,
  `old_values` text,
  `new_values` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `activity_type` (`activity_type`),
  KEY `related_to_id` (`related_to`,`related_id`),
  CONSTRAINT `fk_activity_logs_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `admin_logs`;
CREATE TABLE `admin_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `user_id` (`user_id`),
  KEY `action` (`action`),
  KEY `created_at` (`created_at`),
  CONSTRAINT `admin_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `agent`;
CREATE TABLE `agent` (
  `agent_id` int NOT NULL AUTO_INCREMENT,
  `agent_name` varchar(70) COLLATE utf8mb4_general_ci NOT NULL,
  `agent_type` int NOT NULL,
  `tel_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `mobile_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `postal_add` varchar(15) COLLATE utf8mb4_general_ci NOT NULL,
  `town` int NOT NULL,
  `phy_loc` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `date_entered` date NOT NULL,
  `unit_manager` varchar(15) COLLATE utf8mb4_general_ci NOT NULL,
  `branch` varchar(5) COLLATE utf8mb4_general_ci NOT NULL,
  `branch_manager` varchar(15) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_person` varchar(70) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_tel` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `contact_mobile` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `unit` varchar(30) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`agent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `agent_documents`;
CREATE TABLE `agent_documents` (
  `doc_id` int NOT NULL AUTO_INCREMENT,
  `agent_id` int NOT NULL,
  `doc_type` enum('IRA_LICENSE','ANNUAL_CONTRACT') NOT NULL,
  `doc_path` varchar(255) NOT NULL,
  `upload_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiry_date` date DEFAULT NULL,
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `verified_by` int DEFAULT NULL,
  `verified_at` timestamp NULL DEFAULT NULL,
  `status` enum('PENDING','APPROVED','REJECTED') NOT NULL DEFAULT 'PENDING',
  PRIMARY KEY (`doc_id`),
  KEY `agent_id` (`agent_id`),
  CONSTRAINT `agent_documents_ibfk_1` FOREIGN KEY (`agent_id`) REFERENCES `agents` (`agent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `agents`;
CREATE TABLE `agents` (
  `agent_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `branch_id` int NOT NULL,
  `agent_code` varchar(20) NOT NULL,
  `ira_license_no` varchar(50) NOT NULL,
  `license_expiry` date NOT NULL,
  `status` enum('ACTIVE','INACTIVE','SUSPENDED') NOT NULL DEFAULT 'ACTIVE',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int NOT NULL,
  `license_verified` tinyint(1) DEFAULT '0',
  `license_verified_by` int DEFAULT NULL,
  `license_verified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`agent_id`),
  UNIQUE KEY `agent_code` (`agent_code`),
  KEY `user_id` (`user_id`),
  KEY `branch_id` (`branch_id`),
  KEY `license_verified_by` (`license_verified_by`),
  CONSTRAINT `agents_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `agents_ibfk_2` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`branch_id`),
  CONSTRAINT `agents_ibfk_3` FOREIGN KEY (`license_verified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `api_auth`;
CREATE TABLE `api_auth` (
  `id` int NOT NULL AUTO_INCREMENT,
  `client_id` varchar(150) COLLATE utf8mb4_general_ci NOT NULL,
  `client_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `secret_key` varchar(200) COLLATE utf8mb4_general_ci NOT NULL,
  `token` varchar(2048) COLLATE utf8mb4_general_ci NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `password` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `api_key` varchar(750) COLLATE utf8mb4_general_ci GENERATED ALWAYS AS (md5(`client_id`)) STORED,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `api_category_change`;
CREATE TABLE `api_category_change` (
  `id` int NOT NULL AUTO_INCREMENT,
  `policy_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `member_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `category` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `sync` decimal(1,0) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `api_diagnosis`;
CREATE TABLE `api_diagnosis` (
  `idx` bigint NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `invoice_no` varchar(30) COLLATE utf8mb4_general_ci NOT NULL,
  `diagnosis` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `api_member_edits`;
CREATE TABLE `api_member_edits` (
  `idx` int NOT NULL AUTO_INCREMENT,
  `family_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `member_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `staff_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `surname` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `first_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `other_names` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `family_title` decimal(3,0) DEFAULT NULL,
  `id_pp_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `gender` decimal(2,0) DEFAULT NULL,
  `nhif_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `sync` decimal(1,0) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  PRIMARY KEY (`idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `audit_log`;
CREATE TABLE `audit_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `action_type` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `table_name` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `record_id` int NOT NULL,
  `user_id` int NOT NULL,
  `action_date` datetime NOT NULL,
  `details` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_action_date` (`action_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `auto_debit_log`;
CREATE TABLE `auto_debit_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `run_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `debit_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `status` enum('SUCCESS','FAILED') COLLATE utf8mb4_general_ci NOT NULL,
  `message` text COLLATE utf8mb4_general_ci,
  `error_message` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`log_id`),
  KEY `idx_run_date` (`run_date`),
  KEY `idx_corp_id` (`corp_id`),
  CONSTRAINT `fk_log_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `auto_debit_runs`;
CREATE TABLE `auto_debit_runs` (
  `run_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `run_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('SUCCESS','FAILED') COLLATE utf8mb4_general_ci NOT NULL,
  `debits_generated` int NOT NULL DEFAULT '0',
  `total_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `error_message` text COLLATE utf8mb4_general_ci,
  `initiated_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`run_id`),
  KEY `idx_date` (`run_date`),
  KEY `idx_status` (`status`),
  KEY `initiated_by` (`initiated_by`),
  CONSTRAINT `auto_debit_runs_ibfk_1` FOREIGN KEY (`initiated_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `backup_settings`;
CREATE TABLE `backup_settings` (
  `setting_id` int NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `setting_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `banks`;
CREATE TABLE `banks` (
  `bank_code` int NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `bank_branch` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `swift_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bank_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contact_person` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tel_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `date_entered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int DEFAULT NULL,
  `last_modified` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  PRIMARY KEY (`bank_code`),
  KEY `idx_bank_name` (`bank_name`),
  KEY `idx_bank_active` (`active`),
  KEY `fk_bank_user` (`user_id`),
  KEY `fk_bank_modifier` (`modified_by`),
  CONSTRAINT `fk_bank_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_bank_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `benefit`;
CREATE TABLE `benefit` (
  `code` int NOT NULL AUTO_INCREMENT,
  `benefit` varchar(70) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `benefit_caps`;
CREATE TABLE `benefit_caps` (
  `cap_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_code` int NOT NULL,
  `cap_type` enum('FREQUENCY','AMOUNT') COLLATE utf8mb4_general_ci NOT NULL,
  `cap_value` decimal(15,2) NOT NULL,
  `period` enum('PER_VISIT','MONTHLY','QUARTERLY','ANNUALLY','PER_ADMISSION') COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`cap_id`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_benefit` (`benefit_code`),
  KEY `idx_status` (`status`),
  KEY `fk_cap_creator` (`created_by`),
  KEY `fk_cap_modifier` (`modified_by`),
  CONSTRAINT `fk_cap_benefit` FOREIGN KEY (`benefit_code`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_cap_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_cap_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_cap_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `benefit_rules`;
CREATE TABLE `benefit_rules` (
  `rule_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `category_code` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_code` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `is_waitingperiod` tinyint(1) DEFAULT '0',
  `waiting_days` int DEFAULT NULL,
  `waiting_months` int DEFAULT NULL,
  `is_autogrowth` tinyint(1) DEFAULT '0',
  `autogrowth_rate_type` enum('PERCENTAGE','FIXED','FAMILY_SIZE') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `autogrowth_rate` decimal(10,2) DEFAULT NULL,
  `autogrowth_min` int DEFAULT NULL,
  `autogrowth_max` int DEFAULT NULL,
  `is_buffer` tinyint(1) DEFAULT '0',
  `buffer_type` enum('PERCENTAGE','FIXED') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `buffer_limit` decimal(10,2) DEFAULT NULL,
  `is_frequency` tinyint(1) DEFAULT '0',
  `frequency_limit` int DEFAULT NULL,
  `status` enum('ACTIVE','SUSPENDED','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `suspended_at` timestamp NULL DEFAULT NULL,
  `suspension_reason` text COLLATE utf8mb4_general_ci,
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rule_id`),
  UNIQUE KEY `uq_corp_cat_ben` (`corp_id`,`category_code`,`benefit_code`),
  KEY `idx_status` (`status`),
  KEY `fk_rules_creator` (`created_by`),
  KEY `fk_rules_updater` (`updated_by`),
  CONSTRAINT `fk_rules_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_rules_updater` FOREIGN KEY (`updated_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `benefit_sharing`;
CREATE TABLE `benefit_sharing` (
  `code` int NOT NULL,
  `sharing` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `bill_vet`;
CREATE TABLE `bill_vet` (
  `claim_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `invoice_no` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `service` int NOT NULL,
  `provider` int NOT NULL,
  `vet_status` tinyint(1) NOT NULL,
  `reasons` tinyint NOT NULL,
  `remarks` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `vet_datetime` time DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  PRIMARY KEY (`invoice_no`,`service`,`provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `bills`;
CREATE TABLE `bills` (
  `claim_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `claim_form_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `invoice_no` varchar(30) COLLATE utf8mb4_general_ci NOT NULL,
  `service` int NOT NULL,
  `provider` int NOT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `claim_nature` varchar(25) COLLATE utf8mb4_general_ci NOT NULL,
  `batch_no` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invoice_date` date NOT NULL,
  `invoiced_amount` decimal(10,0) NOT NULL,
  `date_received` date DEFAULT NULL,
  `vet_status` tinyint(1) DEFAULT NULL,
  `deduction_amount` decimal(10,0) DEFAULT NULL,
  `deduction_reason` int DEFAULT NULL,
  `amount_payable` decimal(10,0) DEFAULT NULL,
  `paid` tinyint(1) DEFAULT NULL,
  `anniv` tinyint DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `voucher_no` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `voucher_user` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `voucher_date` date DEFAULT NULL,
  `payment_no` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `refund` tinyint(1) DEFAULT NULL,
  `admin_fee` decimal(10,0) DEFAULT NULL,
  `fund` tinyint(1) DEFAULT NULL,
  `pre_auth_no` int DEFAULT NULL,
  `corp_id` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `family_no` varchar(30) COLLATE utf8mb4_general_ci NOT NULL,
  `pri_dep` tinyint NOT NULL,
  `is_reimbursement` tinyint(1) DEFAULT '0',
  `reimbursement_bank` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reimbursement_account` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reimbursement_account_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reimbursement_status` enum('PENDING','PAID') COLLATE utf8mb4_general_ci DEFAULT 'PENDING',
  `copay_amount` decimal(15,2) DEFAULT '0.00',
  `copay_type` enum('PERCENTAGE','FIXED') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `copay_value` decimal(15,2) DEFAULT '0.00',
  `payable_amount` decimal(15,2) DEFAULT '0.00',
  PRIMARY KEY (`invoice_no`,`service`,`provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `bills_payment`;
CREATE TABLE `bills_payment` (
  `payment_no` int NOT NULL AUTO_INCREMENT,
  `cheque_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `cheque_date` date NOT NULL,
  `cheque_amount` decimal(10,0) NOT NULL,
  `provider` varchar(7) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `dispatched` tinyint(1) DEFAULT NULL,
  `date_dispatched` date DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `admin_fee` decimal(10,0) DEFAULT NULL,
  `corp_paid_for` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `self_fund` tinyint(1) DEFAULT NULL,
  `payment_mode` tinyint(1) DEFAULT NULL,
  `voucher_no` varchar(30) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`payment_no`)
) ENGINE=InnoDB AUTO_INCREMENT=20250011 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `branches`;
CREATE TABLE `branches` (
  `branch_id` int NOT NULL AUTO_INCREMENT,
  `branch_name` varchar(100) NOT NULL,
  `region_id` int NOT NULL,
  `status` enum('ACTIVE','INACTIVE') NOT NULL DEFAULT 'ACTIVE',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int NOT NULL,
  PRIMARY KEY (`branch_id`),
  KEY `region_id` (`region_id`),
  CONSTRAINT `branches_ibfk_1` FOREIGN KEY (`region_id`) REFERENCES `regions` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `business_classes`;
CREATE TABLE `business_classes` (
  `class_id` int NOT NULL AUTO_INCREMENT,
  `class_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `class_code` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_by` int DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`class_id`),
  UNIQUE KEY `class_code` (`class_code`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `business_classes_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `business_classes_ibfk_2` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `care_admission`;
CREATE TABLE `care_admission` (
  `member_no` varchar(15) COLLATE utf8mb4_general_ci NOT NULL,
  `pre_auth_no` decimal(7,0) NOT NULL,
  `provider` decimal(7,0) NOT NULL,
  `date_admitted` date NOT NULL,
  `admitting_doc` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `admission_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ward` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `room_no` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bed_no` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `diagnosis` varchar(70) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_discharged` date DEFAULT NULL,
  PRIMARY KEY (`member_no`,`pre_auth_no`,`provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `care_visit`;
CREATE TABLE `care_visit` (
  `visit_no` decimal(7,0) NOT NULL,
  `member_no` varchar(15) COLLATE utf8mb4_general_ci NOT NULL,
  `pre_auth_no` decimal(7,0) NOT NULL,
  `visit_date` date NOT NULL,
  `visited_by` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `presented` decimal(3,0) DEFAULT NULL,
  `incurred_amt` decimal(10,2) DEFAULT NULL,
  `exp_discharge_date` date DEFAULT NULL,
  `care_nurse_comments` varchar(3000) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `doc_comments` varchar(1000) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`visit_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `claim_diagnoses`;
CREATE TABLE `claim_diagnoses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `claim_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `icd10_id` int NOT NULL,
  `primary_diagnosis` tinyint(1) DEFAULT '0',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_claim_no` (`claim_no`),
  KEY `idx_icd10_id` (`icd10_id`),
  KEY `idx_created_by` (`created_by`),
  CONSTRAINT `fk_diag_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_icd10` FOREIGN KEY (`icd10_id`) REFERENCES `icd10_codes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `claim_drafts`;
CREATE TABLE `claim_drafts` (
  `draft_id` int NOT NULL AUTO_INCREMENT,
  `claim_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `family_no` varchar(30) COLLATE utf8mb4_general_ci NOT NULL,
  `provider` int NOT NULL,
  `invoice_date` date NOT NULL,
  `claim_data` json NOT NULL,
  `created_by` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status` enum('draft','processed','cancelled') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'draft',
  PRIMARY KEY (`draft_id`),
  KEY `idx_member_no` (`member_no`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `claim_form`;
CREATE TABLE `claim_form` (
  `claim_no` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `visit_date` date NOT NULL,
  `attending_doc` decimal(5,0) DEFAULT NULL,
  `doctor_sign` decimal(1,0) DEFAULT NULL,
  `doctor_date` date DEFAULT NULL,
  `claim_form_signed` decimal(1,0) DEFAULT NULL,
  `date_admitted` date DEFAULT NULL,
  `date_discharged` date DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `id` decimal(10,0) NOT NULL DEFAULT '0',
  PRIMARY KEY (`claim_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `claim_status_log`;
CREATE TABLE `claim_status_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `claim_no` varchar(20) NOT NULL,
  `invoice_no` varchar(30) NOT NULL,
  `provider` int NOT NULL,
  `status_code` enum('RECEIVED','VALIDATED','VETTED','APPROVED','REJECTED','DEFERRED','PAYMENT_PENDING','PAID','REVERSED') NOT NULL,
  `status_name` varchar(50) NOT NULL,
  `remarks` text,
  `completed` tinyint(1) DEFAULT '0',
  `active` tinyint(1) DEFAULT '0',
  `user_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `idx_claim` (`claim_no`,`invoice_no`,`provider`),
  KEY `idx_status` (`status_code`),
  KEY `idx_user` (`user_id`),
  CONSTRAINT `fk_status_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `client_documents`;
CREATE TABLE `client_documents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `member_no` varchar(255) NOT NULL,
  `corp_id` varchar(255) NOT NULL,
  `doc_type` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `original_name` varchar(255) NOT NULL,
  `file_path` text NOT NULL,
  `description` text,
  `uploaded_by` int NOT NULL,
  `uploaded_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `commission_structures`;
CREATE TABLE `commission_structures` (
  `structure_id` int NOT NULL AUTO_INCREMENT,
  `channel_id` int NOT NULL,
  `business_class` int NOT NULL,
  `agent_commission` decimal(5,2) NOT NULL,
  `unit_manager_override` decimal(5,2) NOT NULL,
  `branch_manager_override` decimal(5,2) NOT NULL,
  `regional_manager_override` decimal(5,2) NOT NULL,
  `effective_from` date NOT NULL,
  `effective_to` date DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_by` int DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`structure_id`),
  KEY `channel_id` (`channel_id`),
  KEY `business_class` (`business_class`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `commission_structures_ibfk_1` FOREIGN KEY (`channel_id`) REFERENCES `distribution_channels` (`channel_id`),
  CONSTRAINT `commission_structures_ibfk_2` FOREIGN KEY (`business_class`) REFERENCES `business_classes` (`class_id`),
  CONSTRAINT `commission_structures_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `commission_structures_ibfk_4` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `commission_transactions`;
CREATE TABLE `commission_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `agent_id` int NOT NULL,
  `policy_no` varchar(50) NOT NULL,
  `premium_amount` decimal(15,2) NOT NULL,
  `commission_amount` decimal(15,2) NOT NULL,
  `commission_type` enum('COMMISSION','OVERRIDE') NOT NULL,
  `transaction_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_status` enum('PENDING','PAID') NOT NULL DEFAULT 'PENDING',
  `payment_date` timestamp NULL DEFAULT NULL,
  `payment_reference` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `agent_id` (`agent_id`),
  CONSTRAINT `commission_transactions_ibfk_1` FOREIGN KEY (`agent_id`) REFERENCES `agents` (`agent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `corp_anniversary`;
CREATE TABLE `corp_anniversary` (
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `anniv` tinyint NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `renewal_date` date NOT NULL,
  `agent_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `renewal_notified` tinyint DEFAULT '0',
  `sync` tinyint DEFAULT '0',
  `smart_sync` tinyint DEFAULT '0',
  `corp_status` varchar(10) COLLATE utf8mb4_general_ci DEFAULT '1',
  `is_renewed` varchar(2) COLLATE utf8mb4_general_ci DEFAULT '0',
  PRIMARY KEY (`corp_id`,`anniv`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `corp_groups`;
CREATE TABLE `corp_groups` (
  `idx` int NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `anniv` int NOT NULL,
  `category` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `benefit` int DEFAULT NULL,
  `sub_limit_of` int DEFAULT NULL,
  `limit` decimal(10,2) DEFAULT NULL,
  `lives` int DEFAULT NULL,
  `sharing` tinyint(1) DEFAULT NULL,
  `fund` tinyint(1) DEFAULT NULL,
  `payment_plan` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `smart_picked` int DEFAULT '0',
  `exceed_limit` int DEFAULT NULL,
  `sync` tinyint(1) DEFAULT NULL,
  `smart_sync` tinyint(1) DEFAULT NULL,
  `utilize` decimal(4,2) DEFAULT NULL,
  `suspend_at` int DEFAULT NULL,
  `waiting_period` int DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `bed_limit` decimal(18,2) DEFAULT NULL,
  `allocate_to` int DEFAULT NULL,
  `allocated_to` int DEFAULT NULL,
  `ward_bed` int DEFAULT NULL,
  `group_limit` decimal(15,2) DEFAULT NULL,
  `susp` tinyint(1) DEFAULT NULL,
  `susp_by` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `susp_date` date DEFAULT NULL,
  `parent_benefit` int DEFAULT NULL,
  PRIMARY KEY (`idx`),
  KEY `idx_corp_id` (`corp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `corp_renewal_status`;
CREATE TABLE `corp_renewal_status` (
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `renewable` tinyint(1) NOT NULL DEFAULT '1',
  `reason` text COLLATE utf8mb4_general_ci,
  `updated_by` int NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`corp_id`),
  KEY `updated_by` (`updated_by`),
  CONSTRAINT `corp_renewal_status_ibfk_1` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `corp_renewal_status_ibfk_2` FOREIGN KEY (`updated_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `corporate`;
CREATE TABLE `corporate` (
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `corporate` varchar(300) COLLATE utf8mb4_general_ci NOT NULL,
  `tel_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fax_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mobile_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `postal_add` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `town` int DEFAULT NULL,
  `phy_loc` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `agent_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `scheme` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  `modified_by` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cancelled` tinyint(1) DEFAULT NULL,
  `insurer` int DEFAULT NULL,
  `underwrite` tinyint(1) DEFAULT NULL,
  `waiting_period` int DEFAULT NULL,
  `enhanced` tinyint(1) DEFAULT NULL,
  `acct_no` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `policy_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `individual` tinyint(1) DEFAULT NULL,
  `idx` int DEFAULT NULL,
  `branch` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_general_ci,
  `web_synced` tinyint(1) DEFAULT NULL,
  `abbreviation` varchar(3) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `smart_picked` int NOT NULL DEFAULT '0',
  `smart_sync` int NOT NULL DEFAULT '0',
  `uploaded` tinyint(1) DEFAULT NULL,
  `corp_pin` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sync` int DEFAULT NULL,
  `outpatient_threshold` decimal(5,2) DEFAULT '80.00',
  `inpatient_threshold` decimal(5,2) DEFAULT '80.00',
  `fund_balance` decimal(15,2) DEFAULT '0.00',
  `suspended_date` date DEFAULT NULL,
  `termination_date` date DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status_reason` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_frequency` enum('MONTHLY','QUARTERLY','SEMI_ANNUAL','ANNUAL') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ANNUAL',
  PRIMARY KEY (`corp_id`),
  KEY `idx_fund_balance` (`fund_balance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `corporate_discounts`;
CREATE TABLE `corporate_discounts` (
  `discount_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit` int DEFAULT NULL COMMENT 'Benefit code, NULL means applies to all benefits',
  `min_members` int NOT NULL COMMENT 'Minimum number of members for discount to apply',
  `discount_percent` decimal(5,2) NOT NULL COMMENT 'Discount percentage',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`discount_id`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_benefit` (`benefit`),
  KEY `idx_status` (`status`),
  KEY `idx_members` (`min_members`),
  KEY `fk_discount_creator` (`created_by`),
  KEY `fk_discount_modifier` (`modified_by`),
  CONSTRAINT `fk_discount_benefit` FOREIGN KEY (`benefit`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_discount_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_discount_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_discount_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `corporate_groups`;
CREATE TABLE `corporate_groups` (
  `group_id` int NOT NULL AUTO_INCREMENT,
  `group_code` varchar(20) NOT NULL,
  `group_name` varchar(100) NOT NULL,
  `description` text,
  `status` tinyint(1) DEFAULT '1',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `group_code` (`group_code`),
  KEY `fk_group_creator` (`created_by`),
  KEY `fk_group_modifier` (`modified_by`),
  CONSTRAINT `fk_group_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_group_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `data_sources`;
CREATE TABLE `data_sources` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text,
  `db_type` varchar(20) NOT NULL DEFAULT 'mysql',
  `db_host` varchar(255) NOT NULL,
  `db_port` int DEFAULT NULL,
  `db_name` varchar(100) NOT NULL,
  `db_username` varchar(100) NOT NULL,
  `db_password` varchar(255) NOT NULL,
  `last_used` datetime DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `debit_schedule`;
CREATE TABLE `debit_schedule` (
  `schedule_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `frequency` enum('MONTHLY','QUARTERLY','SEMI_ANNUAL','ANNUAL') COLLATE utf8mb4_general_ci NOT NULL,
  `next_debit_date` date NOT NULL,
  `period_start` date NOT NULL,
  `period_end` date NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `debit_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` enum('PENDING','GENERATED','SKIPPED') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'PENDING',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`schedule_id`),
  KEY `idx_next_debit` (`next_debit_date`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_status_date` (`status`,`next_debit_date`),
  CONSTRAINT `fk_schedule_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `deduction_reasons`;
CREATE TABLE `deduction_reasons` (
  `code` int NOT NULL AUTO_INCREMENT,
  `description` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `status` tinyint(1) DEFAULT '1',
  `user_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `distribution_channels`;
CREATE TABLE `distribution_channels` (
  `channel_id` int NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(100) NOT NULL,
  `description` text,
  `status` enum('ACTIVE','INACTIVE') NOT NULL DEFAULT 'ACTIVE',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int NOT NULL,
  PRIMARY KEY (`channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `document_verification_history`;
CREATE TABLE `document_verification_history` (
  `history_id` int NOT NULL AUTO_INCREMENT,
  `doc_id` int NOT NULL,
  `action` enum('APPROVE','REJECT') COLLATE utf8mb4_general_ci NOT NULL,
  `action_by` int NOT NULL,
  `action_at` datetime NOT NULL,
  `remarks` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`history_id`),
  KEY `doc_id` (`doc_id`),
  KEY `action_by` (`action_by`),
  CONSTRAINT `document_verification_history_ibfk_1` FOREIGN KEY (`doc_id`) REFERENCES `agent_documents` (`doc_id`),
  CONSTRAINT `document_verification_history_ibfk_2` FOREIGN KEY (`action_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_benefit_configs`;
CREATE TABLE `edi_benefit_configs` (
  `config_id` int NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `category_code` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `modified_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`config_id`),
  KEY `corp_id` (`corp_id`),
  CONSTRAINT `edi_benefit_configs_ibfk_1` FOREIGN KEY (`corp_id`) REFERENCES `corp_groups` (`corp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_benefit_rules`;
CREATE TABLE `edi_benefit_rules` (
  `rule_id` int NOT NULL AUTO_INCREMENT,
  `provider_id` int DEFAULT NULL,
  `benefit_id` int DEFAULT NULL,
  `rule_description` text COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `modified_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rule_id`),
  KEY `provider_id` (`provider_id`),
  KEY `benefit_id` (`benefit_id`),
  CONSTRAINT `edi_benefit_rules_ibfk_1` FOREIGN KEY (`provider_id`) REFERENCES `edi_providers` (`provider_id`),
  CONSTRAINT `edi_benefit_rules_ibfk_2` FOREIGN KEY (`benefit_id`) REFERENCES `edi_benefits` (`benefit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_benefits`;
CREATE TABLE `edi_benefits` (
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `provider_id` int DEFAULT NULL,
  `benefit_code` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `modified_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`benefit_id`),
  KEY `provider_id` (`provider_id`),
  CONSTRAINT `edi_benefits_ibfk_1` FOREIGN KEY (`provider_id`) REFERENCES `edi_providers` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_claims`;
CREATE TABLE `edi_claims` (
  `claim_id` bigint NOT NULL AUTO_INCREMENT,
  `provider_id` int NOT NULL,
  `smart_claim_id` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `claim_code` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `member_number` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `status` enum('PENDING','PROCESSED','FAILED') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'PENDING',
  `error_message` text COLLATE utf8mb4_general_ci,
  `claim_data` json DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`claim_id`),
  KEY `idx_provider_status` (`provider_id`,`status`),
  KEY `idx_member` (`member_number`),
  CONSTRAINT `fk_claim_provider` FOREIGN KEY (`provider_id`) REFERENCES `edi_providers` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_configurations`;
CREATE TABLE `edi_configurations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `edi_type` enum('SMART','SLADE','LCT') NOT NULL,
  `auth_url` varchar(255) DEFAULT NULL,
  `api_base_url` varchar(255) DEFAULT NULL,
  `client_id` varchar(255) DEFAULT NULL,
  `client_secret` varchar(255) DEFAULT NULL,
  `customer_id` varchar(255) DEFAULT NULL,
  `country_code` varchar(10) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `edi_type` (`edi_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `edi_integration_logs`;
CREATE TABLE `edi_integration_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `provider_id` int DEFAULT NULL,
  `operation` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `details` text COLLATE utf8mb4_general_ci,
  `request_data` text COLLATE utf8mb4_general_ci,
  `response_data` text COLLATE utf8mb4_general_ci,
  `error_message` text COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `provider_id` (`provider_id`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `edi_integration_logs_ibfk_1` FOREIGN KEY (`provider_id`) REFERENCES `edi_providers` (`provider_id`),
  CONSTRAINT `edi_integration_logs_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_members`;
CREATE TABLE `edi_members` (
  `member_id` int NOT NULL AUTO_INCREMENT,
  `provider_id` int DEFAULT NULL,
  `member_number` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `modified_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`member_id`),
  KEY `provider_id` (`provider_id`),
  CONSTRAINT `edi_members_ibfk_1` FOREIGN KEY (`provider_id`) REFERENCES `edi_providers` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_preauth`;
CREATE TABLE `edi_preauth` (
  `preauth_id` int NOT NULL AUTO_INCREMENT,
  `provider_id` int DEFAULT NULL,
  `preauth_number` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `member_number` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'PENDING',
  `requested_amount` decimal(10,2) NOT NULL,
  `approved_amount` decimal(10,2) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `modified_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`preauth_id`),
  KEY `provider_id` (`provider_id`),
  CONSTRAINT `edi_preauth_ibfk_1` FOREIGN KEY (`provider_id`) REFERENCES `edi_providers` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_provider_settings`;
CREATE TABLE `edi_provider_settings` (
  `setting_id` int NOT NULL AUTO_INCREMENT,
  `provider_id` int NOT NULL,
  `setting_key` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `setting_value` text COLLATE utf8mb4_general_ci NOT NULL,
  `is_encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `unique_provider_setting` (`provider_id`,`setting_key`),
  CONSTRAINT `fk_setting_provider` FOREIGN KEY (`provider_id`) REFERENCES `edi_providers` (`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `edi_providers`;
CREATE TABLE `edi_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `provider_name` varchar(255) NOT NULL,
  `edi_type` enum('SMART','SLADE','LCT') NOT NULL,
  `description` text,
  `is_active` tinyint(1) DEFAULT '0',
  `status` enum('PENDING','CONFIGURED','ERROR') DEFAULT 'PENDING',
  `error_message` text,
  `api_base_url` varchar(255) DEFAULT NULL,
  `last_sync` datetime DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`provider_id`),
  KEY `idx_edi_type` (`edi_type`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `edi_settings`;
CREATE TABLE `edi_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `edi_type` enum('SMART','SLADE','LCT') NOT NULL,
  `name` varchar(50) NOT NULL,
  `auth_url` varchar(255) NOT NULL,
  `api_base_url` varchar(255) NOT NULL,
  `client_id` varchar(100) NOT NULL,
  `client_secret` varchar(255) NOT NULL,
  `customer_id` varchar(100) NOT NULL,
  `country_code` varchar(5) NOT NULL,
  `additional_settings` json DEFAULT NULL,
  `token` text,
  `token_expiry` timestamp NULL DEFAULT NULL,
  `last_sync` timestamp NULL DEFAULT NULL,
  `status` enum('CONFIGURED','ERROR') DEFAULT NULL,
  `error_message` text,
  `is_active` tinyint(1) DEFAULT '1',
  `modified_by` int NOT NULL,
  `modified_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_edi_type` (`edi_type`),
  KEY `idx_modified` (`modified_at`),
  KEY `fk_modified_by` (`modified_by`),
  CONSTRAINT `fk_edi_modified_by` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `email_logs`;
CREATE TABLE `email_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `quotation_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `recipient` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `cc` text COLLATE utf8mb4_general_ci,
  `bcc` text COLLATE utf8mb4_general_ci,
  `subject` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `content` text COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('SENT','FAILED','DELIVERED','BOUNCED') COLLATE utf8mb4_general_ci NOT NULL,
  `error_message` text COLLATE utf8mb4_general_ci,
  `sent_by` int NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `delivered_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `idx_quotation` (`quotation_no`),
  KEY `idx_status` (`status`),
  KEY `idx_sent_at` (`sent_at`),
  KEY `fk_email_sender` (`sent_by`),
  CONSTRAINT `fk_email_quotation` FOREIGN KEY (`quotation_no`) REFERENCES `quotations` (`quotation_no`),
  CONSTRAINT `fk_email_sender` FOREIGN KEY (`sent_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `fund_admin_config`;
CREATE TABLE `fund_admin_config` (
  `config_id` int NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit` int NOT NULL,
  `fund_percentage` decimal(5,2) NOT NULL,
  `admin_fee_percentage` decimal(5,2) NOT NULL,
  `effective_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`config_id`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_benefit` (`benefit`),
  KEY `idx_dates` (`effective_date`,`end_date`),
  CONSTRAINT `fk_fund_config_benefit` FOREIGN KEY (`benefit`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_fund_config_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `fund_premium_splits`;
CREATE TABLE `fund_premium_splits` (
  `split_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `debit_id` bigint unsigned NOT NULL,
  `benefit` int NOT NULL,
  `total_premium` decimal(15,2) NOT NULL,
  `fund_amount` decimal(15,2) NOT NULL,
  `admin_amount` decimal(15,2) NOT NULL,
  `fund_percentage` decimal(5,2) NOT NULL,
  `admin_percentage` decimal(5,2) NOT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`split_id`),
  KEY `idx_debit` (`debit_id`),
  KEY `idx_benefit` (`benefit`),
  CONSTRAINT `fk_split_benefit` FOREIGN KEY (`benefit`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_split_debit` FOREIGN KEY (`debit_id`) REFERENCES `premium_debit_notes` (`debit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `fund_receipts`;
CREATE TABLE `fund_receipts` (
  `receipt_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `receipt_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `debit_id` bigint unsigned NOT NULL,
  `receipt_date` date NOT NULL,
  `fund_amount` decimal(15,2) NOT NULL,
  `admin_amount` decimal(15,2) NOT NULL,
  `payment_mode` enum('CASH','CHEQUE','BANK_TRANSFER') COLLATE utf8mb4_general_ci NOT NULL,
  `reference_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`receipt_id`),
  UNIQUE KEY `uk_receipt_no` (`receipt_no`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_debit` (`debit_id`),
  CONSTRAINT `fk_fund_receipt_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_fund_receipt_debit` FOREIGN KEY (`debit_id`) REFERENCES `premium_debit_notes` (`debit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `fund_transactions`;
CREATE TABLE `fund_transactions` (
  `transaction_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `transaction_date` date NOT NULL,
  `transaction_type` enum('TOPUP','CLAIM','ADJUSTMENT') COLLATE utf8mb4_general_ci NOT NULL,
  `reference_no` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`transaction_id`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_type` (`transaction_type`),
  KEY `idx_date` (`transaction_date`),
  KEY `idx_reference` (`reference_no`),
  KEY `fk_fund_creator` (`created_by`),
  KEY `fk_fund_modifier` (`modified_by`),
  CONSTRAINT `fk_fund_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_fund_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_fund_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `fund_transactions_view`;
CREATE ALGORITHM=UNDEFINED DEFINER=`homecar1`@`localhost` SQL SECURITY DEFINER VIEW `fund_transactions_view` AS select `c`.`corporate` AS `corporate`,`b`.`benefit` AS `benefit`,`fps`.`debit_id` AS `debit_id`,`pdn`.`debit_no` AS `debit_no`,`fps`.`total_premium` AS `total_premium`,`fps`.`fund_amount` AS `fund_amount`,`fps`.`admin_amount` AS `admin_amount`,`fps`.`fund_percentage` AS `fund_percentage`,`fps`.`admin_percentage` AS `admin_percentage`,coalesce(`fr`.`receipt_no`,'PENDING') AS `receipt_status`,`fps`.`created_at` AS `created_at` from ((((`fund_premium_splits` `fps` join `premium_debit_notes` `pdn` on((`fps`.`debit_id` = `pdn`.`debit_id`))) join `corporate` `c` on((`pdn`.`corp_id` = `c`.`corp_id`))) join `benefit` `b` on((`fps`.`benefit` = `b`.`code`))) left join `fund_receipts` `fr` on((`fps`.`debit_id` = `fr`.`debit_id`))) order by `fps`.`created_at` desc;

DROP TABLE IF EXISTS `help_faqs`;
CREATE TABLE `help_faqs` (
  `faq_id` int NOT NULL AUTO_INCREMENT,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_order` int DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`faq_id`),
  KEY `idx_category` (`category`),
  KEY `idx_display_order` (`display_order`),
  KEY `fk_faq_creator` (`created_by`),
  KEY `fk_faq_modifier` (`modified_by`),
  CONSTRAINT `fk_faq_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_faq_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `icd10_codes`;
CREATE TABLE `icd10_codes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `description` text NOT NULL,
  `category` varchar(100) DEFAULT NULL,
  `sub_category` varchar(100) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `idx_status` (`status`),
  KEY `idx_category` (`category`),
  KEY `fk_icd_creator` (`created_by`),
  KEY `fk_icd_modifier` (`modified_by`),
  CONSTRAINT `fk_icd_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_icd_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6556 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `insurance_products`;
CREATE TABLE `insurance_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `product_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `product_code` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `category_id` int NOT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `is_group_scheme` tinyint(1) DEFAULT '0',
  `funding_type` enum('INSURED','CAPITATION_PREMIUM','CAPITATION_CLAIM') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `has_fixed_end_date` tinyint(1) DEFAULT '1',
  `minimum_term` int DEFAULT NULL,
  `maximum_term` int DEFAULT NULL,
  `term_unit` enum('DAYS','MONTHS','YEARS') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` enum('DRAFT','ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'DRAFT',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_by` int DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`product_id`),
  UNIQUE KEY `product_code` (`product_code`),
  KEY `category_id` (`category_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `insurance_products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`category_id`),
  CONSTRAINT `insurance_products_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `insurance_products_ibfk_3` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `insurer`;
CREATE TABLE `insurer` (
  `code` int NOT NULL AUTO_INCREMENT,
  `insurer` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `insuring_rates`;
CREATE TABLE `insuring_rates` (
  `code` int NOT NULL AUTO_INCREMENT,
  `full_desc` varchar(35) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit` int DEFAULT NULL,
  `limit` decimal(10,2) DEFAULT NULL,
  `family_size` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `premium` decimal(10,2) DEFAULT NULL,
  `client` tinyint(1) DEFAULT NULL,
  `year` int DEFAULT NULL,
  `insurer` int DEFAULT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`code`),
  KEY `corp_id` (`corp_id`),
  CONSTRAINT `insuring_rates_ibfk_1` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `liability_limits`;
CREATE TABLE `liability_limits` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_code` int NOT NULL,
  `limit_amount` decimal(15,2) NOT NULL,
  `notes` text COLLATE utf8mb4_general_ci,
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `corp_id` (`corp_id`,`benefit_code`),
  KEY `benefit_code` (`benefit_code`),
  KEY `created_by` (`created_by`),
  KEY `updated_by` (`updated_by`),
  CONSTRAINT `liability_limits_ibfk_1` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `liability_limits_ibfk_2` FOREIGN KEY (`benefit_code`) REFERENCES `benefit` (`code`),
  CONSTRAINT `liability_limits_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `liability_limits_ibfk_4` FOREIGN KEY (`updated_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_anniversary`;
CREATE TABLE `member_anniversary` (
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `renewal_date` date DEFAULT NULL,
  `anniv` decimal(2,0) NOT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `sync` decimal(1,0) DEFAULT NULL,
  `renewal_notified` decimal(1,0) DEFAULT NULL,
  `invoice_no` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `smart_sync` decimal(1,0) DEFAULT NULL,
  `smart_picked` int DEFAULT NULL,
  `card_type` decimal(2,0) DEFAULT NULL,
  `corp_id` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`member_no`,`anniv`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_benefits`;
CREATE TABLE `member_benefits` (
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit` decimal(3,0) NOT NULL,
  `limit` decimal(10,2) DEFAULT NULL,
  `sharing` decimal(1,0) DEFAULT NULL,
  `anniv` decimal(2,0) NOT NULL,
  `sub_limit_of` decimal(3,0) DEFAULT NULL,
  `re_insurer` decimal(2,0) DEFAULT NULL,
  `suspended` decimal(1,0) DEFAULT NULL,
  `suspended_date` date DEFAULT NULL,
  `suspend_reason` decimal(2,0) DEFAULT NULL,
  `suspend_user` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `suspended_entry` date DEFAULT NULL,
  `claims` decimal(10,2) DEFAULT NULL,
  `reserve` decimal(10,2) DEFAULT NULL,
  `expense` decimal(10,2) DEFAULT NULL,
  `balance` decimal(10,2) DEFAULT NULL,
  `percent` decimal(5,2) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `abbriv` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `web_picked` decimal(1,0) DEFAULT NULL,
  `waiting_period` int DEFAULT NULL,
  `care_picked` int DEFAULT NULL,
  `bal_up` decimal(2,0) DEFAULT NULL,
  `fund` int DEFAULT NULL,
  `exceed_limit` int DEFAULT NULL,
  `category` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `capitated` decimal(1,0) DEFAULT NULL,
  `utilize` decimal(3,2) DEFAULT NULL,
  `threshold` decimal(10,2) DEFAULT NULL,
  `reserve_amt` decimal(10,2) DEFAULT NULL,
  `smart_sync` int DEFAULT NULL,
  `sync` int DEFAULT NULL,
  `suspend_at` int DEFAULT NULL,
  `bed_limit` decimal(10,2) DEFAULT NULL,
  `group_limit` decimal(15,2) DEFAULT NULL,
  `ward` decimal(2,0) DEFAULT NULL,
  `allocate_to` decimal(2,0) DEFAULT NULL,
  `parent_benefit` int DEFAULT NULL,
  `corp_id` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`member_no`,`benefit`,`anniv`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_cancellation`;
CREATE TABLE `member_cancellation` (
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `cancelled` decimal(1,0) NOT NULL,
  `date_can` date NOT NULL,
  `anniv` decimal(2,0) DEFAULT NULL,
  `reason` decimal(2,0) DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `sync` decimal(1,0) DEFAULT NULL,
  `temporary_cancellation` int DEFAULT NULL,
  `smart_sync` decimal(1,0) DEFAULT NULL,
  PRIMARY KEY (`member_no`,`cancelled`,`date_can`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_conditions`;
CREATE TABLE `member_conditions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `condition_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `condition_code` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'ICD-10 code',
  `diagnosis_date` date NOT NULL,
  `is_chronic` tinyint(1) DEFAULT '0',
  `severity` enum('MILD','MODERATE','SEVERE') COLLATE utf8mb4_general_ci NOT NULL,
  `last_checkup_date` date DEFAULT NULL,
  `last_prescription_date` date DEFAULT NULL,
  `notes` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_no`),
  KEY `idx_chronic` (`is_chronic`),
  CONSTRAINT `member_conditions_ibfk_1` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_family_history`;
CREATE TABLE `member_family_history` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `condition_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `relationship` enum('PARENT','SIBLING','CHILD','GRANDPARENT') COLLATE utf8mb4_general_ci NOT NULL,
  `age_at_onset` int DEFAULT NULL,
  `is_hereditary` tinyint(1) DEFAULT '0',
  `notes` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_no`),
  KEY `idx_hereditary` (`is_hereditary`),
  CONSTRAINT `member_family_history_ibfk_1` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_health_data`;
CREATE TABLE `member_health_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `height` decimal(5,2) DEFAULT NULL COMMENT 'Height in cm',
  `weight` decimal(5,2) DEFAULT NULL COMMENT 'Weight in kg',
  `blood_pressure_systolic` int DEFAULT NULL,
  `blood_pressure_diastolic` int DEFAULT NULL,
  `blood_sugar` decimal(5,2) DEFAULT NULL,
  `cholesterol` decimal(5,2) DEFAULT NULL,
  `date_recorded` date NOT NULL,
  `recorded_by` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_no`),
  KEY `idx_date` (`date_recorded`),
  KEY `recorded_by` (`recorded_by`),
  CONSTRAINT `member_health_data_ibfk_1` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`),
  CONSTRAINT `member_health_data_ibfk_2` FOREIGN KEY (`recorded_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_info`;
CREATE TABLE `member_info` (
  `family_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `surname` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `first_name` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `other_names` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `id_no` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `blood_group` decimal(2,0) DEFAULT NULL,
  `relation_to_principal` decimal(2,0) DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `family_title` decimal(2,0) DEFAULT NULL,
  `cancelled` decimal(1,0) DEFAULT '0',
  `employment_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `gender` decimal(1,0) DEFAULT NULL,
  `card_to_member` date DEFAULT NULL,
  `passport_no` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nhif_card_no` varchar(15) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `height` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `weight` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `photo_form` decimal(1,0) DEFAULT NULL,
  `photo_no` decimal(5,0) DEFAULT NULL,
  `info_to_printer` date DEFAULT NULL,
  `card_from_printer` date DEFAULT NULL,
  `app_form_date` date DEFAULT NULL,
  `marital_status` decimal(1,0) DEFAULT NULL,
  `date_employed` date DEFAULT NULL,
  `status` decimal(1,0) NOT NULL,
  `def_rej` decimal(2,0) DEFAULT NULL,
  `dep_pos` decimal(2,0) DEFAULT NULL,
  `web_synced` decimal(1,0) DEFAULT NULL,
  `corp_id` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `care_picked` int DEFAULT NULL,
  `temporary_cancellation` int DEFAULT NULL,
  `smart_picked` int NOT NULL DEFAULT '0',
  `smart_sync` int NOT NULL DEFAULT '0',
  `cat_change_picked` int NOT NULL DEFAULT '0',
  `member_id` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `family_size` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mem_pin` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `single_parent` decimal(1,0) DEFAULT NULL,
  `age` int DEFAULT NULL,
  `card_serial_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`member_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_interventions`;
CREATE TABLE `member_interventions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `intervention_type` enum('CLINICAL','LIFESTYLE','PREVENTIVE') COLLATE utf8mb4_general_ci NOT NULL,
  `priority` enum('LOW','MEDIUM','HIGH') COLLATE utf8mb4_general_ci NOT NULL,
  `description` text COLLATE utf8mb4_general_ci NOT NULL,
  `recommended_action` text COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('PENDING','IN_PROGRESS','COMPLETED','CANCELLED') COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `started_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `notes` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_no`),
  KEY `idx_status` (`status`),
  KEY `idx_type` (`intervention_type`),
  CONSTRAINT `member_interventions_ibfk_1` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_lifestyle`;
CREATE TABLE `member_lifestyle` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `smoking_status` enum('never','former','current') COLLATE utf8mb4_general_ci NOT NULL,
  `exercise_frequency` int DEFAULT NULL COMMENT 'Days per week',
  `exercise_minutes` int DEFAULT NULL COMMENT 'Minutes per session',
  `alcohol_units_weekly` int DEFAULT NULL,
  `diet_rating` int DEFAULT NULL COMMENT '1-5 scale',
  `stress_level` int DEFAULT NULL COMMENT '1-5 scale',
  `sleep_hours` decimal(3,1) DEFAULT NULL,
  `assessment_date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_no`),
  KEY `idx_date` (`assessment_date`),
  CONSTRAINT `member_lifestyle_ibfk_1` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_risk_scores`;
CREATE TABLE `member_risk_scores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `total_score` decimal(4,2) NOT NULL,
  `age_score` decimal(4,2) NOT NULL,
  `bmi_score` decimal(4,2) NOT NULL,
  `chronic_score` decimal(4,2) NOT NULL,
  `lifestyle_score` decimal(4,2) NOT NULL,
  `family_score` decimal(4,2) NOT NULL,
  `claims_score` decimal(4,2) NOT NULL,
  `assessment_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_no`),
  KEY `idx_date` (`assessment_date`),
  CONSTRAINT `member_risk_scores_ibfk_1` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `member_vitals`;
CREATE TABLE `member_vitals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `vital_type` enum('BLOOD_PRESSURE','HEART_RATE','BLOOD_SUGAR','TEMPERATURE','OXYGEN','WEIGHT') COLLATE utf8mb4_general_ci NOT NULL,
  `vital_value` decimal(8,2) NOT NULL,
  `unit` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `reading_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reading_time` time NOT NULL,
  `recorded_by` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_no`),
  KEY `idx_type` (`vital_type`),
  KEY `idx_date` (`reading_date`),
  KEY `recorded_by` (`recorded_by`),
  CONSTRAINT `member_vitals_ibfk_1` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`),
  CONSTRAINT `member_vitals_ibfk_2` FOREIGN KEY (`recorded_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `menu_items`;
CREATE TABLE `menu_items` (
  `menu_id` int NOT NULL AUTO_INCREMENT,
  `parent_id` int DEFAULT NULL,
  `menu_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `menu_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menu_icon` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menu_order` int NOT NULL DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`menu_id`),
  KEY `idx_parent` (`parent_id`),
  KEY `idx_order` (`menu_order`),
  CONSTRAINT `menu_items_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `menu_items` (`menu_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `notification_queue`;
CREATE TABLE `notification_queue` (
  `queue_id` bigint NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `recipient_email` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `recipient_phone` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_general_ci,
  `sms_message` text COLLATE utf8mb4_general_ci,
  `status` enum('PENDING','SENT','FAILED') COLLATE utf8mb4_general_ci DEFAULT 'PENDING',
  `retry_count` int DEFAULT '0',
  `scheduled_at` timestamp NOT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `error_message` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`queue_id`),
  KEY `template_id` (`template_id`),
  KEY `idx_queue_status` (`status`,`scheduled_at`),
  CONSTRAINT `notification_queue_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `notification_templates` (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `notification_settings`;
CREATE TABLE `notification_settings` (
  `setting_id` int NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `recipient_type` enum('USER','ROLE','EMAIL','PHONE') COLLATE utf8mb4_general_ci NOT NULL,
  `recipient_value` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `notify_via_email` tinyint(1) DEFAULT '1',
  `notify_via_sms` tinyint(1) DEFAULT '0',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`setting_id`),
  KEY `created_by` (`created_by`),
  KEY `idx_settings_template` (`template_id`,`recipient_type`),
  CONSTRAINT `notification_settings_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `notification_templates` (`template_id`),
  CONSTRAINT `notification_settings_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `notification_templates`;
CREATE TABLE `notification_templates` (
  `template_id` int NOT NULL AUTO_INCREMENT,
  `template_code` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `template_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `subject_template` text COLLATE utf8mb4_general_ci NOT NULL,
  `body_template` text COLLATE utf8mb4_general_ci NOT NULL,
  `sms_template` text COLLATE utf8mb4_general_ci,
  `days_before` int DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `template_code` (`template_code`),
  KEY `idx_template_code` (`template_code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `notification_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `type` enum('Booking Confirmation','Flight Update','Promotion','Reminder') NOT NULL,
  `content` text NOT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`notification_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NOT NULL,
  `used_at` timestamp NULL DEFAULT NULL,
  `created_by_ip` varchar(45) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_token` (`token`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_expires` (`expires_at`),
  CONSTRAINT `password_resets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `payment_credits`;
CREATE TABLE `payment_credits` (
  `credit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `receipt_no` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `corp_id` varchar(10) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('ACTIVE','USED','CANCELLED') NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`credit_id`),
  KEY `idx_receipt` (`receipt_no`),
  KEY `idx_corporate` (`corp_id`),
  CONSTRAINT `fk_credit_receipt` FOREIGN KEY (`receipt_no`) REFERENCES `premium_receipt` (`receipt_no`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `payment_plan_installments`;
CREATE TABLE `payment_plan_installments` (
  `installment_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `plan_id` bigint unsigned NOT NULL,
  `installment_no` int NOT NULL,
  `due_date` date NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `paid_amount` decimal(15,2) DEFAULT '0.00',
  `status` enum('PENDING','PAID','OVERDUE','PARTIAL') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'PENDING',
  `receipt_no` varchar(35) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reminder_sent` tinyint(1) DEFAULT '0',
  `last_reminder_date` datetime DEFAULT NULL,
  PRIMARY KEY (`installment_id`),
  KEY `idx_plan` (`plan_id`),
  KEY `idx_status` (`status`),
  KEY `idx_due_date` (`due_date`),
  KEY `receipt_no` (`receipt_no`),
  CONSTRAINT `payment_plan_installments_ibfk_1` FOREIGN KEY (`plan_id`) REFERENCES `payment_plans` (`plan_id`),
  CONSTRAINT `payment_plan_installments_ibfk_2` FOREIGN KEY (`receipt_no`) REFERENCES `premium_receipt` (`receipt_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `payment_plans`;
CREATE TABLE `payment_plans` (
  `plan_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `family_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `installments` int NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `payment_frequency` enum('WEEKLY','MONTHLY','QUARTERLY') COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('ACTIVE','COMPLETED','DEFAULTED','CANCELLED') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`plan_id`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_family` (`family_no`),
  KEY `idx_status` (`status`),
  CONSTRAINT `payment_plans_ibfk_1` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `payment_plans_ibfk_2` FOREIGN KEY (`family_no`) REFERENCES `principal_applicant` (`family_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `payment_reminders_log`;
CREATE TABLE `payment_reminders_log` (
  `reminder_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `installment_id` bigint unsigned NOT NULL,
  `reminder_type` enum('EMAIL','SMS') COLLATE utf8mb4_general_ci NOT NULL,
  `recipient` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `message` text COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('SENT','FAILED') COLLATE utf8mb4_general_ci NOT NULL,
  `error_message` text COLLATE utf8mb4_general_ci,
  `sent_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`reminder_id`),
  KEY `idx_installment` (`installment_id`),
  CONSTRAINT `payment_reminders_log_ibfk_1` FOREIGN KEY (`installment_id`) REFERENCES `payment_plan_installments` (`installment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `payment_voucher_items`;
CREATE TABLE `payment_voucher_items` (
  `item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `voucher_id` bigint unsigned NOT NULL,
  `claim_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `invoice_no` varchar(30) COLLATE utf8mb4_general_ci NOT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `amount` decimal(15,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `fk_voucher` (`voucher_id`),
  CONSTRAINT `fk_voucher_items` FOREIGN KEY (`voucher_id`) REFERENCES `payment_vouchers` (`voucher_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `payment_vouchers`;
CREATE TABLE `payment_vouchers` (
  `voucher_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `payment_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `voucher_date` date NOT NULL,
  `recipient_type` enum('PROVIDER','MEMBER','CORPORATE') COLLATE utf8mb4_general_ci NOT NULL,
  `recipient_id` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `recipient_name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `status` enum('DRAFT','POSTED','CANCELLED') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'POSTED',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`voucher_id`),
  UNIQUE KEY `voucher_no` (`voucher_no`),
  KEY `idx_payment` (`payment_no`),
  KEY `idx_recipient` (`recipient_type`,`recipient_id`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `pre_authorization`;
CREATE TABLE `pre_authorization` (
  `code` int NOT NULL,
  `member_no` varchar(15) NOT NULL,
  `provider` int NOT NULL,
  `date_reported` date DEFAULT NULL,
  `reported_by` varchar(20) DEFAULT NULL,
  `date_authorized` date DEFAULT NULL,
  `authorized_by` varchar(10) DEFAULT NULL,
  `pre_diagnosis` varchar(255) DEFAULT NULL,
  `authority_type` int DEFAULT NULL,
  `ward` int DEFAULT NULL,
  `available_limit` decimal(10,2) DEFAULT NULL,
  `admit_days` int DEFAULT NULL,
  `reserve` decimal(10,2) DEFAULT NULL,
  `notes` varchar(200) DEFAULT NULL,
  `co_signee` varchar(30) DEFAULT NULL,
  `anniv` int DEFAULT NULL,
  `doctor_attending` varchar(20) DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `family_no` varchar(30) NOT NULL,
  `pre_auth_code` varchar(20) DEFAULT NULL,
  `sc_id` int DEFAULT NULL,
  `date_admitted` date DEFAULT NULL,
  `date_discharged` date DEFAULT NULL,
  `treatment_due` varchar(20) DEFAULT NULL,
  `last_replaced` varchar(20) DEFAULT NULL,
  `first_diagnosed` varchar(20) DEFAULT NULL,
  `excess_amt` decimal(15,2) DEFAULT NULL,
  `discharge_date` date DEFAULT NULL,
  `admission_date` date DEFAULT NULL,
  `admitting_doc` varchar(100) DEFAULT NULL,
  `service` int DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  `modified_by` varchar(20) DEFAULT NULL,
  `lou_ref` varchar(30) DEFAULT NULL,
  `dianosis_class` varchar(50) DEFAULT NULL,
  `diagnosis_condition` int DEFAULT NULL,
  `status` varchar(6) DEFAULT 'ACTIVE',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `premium_credit_items`;
CREATE TABLE `premium_credit_items` (
  `item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `credit_id` bigint unsigned NOT NULL,
  `benefit_code` int NOT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`item_id`),
  KEY `credit_id` (`credit_id`),
  KEY `benefit_code` (`benefit_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_credit_notes`;
CREATE TABLE `premium_credit_notes` (
  `credit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `credit_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `debit_id` bigint unsigned NOT NULL,
  `credit_date` date NOT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `reason` text COLLATE utf8mb4_general_ci NOT NULL,
  `credit_type` enum('MEMBER_EXIT','OVERCHARGE','OTHER') COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('DRAFT','POSTED','CANCELLED') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'DRAFT',
  `member_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `exit_date` date DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`credit_id`),
  UNIQUE KEY `credit_no` (`credit_no`),
  KEY `debit_id` (`debit_id`),
  KEY `corp_id` (`corp_id`),
  KEY `member_no` (`member_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_debit_items`;
CREATE TABLE `premium_debit_items` (
  `item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `debit_id` bigint unsigned NOT NULL,
  `benefit_code` int NOT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`item_id`),
  KEY `debit_id` (`debit_id`),
  KEY `benefit_code` (`benefit_code`),
  KEY `member_no` (`member_no`),
  CONSTRAINT `fk_debit_items_benefit` FOREIGN KEY (`benefit_code`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_debit_items_debit` FOREIGN KEY (`debit_id`) REFERENCES `premium_debit_notes` (`debit_id`),
  CONSTRAINT `fk_debit_items_member` FOREIGN KEY (`member_no`) REFERENCES `member_info` (`member_no`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_debit_notes`;
CREATE TABLE `premium_debit_notes` (
  `debit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `debit_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `debit_date` date NOT NULL,
  `debit_type` enum('SCHEME','FAMILY') COLLATE utf8mb4_general_ci NOT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `family_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `allocated_amount` decimal(10,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `period_from` date NOT NULL,
  `period_to` date NOT NULL,
  `status` enum('UNALLOCATED','ALLOCATED','CANCELLED') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'UNALLOCATED',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `commission_amount` decimal(10,2) DEFAULT NULL,
  `is_new_client` tinyint(1) DEFAULT '0',
  `commission_calculated` tinyint(1) DEFAULT '0',
  `calculation_date` datetime DEFAULT NULL,
  `calculated_by` int DEFAULT NULL,
  PRIMARY KEY (`debit_id`),
  UNIQUE KEY `debit_no` (`debit_no`),
  KEY `corp_id` (`corp_id`),
  KEY `family_no` (`family_no`),
  CONSTRAINT `fk_debit_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_debit_family` FOREIGN KEY (`family_no`) REFERENCES `principal_applicant` (`family_no`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_invoice`;
CREATE TABLE `premium_invoice` (
  `invoice_no` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `member_no` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `corp_id` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `invoice_total` decimal(20,2) DEFAULT NULL,
  `anniv` int DEFAULT NULL,
  `user_id` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `premium_type` int DEFAULT NULL,
  `invoice_net` decimal(20,2) DEFAULT NULL,
  `discount_amt` decimal(20,2) DEFAULT NULL,
  `agent_id` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `premium_net` decimal(20,2) DEFAULT NULL,
  `discount_allowed` decimal(20,0) DEFAULT NULL,
  `fund_invoice` decimal(20,0) DEFAULT NULL,
  `prorated` decimal(20,0) DEFAULT NULL,
  `insurer` decimal(20,0) DEFAULT NULL,
  `allocated` decimal(20,0) DEFAULT NULL,
  `allocated_amt` decimal(20,2) DEFAULT NULL,
  `cover_start_date` date DEFAULT NULL,
  `load` decimal(20,0) DEFAULT NULL,
  `new_renewal` decimal(20,0) DEFAULT NULL,
  `stamp_duty` decimal(20,2) DEFAULT NULL,
  `phcf` decimal(20,2) DEFAULT NULL,
  `tl` decimal(20,2) DEFAULT NULL,
  `nullify` int DEFAULT NULL,
  `credit_note` int DEFAULT NULL,
  `prorate_days` decimal(20,0) DEFAULT NULL,
  `idx` int NOT NULL AUTO_INCREMENT,
  `prorate_days_month` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_general_ci,
  `misc` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `proration_days` int DEFAULT NULL COMMENT 'Number of remaining days in period',
  `proration_factor` decimal(10,4) DEFAULT NULL COMMENT 'Factor used for proration calculation',
  `total_days` int DEFAULT NULL COMMENT 'Total days in period',
  PRIMARY KEY (`idx`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_invoice_details`;
CREATE TABLE `premium_invoice_details` (
  `family_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `benefit` decimal(10,0) DEFAULT NULL,
  `limit` decimal(10,2) DEFAULT NULL,
  `premium` decimal(10,2) DEFAULT NULL,
  `invoice_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sharing` decimal(1,0) DEFAULT NULL,
  `family_size` decimal(2,0) DEFAULT NULL,
  `family_age` decimal(3,0) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `prorated_prem` decimal(10,2) DEFAULT NULL,
  `discounted_prem` decimal(10,2) DEFAULT NULL,
  `loaded_prem` decimal(10,2) DEFAULT NULL,
  `disc_amt` double DEFAULT NULL,
  `load_amt` double DEFAULT NULL,
  `category` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `idx` int NOT NULL AUTO_INCREMENT,
  `prins_name` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `prorata_period` decimal(3,0) DEFAULT NULL,
  `effective_date` date DEFAULT NULL,
  `dep_pos` decimal(2,0) DEFAULT NULL,
  `family_title` int DEFAULT NULL,
  `prorated_period` int DEFAULT NULL,
  `plan` decimal(5,0) DEFAULT NULL,
  `annual_premium` decimal(15,2) DEFAULT NULL COMMENT 'Original annual premium before proration',
  `prorated_premium` decimal(15,2) DEFAULT NULL COMMENT 'Final premium after proration',
  PRIMARY KEY (`idx`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_invoice_details_summary`;
CREATE TABLE `premium_invoice_details_summary` (
  `id_key` int NOT NULL AUTO_INCREMENT,
  `invoice_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `class` decimal(10,0) DEFAULT NULL,
  `net_premium` decimal(10,2) DEFAULT NULL,
  `allocated` decimal(1,0) DEFAULT NULL,
  `allocated_amt` decimal(10,2) DEFAULT NULL,
  `paid` decimal(1,0) DEFAULT NULL,
  `commission` decimal(15,2) DEFAULT NULL,
  `commis_vno` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `commis_payno` decimal(10,0) DEFAULT NULL,
  `levied` decimal(10,2) DEFAULT NULL,
  `wh_tax` decimal(10,2) DEFAULT NULL,
  `commis_rate` decimal(7,2) DEFAULT NULL,
  `wh_tax_rate` decimal(7,2) DEFAULT NULL,
  `receipt_no` varchar(35) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `voucher_date` date DEFAULT NULL,
  `commis_voucher_batch_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_payments`;
CREATE TABLE `premium_payments` (
  `payment_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `debit_id` bigint unsigned NOT NULL,
  `payment_date` date NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `payment_method` enum('CASH','CHEQUE','BANK_TRANSFER') COLLATE utf8mb4_general_ci NOT NULL,
  `reference_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bank_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cheque_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `status` enum('PENDING','CLEARED','BOUNCED','CANCELLED') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'PENDING',
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`payment_id`),
  UNIQUE KEY `payment_no` (`payment_no`),
  KEY `debit_id` (`debit_id`),
  CONSTRAINT `fk_payment_debit` FOREIGN KEY (`debit_id`) REFERENCES `premium_debit_notes` (`debit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_rates`;
CREATE TABLE `premium_rates` (
  `rate_id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `benefit_id` int DEFAULT NULL,
  `age_band_start` int DEFAULT NULL,
  `age_band_end` int DEFAULT NULL,
  `gender` enum('M','F','ALL') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `sum_assured_band_start` decimal(15,2) DEFAULT NULL,
  `sum_assured_band_end` decimal(15,2) DEFAULT NULL,
  `premium_rate` decimal(10,4) NOT NULL,
  `rate_type` enum('PERCENTAGE','FIXED') COLLATE utf8mb4_general_ci NOT NULL,
  `effective_from` date NOT NULL,
  `effective_to` date DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_by` int DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`rate_id`),
  KEY `product_id` (`product_id`),
  KEY `benefit_id` (`benefit_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `premium_rates_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `insurance_products` (`product_id`),
  CONSTRAINT `premium_rates_ibfk_2` FOREIGN KEY (`benefit_id`) REFERENCES `product_benefits` (`benefit_id`),
  CONSTRAINT `premium_rates_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `premium_rates_ibfk_4` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `premium_receipt`;
CREATE TABLE `premium_receipt` (
  `receipt_no` varchar(35) COLLATE utf8mb4_general_ci NOT NULL,
  `receipt_amount` decimal(10,2) NOT NULL,
  `receipt_date` date NOT NULL,
  `payment_mode` decimal(2,0) NOT NULL,
  `cheque_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `financer` decimal(2,0) DEFAULT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `receipt_bank` decimal(7,0) DEFAULT NULL,
  `fund_receipt` decimal(1,0) DEFAULT NULL,
  `reversed` decimal(1,0) DEFAULT NULL,
  `reason` decimal(3,0) DEFAULT NULL,
  `commis_excempt` decimal(1,0) DEFAULT NULL,
  `import` decimal(1,0) DEFAULT NULL,
  `id_key` decimal(20,0) NOT NULL DEFAULT '0',
  `payment_type` enum('exact','over','under') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'exact',
  `payment_difference` decimal(15,2) DEFAULT NULL,
  `reversed_by` int DEFAULT NULL,
  `reversed_at` timestamp NULL DEFAULT NULL,
  `reversal_reason` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`receipt_no`),
  KEY `reversed_by` (`reversed_by`),
  CONSTRAINT `premium_receipt_ibfk_1` FOREIGN KEY (`reversed_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `principal_applicant`;
CREATE TABLE `principal_applicant` (
  `family_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `member_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `surname` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `first_name` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `other_names` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `agent_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `employer` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tel_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mobile_no` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `postal_add` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `town` decimal(5,0) DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phy_loc` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `family_size` decimal(2,0) DEFAULT NULL,
  `relation_to_family` decimal(2,0) DEFAULT NULL,
  `individual` decimal(1,0) DEFAULT NULL,
  `date_form_received` date DEFAULT NULL,
  `user_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `form_filled` decimal(1,0) DEFAULT NULL,
  `department` decimal(3,0) DEFAULT NULL,
  `insurer` decimal(3,0) DEFAULT NULL,
  `idx` decimal(10,0) DEFAULT NULL,
  `category` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `marital_status` decimal(1,0) DEFAULT NULL,
  `date_employed` date DEFAULT NULL,
  `previous_insurer` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `period_insured` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `beneficiary` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `beneficiary_id` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `beneficiary_relation` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `parish` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `policy_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `pin_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `branch` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `smart_cat_change` int NOT NULL DEFAULT '0',
  `cat_change_date` date DEFAULT NULL,
  `deleted` varchar(1) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `indv` decimal(10,0) DEFAULT NULL,
  `uploaded` decimal(1,0) DEFAULT NULL,
  `client_code` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `smart_sync` int DEFAULT NULL,
  `sync` int DEFAULT NULL,
  `return_error_message` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bank_branch` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_no` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `beneficary_account_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `beneficary_mob_no` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `beneficary_bank_branch` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `plan_code` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `employer_code` varchar(30) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`family_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `product_benefits`;
CREATE TABLE `product_benefits` (
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `benefit_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_code` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_type` enum('MEDICAL','NON_MEDICAL') COLLATE utf8mb4_general_ci NOT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `is_rider` tinyint(1) DEFAULT '0',
  `minimum_sum_assured` decimal(15,2) DEFAULT NULL,
  `maximum_sum_assured` decimal(15,2) DEFAULT NULL,
  `waiting_period` int DEFAULT NULL,
  `waiting_period_unit` enum('DAYS','MONTHS','YEARS') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_by` int DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`benefit_id`),
  UNIQUE KEY `product_id` (`product_id`,`benefit_code`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `product_benefits_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `insurance_products` (`product_id`),
  CONSTRAINT `product_benefits_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `product_benefits_ibfk_3` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `product_categories`;
CREATE TABLE `product_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `category_name` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `category_code` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_by` int DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `category_code` (`category_code`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `product_categories_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `product_categories_ibfk_2` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `product_rules`;
CREATE TABLE `product_rules` (
  `rule_id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `rule_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `rule_type` enum('ELIGIBILITY','PRICING','UNDERWRITING','CLAIMS') COLLATE utf8mb4_general_ci NOT NULL,
  `rule_condition` text COLLATE utf8mb4_general_ci NOT NULL,
  `rule_action` text COLLATE utf8mb4_general_ci NOT NULL,
  `priority` int DEFAULT '0',
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_by` int DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`rule_id`),
  KEY `product_id` (`product_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `product_rules_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `insurance_products` (`product_id`),
  CONSTRAINT `product_rules_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `product_rules_ibfk_3` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `providers`;
CREATE TABLE `providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `provider_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `provider_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `tel_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `mobile_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `postal_add` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `physical_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `town` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `provider_type` int DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `payment_mode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bank_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bank_branch` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `pin_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contract_start_date` date DEFAULT NULL,
  `contract_end_date` date DEFAULT NULL,
  `user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `date_modified` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `modified_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`provider_id`),
  UNIQUE KEY `provider_code` (`provider_code`),
  KEY `idx_provider_status` (`status`),
  KEY `idx_provider_type` (`provider_type`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `quotation_member_benefits`;
CREATE TABLE `quotation_member_benefits` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `quotation_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `member_id` bigint unsigned NOT NULL,
  `benefit_code` int NOT NULL,
  `premium` decimal(15,2) NOT NULL,
  `limit_amount` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_member` (`member_id`),
  KEY `idx_benefit` (`benefit_code`),
  CONSTRAINT `fk_benefit_code` FOREIGN KEY (`benefit_code`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_benefit_member` FOREIGN KEY (`member_id`) REFERENCES `quotation_members` (`member_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `quotation_members`;
CREATE TABLE `quotation_members` (
  `member_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `quotation_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `relation` enum('principal','spouse','child') COLLATE utf8mb4_general_ci NOT NULL,
  `age` int NOT NULL,
  `premium` decimal(15,2) NOT NULL,
  PRIMARY KEY (`member_id`),
  KEY `idx_quotation` (`quotation_no`),
  CONSTRAINT `fk_member_quotation` FOREIGN KEY (`quotation_no`) REFERENCES `quotations` (`quotation_no`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `quotations`;
CREATE TABLE `quotations` (
  `quotation_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `quotation_no` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `quotation_type` enum('NEW','ADDITIONAL') COLLATE utf8mb4_general_ci NOT NULL,
  `total_premium` decimal(15,2) NOT NULL,
  `valid_until` date NOT NULL,
  `status` enum('PENDING','ACCEPTED','REJECTED','EXPIRED') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'PENDING',
  `generated_by` int NOT NULL,
  `generated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`quotation_id`),
  UNIQUE KEY `quotation_no` (`quotation_no`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_status` (`status`),
  KEY `idx_valid_until` (`valid_until`),
  KEY `fk_quote_generator` (`generated_by`),
  KEY `fk_quote_modifier` (`modified_by`),
  CONSTRAINT `fk_quote_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_quote_generator` FOREIGN KEY (`generated_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_quote_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `receipt_allocations`;
CREATE TABLE `receipt_allocations` (
  `allocation_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `receipt_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `debit_id` bigint unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `is_partial` int DEFAULT NULL,
  `allocation_date` date NOT NULL,
  `user_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`allocation_id`),
  KEY `fk_allocation_debit` (`debit_id`),
  KEY `fk_allocation_receipt` (`receipt_no`),
  KEY `fk_allocation_user` (`user_id`),
  KEY `idx_allocation_date` (`allocation_date`),
  KEY `idx_amount` (`amount`),
  CONSTRAINT `fk_allocation_debit` FOREIGN KEY (`debit_id`) REFERENCES `premium_debit_notes` (`debit_id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `fk_allocation_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `regions`;
CREATE TABLE `regions` (
  `region_id` int NOT NULL AUTO_INCREMENT,
  `region_name` varchar(100) NOT NULL,
  `channel_id` int NOT NULL,
  `status` enum('ACTIVE','INACTIVE') NOT NULL DEFAULT 'ACTIVE',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int NOT NULL,
  PRIMARY KEY (`region_id`),
  KEY `channel_id` (`channel_id`),
  CONSTRAINT `regions_ibfk_1` FOREIGN KEY (`channel_id`) REFERENCES `distribution_channels` (`channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `report_parameters`;
CREATE TABLE `report_parameters` (
  `param_id` int NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `param_name` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `display_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `param_type` enum('text','number','date','dropdown','multi-select') COLLATE utf8mb4_general_ci NOT NULL,
  `default_value` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_required` tinyint(1) DEFAULT '1',
  `options` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`param_id`),
  KEY `template_id` (`template_id`),
  CONSTRAINT `report_parameters_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `report_templates` (`template_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `report_sections`;
CREATE TABLE `report_sections` (
  `section_id` int NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `section_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `section_order` int NOT NULL,
  `query_text` text COLLATE utf8mb4_general_ci NOT NULL,
  `chart_type` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`section_id`),
  KEY `template_id` (`template_id`),
  CONSTRAINT `report_sections_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `report_templates` (`template_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `report_templates`;
CREATE TABLE `report_templates` (
  `template_id` int NOT NULL AUTO_INCREMENT,
  `template_name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `is_public` tinyint(1) DEFAULT '0',
  `category` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`template_id`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `report_templates_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `reversed_claims`;
CREATE TABLE `reversed_claims` (
  `id` int NOT NULL AUTO_INCREMENT,
  `claim_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `claim_form_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `invoice_no` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `service` int NOT NULL,
  `provider` int NOT NULL,
  `member_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `claim_nature` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `batch_no` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `invoice_date` date NOT NULL,
  `invoiced_amount` decimal(10,0) NOT NULL,
  `date_received` date DEFAULT NULL,
  `vet_status` tinyint(1) DEFAULT NULL,
  `deduction_amount` decimal(10,0) DEFAULT NULL,
  `deduction_reason` int DEFAULT NULL,
  `amount_payable` decimal(10,0) DEFAULT NULL,
  `paid` tinyint(1) DEFAULT NULL,
  `anniv` tinyint DEFAULT NULL,
  `user_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_entered` date DEFAULT NULL,
  `voucher_no` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `voucher_user` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `voucher_date` date DEFAULT NULL,
  `payment_no` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `refund` tinyint(1) DEFAULT NULL,
  `admin_fee` decimal(10,0) DEFAULT NULL,
  `fund` tinyint(1) DEFAULT NULL,
  `pre_auth_no` int DEFAULT NULL,
  `corp_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `family_no` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `pri_dep` tinyint NOT NULL,
  `is_reimbursement` tinyint(1) DEFAULT '0',
  `reimbursement_bank` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reimbursement_account` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reimbursement_account_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reimbursement_status` enum('PENDING','PAID') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'PENDING',
  `copay_amount` decimal(15,2) DEFAULT '0.00',
  `copay_type` enum('PERCENTAGE','FIXED') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `copay_value` decimal(15,2) DEFAULT '0.00',
  `payable_amount` decimal(15,2) DEFAULT '0.00',
  `reversed_by` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `reversed_date` datetime NOT NULL,
  `reversal_reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `claim_no` (`claim_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `role_permissions`;
CREATE TABLE `role_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int NOT NULL,
  `menu_id` int NOT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`permission_id`),
  UNIQUE KEY `unique_role_menu` (`role_id`,`menu_id`),
  KEY `idx_role` (`role_id`),
  KEY `idx_menu` (`menu_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `role_permissions_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`) ON DELETE CASCADE,
  CONSTRAINT `role_permissions_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `role_permissions_ibfk_3` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2330 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `sales_targets`;
CREATE TABLE `sales_targets` (
  `target_id` int NOT NULL AUTO_INCREMENT,
  `agent_id` int NOT NULL,
  `business_class` varchar(50) NOT NULL,
  `target_amount` decimal(15,2) NOT NULL,
  `target_period` varchar(7) NOT NULL,
  `achieved_amount` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int NOT NULL,
  PRIMARY KEY (`target_id`),
  KEY `agent_id` (`agent_id`),
  CONSTRAINT `sales_targets_ibfk_1` FOREIGN KEY (`agent_id`) REFERENCES `agents` (`agent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `scheme_copay`;
CREATE TABLE `scheme_copay` (
  `copay_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_code` int NOT NULL,
  `copay_type` enum('PERCENTAGE','FIXED') COLLATE utf8mb4_general_ci NOT NULL,
  `copay_value` decimal(15,2) NOT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`copay_id`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_benefit` (`benefit_code`),
  KEY `idx_status` (`status`),
  KEY `fk_copay_creator` (`created_by`),
  KEY `fk_copay_modifier` (`modified_by`),
  CONSTRAINT `fk_copay_benefit` FOREIGN KEY (`benefit_code`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_copay_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_copay_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_copay_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `scheme_credit_rules`;
CREATE TABLE `scheme_credit_rules` (
  `rule_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `allow_credit_notes` tinyint(1) NOT NULL DEFAULT '1',
  `days_limit` int DEFAULT '90',
  `pro_rata` tinyint(1) NOT NULL DEFAULT '1',
  `minimum_amount` decimal(15,2) DEFAULT '0.00',
  `notes` text COLLATE utf8mb4_general_ci,
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rule_id`),
  UNIQUE KEY `corp_id` (`corp_id`),
  KEY `created_by` (`created_by`),
  KEY `modified_by` (`modified_by`),
  CONSTRAINT `scheme_credit_rules_ibfk_1` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `scheme_credit_rules_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `scheme_credit_rules_ibfk_3` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `scheme_provider_restrictions`;
CREATE TABLE `scheme_provider_restrictions` (
  `restriction_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_code` int NOT NULL,
  `provider_id` int NOT NULL,
  `restriction_type` enum('ALLOWED','NOT_ALLOWED') COLLATE utf8mb4_general_ci NOT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ACTIVE',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` int DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`restriction_id`),
  KEY `idx_corporate` (`corp_id`),
  KEY `idx_benefit` (`benefit_code`),
  KEY `idx_provider` (`provider_id`),
  KEY `idx_status` (`status`),
  KEY `fk_restriction_creator` (`created_by`),
  KEY `fk_restriction_modifier` (`modified_by`),
  CONSTRAINT `fk_restriction_benefit` FOREIGN KEY (`benefit_code`) REFERENCES `benefit` (`code`),
  CONSTRAINT `fk_restriction_corporate` FOREIGN KEY (`corp_id`) REFERENCES `corporate` (`corp_id`),
  CONSTRAINT `fk_restriction_creator` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_restriction_modifier` FOREIGN KEY (`modified_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_restriction_provider` FOREIGN KEY (`provider_id`) REFERENCES `providers` (`provider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `services`;
CREATE TABLE `services` (
  `code` int NOT NULL,
  `service` varchar(25) NOT NULL,
  `status` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL,
  `setting_value` text NOT NULL,
  `company_logo` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `support_tickets`;
CREATE TABLE `support_tickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `subject` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `description` text COLLATE utf8mb4_general_ci NOT NULL,
  `internal_notes` varchar(200) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `category` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `priority` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'OPEN',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ticket_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `support_tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `suspended_benefits`;
CREATE TABLE `suspended_benefits` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `corp_id` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `category_code` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `benefit_code` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `suspend_reason` text COLLATE utf8mb4_general_ci NOT NULL,
  `suspended_by` int NOT NULL,
  `suspended_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `activated` tinyint(1) NOT NULL DEFAULT '0',
  `activated_by` int DEFAULT NULL,
  `activated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_corp_cat_ben` (`corp_id`,`category_code`,`benefit_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `system_updates`;
CREATE TABLE `system_updates` (
  `update_id` int NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `update_files` json DEFAULT NULL,
  `db_changes` json DEFAULT NULL,
  `release_date` date DEFAULT NULL,
  `installed_date` timestamp NULL DEFAULT NULL,
  `installed_by` int DEFAULT NULL,
  `status` enum('AVAILABLE','INSTALLING','INSTALLED','FAILED') COLLATE utf8mb4_general_ci DEFAULT 'AVAILABLE',
  `error_message` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`update_id`),
  KEY `installed_by` (`installed_by`),
  CONSTRAINT `system_updates_ibfk_1` FOREIGN KEY (`installed_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `ticket_activity_log`;
CREATE TABLE `ticket_activity_log` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `ticket_id` int NOT NULL,
  `user_id` int NOT NULL,
  `description` text COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `ticket_activity_log_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`ticket_id`),
  CONSTRAINT `ticket_activity_log_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `ticket_attachments`;
CREATE TABLE `ticket_attachments` (
  `attachment_id` int NOT NULL AUTO_INCREMENT,
  `ticket_id` int NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `file_path` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `uploaded_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`attachment_id`),
  KEY `ticket_id` (`ticket_id`),
  CONSTRAINT `ticket_attachments_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`ticket_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `ticket_comments`;
CREATE TABLE `ticket_comments` (
  `comment_id` int NOT NULL AUTO_INCREMENT,
  `ticket_id` int NOT NULL,
  `user_id` int NOT NULL,
  `comment` text COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`comment_id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `ticket_comments_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`ticket_id`),
  CONSTRAINT `ticket_comments_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `update_logs`;
CREATE TABLE `update_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `update_id` int DEFAULT NULL,
  `log_type` enum('INFO','WARNING','ERROR') COLLATE utf8mb4_general_ci DEFAULT 'INFO',
  `message` text COLLATE utf8mb4_general_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `update_id` (`update_id`),
  CONSTRAINT `update_logs_ibfk_1` FOREIGN KEY (`update_id`) REFERENCES `system_updates` (`update_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `user_role`;
CREATE TABLE `user_role` (
  `role_id` int NOT NULL AUTO_INCREMENT,
  `role_name` varchar(50) NOT NULL,
  PRIMARY KEY (`role_id`),
  UNIQUE KEY `role_name` (`role_name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `user_roles`;
CREATE TABLE `user_roles` (
  `user_id` int NOT NULL,
  `role_id` int NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `user_roles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `user_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `user_role` enum('admin','general_manager','operations','finance','declaration_officer','shipping_line_clerk','transport_supervisor') DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `verified` tinyint DEFAULT '1',
  `failed_attempts` int NOT NULL DEFAULT '0',
  `last_attempt_time` timestamp NULL DEFAULT NULL,
  `last_password_change` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `role_id` int DEFAULT NULL,
  `last_active` timestamp NULL DEFAULT NULL,
  `avatar` varchar(30) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `email` (`email`),
  KEY `fk_user_role` (`role_id`),
  CONSTRAINT `fk_user_role` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;

INSERT INTO `active_corporate_discounts` VALUES
('1', '3', NULL, '5', '5.00', '2025-01-14', '2026-01-14', 'ACTIVE', '1', '2025-01-14 15:32:53', NULL, NULL, 'Polakis Technologies Ltd', NULL),
('2', '3', NULL, '10', '10.00', '2025-01-14', '2026-01-14', 'ACTIVE', '1', '2025-01-14 15:32:53', NULL, NULL, 'Polakis Technologies Ltd', NULL),
('3', '3', NULL, '20', '15.00', '2025-01-14', '2026-01-14', 'ACTIVE', '1', '2025-01-14 15:32:53', NULL, NULL, 'Polakis Technologies Ltd', NULL);

INSERT INTO `activity_log` VALUES
('16', '1', 'DELETE', 'corporate', '6', '{\"corp_id\":\"6\",\"corporate\":\"ISY Solutions\",\"tel_no\":null,\"fax_no\":null,\"mobile_no\":null,\"postal_add\":null,\"town\":0,\"phy_loc\":null,\"email\":null,\"user_id\":\"Admin\",\"date_entered\":\"2024-12-24\",\"agent_id\":null,\"scheme\":\"ISS\",\"date_modified\":null,\"modified_by\":null,\"cancelled\":0,\"insurer\":null,\"underwrite\":null,\"waiting_period\":null,\"enhanced\":null,\"acct_no\":null,\"policy_no\":\"ISY\",\"individual\":2,\"idx\":null,\"branch\":null,\"notes\":null,\"web_synced\":0,\"abbreviation\":null,\"smart_picked\":0,\"smart_sync\":0,\"uploaded\":null,\"corp_pin\":\"A00354G\",\"currency\":\"Kes.\",\"sync\":null,\"outpatient_threshold\":\"7.00\",\"inpatient_threshold\":\"7.00\"}', '{\"cancelled\":1,\"modified_by\":1}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-24 13:37:57', '{\"session_id\":\"099e81692be6943b0f2514d8a6212401\",\"deletion_type\":\"soft_delete\"}'),
('17', '1', 'DELETE', 'corporate', '6', '{\"corp_id\":\"6\",\"corporate\":\"ISY Solutions\",\"tel_no\":null,\"fax_no\":null,\"mobile_no\":null,\"postal_add\":null,\"town\":0,\"phy_loc\":null,\"email\":null,\"user_id\":\"Admin\",\"date_entered\":\"2024-12-24\",\"agent_id\":null,\"scheme\":\"ISS\",\"date_modified\":\"2024-12-24\",\"modified_by\":\"1\",\"cancelled\":1,\"insurer\":null,\"underwrite\":null,\"waiting_period\":null,\"enhanced\":null,\"acct_no\":null,\"policy_no\":\"ISY\",\"individual\":2,\"idx\":null,\"branch\":null,\"notes\":null,\"web_synced\":0,\"abbreviation\":null,\"smart_picked\":0,\"smart_sync\":0,\"uploaded\":null,\"corp_pin\":\"A00354G\",\"currency\":\"Kes.\",\"sync\":null,\"outpatient_threshold\":\"7.00\",\"inpatient_threshold\":\"7.00\"}', '{\"cancelled\":1,\"modified_by\":1}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-24 13:38:10', '{\"session_id\":\"099e81692be6943b0f2514d8a6212401\",\"deletion_type\":\"soft_delete\"}'),
('18', '1', 'DELETE', 'corporate', '4', '{\"corp_id\":\"4\",\"corporate\":\"BSixty7 Software\",\"tel_no\":null,\"fax_no\":null,\"mobile_no\":null,\"postal_add\":null,\"town\":0,\"phy_loc\":null,\"email\":null,\"user_id\":\"Admin\",\"date_entered\":\"2024-12-24\",\"agent_id\":null,\"scheme\":\"BS7\",\"date_modified\":null,\"modified_by\":null,\"cancelled\":0,\"insurer\":null,\"underwrite\":null,\"waiting_period\":null,\"enhanced\":null,\"acct_no\":null,\"policy_no\":\"BS7\",\"individual\":2,\"idx\":null,\"branch\":null,\"notes\":null,\"web_synced\":0,\"abbreviation\":null,\"smart_picked\":0,\"smart_sync\":0,\"uploaded\":null,\"corp_pin\":\"A00354G\",\"currency\":\"Kes.\",\"sync\":null,\"outpatient_threshold\":\"70.00\",\"inpatient_threshold\":\"70.00\"}', '{\"cancelled\":1,\"modified_by\":1}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-24 13:58:53', '{\"session_id\":\"099e81692be6943b0f2514d8a6212401\",\"deletion_type\":\"soft_delete\"}'),
('21', '1', 'CREATE', 'premium_debit_notes', '3', NULL, '{\"debit_no\":\"DN\\/2400001\",\"debit_type\":\"SCHEME\",\"corp_id\":\"3\",\"family_no\":null,\"amount\":10000,\"status\":\"POSTED\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-25 21:06:40', NULL),
('22', '1', 'CREATE', 'insuring_rates', '1', NULL, '{\"full_desc\":\"Rate 1 AAR\",\"insurer\":\"2\",\"year\":\"2024\",\"benefit\":\"2\",\"limit\":\"500000\",\"premium\":\"5000\",\"family_size\":\"\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 07:48:15', NULL),
('23', '1', 'CREATE', 'insuring_rates', '2', NULL, '{\"full_desc\":\"Rate 1 Madison\",\"insurer\":\"1\",\"year\":\"2024\",\"benefit\":\"2\",\"limit\":\"1000000\",\"premium\":\"5000\",\"family_size\":\"\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 07:49:23', NULL),
('24', '1', 'CREATE', 'insuring_rates', '3', NULL, '{\"full_desc\":\"Rate 2 AAR\",\"insurer\":\"2\",\"year\":\"2024\",\"benefit\":\"1\",\"limit\":\"1000000\",\"premium\":\"5000\",\"family_size\":\"\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 07:49:40', NULL),
('25', '1', 'CREATE', 'insuring_rates', '1', NULL, '{\"full_desc\":\"Rate 1 AAR\",\"corp_id\":\"3\",\"insurer\":\"2\",\"benefit\":\"2\",\"limit\":\"500000\",\"premium\":\"5000\",\"family_size\":\"\",\"year\":\"2024\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 08:03:47', NULL),
('26', '1', 'CREATE', 'insuring_rates', '2', NULL, '{\"rate_details\":{\"full_desc\":\"Rate 2 AAR\",\"corp_id\":\"3\",\"insurer\":\"2\",\"benefit\":\"1\",\"limit\":\"1000000\",\"premium\":\"5000\",\"family_size\":\"\",\"year\":\"2024\"},\"corporate_specific\":true}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 08:13:23', NULL),
('27', '1', 'CREATE', 'insuring_rates', '3', NULL, '{\"rate_details\":{\"full_desc\":\"Rate 3 AAR\",\"corp_id\":\"3\",\"insurer\":\"2\",\"benefit\":\"2\",\"limit\":\"100000\",\"premium\":\"5000\",\"family_size\":\"1\",\"year\":\"2024\"},\"corporate_specific\":true}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 08:51:10', NULL),
('28', '1', 'CREATE', 'premium_invoice', 'INV0000002', NULL, '{\"invoice_no\":\"INV0000002\",\"invoice_type\":\"NEW\",\"corp_id\":\"3\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 12:45:25', NULL),
('29', '1', 'DELETE', 'insuring_rates', '1', NULL, '{\"code\":\"1\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-26 12:56:59', NULL),
('30', '1', 'UPDATE', 'bills', 'CLM-0000004', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":0,\"deduction_reason\":0,\"amount_payable\":200000,\"invoice_no\":\"55354er\"}', NULL, NULL, '2024-12-27 19:15:06', 'Invoice 55354er Approved: '),
('31', '1', 'UPDATE', 'bills', 'CLM-0000004', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":0,\"deduction_reason\":0,\"amount_payable\":4560,\"invoice_no\":\"56554\"}', NULL, NULL, '2024-12-27 19:17:33', 'Invoice 56554 Approved: '),
('32', '1', 'UPDATE', 'settings', 'tax', NULL, '{\"phcf_percentage\":0.25,\"stamp_duty\":40}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 12:20:28', NULL),
('33', '1', 'UPDATE', 'settings', 'tax', NULL, '{\"phcf_percentage\":0.2600000000000000088817841970012523233890533447265625,\"stamp_duty\":40}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 12:22:20', NULL),
('34', '1', 'UPDATE', 'settings', 'tax', NULL, '{\"phcf_percentage\":0.25,\"stamp_duty\":40}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 12:22:31', NULL),
('35', '1', 'UPDATE', 'settings', 'tax', NULL, '{\"phcf_percentage\":0.25,\"training_levy\":0.2099999999999999922284388276239042170345783233642578125,\"stamp_duty\":40}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 12:58:49', NULL),
('36', '1', 'UPDATE', 'settings', 'tax', NULL, '{\"phcf_percentage\":0.25,\"training_levy\":0.200000000000000011102230246251565404236316680908203125,\"stamp_duty\":40}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 12:58:59', NULL),
('37', '1', 'CREATE', 'premium_invoice', 'INV0000003', NULL, '{\"invoice_no\":\"INV0000003\",\"invoice_type\":\"NEW\",\"corp_id\":\"3\"}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 14:22:52', NULL),
('38', '1', 'CREATE', 'premium_invoice', 'INV0000001', NULL, '{\"invoice_no\":\"INV0000001\",\"invoice_type\":\"NEW\",\"corp_id\":\"3\"}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 14:28:55', NULL),
('39', '1', 'CREATE', 'insuring_rates', '4', NULL, '{\"rate_details\":{\"full_desc\":\"Rate 1 SSL\",\"corp_id\":\"4\",\"insurer\":\"2\",\"benefit\":\"2\",\"limit\":\"100000\",\"premium\":\"5000\",\"family_size\":\"\",\"year\":\"2024\"},\"corporate_specific\":true}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 19:43:27', NULL),
('40', '1', 'CREATE', 'insuring_rates', '5', NULL, '{\"rate_details\":{\"full_desc\":\"Rate 2 SSL\",\"corp_id\":\"4\",\"insurer\":\"2\",\"benefit\":\"1\",\"limit\":\"1000000\",\"premium\":\"5500\",\"family_size\":\"2\",\"year\":\"2024\"},\"corporate_specific\":true}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-28 19:44:05', NULL),
('41', '1', 'CREATE', 'pre_authorization', '2', NULL, '{\"pre_auth_code\":\"PA000002\",\"member_no\":\"PTL-001-00\",\"reserve\":\"10000\",\"authority_type\":\"1\"}', '154.159.252.20', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-29 08:16:33', NULL),
('42', '1', 'CREATE', 'premium_receipt', 'RCP0000001', NULL, '{\"receipt_no\":\"RCP0000001\",\"amount\":\"10000.00\",\"payment_mode\":2,\"debit_id\":\"5\",\"new_status\":\"UNALLOCATED\",\"allocated_amount\":10000}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2024-12-31 08:44:51', NULL),
('43', '1', 'UPDATE', 'bills', 'CLM-0000003', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":300,\"deduction_reason\":1,\"amount_payable\":900,\"invoice_no\":\"INV0001\"}', NULL, NULL, '2025-01-09 10:04:27', 'Invoice INV0001 Approved: '),
('44', '1', 'CREATE', 'premium_receipt', 'RCP0000002', NULL, '{\"receipt_no\":\"RCP0000002\",\"amount\":\"9000\",\"payment_mode\":2,\"debit_id\":\"6\",\"new_status\":\"UNALLOCATED\",\"allocated_amount\":9000}', '197.248.222.6', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36', '2025-01-09 10:14:38', NULL),
('45', '1', 'UPDATE', 'premium_debit_notes', 'DN/2500001', NULL, '{\"commission_amount\":953.74656249999998181010596454143524169921875,\"is_new_client\":true,\"status\":\"ALLOCATED\"}', NULL, NULL, '2025-01-10 07:05:16', NULL),
('46', '1', '', 'premium_debit_notes', '', NULL, '{\"total_system_amount\":10125,\"total_schedule_amount\":350000,\"total_variance\":339875,\"matches\":0,\"mismatches\":3}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-10 15:03:40', '{\"total_policies\":3,\"missing_in_system\":2,\"missing_in_schedule\":1}'),
('47', '1', '', 'premium_debit_notes', '', NULL, '{\"total_system_amount\":10125,\"total_schedule_amount\":350000,\"total_variance\":339875,\"matches\":0,\"mismatches\":3}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-10 16:18:40', '{\"total_policies\":3,\"missing_in_system\":2,\"missing_in_schedule\":1}'),
('48', '1', '', 'premium_debit_notes', '', NULL, '{\"total_system_amount\":10125,\"total_schedule_amount\":350000,\"total_variance\":339875,\"matches\":0,\"mismatches\":3}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-10 16:23:34', '{\"total_policies\":3,\"missing_in_system\":2,\"missing_in_schedule\":1}'),
('49', '1', '', 'premium_debit_notes', '', NULL, '{\"total_system_amount\":10125,\"total_schedule_amount\":350000,\"total_variance\":339875,\"matches\":0,\"mismatches\":3}', '154.76.171.22', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Edg/131.0.0.0', '2025-01-10 16:23:36', '{\"total_policies\":3,\"missing_in_system\":2,\"missing_in_schedule\":1}'),
('50', '1', '', 'bills', 'EXPORT-20250111145321', NULL, '{\"report_type\":\"vetted_claims\",\"date_from\":\"2024-11-01\",\"date_to\":\"2025-01-11\",\"filters\":{\"corporate\":\"all\",\"provider\":\"all\",\"benefit\":\"all\"},\"record_count\":4}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-11 17:53:21', 'Exported 4 records to Excel'),
('51', '1', '', 'bills', 'EXPORT-20250111145402', NULL, '{\"report_type\":\"claims_analysis\",\"date_from\":\"2024-11-01\",\"date_to\":\"2025-01-11\",\"filters\":{\"corporate\":\"all\",\"provider\":\"all\",\"benefit\":\"all\"},\"record_count\":2}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-11 17:54:02', 'Exported 2 records to Excel'),
('52', '1', '', 'finance_reports', 'EXPORT-20250111191748', NULL, '{\"report_type\":\"premium_collections\",\"date_from\":\"2024-12-11\",\"date_to\":\"2025-01-11\",\"filters\":{\"corporate\":\"all\",\"status\":\"Fully Allocated\"}}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-11 22:17:48', NULL),
('53', '1', '', 'finance_reports', 'EXPORT-20250111191807', NULL, '{\"report_type\":\"debit_summary\",\"date_from\":\"2024-11-01\",\"date_to\":\"2025-01-11\",\"filters\":{\"corporate\":\"all\",\"status\":\"all\"}}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-11 22:18:07', NULL),
('54', '1', '', 'bills', 'template', NULL, 'Downloaded claims template', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-12 19:37:00', '{\"template_type\":\"provider_claims\",\"download_time\":\"2025-01-12 16:37:00\"}'),
('55', '1', '', 'bills', '1-3', NULL, '{\"total_system_amount\":212760,\"total_provider_amount\":3500,\"total_variance\":-209260,\"matching_claims\":0,\"provider_id\":\"1\",\"corp_id\":\"3\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-12 20:05:05', '{\"total_system_claims\":7,\"total_provider_claims\":2,\"difference_count\":9}'),
('56', '1', 'CREATE', 'fund_transactions', 'FND2025016823', NULL, '{\"receipt_no\":\"FND2025016823\",\"amount\":750000,\"payment_mode\":2,\"cheque_no\":\"CHQ475A\"}', '154.159.252.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-13 08:37:35', '{\"transaction_type\":\"TOPUP\",\"corporate_id\":\"5\"}'),
('57', '1', '', 'bills', '1-3', NULL, '{\"total_system_amount\":212760,\"total_provider_amount\":212760,\"total_variance\":0,\"matching_claims\":7,\"provider_id\":\"1\",\"corp_id\":\"3\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-13 09:57:58', '{\"total_system_claims\":7,\"total_provider_claims\":9,\"difference_count\":9}'),
('58', '1', '', 'bills', 'template', NULL, 'Downloaded claims template', '197.248.222.6', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36', '2025-01-13 13:36:17', '{\"template_type\":\"provider_claims\",\"download_time\":\"2025-01-13 10:36:17\"}'),
('59', '1', '', 'bills', '1-3', NULL, '{\"total_system_amount\":212760,\"total_provider_amount\":3500,\"total_variance\":-209260,\"matching_claims\":0,\"provider_id\":\"1\",\"corp_id\":\"3\"}', '197.248.222.6', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36', '2025-01-13 13:36:54', '{\"total_system_claims\":7,\"total_provider_claims\":2,\"difference_count\":9}'),
('60', '1', '', 'premium_debit_notes', '', NULL, '{\"total_system_amount\":10125,\"total_schedule_amount\":350000,\"total_variance\":339875,\"matches\":0,\"mismatches\":3}', '197.248.222.6', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36', '2025-01-13 13:47:51', '{\"total_policies\":3,\"missing_in_system\":2,\"missing_in_schedule\":1}'),
('61', '1', 'UPDATE', 'corp_anniversary', '4', NULL, '{\"corp_id\":\"4\",\"old_anniv\":1,\"new_anniv\":2,\"start_date\":\"2024-12-28\",\"end_date\":\"2025-12-27\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-13 21:32:09', '{\"action\":\"Corporate Renewal\",\"scheme\":\"SSL\",\"members_pending\":true}'),
('62', '1', 'DELETE', 'benefit', '12', '{\"code\":\"12\"}', NULL, NULL, NULL, '2025-01-16 08:14:08', NULL),
('63', '1', 'DELETE', 'corporate', '4', '{\"corp_id\":\"4\",\"corporate\":\"Saroze Solutions\",\"tel_no\":null,\"fax_no\":null,\"mobile_no\":null,\"postal_add\":null,\"town\":1,\"phy_loc\":null,\"email\":null,\"user_id\":\"Admin\",\"date_entered\":\"2024-12-28\",\"agent_id\":null,\"scheme\":\"SSL\",\"date_modified\":null,\"modified_by\":null,\"cancelled\":0,\"insurer\":2,\"underwrite\":null,\"waiting_period\":null,\"enhanced\":null,\"acct_no\":null,\"policy_no\":\"SSL\",\"individual\":2,\"idx\":null,\"branch\":null,\"notes\":null,\"web_synced\":0,\"abbreviation\":null,\"smart_picked\":0,\"smart_sync\":0,\"uploaded\":null,\"corp_pin\":\"A00563456Y\",\"currency\":\"Kes.\",\"sync\":null,\"outpatient_threshold\":\"70.00\",\"inpatient_threshold\":\"70.00\",\"fund_balance\":\"0.00\"}', '{\"cancelled\":1,\"modified_by\":1}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 19:01:47', '{\"session_id\":\"4e2a1930cdc9e8d6801ceea30be5f97d\",\"deletion_type\":\"soft_delete\"}'),
('64', '1', '', 'premium_debit_notes', 'PDF-20250116162721', NULL, '{\"report_type\":\"commission\",\"corporate_id\":\"\",\"date_generated\":\"2025-01-16 16:27:21\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 19:27:21', 'Generated PDF report: Commission Ledger'),
('65', '1', '', 'premium_debit_notes', 'PDF-20250116162723', NULL, '{\"report_type\":\"commission\",\"corporate_id\":\"\",\"date_generated\":\"2025-01-16 16:27:23\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 19:27:23', 'Generated PDF report: Commission Ledger'),
('66', '1', '', 'icd10_codes', 'BULK', NULL, '{\"added\":499,\"updated\":0,\"skipped\":0,\"file_name\":\"icd10_template(1).xlsx\"}', NULL, NULL, '2025-01-16 19:41:55', NULL),
('67', '1', '', 'icd10_codes', 'BULK', NULL, '{\"added\":1100,\"updated\":0,\"skipped\":0,\"file_name\":\"icd10_template.xlsx\"}', NULL, NULL, '2025-01-16 19:52:00', NULL),
('68', '1', '', 'icd10_codes', 'BULK', NULL, '{\"added\":1400,\"updated\":0,\"skipped\":0,\"file_name\":\"icd10_template.xlsx\"}', NULL, NULL, '2025-01-16 19:59:34', NULL),
('69', '1', 'CREATE', 'bills', 'CLM-0000007', NULL, '{\"claim_no\":\"CLM-0000007\",\"member_no\":\"PTL-001-00\",\"diagnoses\":[{\"id\":\"464\",\"primary\":1}],\"claim_count\":1}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 20:29:27', NULL),
('70', '1', 'CREATE', 'bills', 'CLM-0000008', NULL, '{\"claim_no\":\"CLM-0000008\",\"member_no\":\"PTL-001-00\",\"diagnoses\":[{\"id\":\"68\",\"primary\":1}],\"claim_count\":2}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 21:56:59', NULL),
('71', '1', 'UPDATE', 'bills', 'CLM-0000008', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":0,\"deduction_reason\":0,\"amount_payable\":5000,\"invoice_no\":\"INVTY67\"}', NULL, NULL, '2025-01-16 21:57:44', 'Invoice INVTY67 Approved: '),
('72', '1', 'CREATE', 'bills_payment', '20250001', NULL, '{\"payment_mode\":\"1\",\"cheque_no\":\"CHQ1234Z\",\"cheque_date\":\"2025-01-16\",\"admin_fee\":0,\"total_amount\":5000,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"},\"claims\":[{\"claim_no\":\"CLM-0000008\",\"invoice_no\":\"INVTY67\",\"amount\":5000,\"provider_id\":1,\"member_no\":\"PTL-001-00\",\"corp_id\":3}]}', NULL, NULL, '2025-01-16 22:21:10', 'Payment processed for 1 claim(s). Payment to: provider'),
('73', '1', '', 'premium_debit_notes', 'PDF-20250116194631', NULL, '{\"report_type\":\"premium\",\"corporate_id\":\"\",\"date_generated\":\"2025-01-16 19:46:31\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 22:46:31', 'Generated PDF report: Premium Ledger'),
('74', '1', '', 'premium_debit_notes', 'PDF-20250116194632', NULL, '{\"report_type\":\"premium\",\"corporate_id\":\"\",\"date_generated\":\"2025-01-16 19:46:32\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 22:46:32', 'Generated PDF report: Premium Ledger'),
('75', '1', '', 'bills', 'PDF-20250116194657', NULL, '{\"report_type\":\"claims\",\"corporate_id\":\"\",\"date_generated\":\"2025-01-16 19:46:57\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 22:46:57', 'Generated PDF report: Claims Ledger'),
('76', '1', '', 'bills', 'PDF-20250116194659', NULL, '{\"report_type\":\"claims\",\"corporate_id\":\"\",\"date_generated\":\"2025-01-16 19:46:59\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-16 22:46:59', 'Generated PDF report: Claims Ledger'),
('77', '1', 'DELETE', 'corporate', '4', '{\"corp_id\":\"4\",\"corporate\":\"Saroze Solutions\",\"tel_no\":null,\"fax_no\":null,\"mobile_no\":null,\"postal_add\":null,\"town\":1,\"phy_loc\":null,\"email\":null,\"user_id\":\"Admin\",\"date_entered\":\"2024-12-28\",\"agent_id\":null,\"scheme\":\"SSL\",\"date_modified\":\"2025-01-16\",\"modified_by\":\"1\",\"cancelled\":1,\"insurer\":2,\"underwrite\":null,\"waiting_period\":null,\"enhanced\":null,\"acct_no\":null,\"policy_no\":\"SSL\",\"individual\":2,\"idx\":null,\"branch\":null,\"notes\":null,\"web_synced\":0,\"abbreviation\":null,\"smart_picked\":0,\"smart_sync\":0,\"uploaded\":null,\"corp_pin\":\"A00563456Y\",\"currency\":\"Kes.\",\"sync\":null,\"outpatient_threshold\":\"70.00\",\"inpatient_threshold\":\"70.00\",\"fund_balance\":\"0.00\"}', '{\"cancelled\":1,\"modified_by\":1}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-17 13:13:10', '{\"session_id\":\"4e2a1930cdc9e8d6801ceea30be5f97d\",\"deletion_type\":\"soft_delete\"}'),
('78', '1', '', 'corporate', '4', '{\"status\":\"PREVIOUS_STATUS\"}', '{\"status\":\"SUSPENDED\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-17 13:54:55', '{\"reason\":\"Holds\"}'),
('79', '1', '', 'corporate', '4', '{\"status\":\"PREVIOUS_STATUS\"}', '{\"status\":\"SUSPENDED\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-17 13:56:07', '{\"reason\":\"Holds\"}'),
('80', '1', '', 'corporate', '4', '{\"status\":\"SUSPENDED\",\"cancelled\":1}', '{\"status\":\"ACTIVE\",\"cancelled\":0}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-17 13:59:31', '{\"reason\":\"Cleared holds\",\"action_type\":\"reinstate\"}'),
('81', '1', '', 'corporate', '4', '{\"status\":\"ACTIVE\",\"cancelled\":0}', '{\"status\":\"SUSPENDED\",\"cancelled\":1}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-17 13:59:44', '{\"reason\":\"Holds\",\"action_type\":\"suspend\"}'),
('82', '1', '', 'corporate', '4', '{\"status\":\"SUSPENDED\",\"cancelled\":1}', '{\"status\":\"ACTIVE\",\"cancelled\":0}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-17 13:59:57', '{\"reason\":\"Cleared holds\",\"action_type\":\"reinstate\"}'),
('83', '1', 'CREATE', 'bills_payment', '20250002', NULL, '{\"payment_mode\":\"1\",\"cheque_no\":\"CHQ1234S\",\"cheque_date\":\"2025-01-18\",\"admin_fee\":0,\"total_amount\":900,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"},\"claims\":[{\"claim_no\":\"CLM-0000003\",\"invoice_no\":\"INV0001\",\"amount\":900,\"provider_id\":1,\"member_no\":\"PTL-001-00\",\"corp_id\":3}]}', NULL, NULL, '2025-01-18 07:31:41', 'Payment processed for 1 claim(s). Payment to: provider'),
('84', '1', 'CREATE', 'bills_payment', '20250003', NULL, '{\"payment_no\":\"20250003\",\"voucher_no\":\"VCH-20250003\",\"amount\":4560,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"}}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-18 07:44:21', 'Payment processed for 1 claim(s). Total amount: 4560.00. Payment to: Aga Khan University Hospital'),
('85', '1', '', 'member_info', 'PTL-001-00', NULL, '{\"member_no\":\"PTL-001-00\",\"exit_date\":\"2025-01-19\",\"total_credit\":null,\"benefits_processed\":0,\"proration_factor\":0.8109589041095890404875490276026539504528045654296875}', '102.140.245.174', NULL, '2025-01-19 08:37:18', 'Exit credit calculation performed'),
('86', '1', '', 'member_info', 'PTL-001-00', NULL, '{\"member_no\":\"PTL-001-00\",\"exit_date\":\"2025-01-19\",\"total_credit\":null,\"benefits_processed\":0,\"proration_factor\":0.8109589041095890404875490276026539504528045654296875}', '102.140.245.174', NULL, '2025-01-19 08:59:37', 'Exit credit calculation performed'),
('87', '1', 'CREATE', 'bills', 'CLM-0000009', NULL, '{\"claim_no\":\"CLM-0000009\",\"member_no\":\"PTL-001-00\",\"diagnoses\":[{\"id\":\"67\",\"primary\":1}],\"claim_count\":1}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-19 18:34:38', NULL),
('88', '1', 'CREATE', 'scheme_copay', '1', NULL, '{\"corp_id\":\"3\",\"benefit_code\":\"15\",\"copay_type\":\"FIXED\",\"copay_value\":\"1000\",\"status\":\"ACTIVE\"}', NULL, NULL, '2025-01-19 18:36:31', NULL),
('89', '1', 'CREATE', 'scheme_provider_restrictions', '1', NULL, '{\"corp_id\":\"3\",\"benefit_code\":\"15\",\"provider_id\":\"1\",\"restriction_type\":\"ALLOWED\",\"status\":\"ACTIVE\"}', NULL, NULL, '2025-01-19 18:36:48', NULL),
('90', '1', '', 'policies', 'PTL-001', NULL, '{\"action\":\"Downloaded policy document\",\"policy_no\":\"PTL001\",\"family_no\":\"PTL-001\",\"download_date\":\"2025-01-20 09:25:00\"}', NULL, NULL, '2025-01-20 12:25:00', NULL),
('91', '1', '', 'policies', 'PTL-001', NULL, '{\"action\":\"Downloaded policy document\",\"policy_no\":\"PTL001\",\"family_no\":\"PTL-001\",\"download_date\":\"2025-01-20 09:25:02\"}', NULL, NULL, '2025-01-20 12:25:02', NULL),
('92', '1', '', 'policies', 'PTL-001', NULL, '{\"action\":\"Downloaded policy document\",\"policy_no\":\"PTL001\",\"family_no\":\"PTL-001\",\"download_date\":\"2025-01-20 13:27:02\"}', NULL, NULL, '2025-01-20 16:27:02', NULL),
('93', '1', '', 'member_info', 'PTL-001', NULL, '{\"member_count\":1,\"generated_at\":\"2025-01-20 13:36:55\"}', NULL, NULL, '2025-01-20 16:36:55', 'Generated member cards for family: PTL-001'),
('94', '1', '', 'member_info', 'PTL-001', NULL, '{\"member_count\":1,\"generated_at\":\"2025-01-20 13:36:57\"}', NULL, NULL, '2025-01-20 16:36:57', 'Generated member cards for family: PTL-001'),
('95', '1', '', 'member_info', 'PTL-001', NULL, '{\"member_count\":1,\"generated_at\":\"2025-01-20 13:45:57\"}', NULL, NULL, '2025-01-20 16:45:57', 'Generated member cards for family: PTL-001'),
('96', '1', '', 'member_info', 'PTL-001', NULL, '{\"member_count\":1,\"generated_at\":\"2025-01-20 13:46:00\"}', NULL, NULL, '2025-01-20 16:46:00', 'Generated member cards for family: PTL-001'),
('97', '1', 'UPDATE', 'liability_limits', '3', NULL, '{\"corp_id\":\"3\",\"benefit_code\":\"3\",\"limit_amount\":5000,\"notes\":\"\"}', NULL, NULL, '2025-01-21 09:03:12', NULL),
('98', '1', 'UPDATE', 'corp_renewal_status', '2', NULL, '{\"renewable\":\"1\",\"reason\":\"Can renew\"}', NULL, NULL, '2025-01-21 09:06:25', 'Updated renewal status to: Renewable'),
('99', '1', 'CREATE', 'scheme_credit_rules', '3', NULL, '{\"corp_id\":\"3\",\"allow_credit_notes\":\"1\",\"days_limit\":\"90\",\"pro_rata\":\"1\",\"minimum_amount\":\"1000.00\",\"notes\":\"\"}', NULL, NULL, '2025-01-21 19:56:31', NULL),
('100', '1', 'DELETE', 'scheme_credit_rules', '1', '{\"rule_id\":1,\"corp_id\":\"3\",\"allow_credit_notes\":1,\"days_limit\":90,\"pro_rata\":1,\"minimum_amount\":\"1000.00\",\"notes\":\"\",\"created_by\":1,\"created_at\":\"2025-01-21 19:56:31\",\"modified_by\":null,\"modified_at\":null}', NULL, NULL, NULL, '2025-01-21 20:00:31', NULL),
('101', '1', 'UPDATE', 'bills', 'CLM-0000010', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":0,\"deduction_reason\":0,\"amount_payable\":5000,\"invoice_no\":\"SHL003\",\"is_reimbursement\":0}', NULL, NULL, '2025-01-23 11:08:01', 'Invoice SHL003 Approved: '),
('102', '1', 'CREATE', 'bills_payment', '20250004', NULL, '{\"payment_no\":\"20250004\",\"voucher_no\":\"VCH-20250004\",\"amount\":5000,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"}}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-23 11:08:51', 'Payment processed for 1 claim(s). Total amount: 5000.00. Payment to: Aga Khan University Hospital'),
('103', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"21\",\"22\",\"23\",\"24\",\"25\",\"26\"]}', NULL, NULL, '2025-01-24 16:03:47', NULL),
('104', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"42\",\"44\",\"46\",\"51\",\"52\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\"]}', NULL, NULL, '2025-01-24 16:04:12', NULL),
('105', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"7\",\"13\",\"14\",\"15\",\"16\",\"18\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]}', NULL, NULL, '2025-01-24 21:36:46', NULL),
('106', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"1\",\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\"]}', NULL, NULL, '2025-01-24 21:37:04', NULL),
('107', '1', 'UPDATE', 'role_permissions', '4', NULL, '{\"role_id\":4,\"permissions\":[\"5\",\"44\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\"]}', NULL, NULL, '2025-01-25 06:05:56', NULL),
('108', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"1\",\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\"]}', NULL, NULL, '2025-01-25 20:15:23', NULL),
('109', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"1\",\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\"]}', NULL, NULL, '2025-01-25 20:28:40', NULL),
('110', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\"]}', NULL, NULL, '2025-01-25 20:29:27', NULL),
('111', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]}', NULL, NULL, '2025-01-25 20:30:25', NULL),
('112', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]}', NULL, NULL, '2025-01-25 20:30:30', NULL),
('113', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]}', NULL, NULL, '2025-01-25 20:30:30', NULL),
('114', '1', 'UPDATE', 'role_permissions', '5', NULL, '{\"role_id\":5,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"66\",\"68\",\"69\",\"76\"]}', NULL, NULL, '2025-01-25 20:32:29', NULL),
('115', '1', 'CREATE', 'fund_admin_config', '1', NULL, '{\"corp_id\":\"5\",\"benefit\":\"14\",\"fund_percentage\":\"10\",\"admin_fee_percentage\":\"10\",\"effective_date\":\"2025-01-01\",\"end_date\":\"\"}', NULL, NULL, '2025-01-25 20:40:40', NULL),
('116', '1', '', 'fund_admin_config', '1', NULL, '{\"status\":\"INACTIVE\",\"config_id\":\"1\"}', NULL, NULL, '2025-01-25 20:42:12', NULL),
('117', '1', 'UPDATE', 'role_permissions', '2', NULL, '{\"role_id\":2,\"permissions\":[\"1\",\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\"]}', NULL, NULL, '2025-01-25 22:02:52', NULL),
('118', '1', 'CREATE', 'menu_items', '79', NULL, '{\"menu_name\":\"Financial Analytics\",\"menu_url\":\"financial_analytics.php\",\"menu_icon\":\"\",\"parent_id\":\"5\",\"menu_order\":\"1\"}', NULL, NULL, '2025-01-27 07:27:22', NULL),
('119', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"1\",\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\"]}', NULL, NULL, '2025-01-27 07:31:55', NULL),
('120', '1', 'CREATE', 'menu_items', '80', NULL, '{\"menu_name\":\"Claims Analytics\",\"menu_url\":\"claims_analytics.php\",\"menu_icon\":\"ri-funds-box-line\",\"parent_id\":\"4\",\"menu_order\":\"0\"}', NULL, NULL, '2025-01-27 17:46:53', NULL),
('121', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"1\",\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\"]}', NULL, NULL, '2025-01-27 17:47:11', NULL),
('122', '1', 'CREATE', 'menu_items', '81', NULL, '{\"menu_name\":\"Member Risk Profile\",\"menu_url\":\"member_risk_profile.php\",\"menu_icon\":\"\",\"parent_id\":\"3\",\"menu_order\":\"0\"}', NULL, NULL, '2025-01-27 18:11:09', NULL),
('123', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"1\",\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\"]}', NULL, NULL, '2025-01-27 18:11:20', NULL),
('124', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\"]}', NULL, NULL, '2025-01-27 18:16:38', NULL),
('125', '19', '', 'password_resets', 'c91bb59910186bc9911a80abb8d535d1f3c6303e0c51a8fcf8', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 07:42:54', 'Password reset requested. Reset link sent to email.'),
('126', '19', '', 'password_resets', 'ce7402c3e65422c406405b1318b5abd37cd9fa6659c622c462', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 07:45:48', 'Password reset requested. Reset link sent to email.'),
('127', '19', '', 'password_resets', 'd5e10ac3a9c46b58b73bb026837df48a638bbc71709c6dbcb2', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 07:53:50', 'Password reset requested. Reset link sent to email.'),
('128', '19', '', 'password_resets', '063dfa36eeafe792fe201bd20b86bc28e74726471999510555', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 07:57:47', 'Password reset requested. Reset link sent to email.'),
('129', '19', '', 'password_resets', 'fbdc7fec09522f0beee9eb6e32201fde09b58dac6397db7e85', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 08:04:47', 'Password reset requested. Reset link sent to email.'),
('130', '19', '', 'password_resets', '7b194a2a1e37258c3e876be65f3e5e957e8ded6ee3f3f216a0', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 08:29:50', 'Password reset requested. Reset link sent to email.'),
('131', '19', '', 'password_resets', '22eee43554fc7353c209090567f75c3625788f13e6854ed8d0', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 08:57:13', 'Password reset requested. Reset link sent to email.'),
('132', '19', '', 'password_resets', 'a04b93885c966480b1c538f4e1e23c69b8a803fb1bdc98f64f', NULL, NULL, '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0', '2025-01-28 09:04:25', 'Password reset requested. Reset link sent to email.'),
('133', '1', 'CREATE', 'menu_items', '82', NULL, '{\"menu_name\":\"View Pre Auths\",\"menu_url\":\"view_pre_auth.php\",\"menu_icon\":\"\",\"parent_id\":\"4\",\"menu_order\":\"10\"}', NULL, NULL, '2025-01-29 18:59:01', NULL),
('134', '1', 'UPDATE', 'corp_anniversary', '4', NULL, '{\"corp_id\":\"4\",\"old_anniv\":1,\"new_anniv\":2,\"start_date\":\"2024-12-28\",\"end_date\":\"2025-12-27\"}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 14:20:55', '{\"action\":\"Corporate Renewal\",\"scheme\":\"SSL\",\"members_pending\":true}'),
('135', '1', 'UPDATE', 'bills', 'CLM-0000005', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":500,\"deduction_reason\":1,\"amount_payable\":1500,\"invoice_no\":\"INV45\",\"is_reimbursement\":0}', NULL, NULL, '2025-01-31 14:54:53', 'Invoice INV45 Approved: '),
('136', '1', 'UPDATE', 'bills', 'CLM-0000006', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":500,\"deduction_reason\":1,\"amount_payable\":2000,\"invoice_no\":\"INVT234\",\"is_reimbursement\":0}', NULL, NULL, '2025-01-31 14:55:25', 'Invoice INVT234 Approved: '),
('137', '1', 'CREATE', 'claim_drafts', '3', NULL, '{\"claim_no\":\"CLM-0000011\",\"invoice_date\":\"2025-01-31\",\"provider\":\"1\",\"member_no\":\"PTL-001-00\",\"corp_id\":\"3\",\"family_no\":\"PTL-001\",\"pri_dep\":\"1\",\"claims\":[{\"benefit_code\":\"2\",\"benefit_name\":\"Outpatient\",\"amount\":3000,\"description\":\"1\",\"description_text\":\"Consultation\",\"invoiceNo\":\"INVT234X\",\"dateReceived\":\"2025-01-01\"}]}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 14:57:59', 'Draft claim created'),
('138', '1', 'CREATE', 'bills_payment', '20250005', NULL, '{\"payment_no\":\"20250005\",\"voucher_no\":\"VCH-20250005\",\"amount\":2000,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"}}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 15:04:01', 'Payment processed for 1 claim(s). Total amount: 2000.00. Payment to: Aga Khan University Hospital'),
('139', '1', '', 'bills', 'template', NULL, 'Downloaded claims template', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 15:18:33', '{\"template_type\":\"provider_claims\",\"download_time\":\"2025-01-31 12:18:33\"}'),
('140', '1', '', 'bills', 'template', NULL, 'Downloaded claims template', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 15:18:34', '{\"template_type\":\"provider_claims\",\"download_time\":\"2025-01-31 12:18:34\"}'),
('141', '1', '', 'bills', '1-3', NULL, '{\"total_system_amount\":229760,\"total_provider_amount\":3500,\"total_variance\":-226260,\"matching_claims\":0,\"provider_id\":\"1\",\"corp_id\":\"3\"}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 15:18:53', '{\"total_system_claims\":11,\"total_provider_claims\":2,\"difference_count\":13}'),
('142', '1', '', 'bills', 'EXPORT-20250131122203', NULL, '{\"report_type\":\"claims_analysis\",\"date_from\":\"2024-12-31\",\"date_to\":\"2025-01-31\",\"filters\":{\"corporate\":\"all\",\"provider\":\"1\",\"benefit\":\"all\"},\"record_count\":2}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 15:22:03', 'Exported 2 records to Excel'),
('143', '1', '', 'bills', 'EXPORT-20250131122205', NULL, '{\"report_type\":\"claims_analysis\",\"date_from\":\"2024-12-31\",\"date_to\":\"2025-01-31\",\"filters\":{\"corporate\":\"all\",\"provider\":\"1\",\"benefit\":\"all\"},\"record_count\":2}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:130.0) Gecko/20100101 Firefox/130.0', '2025-01-31 15:22:05', 'Exported 2 records to Excel'),
('144', '1', 'CREATE', 'bills', 'RMB-000001', NULL, '{\"claim_no\":\"RMB-000001\",\"member_no\":\"PTL-001-00\",\"corp_id\":\"3\",\"total_amount\":2500,\"reimbursement_details\":{\"bank\":\"1\",\"account\":\"1234567\"}}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:134.0) Gecko/20100101 Firefox/134.0', '2025-02-01 07:55:24', 'Reimbursement claim created'),
('145', '1', 'UPDATE', 'bills', 'RMB-000001', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":0,\"deduction_reason\":0,\"amount_payable\":2500,\"invoice_no\":\"RMB-000001-02\",\"is_reimbursement\":1}', NULL, NULL, '2025-02-01 07:57:38', 'Reimbursement Invoice RMB-000001-02 Approved: '),
('146', '1', 'CREATE', 'pre_authorization', '3', NULL, '{\"pre_auth_code\":\"PA000003\",\"member_no\":\"PTL-001-00\",\"reserve\":\"5000\",\"authority_type\":\"2\",\"available_limit\":\"65300.00\",\"anniv\":\"1\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:134.0) Gecko/20100101 Firefox/134.0', '2025-02-01 15:37:33', 'Pre-authorization created with reserve amount: 5,000.00'),
('147', '1', 'UPDATE', 'corp_renewal_status', '3', NULL, '{\"renewable\":\"1\",\"reason\":\"Can be renewed\"}', NULL, NULL, '2025-02-11 06:47:46', 'Updated renewal status to: Renewable'),
('148', '1', 'CREATE', 'menu_items', '83', NULL, '{\"menu_name\":\"Member Benefits\",\"menu_url\":\"member_benefits.php\",\"menu_icon\":\"\",\"parent_id\":\"3\",\"menu_order\":\"5\"}', NULL, NULL, '2025-02-13 16:48:40', NULL),
('149', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"23\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\"]}', NULL, NULL, '2025-02-13 16:48:54', NULL),
('150', '1', 'CREATE', 'menu_items', '84', NULL, '{\"menu_name\":\"Manage Updates\",\"menu_url\":\"manage_updates.php\",\"menu_icon\":\"\",\"parent_id\":\"6\",\"menu_order\":\"25\"}', NULL, NULL, '2025-02-16 15:31:24', NULL),
('151', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-02-16 15:31:39', NULL),
('152', '1', 'UPDATE', 'users', '19', NULL, '{\"verified\":1,\"failed_attempts\":0,\"status\":\"ACTIVE\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:135.0) Gecko/20100101 Firefox/135.0', '2025-02-17 20:58:33', NULL),
('153', '1', 'UPDATE', 'users', '14', NULL, '{\"verified\":1,\"failed_attempts\":0,\"status\":\"ACTIVE\"}', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:135.0) Gecko/20100101 Firefox/135.0', '2025-02-17 21:02:05', NULL),
('154', '1', 'CREATE', 'menu_items', '85', NULL, '{\"menu_name\":\"Claims Experience\",\"menu_url\":\"claims_experience_rpt.php\",\"menu_icon\":\"\",\"parent_id\":\"2\",\"menu_order\":\"13\"}', NULL, NULL, '2025-02-19 17:46:44', NULL),
('155', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-02-19 17:46:54', NULL),
('156', '1', 'CREATE', 'menu_items', '86', NULL, '{\"menu_name\":\"Executive Reports\",\"menu_url\":\"executive_report_dashboard.php\",\"menu_icon\":\"\",\"parent_id\":\"5\",\"menu_order\":\"0\"}', NULL, NULL, '2025-02-20 13:17:58', NULL),
('157', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"86\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-02-20 13:18:16', NULL),
('158', '1', 'CREATE', 'menu_items', '87', NULL, '{\"menu_name\":\"Sales Dashboard\",\"menu_url\":\"sales_dashboard.php\",\"menu_icon\":\"\",\"parent_id\":\"5\",\"menu_order\":\"0\"}', NULL, NULL, '2025-03-06 07:05:21', NULL),
('159', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"86\",\"87\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-06 07:05:37', NULL),
('160', '1', 'CREATE', 'menu_items', '88', NULL, '{\"menu_name\":\"Leads Dashboard\",\"menu_url\":\"lead_dashboard.php\",\"menu_icon\":\"\",\"parent_id\":\"5\",\"menu_order\":\"0\"}', NULL, NULL, '2025-03-06 07:20:38', NULL),
('161', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"86\",\"87\",\"88\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-06 07:20:48', NULL),
('162', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"87\",\"88\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-06 07:36:54', NULL),
('163', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"86\",\"87\",\"88\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-06 07:37:13', NULL),
('164', '1', 'CREATE', 'menu_items', '89', NULL, '{\"menu_name\":\"Quotes Management\",\"menu_url\":\"quotes.php\",\"menu_icon\":\"\",\"parent_id\":\"5\",\"menu_order\":\"0\"}', NULL, NULL, '2025-03-06 07:43:18', NULL),
('165', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-06 07:43:28', NULL),
('166', '1', 'CREATE', 'menu_items', '90', NULL, '{\"menu_name\":\"Custom Reports\",\"menu_url\":\"run_report.php\",\"menu_icon\":\"\",\"parent_id\":\"2\",\"menu_order\":\"0\"}', NULL, NULL, '2025-03-08 18:29:31', NULL),
('167', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"90\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-08 18:29:38', NULL),
('168', '1', 'CREATE', 'menu_items', '91', NULL, '{\"menu_name\":\"Data Migration\",\"menu_url\":\"data_sources.php\",\"menu_icon\":\"\",\"parent_id\":\"6\",\"menu_order\":\"0\"}', NULL, NULL, '2025-03-10 09:27:47', NULL),
('169', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"2\",\"90\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"91\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-10 09:27:58', NULL),
('170', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"94\",\"2\",\"90\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"91\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-17 20:42:06', NULL),
('171', '1', 'CREATE', 'menu_items', '95', NULL, '{\"menu_name\":\"All Agents\",\"menu_url\":\"all_agents.php\",\"menu_icon\":\"\",\"parent_id\":\"94\",\"menu_order\":\"0\"}', NULL, NULL, '2025-03-17 20:44:59', NULL),
('172', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"94\",\"95\",\"2\",\"90\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"91\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-03-17 20:45:12', NULL),
('173', '1', '', 'finance_reports', 'EXPORT-20250402145809', NULL, '{\"report_type\":\"premium_collections\",\"date_from\":\"2024-10-01\",\"date_to\":\"2025-04-02\",\"filters\":{\"corporate\":\"all\",\"status\":\"Fully Allocated\"}}', '154.159.252.191', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-04-02 17:58:09', NULL),
('174', '1', '', 'premium_debit_notes', '', NULL, '{\"total_system_amount\":18433.639999999999417923390865325927734375,\"total_schedule_amount\":350000,\"total_variance\":331566.359999999986030161380767822265625,\"matches\":0,\"mismatches\":3}', '154.159.252.191', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-04-02 18:00:17', '{\"total_policies\":3,\"missing_in_system\":2,\"missing_in_schedule\":1}'),
('175', '1', '', 'bills', 'template', NULL, 'Downloaded claims template', '154.159.252.191', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-04-02 18:00:45', '{\"template_type\":\"provider_claims\",\"download_time\":\"2025-04-02 15:00:45\"}'),
('176', '1', '', 'bills', '1-3', NULL, '{\"total_system_amount\":232260,\"total_provider_amount\":3500,\"total_variance\":-228760,\"matching_claims\":0,\"provider_id\":\"1\",\"corp_id\":\"3\"}', '154.159.252.191', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-04-02 18:00:52', '{\"total_system_claims\":12,\"total_provider_claims\":2,\"difference_count\":14}'),
('177', '1', 'CREATE', 'insuring_rates', '6', NULL, '{\"rate_details\":{\"full_desc\":\"HSJUTLEY\",\"corp_id\":\"7\",\"insurer\":\"2\",\"benefit\":\"1\",\"limit\":\"1000000\",\"premium\":\"26754\",\"family_size\":\"1\",\"year\":1},\"corporate_specific\":true}', '154.159.252.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', '2025-04-07 14:15:44', NULL),
('178', '1', 'CREATE', 'scheme_copay', '2', NULL, '{\"corp_id\":\"7\",\"benefit_code\":\"2\",\"copay_type\":\"FIXED\",\"copay_value\":\"500\",\"status\":\"ACTIVE\"}', NULL, NULL, '2025-04-07 14:17:27', NULL),
('179', '1', 'CREATE', 'scheme_provider_restrictions', '2', NULL, '{\"corp_id\":\"7\",\"benefit_code\":\"2\",\"provider_id\":\"1\",\"restriction_type\":\"NOT_ALLOWED\",\"status\":\"ACTIVE\"}', NULL, NULL, '2025-04-07 14:18:10', NULL),
('180', '1', 'CREATE', 'claim_drafts', '4', NULL, '{\"claim_no\":\"CLM-0000002\",\"invoice_date\":\"2025-04-01\",\"provider\":\"3\",\"member_no\":\"PTL-001-00\",\"corp_id\":\"3\",\"family_no\":\"PTL-001\",\"pri_dep\":\"1\",\"claims\":[{\"benefit_code\":\"1\",\"benefit_name\":\"Inpatient\",\"amount\":6500,\"description\":\"2\",\"description_text\":\"Prescription\",\"invoiceNo\":\"re3454\",\"dateReceived\":\"2025-04-05\"}]}', '154.152.152.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', '2025-04-12 16:15:56', 'Draft claim created'),
('181', '1', 'CREATE', 'claim_drafts', '5', NULL, '{\"claim_no\":\"CLM-0000002\",\"invoice_date\":\"2025-01-14\",\"provider\":\"4\",\"member_no\":\"SHL-002-00\",\"corp_id\":\"5\",\"family_no\":\"SHL-001\",\"pri_dep\":\"2\",\"claims\":[{\"benefit_code\":\"1\",\"benefit_name\":\"Inpatient\",\"amount\":8600,\"description\":\"3\",\"description_text\":\"Laboratory Services\",\"invoiceNo\":\"yts64\",\"dateReceived\":\"2025-04-01\"},{\"benefit_code\":\"1\",\"benefit_name\":\"Inpatient\",\"amount\":2500,\"description\":\"1\",\"description_text\":\"Consultation\",\"invoiceNo\":\"7823\",\"dateReceived\":\"2025-04-01\"}]}', '154.152.152.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', '2025-04-12 16:26:12', 'Draft claim created'),
('182', '1', 'CREATE', 'claim_drafts', '6', NULL, '{\"claim_no\":\"CLM-0000002\",\"invoice_date\":\"2025-01-30\",\"provider\":\"2\",\"member_no\":\"SHL-001-00\",\"corp_id\":\"5\",\"family_no\":\"SHL-001\",\"pri_dep\":\"1\",\"claims\":[{\"benefit_code\":\"1\",\"benefit_name\":\"Inpatient\",\"amount\":2500,\"description\":\"1\",\"description_text\":\"Consultation\",\"invoiceNo\":\"iu7823\",\"dateReceived\":\"2025-03-03\"},{\"benefit_code\":\"1\",\"benefit_name\":\"Inpatient\",\"amount\":3500,\"description\":\"5\",\"description_text\":\"Pharmacy\",\"invoiceNo\":\"uidu8\",\"dateReceived\":\"2025-03-03\"}]}', '154.152.152.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', '2025-04-12 16:28:47', 'Draft claim created'),
('183', '1', 'CREATE', 'bills', 'CLM-0000002', NULL, '{\"claim_no\":\"CLM-0000002\",\"member_no\":\"PTL-001-00\",\"diagnoses\":[{\"id\":\"33\",\"primary\":1}],\"claim_count\":1}', '102.140.245.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko/20100101 Firefox/137.0', '2025-04-12 16:42:37', NULL),
('184', '1', 'CREATE', 'bills', 'RMB-000002', NULL, '{\"claim_no\":\"RMB-000002\",\"member_no\":\"SHL-001-00\",\"corp_id\":\"5\",\"total_amount\":6000,\"reimbursement_details\":{\"bank\":\"1\",\"account\":\"124346746\"}}', '154.152.152.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', '2025-04-12 16:52:27', 'Reimbursement claim created'),
('185', '1', 'UPDATE', 'bills', 'RMB-000002', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":1000,\"deduction_reason\":1,\"amount_payable\":1500,\"invoice_no\":\"RMB-000002-02\",\"is_reimbursement\":1}', NULL, NULL, '2025-04-12 16:57:50', 'Reimbursement Invoice RMB-000002-02 Approved: '),
('186', '1', 'CREATE', 'bills_payment', '20250006', NULL, '{\"payment_no\":\"20250006\",\"voucher_no\":\"VCH-20250006\",\"amount\":3000,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":5,\"name\":\"Metropolitan Hospital\"}}', '154.79.35.33', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', '2025-04-12 17:14:26', 'Payment processed for 2 claim(s). Total amount: 3000.00. Payment to: Metropolitan Hospital'),
('187', '1', '', 'bills', 'CLM-0000002', NULL, '{\"claim_no\":\"CLM-0000002\",\"reason\":\"Duplicate Claim: Test\",\"original_amount\":\"2500\",\"pre_auth_no\":null,\"status\":\"DELETED\"}', '197.237.83.207', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko/20100101 Firefox/137.0', '2025-04-15 10:11:34', NULL),
('188', '1', 'CREATE', 'bills', 'CLM-0000011', NULL, '{\"claim_no\":\"CLM-0000011\",\"member_no\":\"PTL-001-00\",\"diagnoses\":[{\"id\":\"58\",\"primary\":1}],\"claim_count\":1}', '197.237.83.207', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko/20100101 Firefox/137.0', '2025-04-15 13:32:25', NULL),
('189', '1', 'CREATE', 'insuring_rates', '7', NULL, '{\"rate_details\":{\"full_desc\":\"Tester\",\"corp_id\":\"7\",\"agent_name\":\"1\",\"benefit\":\"2\",\"limit\":\"500000\",\"premium\":\"15000\",\"family_size\":\"\",\"year\":1},\"corporate_specific\":true}', '197.237.83.207', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko/20100101 Firefox/137.0', '2025-04-15 18:48:45', NULL),
('190', '1', 'CREATE', 'bills', 'RMB-000003', NULL, '{\"claim_no\":\"RMB-000003\",\"member_no\":\"RI-001-00\",\"corp_id\":\"8\",\"total_amount\":27000,\"reimbursement_details\":{\"bank\":\"1\",\"account\":\"hjghfhjf\"}}', '154.159.252.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-15 21:12:16', 'Reimbursement claim created'),
('191', '1', 'UPDATE', 'bills', 'CLM-0000009', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":500,\"deduction_reason\":1,\"amount_payable\":1500,\"invoice_no\":\"AK001S\",\"is_reimbursement\":0}', NULL, NULL, '2025-04-15 21:16:31', 'Invoice AK001S Approved: '),
('192', '1', 'UPDATE', 'bills', 'RMB-000003', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":2500,\"deduction_reason\":1,\"amount_payable\":0,\"invoice_no\":\"RMB-000003-02\",\"is_reimbursement\":1}', NULL, NULL, '2025-04-15 21:18:15', 'Reimbursement Invoice RMB-000003-02 Approved: '),
('193', '1', 'CREATE', 'claim_drafts', '7', NULL, '{\"claim_no\":\"CLM-0000012\",\"invoice_date\":\"2025-02-02\",\"provider\":\"3\",\"member_no\":\"RI-002-00\",\"corp_id\":\"8\",\"family_no\":\"RI-002\",\"pri_dep\":\"1\",\"claims\":[{\"benefit_code\":\"2\",\"benefit_name\":\"Outpatient\",\"amount\":2500,\"description\":\"1\",\"description_text\":\"Consultation\",\"invoiceNo\":\"345345\",\"dateReceived\":\"2025-04-01\"},{\"benefit_code\":\"2\",\"benefit_name\":\"Outpatient\",\"amount\":8500,\"description\":\"3\",\"description_text\":\"Laboratory Services\",\"invoiceNo\":\"ftr5653\",\"dateReceived\":\"2025-04-01\"},{\"benefit_code\":\"2\",\"benefit_name\":\"Outpatient\",\"amount\":19900,\"description\":\"9\",\"description_text\":\"X RAY\",\"invoiceNo\":\"09799\",\"dateReceived\":\"2025-04-01\"}]}', '154.159.252.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-15 21:22:36', 'Draft claim created'),
('194', '1', 'UPDATE', 'bills', 'CLM-0000012', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":2500,\"deduction_reason\":1,\"amount_payable\":17400,\"invoice_no\":\"09799\",\"is_reimbursement\":0}', NULL, NULL, '2025-04-15 21:24:40', 'Invoice 09799 Approved: '),
('195', '1', 'UPDATE', 'bills', 'CLM-0000012', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":3500,\"deduction_reason\":1,\"amount_payable\":5000,\"invoice_no\":\"ftr5653\",\"is_reimbursement\":0}', NULL, NULL, '2025-04-15 21:26:36', 'Invoice ftr5653 Approved: '),
('196', '1', 'CREATE', 'insuring_rates', '8', NULL, '{\"rate_details\":{\"full_desc\":\"Tester 2\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"2\",\"limit\":\"50000\",\"premium\":\"5000\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '197.237.83.207', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko/20100101 Firefox/137.0', '2025-04-15 21:26:54', NULL),
('197', '1', 'CREATE', 'bills_payment', '20250007', NULL, '{\"payment_no\":\"20250007\",\"voucher_no\":\"VCH-20250007\",\"amount\":1500,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"}}', '154.159.252.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-15 21:30:00', 'Payment processed for 1 claim(s). Total amount: 1500.00. Payment to: Aga Khan University Hospital'),
('198', '1', 'CREATE', 'bills_payment', '20250008', NULL, '{\"payment_no\":\"20250008\",\"voucher_no\":\"VCH-20250008\",\"amount\":2500,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"}}', '197.237.83.207', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko/20100101 Firefox/137.0', '2025-04-15 21:30:38', 'Payment processed for 1 claim(s). Total amount: 2500.00. Payment to: Aga Khan University Hospital'),
('199', '1', 'CREATE', 'insuring_rates', '9', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"1\",\"limit\":\"1000000\",\"premium\":\"23654\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:04:09', NULL),
('200', '1', 'CREATE', 'insuring_rates', '10', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"2\",\"limit\":\"100000\",\"premium\":\"18654\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:04:49', NULL),
('201', '1', 'CREATE', 'insuring_rates', '11', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"1\",\"limit\":\"2500000\",\"premium\":\"96418\",\"family_size\":\"M + 2\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:05:48', NULL),
('202', '1', 'DELETE', 'insuring_rates', '11', NULL, '{\"code\":\"11\"}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:12:22', NULL),
('203', '1', 'DELETE', 'insuring_rates', '9', NULL, '{\"code\":\"9\"}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:12:41', NULL),
('204', '1', 'DELETE', 'insuring_rates', '10', NULL, '{\"code\":\"10\"}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:12:52', NULL),
('205', '1', 'CREATE', 'insuring_rates', '9', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"1\",\"limit\":\"1500000\",\"premium\":\"23164\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:14:07', NULL),
('206', '1', 'CREATE', 'insuring_rates', '10', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"2\",\"limit\":\"150000\",\"premium\":\"15690\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:14:58', NULL),
('207', '1', 'CREATE', 'insuring_rates', '11', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"3\",\"limit\":\"100000\",\"premium\":\"21387\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:15:40', NULL),
('208', '1', 'CREATE', 'insuring_rates', '12', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"1\",\"limit\":\"2000000\",\"premium\":\"28764\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:17:11', NULL),
('209', '1', 'CREATE', 'insuring_rates', '13', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"2\",\"limit\":\"200000\",\"premium\":\"23690\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:18:30', NULL),
('210', '1', 'CREATE', 'insuring_rates', '14', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"3\",\"limit\":\"150000\",\"premium\":\"29387\",\"family_size\":\"M\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:19:26', NULL),
('211', '1', 'CREATE', 'insuring_rates', '15', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"1\",\"limit\":\"2500000\",\"premium\":\"36789\",\"family_size\":\"M + 1\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:20:33', NULL),
('212', '1', 'CREATE', 'insuring_rates', '16', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"2\",\"limit\":\"250000\",\"premium\":\"31690\",\"family_size\":\"M + 1\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:21:29', NULL),
('213', '1', 'CREATE', 'insuring_rates', '17', NULL, '{\"rate_details\":{\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"agent_name\":\"1\",\"benefit\":\"3\",\"limit\":\"200000\",\"premium\":\"37689\",\"family_size\":\"M + 1\",\"year\":1},\"corporate_specific\":true}', '154.159.237.200', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-04-17 15:22:43', NULL),
('214', '1', 'UPDATE', 'corporate', '8', '{}', '{\"corp_id\":\"8\",\"corporate\":\"Great Rome Inc\",\"scheme\":\"RI\",\"corp_pin\":\"43ds5454\",\"insurer\":\"2\",\"policy_no\":\"65658\",\"inpatient_threshold\":\"90.00\",\"outpatient_threshold\":\"80.00\",\"currency\":\"Kes.\"}', '41.90.178.40', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko/20100101 Firefox/137.0', '2025-04-24 17:19:52', '{\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10.15; rv:137.0) Gecko\\/20100101 Firefox\\/137.0\",\"ip_address\":\"41.90.178.40\"}'),
('215', '1', '', 'member_info', 'PTL-002-00', NULL, '{\"member_no\":\"PTL-002-00\",\"exit_date\":\"2025-04-01\",\"total_credit\":null,\"benefits_processed\":0,\"proration_factor\":0.61369863013698633391612702325801365077495574951171875}', '41.90.178.40', NULL, '2025-04-24 17:33:04', 'Exit credit calculation performed'),
('216', '1', '', 'member_info', 'PTL-002-00', NULL, '{\"member_no\":\"PTL-002-00\",\"exit_date\":\"2025-03-01\",\"total_credit\":null,\"benefits_processed\":0,\"proration_factor\":0.69863013698630138659240174092701636254787445068359375}', '41.90.178.40', NULL, '2025-04-24 17:33:15', 'Exit credit calculation performed'),
('217', '1', '', 'member_info', 'PTL-002-00', NULL, '{\"member_no\":\"PTL-002-00\",\"exit_date\":\"2025-01-01\",\"total_credit\":null,\"benefits_processed\":0,\"proration_factor\":0.8602739726027397448859801443177275359630584716796875}', '41.90.178.40', NULL, '2025-04-24 17:33:27', 'Exit credit calculation performed'),
('218', '1', 'CREATE', 'menu_items', '96', NULL, '{\"menu_name\":\"All Agents\",\"menu_url\":\"agents.php\",\"menu_icon\":\"\",\"parent_id\":\"94\",\"menu_order\":\"0\"}', NULL, NULL, '2025-04-29 15:28:10', NULL),
('219', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"94\",\"96\",\"2\",\"90\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"82\",\"37\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"91\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-04-29 15:28:20', NULL),
('220', '1', 'CREATE', 'bills_payment', '20250009', NULL, '{\"payment_no\":\"20250009\",\"voucher_no\":\"VCH-20250009\",\"amount\":1500,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"}}', '41.90.177.106', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-04-29 19:02:19', 'Payment processed for 1 claim(s). Total amount: 1500.00. Payment to: Aga Khan University Hospital'),
('221', '1', 'CREATE', 'menu_items', '97', NULL, '{\"menu_name\":\"View Payment Vouchers\",\"menu_url\":\"view_payment_voucher.php\",\"menu_icon\":\"\",\"parent_id\":\"4\",\"menu_order\":\"0\"}', NULL, NULL, '2025-04-29 19:12:10', NULL),
('222', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"94\",\"96\",\"2\",\"90\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"97\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"82\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"91\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-04-29 19:12:26', NULL),
('223', '1', 'UPDATE', 'insuring_rates', '2', NULL, '{\"code\":\"2\",\"full_desc\":\"Rate 2 AAR\",\"corp_id\":\"3\",\"limit\":\"1000000.00\",\"premium\":\"5000.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"18\",\"year\":\"1\"}', '41.90.186.112', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-15 12:54:22', NULL),
('224', '1', 'UPDATE', 'insuring_rates', '8', NULL, '{\"code\":\"8\",\"full_desc\":\"Tester 2\",\"corp_id\":\"8\",\"limit\":\"50000.00\",\"premium\":\"5000.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"18\",\"year\":\"1\"}', '41.90.186.112', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-15 12:54:45', NULL),
('225', '1', 'UPDATE', 'bills', 'CLM-0000007', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":1000,\"deduction_reason\":1,\"amount_payable\":4000,\"invoice_no\":\"INVTY67\",\"is_reimbursement\":0}', NULL, NULL, '2025-05-15 15:31:18', 'Invoice INVTY67 Approved: '),
('226', '1', 'UPDATE', 'bills', 'CLM-0000011', NULL, '{\"claim_no\":\"CLM-0000011\",\"member_no\":\"PTL-001-00\",\"diagnoses\":[{\"id\":\"83\",\"primary\":1}],\"claim_count\":2}', '41.90.186.112', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-15 15:52:44', NULL),
('227', '1', 'UPDATE', 'bills', 'CLM-0000011', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":0,\"deduction_reason\":0,\"amount_payable\":5000,\"invoice_no\":\"BST001\",\"is_reimbursement\":0}', NULL, NULL, '2025-05-15 15:54:31', 'Invoice BST001 Approved: '),
('228', '1', 'UPDATE', 'bills', 'CLM-0000011', NULL, '{\"vet_status\":1,\"remarks\":\"\",\"deduction_amount\":500,\"deduction_reason\":1,\"amount_payable\":2000,\"invoice_no\":\"BST002\",\"is_reimbursement\":0}', NULL, NULL, '2025-05-15 15:55:09', 'Invoice BST002 Approved: '),
('229', '1', 'CREATE', 'bills_payment', '20250010', NULL, '{\"payment_no\":\"20250010\",\"voucher_no\":\"VCH-20250010\",\"amount\":204000,\"payment_to\":\"provider\",\"recipient\":{\"type\":\"provider\",\"id\":1,\"name\":\"Aga Khan University Hospital\"}}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-25 08:29:12', 'Payment processed for 2 claim(s). Total amount: 204000.00. Payment to: Aga Khan University Hospital'),
('230', '1', 'UPDATE', 'insuring_rates', '9', NULL, '{\"code\":\"9\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"1500000.00\",\"premium\":\"23164.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"1\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:17:56', NULL),
('231', '1', 'UPDATE', 'insuring_rates', '10', NULL, '{\"code\":\"10\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"150000.00\",\"premium\":\"15690.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"2\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:18:11', NULL),
('232', '1', 'UPDATE', 'insuring_rates', '11', NULL, '{\"code\":\"11\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"100000.00\",\"premium\":\"21387.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"3\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:18:24', NULL),
('233', '1', 'UPDATE', 'insuring_rates', '12', NULL, '{\"code\":\"12\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"2000000.00\",\"premium\":\"28764.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"1\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:18:48', NULL),
('234', '1', 'UPDATE', 'insuring_rates', '13', NULL, '{\"code\":\"13\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"200000.00\",\"premium\":\"23690.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"2\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:18:57', NULL),
('235', '1', 'UPDATE', 'insuring_rates', '14', NULL, '{\"code\":\"14\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"150000.00\",\"premium\":\"29387.00\",\"family_size\":\"M\",\"agent_name\":\"1\",\"benefit\":\"3\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:19:11', NULL),
('236', '1', 'UPDATE', 'insuring_rates', '15', NULL, '{\"code\":\"15\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"2500000.00\",\"premium\":\"36789.00\",\"family_size\":\"M + 1\",\"agent_name\":\"1\",\"benefit\":\"1\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:19:42', NULL),
('237', '1', 'UPDATE', 'insuring_rates', '16', NULL, '{\"code\":\"16\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"250000.00\",\"premium\":\"31690.00\",\"family_size\":\"M + 1\",\"agent_name\":\"1\",\"benefit\":\"2\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:19:54', NULL),
('238', '1', 'UPDATE', 'insuring_rates', '17', NULL, '{\"code\":\"17\",\"full_desc\":\"Rate\",\"corp_id\":\"8\",\"limit\":\"200000.00\",\"premium\":\"37689.00\",\"family_size\":\"M + 1\",\"agent_name\":\"1\",\"benefit\":\"3\",\"year\":\"1\"}', '102.5.235.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36 Edg/135.0.0.0', '2025-05-25 12:20:08', NULL),
('239', '1', 'CREATE', 'menu_items', '98', NULL, '{\"menu_name\":\"Corporate Dashboard\",\"menu_url\":\"corp_dash.php\",\"menu_icon\":\"\",\"parent_id\":\"2\",\"menu_order\":\"0\"}', NULL, NULL, '2025-05-25 19:33:34', NULL),
('240', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"94\",\"96\",\"2\",\"90\",\"98\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"97\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"82\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"91\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-05-25 19:34:37', NULL),
('241', '1', 'CREATE', 'menu_items', '99', NULL, '{\"menu_name\":\"Member Management Dashboard\",\"menu_url\":\"mem_dash.php\",\"menu_icon\":\"\",\"parent_id\":\"3\",\"menu_order\":\"0\"}', NULL, NULL, '2025-05-25 19:56:04', NULL),
('242', '1', 'UPDATE', 'role_permissions', '1', NULL, '{\"role_id\":1,\"permissions\":[\"94\",\"96\",\"2\",\"90\",\"98\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"85\",\"3\",\"81\",\"99\",\"19\",\"20\",\"21\",\"22\",\"83\",\"24\",\"25\",\"26\",\"27\",\"4\",\"97\",\"80\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"82\",\"38\",\"39\",\"40\",\"41\",\"42\",\"43\",\"5\",\"87\",\"88\",\"89\",\"44\",\"79\",\"45\",\"46\",\"47\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"6\",\"91\",\"54\",\"55\",\"56\",\"57\",\"58\",\"59\",\"60\",\"61\",\"62\",\"63\",\"64\",\"65\",\"66\",\"67\",\"68\",\"69\",\"70\",\"71\",\"72\",\"73\",\"74\",\"75\",\"76\",\"78\",\"84\"]}', NULL, NULL, '2025-05-25 19:56:24', NULL),
('243', '1', 'UPDATE', 'menu_items', '99', NULL, '{\"menu_name\":\"Membership Dashboard\",\"menu_url\":\"mem_dash.php\",\"menu_icon\":\"\",\"parent_id\":3,\"menu_order\":0}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-25 20:13:35', NULL),
('244', '1', 'UPDATE', 'menu_items', '90', NULL, '{\"is_active\":0,\"menu_name\":\"Custom Reports\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-25 20:43:24', NULL),
('245', '1', 'UPDATE', 'menu_items', '90', NULL, '{\"is_active\":1,\"menu_name\":\"Custom Reports\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-25 20:43:45', NULL),
('246', '1', 'CREATE', 'member_info', 'RI-004-00', NULL, '{\"member_no\":\"RI-004-00\",\"family_no\":\"RI-004\",\"member_type\":\"corporate\",\"corp_id\":\"8\",\"category\":\"CAT A\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-26 09:02:19', NULL),
('247', '1', 'CREATE', 'member_info', 'RI-005-00', NULL, '{\"member_no\":\"RI-005-00\",\"family_no\":\"RI-005\",\"member_type\":\"corporate\",\"corp_id\":\"8\",\"category\":\"CAT B\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-26 09:07:53', NULL),
('248', '1', 'CREATE', 'member_info', 'RI-006-00', NULL, '{\"member_no\":\"RI-006-00\",\"family_no\":\"RI-006\",\"member_type\":\"corporate\",\"corp_id\":\"8\",\"category\":\"CAT B\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-26 09:36:46', NULL),
('249', '1', 'CREATE', 'member_info', 'RI-007-00', NULL, '{\"member_no\":\"RI-007-00\",\"family_no\":\"RI-007\",\"member_type\":\"corporate\",\"corp_id\":\"8\",\"category\":\"CAT B\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-26 09:50:16', NULL),
('250', '1', 'CREATE', 'member_info', 'RI-008-00', NULL, '{\"member_no\":\"RI-008-00\",\"family_no\":\"RI-008\",\"member_type\":\"corporate\",\"corp_id\":\"8\",\"category\":\"CAT B\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-26 09:57:37', NULL),
('251', '1', 'CREATE', 'member_info', 'RI-009-00', NULL, '{\"member_no\":\"RI-009-00\",\"family_no\":\"RI-009\",\"member_type\":\"corporate\",\"corp_id\":\"8\",\"category\":\"CAT B\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-26 10:19:33', NULL),
('252', '1', 'CREATE', 'member_info', 'RI-006-00', NULL, '{\"member_no\":\"RI-006-00\",\"family_no\":\"RI-006\",\"member_type\":\"corporate\",\"corp_id\":\"8\",\"category\":\"CAT B\"}', '41.90.188.143', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0', '2025-05-26 11:12:25', NULL);

INSERT INTO `activity_logs` VALUES
('1', '1', 'create', 'Added new data source: MediSureDB', '102.140.245.174', NULL, 'data_source', '2', NULL, NULL, '2025-03-10 09:33:41'),
('2', '1', 'delete', 'Deleted data source: MediSureDB', '102.140.245.174', NULL, 'data_source', '1', NULL, NULL, '2025-03-10 09:33:50'),
('3', '1', 'delete', 'Deleted data source: MediSureDB', '102.140.245.174', NULL, 'data_source', '2', NULL, NULL, '2025-03-10 09:33:55'),
('4', '1', 'create', 'Added new data source: MediSureDB', '102.140.245.174', NULL, 'data_source', '3', NULL, NULL, '2025-03-10 09:34:15');

INSERT INTO `admin_logs` VALUES
('1', '1', 'company_create', 'Company: Saroze Soutions (ID: 2)', '102.140.245.174', '2024-12-29 19:12:44'),
('2', '1', 'company_suspend', 'Company: Saroze Soutions (ID: 2)', '102.140.245.174', '2024-12-29 19:17:25'),
('3', '1', 'company_activate', 'Company: Saroze Soutions (ID: 2)\nChanges:\nstatus: suspended → active', '102.140.245.174', '2024-12-29 19:17:48'),
('4', '1', 'config_change', 'Component: backup\nCreated database backup: backup_2024-12-29_19-27-14.sql', '102.140.245.174', '2024-12-29 19:27:14'),
('5', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2024-12-29_19-27-14.sql', '102.140.245.174', '2024-12-29 19:27:27'),
('6', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-39-50.sql', '102.140.245.174', '2024-12-29 19:39:50'),
('7', '1', 'config_change', 'Component: backup_download\nDownloaded backup file: backup_2024-12-29_19-39-50.sql', '102.140.245.174', '2024-12-29 19:40:01'),
('8', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-43-19.sql', '102.140.245.174', '2024-12-29 19:43:19'),
('9', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-49-17.sql', '102.140.245.174', '2024-12-29 19:49:17'),
('10', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2024-12-29_19-49-17.sql', '102.140.245.174', '2024-12-29 19:50:31'),
('11', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2024-12-29_19-39-50.sql', '102.140.245.174', '2024-12-29 19:50:35'),
('12', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-50-38.sql', '102.140.245.174', '2024-12-29 19:50:38'),
('13', '1', 'config_change', 'Component: backup_settings\nUpdated backup schedule settings', '102.140.245.174', '2024-12-29 19:50:53'),
('14', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-01-03_18-24-30.sql', '102.140.245.174', '2025-01-03 18:24:30'),
('15', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-01-03_18-42-51.sql', '102.140.245.174', '2025-01-03 21:42:51'),
('16', '1', 'config_change', 'Component: backup_download\nDownloaded backup file: backup_2025-01-03_18-42-51.sql', '102.140.245.174', '2025-01-03 21:45:28'),
('17', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-01-10_13-42-10.sql', '102.140.245.174', '2025-01-10 16:42:10'),
('18', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-01-31_12-24-39.sql', '102.140.245.174', '2025-01-31 15:24:39'),
('19', '1', 'config_change', 'Component: backup_download\nDownloaded backup file: backup_2025-01-31_12-24-39.sql', '102.140.245.174', '2025-01-31 15:24:47'),
('20', '1', 'config_change', 'Component: backup_download\nDownloaded backup file: backup_2025-01-31_12-24-39.sql', '102.140.245.174', '2025-01-31 15:24:49');

INSERT INTO `agent` VALUES
('1', 'HS Jutley', '1', '1234', '1234', '1234', '1', '', '', '1', '2024-12-28', '', '', '', '', '', '', ''),
('2', 'Test Agent', '1', '', '', '', '0', '', '', '', '0000-00-00', '', '', '', '', '', '', ''),
('3', 'Minet Insurance Brokers', '1', '', '', '', '0', '', '', '', '0000-00-00', '', '', '', '', '', '', '');




INSERT INTO `api_category_change` VALUES
('1', NULL, 'RI-001-00', 'CAT B', '1', '2025-05-15', '0'),
('2', NULL, 'RI-002-00', 'CAT C', '1', '2025-05-15', '0'),
('3', NULL, 'RI-006-00', 'CAT B', '1', '2025-05-26', '0'),
('4', NULL, 'RI-006-00', 'CAT B', '1', '2025-05-26', '0');






INSERT INTO `backup_settings` VALUES
('1', 'backup_frequency', 'daily', '2024-12-29 19:35:13', '2024-12-29 19:35:13'),
('2', 'retention_days', '30', '2024-12-29 19:35:13', '2024-12-29 19:35:13'),
('3', 'notify_email', 'hi@myne.co.ke', '2024-12-29 19:35:13', '2024-12-29 19:50:53'),
('4', 'last_backup_time', '', '2024-12-29 19:35:13', '2024-12-29 19:35:13'),
('5', 'backup_enabled', '1', '2024-12-29 19:35:13', '2024-12-29 19:35:13');

INSERT INTO `banks` VALUES
('1', 'KCB Bank', 'Head Office', 'KCBLKENX', 'Kencom House, Moi Avenue', NULL, NULL, NULL, '1', '2024-12-30 20:04:59', NULL, NULL, NULL),
('2', 'Equity Bank', 'Head Office', 'EQBLKENA', 'Equity Centre, Upper Hill', NULL, NULL, NULL, '1', '2024-12-30 20:04:59', NULL, NULL, NULL),
('3', 'Cooperative Bank', 'Head Office', 'KCOOKENA', 'Co-op House, Haile Selassie Avenue', NULL, NULL, NULL, '1', '2024-12-30 20:04:59', NULL, NULL, NULL),
('4', 'NCBA Bank', 'Head Office', 'CBAFKENX', 'NCBA Centre, Mara Road', NULL, NULL, NULL, '1', '2024-12-30 20:04:59', NULL, NULL, NULL),
('5', 'Absa Bank', 'Head Office', 'BARCKENX', 'Absa Plaza, Loita Street', NULL, NULL, NULL, '1', '2024-12-30 20:04:59', NULL, NULL, NULL);

INSERT INTO `benefit` VALUES
('1', 'Inpatient'),
('2', 'Outpatient'),
('3', 'Maternity'),
('14', 'Dental'),
('15', 'Optical'),
('16', 'Last Expense'),
('17', 'Critical Illness'),
('18', 'Chronic Illness'),
('19', 'Personal Accident'),
('20', 'Congenital Conditions');




INSERT INTO `bill_vet` VALUES
('CLM-0000012', '09799', '9', '3', '1', '1', '', '21:24:40', '1', '2025-04-15'),
('CLM-0000004', '55354er', '4', '1', '1', '0', '', '19:15:06', '1', '2024-12-27'),
('CLM-0000004', '56554', '1', '1', '1', '0', '', '19:17:33', '1', '2024-12-27'),
('CLM-0000009', 'AK001S', '1', '1', '1', '1', '', '21:16:31', '1', '2025-04-15'),
('CLM-0000011', 'BST001', '1', '5', '1', '0', '', '15:54:31', '1', '2025-05-15'),
('CLM-0000011', 'BST002', '2', '5', '1', '1', '', '15:55:09', '1', '2025-05-15'),
('CLM-0000012', 'ftr5653', '3', '3', '1', '1', '', '21:26:36', '1', '2025-04-15'),
('CLM-0000003', 'INV0001', '1', '1', '1', '1', '', '10:04:27', '1', '2025-01-09'),
('CLM-0000001', 'INV01', '2', '1', '1', '0', '', '16:11:55', '1', '2024-12-23'),
('CLM-0000001', 'INV02', '2', '1', '1', '1', '', '16:12:46', '1', '2024-12-23'),
('CLM-0000002', 'INV030', '1', '1', '1', '0', '', '22:43:32', '1', '2024-12-23'),
('CLM-0000005', 'INV45', '1', '1', '1', '1', '', '14:54:53', '1', '2025-01-31'),
('CLM-0000006', 'INVT234', '1', '1', '1', '1', '', '14:55:25', '1', '2025-01-31'),
('CLM-0000008', 'INVTY67', '1', '1', '1', '0', '', '21:57:44', '1', '2025-01-16'),
('CLM-0000007', 'INVTY67', '2', '1', '1', '1', '', '15:31:18', '1', '2025-05-15'),
('RMB-000001', 'RMB-000001-02', '1', '1', '1', '0', '', '07:57:38', '1', '2025-02-01'),
('RMB-000002', 'RMB-000002-02', '1', '5', '1', '1', '', '16:57:50', '1', '2025-04-12'),
('RMB-000003', 'RMB-000003-02', '1', '4', '1', '1', '', '21:18:15', '1', '2025-04-15'),
('CLM-0000010', 'SHL003', '2', '1', '1', '0', '', '11:08:01', '1', '2025-01-23');

INSERT INTO `bills` VALUES
('CLM-0000012', 'CLM-0000012', '09799', '9', '3', 'RI-002-00', '2', NULL, '2025-02-02', '19900', '2025-04-01', '1', '2500', '1', '17400', NULL, NULL, '1', '2025-04-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8', 'RI-002', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000012', 'CLM-0000012', '345345', '1', '3', 'RI-002-00', '2', NULL, '2025-02-02', '2500', '2025-04-01', NULL, NULL, NULL, NULL, NULL, NULL, '1', '2025-04-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8', 'RI-002', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000004', 'CLM-0000004', '55354er', '4', '1', 'PTL-001-00', '1', NULL, '2024-12-01', '200000', '2024-12-12', '1', '0', '0', '200000', '1', NULL, '1', '2024-12-27', 'VCH-202500', '1', '2025-05-25', '20250010', NULL, NULL, NULL, NULL, '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000004', 'CLM-0000004', '56554', '1', '1', 'PTL-001-00', '1', NULL, '2024-12-01', '4560', '2024-12-12', '1', '0', '0', '4560', '1', NULL, '1', '2024-12-27', 'VCH-202500', '1', '2025-01-18', '20250003', NULL, NULL, NULL, NULL, '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000009', 'CLM-0000009', 'AK001S', '1', '1', 'PTL-001-00', '2', NULL, '2025-01-01', '2000', '2025-01-13', '1', '500', '1', '1500', '1', NULL, '1', '2025-01-19', 'VCH-202500', '1', '2025-04-15', '20250007', NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '2000.00'),
('CLM-0000011', 'CLM-0000011', 'BST001', '1', '5', 'PTL-001-00', '2', NULL, '2025-04-01', '5000', '2025-04-04', '1', '0', '0', '5000', NULL, NULL, '1', '2025-04-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '5000.00'),
('CLM-0000011', 'CLM-0000011', 'BST002', '2', '5', 'PTL-001-00', '2', NULL, '2025-04-01', '2500', '2025-04-04', '1', '500', '1', '2000', NULL, NULL, '1', '2025-05-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '2500.00'),
('CLM-0000012', 'CLM-0000012', 'ftr5653', '3', '3', 'RI-002-00', '2', NULL, '2025-02-02', '8500', '2025-04-01', '1', '3500', '1', '5000', NULL, NULL, '1', '2025-04-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8', 'RI-002', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000003', 'CLM-0000003', 'INV0001', '1', '1', 'PTL-001-00', '2', NULL, '2024-12-10', '1200', '2024-12-19', '1', '300', '1', '900', '1', NULL, '1', '2024-12-24', 'VCH-202500', '1', '2025-01-18', '20250002', NULL, NULL, NULL, NULL, '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000001', 'CLM-0000001', 'INV01', '2', '1', 'PTL-001-00', 'Consu', NULL, '2024-12-18', '1000', '2024-12-20', '1', '0', '0', '1000', '1', NULL, '1', '2024-12-22', 'VCH-202400', NULL, NULL, '20240001', NULL, NULL, NULL, NULL, '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000001', 'CLM-0000001', 'INV02', '2', '1', 'PTL-001-00', 'L', NULL, '2024-12-18', '2500', '2024-12-20', '1', '250', '1', '2250', '1', NULL, '1', '2024-12-22', 'VCH-202400', NULL, NULL, '20240001', NULL, NULL, NULL, NULL, '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000005', 'CLM-0000005', 'INV45', '1', '1', 'PTL-001-00', '2', NULL, '2024-12-11', '2000', '2024-12-24', '1', '500', '1', '1500', '1', NULL, '1', '2024-12-28', 'VCH-202500', '1', '2025-04-29', '20250009', NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000006', 'CLM-0000006', 'INVT234', '1', '1', 'PTL-001-00', '2', NULL, '2025-01-01', '2500', '2025-01-08', '1', '500', '1', '2000', '1', NULL, '1', '2025-01-16', 'VCH-202500', '1', '2025-01-31', '20250005', NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000008', 'CLM-0000008', 'INVTY67', '1', '1', 'PTL-001-00', '2', NULL, '2025-01-01', '5000', '2025-01-13', '1', '0', '0', '5000', '1', NULL, '1', '2025-01-16', 'VCH-202500', '1', '2025-01-16', '20250001', NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000007', 'CLM-0000007', 'INVTY67', '2', '1', 'PTL-001-00', '2', NULL, '2025-01-01', '5000', '2025-01-13', '1', '1000', '1', '4000', '1', NULL, '1', '2025-01-16', 'VCH-202500', '1', '2025-05-25', '20250010', NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000008', 'CLM-0000008', 'INVTY68', '3', '1', 'PTL-001-00', '2', NULL, '2025-01-01', '2500', '2025-01-13', NULL, NULL, NULL, NULL, NULL, NULL, '1', '2025-01-16', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '3', 'PTL-001', '1', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00'),
('RMB-000001', 'RMB-000001', 'RMB-000001-02', '1', '1', 'PTL-001-00', '2', NULL, '2025-01-15', '2500', '2025-02-01', '1', '0', '0', '2500', '1', NULL, '1', '2025-02-01', 'VCH-202500', '1', '2025-04-15', '20250008', NULL, NULL, NULL, NULL, '3', 'PTL-001', '1', '1', '1', '1234567', 'Sam Nujoma', 'PENDING', '0.00', NULL, '0.00', '0.00'),
('RMB-000002', 'RMB-000002', 'RMB-000002-02', '1', '5', 'SHL-001-00', '2', NULL, '2025-03-25', '2500', '2025-04-12', '1', '1000', '1', '1500', '1', NULL, '1', '2025-04-12', 'VCH-202500', '1', '2025-04-12', '20250006', NULL, NULL, NULL, NULL, '5', 'SHL-001', '1', '1', '1', '124346746', 'John Doe', 'PENDING', '0.00', NULL, '0.00', '0.00'),
('RMB-000002', 'RMB-000002', 'RMB-000002-02', '2', '5', 'SHL-001-00', '2', NULL, '2025-03-25', '3500', '2025-04-12', '1', '1000', '1', '1500', '1', NULL, '1', '2025-04-12', 'VCH-202500', '1', '2025-04-12', '20250006', NULL, NULL, NULL, NULL, '5', 'SHL-001', '1', '1', '1', '124346746', 'John Doe', 'PENDING', '0.00', NULL, '0.00', '0.00'),
('RMB-000003', 'RMB-000003', 'RMB-000003-02', '1', '4', 'RI-001-00', '2', NULL, '2025-02-14', '2500', '2025-04-15', '1', '2500', '1', '0', NULL, NULL, '1', '2025-04-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8', 'RI-001', '1', '1', '1', 'hjghfhjf', 'hjjhghgh', 'PENDING', '0.00', NULL, '0.00', '0.00'),
('RMB-000003', 'RMB-000003', 'RMB-000003-02', '2', '4', 'RI-001-00', '2', NULL, '2025-02-14', '5500', '2025-04-15', '1', '2500', '1', '0', NULL, NULL, '1', '2025-04-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8', 'RI-001', '1', '1', '1', 'hjghfhjf', 'hjjhghgh', 'PENDING', '0.00', NULL, '0.00', '0.00'),
('RMB-000003', 'RMB-000003', 'RMB-000003-02', '9', '4', 'RI-001-00', '2', NULL, '2025-02-14', '19000', '2025-04-15', '1', '2500', '1', '0', NULL, NULL, '1', '2025-04-15', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8', 'RI-001', '1', '1', '1', 'hjghfhjf', 'hjjhghgh', 'PENDING', '0.00', NULL, '0.00', '0.00'),
('CLM-0000010', 'CLM-0000010', 'SHL003', '2', '1', 'SHL-003-00', '2', NULL, '2025-01-23', '5000', '2025-01-10', '1', '0', '0', '5000', '1', NULL, '1', '2025-01-23', 'VCH-202500', '1', '2025-01-23', '20250004', NULL, NULL, NULL, NULL, '5', 'SHL-001', '3', '0', NULL, NULL, NULL, 'PENDING', '0.00', NULL, '0.00', '0.00');

INSERT INTO `bills_payment` VALUES
('20240001', 'CHQ001', '2024-12-24', '4750', '1', NULL, NULL, '0', NULL, '2024-12-24', '1', '0', NULL, NULL, '1', ''),
('20250001', 'CHQ1234Z', '2025-01-16', '5000', NULL, NULL, NULL, '0', NULL, '2025-01-16', '1', '0', NULL, NULL, '1', 'VCH-20250001'),
('20250002', 'CHQ1234S', '2025-01-18', '900', NULL, NULL, NULL, '0', NULL, '2025-01-18', '1', '0', NULL, NULL, '1', 'VCH-20250002'),
('20250003', 'EFT001K', '2025-01-18', '4560', '1', NULL, NULL, '0', NULL, '2025-01-18', '1', '0', NULL, NULL, '2', 'VCH-20250003'),
('20250004', 'SHLCHQ001', '2025-01-23', '5000', '1', NULL, NULL, '0', NULL, '2025-01-23', '1', '0', NULL, NULL, '1', 'VCH-20250004'),
('20250005', 'CHQ001', '2025-01-31', '2000', '1', NULL, NULL, '0', NULL, '2025-01-31', '1', '0', NULL, NULL, '1', 'VCH-20250005'),
('20250006', '002183', '2025-04-12', '3000', '5', NULL, NULL, '0', NULL, '2025-04-12', '1', '0', NULL, NULL, '1', 'VCH-20250006'),
('20250007', '002183', '2025-04-15', '1500', '1', NULL, NULL, '0', NULL, '2025-04-15', '1', '0', NULL, NULL, '1', 'VCH-20250007'),
('20250008', 'TSET001', '2025-04-15', '2500', '1', NULL, NULL, '0', NULL, '2025-04-15', '1', '0', NULL, NULL, '1', 'VCH-20250008'),
('20250009', 'CHQ145D', '2025-04-29', '1500', '1', NULL, NULL, '0', NULL, '2025-04-29', '1', '0', NULL, NULL, '1', 'VCH-20250009'),
('20250010', 'PTL001X', '2025-05-25', '204000', '1', NULL, NULL, '0', NULL, '2025-05-25', '1', '0', NULL, NULL, '1', 'VCH-20250010');





INSERT INTO `claim_diagnoses` VALUES
('1', 'CLM-0000007', '464', '1', '1', '2025-01-16 20:29:27'),
('2', 'CLM-0000008', '68', '1', '1', '2025-01-16 21:56:59'),
('3', 'CLM-0000008', '68', '1', '1', '2025-01-16 21:56:59'),
('4', 'CLM-0000009', '67', '1', '1', '2025-01-19 18:34:38'),
('5', 'CLM-0000002', '33', '1', '1', '2025-04-12 16:42:37'),
('8', 'CLM-0000011', '83', '1', '1', '2025-05-15 15:52:44');

INSERT INTO `claim_drafts` VALUES
('2', 'CLM-0000003', 'PTL-001-00', '3', 'PTL-001', '1', '2024-12-10', '{\"claims\": [{\"amount\": 1200, \"invoiceNo\": \"INV0001\", \"description\": \"1\", \"benefit_code\": \"2\", \"benefit_name\": \"Outpatient\", \"dateReceived\": \"2024-12-19\", \"description_text\": \"Consultation\"}], \"corp_id\": \"3\", \"pri_dep\": \"1\", \"claim_no\": \"CLM-0000003\", \"provider\": \"1\", \"family_no\": \"PTL-001\", \"member_no\": \"PTL-001-00\", \"invoice_date\": \"2024-12-10\"}', '1', '2024-12-24 11:10:51', '2024-12-24 11:26:41', 'processed'),
('3', 'CLM-0000011', 'PTL-001-00', '3', 'PTL-001', '1', '2025-01-31', '{\"claims\": [{\"amount\": 3000, \"invoiceNo\": \"INVT234X\", \"description\": \"1\", \"benefit_code\": \"2\", \"benefit_name\": \"Outpatient\", \"dateReceived\": \"2025-01-01\", \"description_text\": \"Consultation\"}], \"corp_id\": \"3\", \"pri_dep\": \"1\", \"claim_no\": \"CLM-0000011\", \"provider\": \"1\", \"family_no\": \"PTL-001\", \"member_no\": \"PTL-001-00\", \"invoice_date\": \"2025-01-31\"}', '1', '2025-01-31 14:57:59', NULL, 'draft'),
('4', 'CLM-0000002', 'PTL-001-00', '3', 'PTL-001', '3', '2025-04-01', '{\"claims\": [{\"amount\": 6500, \"invoiceNo\": \"re3454\", \"description\": \"2\", \"benefit_code\": \"1\", \"benefit_name\": \"Inpatient\", \"dateReceived\": \"2025-04-05\", \"description_text\": \"Prescription\"}], \"corp_id\": \"3\", \"pri_dep\": \"1\", \"claim_no\": \"CLM-0000002\", \"provider\": \"3\", \"family_no\": \"PTL-001\", \"member_no\": \"PTL-001-00\", \"invoice_date\": \"2025-04-01\"}', '1', '2025-04-12 16:15:56', '2025-04-12 16:16:39', 'processed'),
('5', 'CLM-0000002', 'SHL-002-00', '5', 'SHL-001', '4', '2025-01-14', '{\"claims\": [{\"amount\": 8600, \"invoiceNo\": \"yts64\", \"description\": \"3\", \"benefit_code\": \"1\", \"benefit_name\": \"Inpatient\", \"dateReceived\": \"2025-04-01\", \"description_text\": \"Laboratory Services\"}, {\"amount\": 2500, \"invoiceNo\": \"7823\", \"description\": \"1\", \"benefit_code\": \"1\", \"benefit_name\": \"Inpatient\", \"dateReceived\": \"2025-04-01\", \"description_text\": \"Consultation\"}], \"corp_id\": \"5\", \"pri_dep\": \"2\", \"claim_no\": \"CLM-0000002\", \"provider\": \"4\", \"family_no\": \"SHL-001\", \"member_no\": \"SHL-002-00\", \"invoice_date\": \"2025-01-14\"}', '1', '2025-04-12 16:26:12', '2025-04-12 16:30:23', 'processed'),
('6', 'CLM-0000002', 'SHL-001-00', '5', 'SHL-001', '2', '2025-01-30', '{\"claims\": [{\"amount\": 2500, \"invoiceNo\": \"iu7823\", \"description\": \"1\", \"benefit_code\": \"1\", \"benefit_name\": \"Inpatient\", \"dateReceived\": \"2025-03-03\", \"description_text\": \"Consultation\"}, {\"amount\": 3500, \"invoiceNo\": \"uidu8\", \"description\": \"5\", \"benefit_code\": \"1\", \"benefit_name\": \"Inpatient\", \"dateReceived\": \"2025-03-03\", \"description_text\": \"Pharmacy\"}], \"corp_id\": \"5\", \"pri_dep\": \"1\", \"claim_no\": \"CLM-0000002\", \"provider\": \"2\", \"family_no\": \"SHL-001\", \"member_no\": \"SHL-001-00\", \"invoice_date\": \"2025-01-30\"}', '1', '2025-04-12 16:28:47', '2025-04-12 16:30:13', 'processed'),
('7', 'CLM-0000012', 'RI-002-00', '8', 'RI-002', '3', '2025-02-02', '{\"claims\": [{\"amount\": 2500, \"invoiceNo\": \"345345\", \"description\": \"1\", \"benefit_code\": \"2\", \"benefit_name\": \"Outpatient\", \"dateReceived\": \"2025-04-01\", \"description_text\": \"Consultation\"}, {\"amount\": 8500, \"invoiceNo\": \"ftr5653\", \"description\": \"3\", \"benefit_code\": \"2\", \"benefit_name\": \"Outpatient\", \"dateReceived\": \"2025-04-01\", \"description_text\": \"Laboratory Services\"}, {\"amount\": 19900, \"invoiceNo\": \"09799\", \"description\": \"9\", \"benefit_code\": \"2\", \"benefit_name\": \"Outpatient\", \"dateReceived\": \"2025-04-01\", \"description_text\": \"X RAY\"}], \"corp_id\": \"8\", \"pri_dep\": \"1\", \"claim_no\": \"CLM-0000012\", \"provider\": \"3\", \"family_no\": \"RI-002\", \"member_no\": \"RI-002-00\", \"invoice_date\": \"2025-02-02\"}', '1', '2025-04-15 21:22:36', '2025-04-15 21:22:54', 'processed');


INSERT INTO `claim_status_log` VALUES
('1', 'CLM-0000009', 'AK001S', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-19 18:34:38'),
('2', 'CLM-0000010', 'INV001', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 07:40:39'),
('3', 'CLM-0000011', 'SHL001', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 07:58:28'),
('4', 'CLM-0000012', 'SHL003', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 08:07:20'),
('5', 'CLM-0000010', 'SHL003', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 08:31:42'),
('6', 'CLM-0000010', 'SHL003', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 08:33:23'),
('7', 'CLM-0000010', 'SHL003', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 08:48:09'),
('8', 'CLM-0000010', 'SHL003', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 09:12:50'),
('9', 'CLM-0000010', 'SHL003', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 09:13:43'),
('10', 'CLM-0000010', 'SHL003', '1', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-01-23 11:07:02'),
('11', 'RMB-000001', 'RMB-000001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 18:57:27'),
('12', 'RMB-000001', 'RMB-000001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 18:58:44'),
('13', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 19:45:49'),
('14', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 20:02:44'),
('15', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 20:26:45'),
('16', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 20:31:24'),
('17', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 20:37:51'),
('18', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 20:41:21'),
('19', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 20:50:54'),
('20', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 21:26:32'),
('21', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 21:45:09'),
('22', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 21:56:31'),
('23', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-23 22:19:20'),
('24', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-24 06:23:50'),
('25', 'CLM-0000011', 'TST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-01-24 06:40:01'),
('26', 'RMB-000001', 'RMB-000001-02', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-02-01 07:55:24'),
('27', 'CLM-0000002', 're3454', '3', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-04-12 16:16:39'),
('28', 'CLM-0000002', 'iu7823', '2', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-04-12 16:30:13'),
('29', 'CLM-0000002', 'uidu8', '2', 'RECEIVED', 'Claim Received', 'Service: 5 received from provider', '1', '0', '1', '2025-04-12 16:30:13'),
('30', 'CLM-0000002', 'yts64', '4', 'RECEIVED', 'Claim Received', 'Service: 3 received from provider', '1', '0', '1', '2025-04-12 16:30:23'),
('31', 'CLM-0000002', '7823', '4', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-04-12 16:30:23'),
('32', 'CLM-0000002', 'INVTST001', '1', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-04-12 16:42:37'),
('33', 'RMB-000002', 'RMB-000002-02', '5', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-04-12 16:52:27'),
('34', 'RMB-000002', 'RMB-000002-02', '5', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-04-12 16:52:27'),
('35', 'CLM-0000011', 'BST001', '5', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-04-15 13:32:25'),
('36', 'RMB-000003', 'RMB-000003-02', '4', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-04-15 21:12:16'),
('37', 'RMB-000003', 'RMB-000003-02', '4', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-04-15 21:12:16'),
('38', 'RMB-000003', 'RMB-000003-02', '4', 'RECEIVED', 'Claim Received', 'Service: 9 received from provider', '1', '0', '1', '2025-04-15 21:12:16'),
('39', 'CLM-0000012', '345345', '3', 'RECEIVED', 'Claim Received', 'Service: 1 received from provider', '1', '0', '1', '2025-04-15 21:22:54'),
('40', 'CLM-0000012', 'ftr5653', '3', 'RECEIVED', 'Claim Received', 'Service: 3 received from provider', '1', '0', '1', '2025-04-15 21:22:54'),
('41', 'CLM-0000012', '09799', '3', 'RECEIVED', 'Claim Received', 'Service: 9 received from provider', '1', '0', '1', '2025-04-15 21:22:54'),
('43', 'CLM-0000011', 'BST002', '5', 'RECEIVED', 'Claim Received', 'Service: 2 received from provider', '1', '0', '1', '2025-05-15 15:52:44');

INSERT INTO `client_documents` VALUES
('2', 'PTL-001-00', '3', 'medical', '678e07557a803_20250120.pdf', 'Sam Nujoma - Biz Card.pdf', 'documents/3/PTL-001-00/678e07557a803_20250120.pdf', 'Records', '1', '2025-01-20 11:20:37');



INSERT INTO `corp_anniversary` VALUES
('3', '1', '2024-11-11', '2025-11-10', '2025-11-11', '1', 'Admin', '2024-11-11', '0', '0', '0', '1', '0'),
('4', '1', '2024-11-28', '2024-12-27', '2024-12-28', '1', 'Admin', '2024-12-28', '0', '0', '0', '1', '1'),
('4', '2', '2024-12-28', '2025-12-27', '2025-12-28', '1', '1', '2025-01-31', '0', '0', '0', '1', '0'),
('5', '1', '2025-01-12', '2026-01-11', '2026-01-12', '1', 'Admin', '2025-01-12', '0', '0', '0', '1', '0'),
('6', '1', '2025-03-04', '2026-03-03', '2026-03-04', '1', 'Admin', '2025-03-04', '0', '0', '0', '1', '0'),
('7', '1', '2025-04-01', '2026-03-31', '2026-04-01', '1', 'Admin', '2025-04-07', '0', '0', '0', '1', '0'),
('8', '1', '2024-12-01', '2025-11-30', '2025-12-01', '1', 'Admin', '2025-04-15', '0', '0', '0', '1', '0');

INSERT INTO `corp_groups` VALUES
('2', '2', '2024', 'OP', '2', NULL, '100000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('3', '2', '2024', 'IP', '1', NULL, '1000000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('32', '3', '2024', 'IP', '1', NULL, '1000000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, '2024-11-11', '2025-11-10', NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('33', '3', '2024', 'OP', '2', NULL, '100000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('82', '4', '1', 'IP', '1', '0', '1000000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('83', '4', '1', 'OP', '2', '0', '100000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('84', '5', '1', 'IP', '1', '0', '1000000.00', NULL, '1', '1', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('85', '5', '1', 'OP', '2', '0', '500000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('88', '4', '2', 'IP', '1', '0', '1000000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, '2024-12-28', '2025-12-27', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('89', '4', '2', 'OP', '2', '0', '100000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, '2024-12-28', '2025-12-27', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('90', '6', '1', 'CAT A', '1', '0', '2000000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('91', '6', '1', 'CAT A', '2', '0', '1000000.00', NULL, '1', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('92', '7', '1', 'CAT A', '1', '0', '1000000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('93', '7', '1', 'CAT A', '2', '0', '80000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('94', '7', '1', 'CAT A', '3', '0', '150000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('98', '', '0', 'CAT B', '1', NULL, '5000000.00', NULL, '1', '0', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('99', '', '0', 'CAT B', '3', NULL, '300000.00', NULL, '1', '0', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('100', '', '0', 'CAT B', '2', NULL, '2000000.00', NULL, '1', '0', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('101', '', '0', 'CAT C', '1', NULL, '1000000.00', NULL, '1', '0', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('102', '8', '1', 'CAT A', '1', '0', '1000000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('103', '8', '1', 'CAT A', '2', '0', '100000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('104', '8', '1', 'CAT B', '1', '0', '1500000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('105', '8', '1', 'CAT B', '2', '0', '150000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('106', '8', '1', 'CAT B', '3', '0', '100000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('107', '8', '1', 'CAT C', '1', '0', '2000000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('108', '8', '1', 'CAT C', '2', '0', '200000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('109', '8', '1', 'CAT C', '3', '0', '150000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('110', '8', '1', 'CAT D', '1', '0', '2500000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('111', '8', '1', 'CAT D', '2', '0', '250000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL),
('112', '8', '1', 'CAT D', '3', '0', '200000.00', NULL, '0', '0', NULL, '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL);

INSERT INTO `corp_renewal_status` VALUES
('2', '1', 'Can renew', '1', '2025-01-21 09:06:25'),
('3', '1', 'Can be renewed', '1', '2025-02-11 06:47:46');

INSERT INTO `corporate` VALUES
('1', 'Myne Interactive Ltd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Admin', '2024-11-09', NULL, 'MIL', NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, 'MIL001', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, 'A005635485K', '', NULL, '80.00', '80.00', '0.00', NULL, NULL, NULL, NULL, 'ANNUAL'),
('2', 'Liberty Telco Ke Ltd', NULL, NULL, NULL, NULL, '0', NULL, NULL, 'Admin', '2024-11-09', NULL, 'LTK', NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, 'LTK001', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, 'A015635485Z', 'Kes.', NULL, '80.00', '80.00', '0.00', NULL, NULL, NULL, NULL, 'ANNUAL'),
('3', 'Polakis Technologies Ltd', NULL, NULL, NULL, NULL, '0', NULL, NULL, 'Admin', '2024-11-11', NULL, 'PTL', NULL, NULL, '0', '2', NULL, NULL, NULL, NULL, 'PTL001', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, 'A005635485Z', 'Kes.', NULL, '80.00', '80.00', '0.00', NULL, NULL, NULL, NULL, 'ANNUAL'),
('4', 'Saroze Solutions', NULL, NULL, NULL, NULL, '1', NULL, NULL, 'Admin', '2024-12-28', NULL, 'SSL', '2025-01-17', '1', '0', '2', NULL, NULL, NULL, NULL, 'SSL', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, 'A00563456Y', 'Kes.', NULL, '70.00', '70.00', '0.00', NULL, NULL, 'ACTIVE', 'Cleared holds', 'ANNUAL'),
('5', 'Shine Limited', NULL, NULL, NULL, NULL, '1', NULL, NULL, 'Admin', '2025-01-12', NULL, 'SHL', NULL, NULL, '0', '2', NULL, NULL, NULL, NULL, 'SHL01', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, 'SHLX478437', 'Kes.', NULL, '75.00', '70.00', '750000.00', NULL, NULL, NULL, NULL, 'ANNUAL'),
('6', 'DEVELOPMENT', NULL, NULL, NULL, NULL, '1', NULL, NULL, 'Admin', '2025-03-04', NULL, 'D', NULL, NULL, '0', '1', NULL, NULL, NULL, NULL, '1223344', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, '1122334455', 'Kes.', NULL, '999.99', '999.99', '0.00', NULL, NULL, NULL, NULL, 'ANNUAL'),
('7', 'Null Island Inc', NULL, NULL, NULL, NULL, '1', NULL, NULL, 'Admin', '2025-04-07', NULL, 'NII', NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '672346D', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, 'KPYWDIJIE', 'Kes.', NULL, '70.00', '80.00', '0.00', NULL, NULL, NULL, NULL, 'ANNUAL'),
('8', 'Great Rome Inc', '', NULL, '', '', '1', '', '', 'Admin', '2025-04-15', NULL, 'RI', '2025-04-24', '1', '0', '2', NULL, NULL, NULL, NULL, '65658', '2', NULL, NULL, NULL, '0', NULL, '0', '0', NULL, '43ds5454', 'Kes.', NULL, '80.00', '90.00', '0.00', NULL, NULL, NULL, NULL, 'ANNUAL');

INSERT INTO `corporate_discounts` VALUES
('1', '3', NULL, '5', '5.00', '2025-01-14', '2026-01-14', 'ACTIVE', '1', '2025-01-14 15:32:53', NULL, NULL),
('2', '3', NULL, '10', '10.00', '2025-01-14', '2026-01-14', 'ACTIVE', '1', '2025-01-14 15:32:53', NULL, NULL),
('3', '3', NULL, '20', '15.00', '2025-01-14', '2026-01-14', 'ACTIVE', '1', '2025-01-14 15:32:53', NULL, NULL);

INSERT INTO `corporate_groups` VALUES
('1', 'CAT A', 'Category A', 'Category A', '1', '1', '2025-01-16 07:48:41', NULL, NULL),
('2', 'CAT B', 'Category B', 'Category B', '1', '1', '2025-01-16 07:48:56', '1', '2025-04-08 22:36:53'),
('3', 'CAT C', 'Category C', 'Category C', '1', '1', '2025-01-16 07:49:09', '1', '2025-04-08 22:37:11'),
('4', 'CAT D', 'Category D', 'Category D', '1', '1', '2025-01-16 07:49:24', NULL, NULL),
('5', 'CAT E', 'Category E', 'Category E', '1', '1', '2025-01-16 07:49:42', NULL, NULL),
('6', 'CAT F', 'Category F', 'Category F', '1', '1', '2025-01-16 07:49:57', NULL, NULL);

INSERT INTO `data_sources` VALUES
('3', 'MediSureDB', '', 'mysql', 'localhost', '3306', 'homecar1_med', 'homecar1_root', '2021wemadeit', '2025-03-10 09:34:26', '1', '2025-03-10 09:34:15', '2025-03-10 09:34:26');


INSERT INTO `deduction_reasons` VALUES
('1', 'Bill Overcharge', '1', 'Admin', '2024-12-22 21:11:03'),
('2', 'Past Cover Limit', '1', 'Admin', '2024-12-22 21:11:03'),
('3', 'Not Covered', '1', 'Admin', '2024-12-22 21:11:03');












INSERT INTO `edi_providers` VALUES
('1', 'SMART Provider', 'SMART', 'SMART EDI Integration', '0', 'PENDING', NULL, NULL, NULL, '1', '2025-01-21 07:06:37', NULL, NULL),
('2', 'SLADE Provider', 'SLADE', 'SLADE EDI Integration', '0', 'PENDING', NULL, NULL, NULL, '1', '2025-01-21 07:06:37', NULL, NULL),
('3', 'LCT Provider', 'LCT', 'LCT EDI Integration', '0', 'PENDING', NULL, NULL, NULL, '1', '2025-01-21 07:06:37', NULL, NULL);


INSERT INTO `email_logs` VALUES
('1', 'QT202500001', 'info@myne.co.ke', 'hi@myne.co.ke', 'nujoma09@gmail.com', 'Insurance Quotation', 'Dear Valued Client,\r\n\r\nPlease find attached your insurance quotation. This quotation is valid until 13/02/2025.\r\n\r\nBest regards,\r\nInsurance Team', 'SENT', NULL, '1', '2025-01-14 20:25:50', NULL),
('2', 'QT202500002', 'info@myne.co.ke', 'hi@myne.co.ke', 'nujoma09@gmail.com', 'Insurance Quotation', 'Dear Valued Client,\r\n\r\nPlease find attached your insurance quotation. This quotation is valid until 13/02/2025.\r\n\r\nBest regards,\r\nInsurance Team', 'SENT', NULL, '1', '2025-01-14 21:00:21', NULL),
('3', 'QT202500003', 'info-med@hsjgroup.co.ke', '', 'nujoma09@gmail.com', 'Insurance Quotation', 'Dear Valued Client,\r\n\r\nPlease find attached your insurance quotation. This quotation is valid until 14/02/2025.\r\n\r\nBest regards,\r\nInsurance Team', 'SENT', NULL, '1', '2025-01-15 09:49:03', NULL),
('5', 'QT202500004', 'nujoma09@gmail.com', NULL, NULL, '', '', 'FAILED', 'SMTP Error: Could not connect to SMTP host.', '1', '2025-01-31 14:27:05', NULL);

INSERT INTO `fund_admin_config` VALUES
('1', '5', '14', '10.00', '10.00', '2025-01-01', NULL, 'INACTIVE', '1', '2025-01-25 20:40:40', '1', '2025-01-25 20:42:12');



INSERT INTO `fund_transactions` VALUES
('3', '5', '2025-01-13', 'TOPUP', 'FND2025016823', '750000.00', 'Fund top-up - Initial payment for fund ', '1', '2025-01-13 08:37:35', NULL, NULL);



INSERT INTO `icd10_codes` VALUES
('25', 'A000', 'Cholera due to Vibrio cholerae 01, biovar cholerae', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('26', 'A001', 'Cholera due to Vibrio cholerae 01, biovar eltor', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('27', 'A009', 'Cholera, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('28', 'A0100', 'Typhoid fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('29', 'A0101', 'Typhoid meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('30', 'A0102', 'Typhoid fever with heart involvement', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('31', 'A0103', 'Typhoid pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('32', 'A0104', 'Typhoid arthritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('33', 'A0105', 'Typhoid osteomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('34', 'A0109', 'Typhoid fever with other complications', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('35', 'A011', 'Paratyphoid fever A', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('36', 'A012', 'Paratyphoid fever B', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('37', 'A013', 'Paratyphoid fever C', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('38', 'A014', 'Paratyphoid fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('39', 'A020', 'Salmonella enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('40', 'A021', 'Salmonella sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('41', 'A0220', 'Localized salmonella infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('42', 'A0221', 'Salmonella meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('43', 'A0222', 'Salmonella pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('44', 'A0223', 'Salmonella arthritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('45', 'A0224', 'Salmonella osteomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('46', 'A0225', 'Salmonella pyelonephritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('47', 'A0229', 'Salmonella with other localized infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('48', 'A028', 'Other specified salmonella infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('49', 'A029', 'Salmonella infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('50', 'A030', 'Shigellosis due to Shigella dysenteriae', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('51', 'A031', 'Shigellosis due to Shigella flexneri', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('52', 'A032', 'Shigellosis due to Shigella boydii', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('53', 'A033', 'Shigellosis due to Shigella sonnei', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('54', 'A038', 'Other shigellosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('55', 'A039', 'Shigellosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('56', 'A040', 'Enteropathogenic Escherichia coli infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('57', 'A041', 'Enterotoxigenic Escherichia coli infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('58', 'A042', 'Enteroinvasive Escherichia coli infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('59', 'A043', 'Enterohemorrhagic Escherichia coli infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('60', 'A044', 'Other intestinal Escherichia coli infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('61', 'A045', 'Campylobacter enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('62', 'A046', 'Enteritis due to Yersinia enterocolitica', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('63', 'A047', 'Enterocolitis due to Clostridium difficile', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('64', 'A0471', 'Enterocolitis due to Clostridium difficile, recurrent', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('65', 'A0472', 'Enterocolitis d/t Clostridium difficile, not spcf as recur', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('66', 'A048', 'Other specified bacterial intestinal infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('67', 'A049', 'Bacterial intestinal infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('68', 'A050', 'Foodborne staphylococcal intoxication', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('69', 'A051', 'Botulism food poisoning', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('70', 'A052', 'Foodborne Clostridium perfringens intoxication', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('71', 'A053', 'Foodborne Vibrio parahaemolyticus intoxication', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('72', 'A054', 'Foodborne Bacillus cereus intoxication', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('73', 'A055', 'Foodborne Vibrio vulnificus intoxication', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('74', 'A058', 'Other specified bacterial foodborne intoxications', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('75', 'A059', 'Bacterial foodborne intoxication, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('76', 'A060', 'Acute amebic dysentery', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('77', 'A061', 'Chronic intestinal amebiasis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('78', 'A062', 'Amebic nondysenteric colitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('79', 'A063', 'Ameboma of intestine', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('80', 'A064', 'Amebic liver abscess', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('81', 'A065', 'Amebic lung abscess', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('82', 'A066', 'Amebic brain abscess', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('83', 'A067', 'Cutaneous amebiasis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('84', 'A0681', 'Amebic cystitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('85', 'A0682', 'Other amebic genitourinary infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('86', 'A0689', 'Other amebic infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('87', 'A069', 'Amebiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('88', 'A070', 'Balantidiasis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('89', 'A071', 'Giardiasis [lambliasis]', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('90', 'A072', 'Cryptosporidiosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('91', 'A073', 'Isosporiasis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('92', 'A074', 'Cyclosporiasis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('93', 'A078', 'Other specified protozoal intestinal diseases', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('94', 'A079', 'Protozoal intestinal disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('95', 'A080', 'Rotaviral enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('96', 'A0811', 'Acute gastroenteropathy due to Norwalk agent', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('97', 'A0819', 'Acute gastroenteropathy due to other small round viruses', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('98', 'A082', 'Adenoviral enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('99', 'A0831', 'Calicivirus enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('100', 'A0832', 'Astrovirus enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('101', 'A0839', 'Other viral enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('102', 'A084', 'Viral intestinal infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('103', 'A088', 'Other specified intestinal infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('104', 'A09', 'Infectious gastroenteritis and colitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('105', 'A150', 'Tuberculosis of lung', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('106', 'A154', 'Tuberculosis of intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('107', 'A155', 'Tuberculosis of larynx, trachea and bronchus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('108', 'A156', 'Tuberculous pleurisy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('109', 'A157', 'Primary respiratory tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('110', 'A158', 'Other respiratory tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('111', 'A159', 'Respiratory tuberculosis unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('112', 'A170', 'Tuberculous meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('113', 'A171', 'Meningeal tuberculoma', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('114', 'A1781', 'Tuberculoma of brain and spinal cord', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('115', 'A1782', 'Tuberculous meningoencephalitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('116', 'A1783', 'Tuberculous neuritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('117', 'A1789', 'Other tuberculosis of nervous system', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('118', 'A179', 'Tuberculosis of nervous system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('119', 'A1801', 'Tuberculosis of spine', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('120', 'A1802', 'Tuberculous arthritis of other joints', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('121', 'A1803', 'Tuberculosis of other bones', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('122', 'A1809', 'Other musculoskeletal tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('123', 'A1810', 'Tuberculosis of genitourinary system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('124', 'A1811', 'Tuberculosis of kidney and ureter', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('125', 'A1812', 'Tuberculosis of bladder', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('126', 'A1813', 'Tuberculosis of other urinary organs', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('127', 'A1814', 'Tuberculosis of prostate', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('128', 'A1815', 'Tuberculosis of other male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('129', 'A1816', 'Tuberculosis of cervix', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('130', 'A1817', 'Tuberculous female pelvic inflammatory disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('131', 'A1818', 'Tuberculosis of other female genital organs', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('132', 'A182', 'Tuberculous peripheral lymphadenopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('133', 'A1831', 'Tuberculous peritonitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('134', 'A1832', 'Tuberculous enteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('135', 'A1839', 'Retroperitoneal tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('136', 'A184', 'Tuberculosis of skin and subcutaneous tissue', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('137', 'A1850', 'Tuberculosis of eye, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('138', 'A1851', 'Tuberculous episcleritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('139', 'A1852', 'Tuberculous keratitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('140', 'A1853', 'Tuberculous chorioretinitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('141', 'A1854', 'Tuberculous iridocyclitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('142', 'A1859', 'Other tuberculosis of eye', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('143', 'A186', 'Tuberculosis of (inner) (middle) ear', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('144', 'A187', 'Tuberculosis of adrenal glands', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('145', 'A1881', 'Tuberculosis of thyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('146', 'A1882', 'Tuberculosis of other endocrine glands', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('147', 'A1883', 'Tuberculosis of digestive tract organs, NEC', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('148', 'A1884', 'Tuberculosis of heart', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('149', 'A1885', 'Tuberculosis of spleen', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('150', 'A1889', 'Tuberculosis of other sites', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('151', 'A190', 'Acute miliary tuberculosis of a single specified site', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('152', 'A191', 'Acute miliary tuberculosis of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('153', 'A192', 'Acute miliary tuberculosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('154', 'A198', 'Other miliary tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('155', 'A199', 'Miliary tuberculosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('156', 'A200', 'Bubonic plague', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('157', 'A201', 'Cellulocutaneous plague', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('158', 'A202', 'Pneumonic plague', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('159', 'A203', 'Plague meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('160', 'A207', 'Septicemic plague', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('161', 'A208', 'Other forms of plague', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('162', 'A209', 'Plague, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('163', 'A210', 'Ulceroglandular tularemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('164', 'A211', 'Oculoglandular tularemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('165', 'A212', 'Pulmonary tularemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('166', 'A213', 'Gastrointestinal tularemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('167', 'A217', 'Generalized tularemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('168', 'A218', 'Other forms of tularemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('169', 'A219', 'Tularemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('170', 'A220', 'Cutaneous anthrax', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('171', 'A221', 'Pulmonary anthrax', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('172', 'A222', 'Gastrointestinal anthrax', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('173', 'A227', 'Anthrax sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('174', 'A228', 'Other forms of anthrax', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('175', 'A229', 'Anthrax, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('176', 'A230', 'Brucellosis due to Brucella melitensis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('177', 'A231', 'Brucellosis due to Brucella abortus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('178', 'A232', 'Brucellosis due to Brucella suis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('179', 'A233', 'Brucellosis due to Brucella canis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('180', 'A238', 'Other brucellosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('181', 'A239', 'Brucellosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('182', 'A240', 'Glanders', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('183', 'A241', 'Acute and fulminating melioidosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('184', 'A242', 'Subacute and chronic melioidosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('185', 'A243', 'Other melioidosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('186', 'A249', 'Melioidosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('187', 'A250', 'Spirillosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('188', 'A251', 'Streptobacillosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('189', 'A259', 'Rat-bite fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('190', 'A260', 'Cutaneous erysipeloid', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('191', 'A267', 'Erysipelothrix sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('192', 'A268', 'Other forms of erysipeloid', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('193', 'A269', 'Erysipeloid, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('194', 'A270', 'Leptospirosis icterohemorrhagica', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('195', 'A2781', 'Aseptic meningitis in leptospirosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('196', 'A2789', 'Other forms of leptospirosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('197', 'A279', 'Leptospirosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('198', 'A280', 'Pasteurellosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('199', 'A281', 'Cat-scratch disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('200', 'A282', 'Extraintestinal yersiniosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('201', 'A288', 'Oth zoonotic bacterial diseases, not elsewhere classified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('202', 'A289', 'Zoonotic bacterial disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('203', 'A300', 'Indeterminate leprosy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('204', 'A301', 'Tuberculoid leprosy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('205', 'A302', 'Borderline tuberculoid leprosy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('206', 'A303', 'Borderline leprosy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('207', 'A304', 'Borderline lepromatous leprosy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('208', 'A305', 'Lepromatous leprosy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('209', 'A308', 'Other forms of leprosy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('210', 'A309', 'Leprosy, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('211', 'A310', 'Pulmonary mycobacterial infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('212', 'A311', 'Cutaneous mycobacterial infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('213', 'A312', 'Dissem mycobacterium avium-intracellulare complex (DMAC)', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('214', 'A318', 'Other mycobacterial infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('215', 'A319', 'Mycobacterial infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('216', 'A320', 'Cutaneous listeriosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('217', 'A3211', 'Listerial meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('218', 'A3212', 'Listerial meningoencephalitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('219', 'A327', 'Listerial sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('220', 'A3281', 'Oculoglandular listeriosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('221', 'A3282', 'Listerial endocarditis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('222', 'A3289', 'Other forms of listeriosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('223', 'A329', 'Listeriosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('224', 'A33', 'Tetanus neonatorum', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('225', 'A34', 'Obstetrical tetanus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('226', 'A35', 'Other tetanus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('227', 'A360', 'Pharyngeal diphtheria', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('228', 'A361', 'Nasopharyngeal diphtheria', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('229', 'A362', 'Laryngeal diphtheria', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('230', 'A363', 'Cutaneous diphtheria', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('231', 'A3681', 'Diphtheritic cardiomyopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('232', 'A3682', 'Diphtheritic radiculomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('233', 'A3683', 'Diphtheritic polyneuritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('234', 'A3684', 'Diphtheritic tubulo-interstitial nephropathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('235', 'A3685', 'Diphtheritic cystitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('236', 'A3686', 'Diphtheritic conjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('237', 'A3689', 'Other diphtheritic complications', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('238', 'A369', 'Diphtheria, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('239', 'A3700', 'Whooping cough due to Bordetella pertussis without pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('240', 'A3701', 'Whooping cough due to Bordetella pertussis with pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('241', 'A3710', 'Whooping cough due to Bordetella parapertussis w/o pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('242', 'A3711', 'Whooping cough due to Bordetella parapertussis w pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('243', 'A3780', 'Whooping cough due to other Bordetella species w/o pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('244', 'A3781', 'Whooping cough due to oth Bordetella species with pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('245', 'A3790', 'Whooping cough, unspecified species without pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('246', 'A3791', 'Whooping cough, unspecified species with pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('247', 'A380', 'Scarlet fever with otitis media', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('248', 'A381', 'Scarlet fever with myocarditis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('249', 'A388', 'Scarlet fever with other complications', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('250', 'A389', 'Scarlet fever, uncomplicated', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('251', 'A390', 'Meningococcal meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('252', 'A391', 'Waterhouse-Friderichsen syndrome', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('253', 'A392', 'Acute meningococcemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('254', 'A393', 'Chronic meningococcemia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('255', 'A394', 'Meningococcemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('256', 'A3950', 'Meningococcal carditis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('257', 'A3951', 'Meningococcal endocarditis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('258', 'A3952', 'Meningococcal myocarditis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('259', 'A3953', 'Meningococcal pericarditis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('260', 'A3981', 'Meningococcal encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('261', 'A3982', 'Meningococcal retrobulbar neuritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('262', 'A3983', 'Meningococcal arthritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('263', 'A3984', 'Postmeningococcal arthritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('264', 'A3989', 'Other meningococcal infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('265', 'A399', 'Meningococcal infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('266', 'A400', 'Sepsis due to streptococcus, group A', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('267', 'A401', 'Sepsis due to streptococcus, group B', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('268', 'A403', 'Sepsis due to Streptococcus pneumoniae', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('269', 'A408', 'Other streptococcal sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('270', 'A409', 'Streptococcal sepsis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('271', 'A4101', 'Sepsis due to Methicillin susceptible Staphylococcus aureus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('272', 'A4102', 'Sepsis due to Methicillin resistant Staphylococcus aureus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('273', 'A411', 'Sepsis due to other specified staphylococcus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('274', 'A412', 'Sepsis due to unspecified staphylococcus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('275', 'A413', 'Sepsis due to Hemophilus influenzae', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('276', 'A414', 'Sepsis due to anaerobes', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('277', 'A4150', 'Gram-negative sepsis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('278', 'A4151', 'Sepsis due to Escherichia coli [E. coli]', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('279', 'A4152', 'Sepsis due to Pseudomonas', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('280', 'A4153', 'Sepsis due to Serratia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('281', 'A4154', 'Sepsis due to Acinetobacter baumannii', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('282', 'A4159', 'Other Gram-negative sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('283', 'A4181', 'Sepsis due to Enterococcus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('284', 'A4189', 'Other specified sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('285', 'A419', 'Sepsis, unspecified organism', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('286', 'A420', 'Pulmonary actinomycosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('287', 'A421', 'Abdominal actinomycosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('288', 'A422', 'Cervicofacial actinomycosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('289', 'A427', 'Actinomycotic sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('290', 'A4281', 'Actinomycotic meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('291', 'A4282', 'Actinomycotic encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('292', 'A4289', 'Other forms of actinomycosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('293', 'A429', 'Actinomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('294', 'A430', 'Pulmonary nocardiosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('295', 'A431', 'Cutaneous nocardiosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('296', 'A438', 'Other forms of nocardiosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('297', 'A439', 'Nocardiosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('298', 'A440', 'Systemic bartonellosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('299', 'A441', 'Cutaneous and mucocutaneous bartonellosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('300', 'A448', 'Other forms of bartonellosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('301', 'A449', 'Bartonellosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('302', 'A46', 'Erysipelas', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('303', 'A480', 'Gas gangrene', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('304', 'A481', 'Legionnaires\' disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('305', 'A482', 'Nonpneumonic Legionnaires\' disease [Pontiac fever]', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('306', 'A483', 'Toxic shock syndrome', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('307', 'A484', 'Brazilian purpuric fever', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('308', 'A4851', 'Infant botulism', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('309', 'A4852', 'Wound botulism', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('310', 'A488', 'Other specified bacterial diseases', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('311', 'A4901', 'Methicillin suscep staph infection, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('312', 'A4902', 'Methicillin resis staph infection, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('313', 'A491', 'Streptococcal infection, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('314', 'A492', 'Hemophilus influenzae infection, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('315', 'A493', 'Mycoplasma infection, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('316', 'A498', 'Other bacterial infections of unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('317', 'A499', 'Bacterial infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('318', 'A5001', 'Early congenital syphilitic oculopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('319', 'A5002', 'Early congenital syphilitic osteochondropathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('320', 'A5003', 'Early congenital syphilitic pharyngitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('321', 'A5004', 'Early congenital syphilitic pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('322', 'A5005', 'Early congenital syphilitic rhinitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('323', 'A5006', 'Early cutaneous congenital syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('324', 'A5007', 'Early mucocutaneous congenital syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('325', 'A5008', 'Early visceral congenital syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('326', 'A5009', 'Other early congenital syphilis, symptomatic', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('327', 'A501', 'Early congenital syphilis, latent', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('328', 'A502', 'Early congenital syphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('329', 'A5030', 'Late congenital syphilitic oculopathy, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('330', 'A5031', 'Late congenital syphilitic interstitial keratitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('331', 'A5032', 'Late congenital syphilitic chorioretinitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('332', 'A5039', 'Other late congenital syphilitic oculopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('333', 'A5040', 'Late congenital neurosyphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('334', 'A5041', 'Late congenital syphilitic meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('335', 'A5042', 'Late congenital syphilitic encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('336', 'A5043', 'Late congenital syphilitic polyneuropathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('337', 'A5044', 'Late congenital syphilitic optic nerve atrophy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('338', 'A5045', 'Juvenile general paresis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('339', 'A5049', 'Other late congenital neurosyphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('340', 'A5051', 'Clutton\'s joints', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('341', 'A5052', 'Hutchinson\'s teeth', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('342', 'A5053', 'Hutchinson\'s triad', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('343', 'A5054', 'Late congenital cardiovascular syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('344', 'A5055', 'Late congenital syphilitic arthropathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('345', 'A5056', 'Late congenital syphilitic osteochondropathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('346', 'A5057', 'Syphilitic saddle nose', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('347', 'A5059', 'Other late congenital syphilis, symptomatic', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('348', 'A506', 'Late congenital syphilis, latent', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('349', 'A507', 'Late congenital syphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('350', 'A509', 'Congenital syphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('351', 'A510', 'Primary genital syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('352', 'A511', 'Primary anal syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('353', 'A512', 'Primary syphilis of other sites', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('354', 'A5131', 'Condyloma latum', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('355', 'A5132', 'Syphilitic alopecia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('356', 'A5139', 'Other secondary syphilis of skin', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('357', 'A5141', 'Secondary syphilitic meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('358', 'A5142', 'Secondary syphilitic female pelvic disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('359', 'A5143', 'Secondary syphilitic oculopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('360', 'A5144', 'Secondary syphilitic nephritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('361', 'A5145', 'Secondary syphilitic hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('362', 'A5146', 'Secondary syphilitic osteopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('363', 'A5149', 'Other secondary syphilitic conditions', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('364', 'A515', 'Early syphilis, latent', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('365', 'A519', 'Early syphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('366', 'A5200', 'Cardiovascular syphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('367', 'A5201', 'Syphilitic aneurysm of aorta', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('368', 'A5202', 'Syphilitic aortitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('369', 'A5203', 'Syphilitic endocarditis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('370', 'A5204', 'Syphilitic cerebral arteritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('371', 'A5205', 'Other cerebrovascular syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('372', 'A5206', 'Other syphilitic heart involvement', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('373', 'A5209', 'Other cardiovascular syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('374', 'A5210', 'Symptomatic neurosyphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('375', 'A5211', 'Tabes dorsalis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('376', 'A5212', 'Other cerebrospinal syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('377', 'A5213', 'Late syphilitic meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('378', 'A5214', 'Late syphilitic encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('379', 'A5215', 'Late syphilitic neuropathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('380', 'A5216', 'Charcot\'s arthropathy (tabetic)', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('381', 'A5217', 'General paresis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('382', 'A5219', 'Other symptomatic neurosyphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('383', 'A522', 'Asymptomatic neurosyphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('384', 'A523', 'Neurosyphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('385', 'A5271', 'Late syphilitic oculopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('386', 'A5272', 'Syphilis of lung and bronchus', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('387', 'A5273', 'Symptomatic late syphilis of other respiratory organs', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('388', 'A5274', 'Syphilis of liver and other viscera', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('389', 'A5275', 'Syphilis of kidney and ureter', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('390', 'A5276', 'Other genitourinary symptomatic late syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('391', 'A5277', 'Syphilis of bone and joint', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('392', 'A5278', 'Syphilis of other musculoskeletal tissue', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('393', 'A5279', 'Other symptomatic late syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('394', 'A528', 'Late syphilis, latent', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('395', 'A529', 'Late syphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('396', 'A530', 'Latent syphilis, unspecified as early or late', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('397', 'A539', 'Syphilis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('398', 'A5400', 'Gonococcal infection of lower genitourinary tract, unsp', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('399', 'A5401', 'Gonococcal cystitis and urethritis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('400', 'A5402', 'Gonococcal vulvovaginitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('401', 'A5403', 'Gonococcal cervicitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('402', 'A5409', 'Other gonococcal infection of lower genitourinary tract', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('403', 'A541', 'Gonocl infct of lower GU tract w periureth and acc glnd abcs', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('404', 'A5421', 'Gonococcal infection of kidney and ureter', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('405', 'A5422', 'Gonococcal prostatitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('406', 'A5423', 'Gonococcal infection of other male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('407', 'A5424', 'Gonococcal female pelvic inflammatory disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('408', 'A5429', 'Other gonococcal genitourinary infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('409', 'A5430', 'Gonococcal infection of eye, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('410', 'A5431', 'Gonococcal conjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('411', 'A5432', 'Gonococcal iridocyclitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('412', 'A5433', 'Gonococcal keratitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('413', 'A5439', 'Other gonococcal eye infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('414', 'A5440', 'Gonococcal infection of musculoskeletal system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('415', 'A5441', 'Gonococcal spondylopathy', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('416', 'A5442', 'Gonococcal arthritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('417', 'A5443', 'Gonococcal osteomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('418', 'A5449', 'Gonococcal infection of other musculoskeletal tissue', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('419', 'A545', 'Gonococcal pharyngitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('420', 'A546', 'Gonococcal infection of anus and rectum', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('421', 'A5481', 'Gonococcal meningitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('422', 'A5482', 'Gonococcal brain abscess', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('423', 'A5483', 'Gonococcal heart infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('424', 'A5484', 'Gonococcal pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('425', 'A5485', 'Gonococcal peritonitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('426', 'A5486', 'Gonococcal sepsis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('427', 'A5489', 'Other gonococcal infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('428', 'A549', 'Gonococcal infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('429', 'A55', 'Chlamydial lymphogranuloma (venereum)', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('430', 'A5600', 'Chlamydial infection of lower genitourinary tract, unsp', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('431', 'A5601', 'Chlamydial cystitis and urethritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('432', 'A5602', 'Chlamydial vulvovaginitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('433', 'A5609', 'Other chlamydial infection of lower genitourinary tract', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('434', 'A5611', 'Chlamydial female pelvic inflammatory disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('435', 'A5619', 'Other chlamydial genitourinary infection', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('436', 'A562', 'Chlamydial infection of genitourinary tract, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('437', 'A563', 'Chlamydial infection of anus and rectum', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('438', 'A564', 'Chlamydial infection of pharynx', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('439', 'A568', 'Sexually transmitted chlamydial infection of other sites', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('440', 'A57', 'Chancroid', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('441', 'A58', 'Granuloma inguinale', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('442', 'A5900', 'Urogenital trichomoniasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('443', 'A5901', 'Trichomonal vulvovaginitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('444', 'A5902', 'Trichomonal prostatitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('445', 'A5903', 'Trichomonal cystitis and urethritis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('446', 'A5909', 'Other urogenital trichomoniasis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('447', 'A598', 'Trichomoniasis of other sites', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('448', 'A599', 'Trichomoniasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('449', 'A6000', 'Herpesviral infection of urogenital system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('450', 'A6001', 'Herpesviral infection of penis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('451', 'A6002', 'Herpesviral infection of other male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('452', 'A6003', 'Herpesviral cervicitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('453', 'A6004', 'Herpesviral vulvovaginitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('454', 'A6009', 'Herpesviral infection of other urogenital tract', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('455', 'A601', 'Herpesviral infection of perianal skin and rectum', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('456', 'A609', 'Anogenital herpesviral infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('457', 'A630', 'Anogenital (venereal) warts', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('458', 'A638', 'Other specified predominantly sexually transmitted diseases', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('459', 'A64', 'Unspecified sexually transmitted disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('460', 'A65', 'Nonvenereal syphilis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('461', 'A660', 'Initial lesions of yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('462', 'A661', 'Multiple papillomata and wet crab yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('463', 'A662', 'Other early skin lesions of yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('464', 'A663', 'Hyperkeratosis of yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('465', 'A664', 'Gummata and ulcers of yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('466', 'A665', 'Gangosa', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('467', 'A666', 'Bone and joint lesions of yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('468', 'A667', 'Other manifestations of yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('469', 'A668', 'Latent yaws', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('470', 'A669', 'Yaws, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('471', 'A670', 'Primary lesions of pinta', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('472', 'A671', 'Intermediate lesions of pinta', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('473', 'A672', 'Late lesions of pinta', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('474', 'A673', 'Mixed lesions of pinta', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('475', 'A679', 'Pinta, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('476', 'A680', 'Louse-borne relapsing fever', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('477', 'A681', 'Tick-borne relapsing fever', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('478', 'A689', 'Relapsing fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('479', 'A690', 'Necrotizing ulcerative stomatitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('480', 'A691', 'Other Vincent\'s infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('481', 'A6920', 'Lyme disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('482', 'A6921', 'Meningitis due to Lyme disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('483', 'A6922', 'Other neurologic disorders in Lyme disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('484', 'A6923', 'Arthritis due to Lyme disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('485', 'A6929', 'Other conditions associated with Lyme disease', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('486', 'A698', 'Other specified spirochetal infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('487', 'A699', 'Spirochetal infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('488', 'A70', 'Chlamydia psittaci infections', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('489', 'A710', 'Initial stage of trachoma', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('490', 'A711', 'Active stage of trachoma', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('491', 'A719', 'Trachoma, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('492', 'A740', 'Chlamydial conjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('493', 'A7481', 'Chlamydial peritonitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('494', 'A7489', 'Other chlamydial diseases', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('495', 'A749', 'Chlamydial infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('496', 'A750', 'Epidemic louse-borne typhus fever d/t Rickettsia prowazekii', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('497', 'A751', 'Recrudescent typhus [Brill\'s disease]', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('498', 'A752', 'Typhus fever due to Rickettsia typhi', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('499', 'A753', 'Typhus fever due to Rickettsia tsutsugamushi', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('500', 'A759', 'Typhus fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('501', 'A770', 'Spotted fever due to Rickettsia rickettsii', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('502', 'A771', 'Spotted fever due to Rickettsia conorii', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('503', 'A772', 'Spotted fever due to Rickettsia siberica', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('504', 'A773', 'Spotted fever due to Rickettsia australis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('505', 'A7740', 'Ehrlichiosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('506', 'A7741', 'Ehrlichiosis chaffeensis [E. chaffeensis]', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('507', 'A7749', 'Other ehrlichiosis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('508', 'A778', 'Other spotted fevers', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('509', 'A779', 'Spotted fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('510', 'A78', 'Q fever', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('511', 'A790', 'Trench fever', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('512', 'A791', 'Rickettsialpox due to Rickettsia akari', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('513', 'A7981', 'Rickettsiosis due to Ehrlichia sennetsu', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('514', 'A7982', 'Anaplasmosis [A. phagocytophilum]', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('515', 'A7989', 'Other specified rickettsioses', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('516', 'A799', 'Rickettsiosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('517', 'A800', 'Acute paralytic poliomyelitis, vaccine-associated', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('518', 'A801', 'Acute paralytic poliomyelitis, wild virus, imported', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('519', 'A802', 'Acute paralytic poliomyelitis, wild virus, indigenous', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('520', 'A8030', 'Acute paralytic poliomyelitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('521', 'A8039', 'Other acute paralytic poliomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('522', 'A804', 'Acute nonparalytic poliomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('523', 'A809', 'Acute poliomyelitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:41:55', NULL, NULL),
('2658', 'A8100', 'Creutzfeldt-Jakob disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2659', 'A8101', 'Variant Creutzfeldt-Jakob disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2660', 'A8109', 'Other Creutzfeldt-Jakob disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2661', 'A811', 'Subacute sclerosing panencephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2662', 'A812', 'Progressive multifocal leukoencephalopathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2663', 'A8181', 'Kuru', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2664', 'A8182', 'Gerstmann-Straussler-Scheinker syndrome', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2665', 'A8183', 'Fatal familial insomnia', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2666', 'A8189', 'Other atypical virus infections of central nervous system', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2667', 'A819', 'Atypical virus infection of central nervous system, unsp', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2668', 'A820', 'Sylvatic rabies', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2669', 'A821', 'Urban rabies', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2670', 'A829', 'Rabies, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2671', 'A830', 'Japanese encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2672', 'A831', 'Western equine encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2673', 'A832', 'Eastern equine encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2674', 'A833', 'St Louis encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2675', 'A834', 'Australian encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2676', 'A835', 'California encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2677', 'A836', 'Rocio virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2678', 'A838', 'Other mosquito-borne viral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2679', 'A839', 'Mosquito-borne viral encephalitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2680', 'A840', 'Far Eastern tick-borne encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2681', 'A841', 'Central European tick-borne encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2682', 'A848', 'Other tick-borne viral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2683', 'A8481', 'Powassan virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2684', 'A8489', 'Other tick-borne viral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2685', 'A849', 'Tick-borne viral encephalitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2686', 'A850', 'Enteroviral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2687', 'A851', 'Adenoviral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2688', 'A852', 'Arthropod-borne viral encephalitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2689', 'A858', 'Other specified viral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2690', 'A86', 'Unspecified viral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2691', 'A870', 'Enteroviral meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2692', 'A871', 'Adenoviral meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2693', 'A872', 'Lymphocytic choriomeningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2694', 'A878', 'Other viral meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2695', 'A879', 'Viral meningitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2696', 'A880', 'Enteroviral exanthematous fever [Boston exanthem]', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2697', 'A881', 'Epidemic vertigo', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2698', 'A888', 'Other specified viral infections of central nervous system', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2699', 'A89', 'Unspecified viral infection of central nervous system', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2700', 'A90', 'Dengue fever [classical dengue]', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2701', 'A91', 'Dengue hemorrhagic fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2702', 'A920', 'Chikungunya virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2703', 'A921', 'O\'nyong-nyong fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2704', 'A922', 'Venezuelan equine fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2705', 'A9230', 'West Nile virus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2706', 'A9231', 'West Nile virus infection with encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2707', 'A9232', 'West Nile virus infection with oth neurologic manifestation', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2708', 'A9239', 'West Nile virus infection with other complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2709', 'A924', 'Rift Valley fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2710', 'A925', 'Zika virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2711', 'A928', 'Other specified mosquito-borne viral fevers', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2712', 'A929', 'Mosquito-borne viral fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2713', 'A930', 'Oropouche virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2714', 'A931', 'Sandfly fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2715', 'A932', 'Colorado tick fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2716', 'A938', 'Other specified arthropod-borne viral fevers', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2717', 'A94', 'Unspecified arthropod-borne viral fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2718', 'A950', 'Sylvatic yellow fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2719', 'A951', 'Urban yellow fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2720', 'A959', 'Yellow fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2721', 'A960', 'Junin hemorrhagic fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2722', 'A961', 'Machupo hemorrhagic fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2723', 'A962', 'Lassa fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2724', 'A968', 'Other arenaviral hemorrhagic fevers', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2725', 'A969', 'Arenaviral hemorrhagic fever, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2726', 'A980', 'Crimean-Congo hemorrhagic fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2727', 'A981', 'Omsk hemorrhagic fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2728', 'A982', 'Kyasanur Forest disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2729', 'A983', 'Marburg virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2730', 'A984', 'Ebola virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2731', 'A985', 'Hemorrhagic fever with renal syndrome', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2732', 'A988', 'Other specified viral hemorrhagic fevers', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2733', 'A99', 'Unspecified viral hemorrhagic fever', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2734', 'B000', 'Eczema herpeticum', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2735', 'B001', 'Herpesviral vesicular dermatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2736', 'B002', 'Herpesviral gingivostomatitis and pharyngotonsillitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2737', 'B003', 'Herpesviral meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2738', 'B004', 'Herpesviral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2739', 'B0050', 'Herpesviral ocular disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2740', 'B0051', 'Herpesviral iridocyclitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2741', 'B0052', 'Herpesviral keratitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2742', 'B0053', 'Herpesviral conjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2743', 'B0059', 'Other herpesviral disease of eye', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2744', 'B007', 'Disseminated herpesviral disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2745', 'B0081', 'Herpesviral hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2746', 'B0082', 'Herpes simplex myelitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2747', 'B0089', 'Other herpesviral infection', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2748', 'B009', 'Herpesviral infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2749', 'B010', 'Varicella meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2750', 'B0111', 'Varicella encephalitis and encephalomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2751', 'B0112', 'Varicella myelitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2752', 'B012', 'Varicella pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2753', 'B0181', 'Varicella keratitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2754', 'B0189', 'Other varicella complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2755', 'B019', 'Varicella without complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2756', 'B020', 'Zoster encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2757', 'B021', 'Zoster meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2758', 'B0221', 'Postherpetic geniculate ganglionitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2759', 'B0222', 'Postherpetic trigeminal neuralgia', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2760', 'B0223', 'Postherpetic polyneuropathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2761', 'B0224', 'Postherpetic myelitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2762', 'B0229', 'Other postherpetic nervous system involvement', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2763', 'B0230', 'Zoster ocular disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2764', 'B0231', 'Zoster conjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2765', 'B0232', 'Zoster iridocyclitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2766', 'B0233', 'Zoster keratitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2767', 'B0234', 'Zoster scleritis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2768', 'B0239', 'Other herpes zoster eye disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2769', 'B027', 'Disseminated zoster', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2770', 'B028', 'Zoster with other complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2771', 'B029', 'Zoster without complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2772', 'B03', 'Smallpox', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2773', 'B04', 'Monkeypox', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2774', 'B050', 'Measles complicated by encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2775', 'B051', 'Measles complicated by meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2776', 'B052', 'Measles complicated by pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2777', 'B053', 'Measles complicated by otitis media', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2778', 'B054', 'Measles with intestinal complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2779', 'B0581', 'Measles keratitis and keratoconjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2780', 'B0589', 'Other measles complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2781', 'B059', 'Measles without complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2782', 'B0600', 'Rubella with neurological complication, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2783', 'B0601', 'Rubella encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2784', 'B0602', 'Rubella meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2785', 'B0609', 'Other neurological complications of rubella', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2786', 'B0681', 'Rubella pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2787', 'B0682', 'Rubella arthritis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2788', 'B0689', 'Other rubella complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2789', 'B069', 'Rubella without complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2790', 'B070', 'Plantar wart', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2791', 'B078', 'Other viral warts', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2792', 'B079', 'Viral wart, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2793', 'B08010', 'Cowpox', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2794', 'B08011', 'Vaccinia not from vaccine', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2795', 'B0802', 'Orf virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2796', 'B0803', 'Pseudocowpox [milker\'s node]', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2797', 'B0804', 'Paravaccinia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2798', 'B0809', 'Other orthopoxvirus infections', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2799', 'B081', 'Molluscum contagiosum', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2800', 'B0820', 'Exanthema subitum [sixth disease], unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2801', 'B0821', 'Exanthema subitum [sixth disease] due to human herpesvirus 6', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2802', 'B0822', 'Exanthema subitum [sixth disease] due to human herpesvirus 7', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2803', 'B083', 'Erythema infectiosum [fifth disease]', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2804', 'B084', 'Enteroviral vesicular stomatitis with exanthem', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2805', 'B085', 'Enteroviral vesicular pharyngitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2806', 'B0860', 'Parapoxvirus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2807', 'B0861', 'Bovine stomatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2808', 'B0862', 'Sealpox', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2809', 'B0869', 'Other parapoxvirus infections', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2810', 'B0870', 'Yatapoxvirus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2811', 'B0871', 'Tanapox virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2812', 'B0872', 'Yaba pox virus disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2813', 'B0879', 'Other yatapoxvirus infections', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2814', 'B088', 'Oth viral infections with skin and mucous membrane lesions', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2815', 'B09', 'Unsp viral infection with skin and mucous membrane lesions', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2816', 'B1001', 'Human herpesvirus 6 encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2817', 'B1009', 'Other human herpesvirus encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2818', 'B1081', 'Human herpesvirus 6 infection', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2819', 'B1082', 'Human herpesvirus 7 infection', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2820', 'B1089', 'Other human herpesvirus infection', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2821', 'B150', 'Hepatitis A with hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2822', 'B159', 'Hepatitis A without hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2823', 'B160', 'Acute hepatitis B with delta-agent with hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2824', 'B161', 'Acute hepatitis B with delta-agent without hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2825', 'B162', 'Acute hepatitis B without delta-agent with hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2826', 'B169', 'Acute hepatitis B w/o delta-agent and without hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2827', 'B170', 'Acute delta-(super) infection of hepatitis B carrier', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2828', 'B1710', 'Acute hepatitis C without hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2829', 'B1711', 'Acute hepatitis C with hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2830', 'B172', 'Acute hepatitis E', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2831', 'B178', 'Other specified acute viral hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2832', 'B179', 'Acute viral hepatitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2833', 'B180', 'Chronic viral hepatitis B with delta-agent', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2834', 'B181', 'Chronic viral hepatitis B without delta-agent', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2835', 'B182', 'Chronic viral hepatitis C', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2836', 'B188', 'Other chronic viral hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2837', 'B189', 'Chronic viral hepatitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2838', 'B190', 'Unspecified viral hepatitis with hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2839', 'B1910', 'Unspecified viral hepatitis B without hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2840', 'B1911', 'Unspecified viral hepatitis B with hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2841', 'B1920', 'Unspecified viral hepatitis C without hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2842', 'B1921', 'Unspecified viral hepatitis C with hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2843', 'B199', 'Unspecified viral hepatitis without hepatic coma', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2844', 'B20', 'Human immunodeficiency virus [HIV] disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2845', 'B250', 'Cytomegaloviral pneumonitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2846', 'B251', 'Cytomegaloviral hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2847', 'B252', 'Cytomegaloviral pancreatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2848', 'B258', 'Other cytomegaloviral diseases', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2849', 'B259', 'Cytomegaloviral disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2850', 'B260', 'Mumps orchitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2851', 'B261', 'Mumps meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2852', 'B262', 'Mumps encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2853', 'B263', 'Mumps pancreatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2854', 'B2681', 'Mumps hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2855', 'B2682', 'Mumps myocarditis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2856', 'B2683', 'Mumps nephritis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2857', 'B2684', 'Mumps polyneuropathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2858', 'B2685', 'Mumps arthritis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2859', 'B2689', 'Other mumps complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2860', 'B269', 'Mumps without complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2861', 'B2700', 'Gammaherpesviral mononucleosis without complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2862', 'B2701', 'Gammaherpesviral mononucleosis with polyneuropathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2863', 'B2702', 'Gammaherpesviral mononucleosis with meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2864', 'B2709', 'Gammaherpesviral mononucleosis with other complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2865', 'B2710', 'Cytomegaloviral mononucleosis without complications', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2866', 'B2711', 'Cytomegaloviral mononucleosis with polyneuropathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2867', 'B2712', 'Cytomegaloviral mononucleosis with meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2868', 'B2719', 'Cytomegaloviral mononucleosis with other complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2869', 'B2780', 'Other infectious mononucleosis without complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2870', 'B2781', 'Other infectious mononucleosis with polyneuropathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2871', 'B2782', 'Other infectious mononucleosis with meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2872', 'B2789', 'Other infectious mononucleosis with other complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2873', 'B2790', 'Infectious mononucleosis, unspecified without complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2874', 'B2791', 'Infectious mononucleosis, unspecified with polyneuropathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2875', 'B2792', 'Infectious mononucleosis, unspecified with meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2876', 'B2799', 'Infectious mononucleosis, unsp with other complication', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2877', 'B300', 'Keratoconjunctivitis due to adenovirus', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2878', 'B301', 'Conjunctivitis due to adenovirus', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2879', 'B302', 'Viral pharyngoconjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2880', 'B303', 'Acute epidemic hemorrhagic conjunctivitis (enteroviral)', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2881', 'B308', 'Other viral conjunctivitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2882', 'B309', 'Viral conjunctivitis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2883', 'B330', 'Epidemic myalgia', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2884', 'B331', 'Ross River disease', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2885', 'B3320', 'Viral carditis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2886', 'B3321', 'Viral endocarditis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2887', 'B3322', 'Viral myocarditis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2888', 'B3323', 'Viral pericarditis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2889', 'B3324', 'Viral cardiomyopathy', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2890', 'B333', 'Retrovirus infections, not elsewhere classified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2891', 'B334', 'Hantavirus (cardio)-pulmonary syndrome [HPS] [HCPS]', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2892', 'B338', 'Other specified viral diseases', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2893', 'B340', 'Adenovirus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2894', 'B341', 'Enterovirus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2895', 'B342', 'Coronavirus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2896', 'B343', 'Parvovirus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2897', 'B344', 'Papovavirus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2898', 'B348', 'Other viral infections of unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2899', 'B349', 'Viral infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2900', 'B350', 'Tinea barbae and tinea capitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2901', 'B351', 'Tinea unguium', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2902', 'B352', 'Tinea manuum', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2903', 'B353', 'Tinea pedis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2904', 'B354', 'Tinea corporis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2905', 'B355', 'Tinea imbricata', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2906', 'B356', 'Tinea cruris', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2907', 'B358', 'Other dermatophytoses', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2908', 'B359', 'Dermatophytosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2909', 'B360', 'Pityriasis versicolor', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2910', 'B361', 'Tinea nigra', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2911', 'B362', 'White piedra', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2912', 'B363', 'Black piedra', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2913', 'B368', 'Other specified superficial mycoses', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2914', 'B369', 'Superficial mycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2915', 'B370', 'Candidal stomatitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2916', 'B371', 'Pulmonary candidiasis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2917', 'B372', 'Candidiasis of skin and nail', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2918', 'B373', 'Candidiasis of vulva and vagina', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2919', 'B3731', 'Acute candidiasis of vulva and vagina', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2920', 'B3732', 'Chronic candidiasis of vulva and vagina', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2921', 'B3741', 'Candidal cystitis and urethritis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2922', 'B3742', 'Candidal balanitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2923', 'B3749', 'Other urogenital candidiasis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2924', 'B375', 'Candidal meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2925', 'B376', 'Candidal endocarditis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2926', 'B377', 'Candidal sepsis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2927', 'B3781', 'Candidal esophagitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2928', 'B3782', 'Candidal enteritis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2929', 'B3783', 'Candidal cheilitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2930', 'B3784', 'Candidal otitis externa', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2931', 'B3789', 'Other sites of candidiasis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2932', 'B379', 'Candidiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2933', 'B380', 'Acute pulmonary coccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2934', 'B381', 'Chronic pulmonary coccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2935', 'B382', 'Pulmonary coccidioidomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2936', 'B383', 'Cutaneous coccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2937', 'B384', 'Coccidioidomycosis meningitis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2938', 'B387', 'Disseminated coccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2939', 'B3881', 'Prostatic coccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2940', 'B3889', 'Other forms of coccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2941', 'B389', 'Coccidioidomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2942', 'B390', 'Acute pulmonary histoplasmosis capsulati', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2943', 'B391', 'Chronic pulmonary histoplasmosis capsulati', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2944', 'B392', 'Pulmonary histoplasmosis capsulati, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2945', 'B393', 'Disseminated histoplasmosis capsulati', NULL, NULL, '1', '1', '2025-01-16 19:51:59', NULL, NULL),
('2946', 'B394', 'Histoplasmosis capsulati, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2947', 'B395', 'Histoplasmosis duboisii', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2948', 'B399', 'Histoplasmosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2949', 'B400', 'Acute pulmonary blastomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2950', 'B401', 'Chronic pulmonary blastomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2951', 'B402', 'Pulmonary blastomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2952', 'B403', 'Cutaneous blastomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2953', 'B407', 'Disseminated blastomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2954', 'B4081', 'Blastomycotic meningoencephalitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2955', 'B4089', 'Other forms of blastomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2956', 'B409', 'Blastomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2957', 'B410', 'Pulmonary paracoccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2958', 'B417', 'Disseminated paracoccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2959', 'B418', 'Other forms of paracoccidioidomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2960', 'B419', 'Paracoccidioidomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2961', 'B420', 'Pulmonary sporotrichosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2962', 'B421', 'Lymphocutaneous sporotrichosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2963', 'B427', 'Disseminated sporotrichosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2964', 'B4281', 'Cerebral sporotrichosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2965', 'B4282', 'Sporotrichosis arthritis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2966', 'B4289', 'Other forms of sporotrichosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2967', 'B429', 'Sporotrichosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2968', 'B430', 'Cutaneous chromomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2969', 'B431', 'Pheomycotic brain abscess', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2970', 'B432', 'Subcutaneous pheomycotic abscess and cyst', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2971', 'B438', 'Other forms of chromomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2972', 'B439', 'Chromomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2973', 'B440', 'Invasive pulmonary aspergillosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2974', 'B441', 'Other pulmonary aspergillosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2975', 'B442', 'Tonsillar aspergillosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2976', 'B447', 'Disseminated aspergillosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2977', 'B4481', 'Allergic bronchopulmonary aspergillosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2978', 'B4489', 'Other forms of aspergillosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2979', 'B449', 'Aspergillosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2980', 'B450', 'Pulmonary cryptococcosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2981', 'B451', 'Cerebral cryptococcosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2982', 'B452', 'Cutaneous cryptococcosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2983', 'B453', 'Osseous cryptococcosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2984', 'B457', 'Disseminated cryptococcosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2985', 'B458', 'Other forms of cryptococcosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2986', 'B459', 'Cryptococcosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2987', 'B460', 'Pulmonary mucormycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2988', 'B461', 'Rhinocerebral mucormycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2989', 'B462', 'Gastrointestinal mucormycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2990', 'B463', 'Cutaneous mucormycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2991', 'B464', 'Disseminated mucormycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2992', 'B465', 'Mucormycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2993', 'B468', 'Other zygomycoses', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2994', 'B469', 'Zygomycosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2995', 'B470', 'Eumycetoma', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2996', 'B471', 'Actinomycetoma', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2997', 'B479', 'Mycetoma, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2998', 'B480', 'Lobomycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('2999', 'B481', 'Rhinosporidiosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3000', 'B482', 'Allescheriasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3001', 'B483', 'Geotrichosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3002', 'B484', 'Penicillosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3003', 'B488', 'Other specified mycoses', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3004', 'B49', 'Unspecified mycosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3005', 'B500', 'Plasmodium falciparum malaria with cerebral complications', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3006', 'B508', 'Other severe and complicated Plasmodium falciparum malaria', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3007', 'B509', 'Plasmodium falciparum malaria, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3008', 'B510', 'Plasmodium vivax malaria with rupture of spleen', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3009', 'B518', 'Plasmodium vivax malaria with other complications', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3010', 'B519', 'Plasmodium vivax malaria without complication', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3011', 'B520', 'Plasmodium malariae malaria with nephropathy', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3012', 'B528', 'Plasmodium malariae malaria with other complications', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3013', 'B529', 'Plasmodium malariae malaria without complication', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3014', 'B530', 'Plasmodium ovale malaria', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3015', 'B531', 'Malaria due to simian plasmodia', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3016', 'B538', 'Other malaria, not elsewhere classified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3017', 'B54', 'Unspecified malaria', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3018', 'B550', 'Visceral leishmaniasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3019', 'B551', 'Cutaneous leishmaniasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3020', 'B552', 'Mucocutaneous leishmaniasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3021', 'B559', 'Leishmaniasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3022', 'B560', 'Gambiense trypanosomiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3023', 'B561', 'Rhodesiense trypanosomiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3024', 'B569', 'African trypanosomiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3025', 'B570', 'Acute Chagas\' disease with heart involvement', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3026', 'B571', 'Acute Chagas\' disease without heart involvement', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3027', 'B572', 'Chagas\' disease (chronic) with heart involvement', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3028', 'B5730', 'Chagas\' disease with digestive system involvement, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3029', 'B5731', 'Megaesophagus in Chagas\' disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3030', 'B5732', 'Megacolon in Chagas\' disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3031', 'B5739', 'Other digestive system involvement in Chagas\' disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3032', 'B5740', 'Chagas\' disease with nervous system involvement, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3033', 'B5741', 'Meningitis in Chagas\' disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3034', 'B5742', 'Meningoencephalitis in Chagas\' disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3035', 'B5749', 'Other nervous system involvement in Chagas\' disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3036', 'B575', 'Chagas\' disease (chronic) with other organ involvement', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3037', 'B5800', 'Toxoplasma oculopathy, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3038', 'B5801', 'Toxoplasma chorioretinitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3039', 'B5809', 'Other toxoplasma oculopathy', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3040', 'B581', 'Toxoplasma hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3041', 'B582', 'Toxoplasma meningoencephalitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3042', 'B583', 'Pulmonary toxoplasmosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3043', 'B5881', 'Toxoplasma myocarditis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3044', 'B5882', 'Toxoplasma myositis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3045', 'B5883', 'Toxoplasma tubulo-interstitial nephropathy', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3046', 'B5889', 'Toxoplasmosis with other organ involvement', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3047', 'B589', 'Toxoplasmosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3048', 'B59', 'Pneumocystosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3049', 'B600', 'Babesiosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3050', 'B6000', 'Babesiosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3051', 'B6001', 'Babesiosis due to Babesia microti', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3052', 'B6002', 'Babesiosis due to Babesia duncani', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3053', 'B6003', 'Babesiosis due to Babesia divergens', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3054', 'B6009', 'Other babesiosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3055', 'B6010', 'Acanthamebiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3056', 'B6011', 'Meningoencephalitis due to Acanthamoeba (culbertsoni)', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3057', 'B6012', 'Conjunctivitis due to Acanthamoeba', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3058', 'B6013', 'Keratoconjunctivitis due to Acanthamoeba', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3059', 'B6019', 'Other acanthamebic disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3060', 'B602', 'Naegleriasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3061', 'B608', 'Other specified protozoal diseases', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3062', 'B64', 'Unspecified protozoal disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3063', 'B650', 'Schistosomiasis due to Schistosoma haematobium', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3064', 'B651', 'Schistosomiasis due to Schistosoma mansoni', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3065', 'B652', 'Schistosomiasis due to Schistosoma japonicum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3066', 'B653', 'Cercarial dermatitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3067', 'B658', 'Other schistosomiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3068', 'B659', 'Schistosomiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3069', 'B660', 'Opisthorchiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3070', 'B661', 'Clonorchiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3071', 'B662', 'Dicroceliasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3072', 'B663', 'Fascioliasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3073', 'B664', 'Paragonimiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3074', 'B665', 'Fasciolopsiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3075', 'B668', 'Other specified fluke infections', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3076', 'B669', 'Fluke infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3077', 'B670', 'Echinococcus granulosus infection of liver', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3078', 'B671', 'Echinococcus granulosus infection of lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3079', 'B672', 'Echinococcus granulosus infection of bone', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3080', 'B6731', 'Echinococcus granulosus infection, thyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3081', 'B6732', 'Echinococcus granulosus infection, multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3082', 'B6739', 'Echinococcus granulosus infection, other sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3083', 'B674', 'Echinococcus granulosus infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3084', 'B675', 'Echinococcus multilocularis infection of liver', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3085', 'B6761', 'Echinococcus multilocularis infection, multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3086', 'B6769', 'Echinococcus multilocularis infection, other sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3087', 'B677', 'Echinococcus multilocularis infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3088', 'B678', 'Echinococcosis, unspecified, of liver', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3089', 'B6790', 'Echinococcosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3090', 'B6799', 'Other echinococcosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3091', 'B680', 'Taenia solium taeniasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3092', 'B681', 'Taenia saginata taeniasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3093', 'B689', 'Taeniasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3094', 'B690', 'Cysticercosis of central nervous system', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3095', 'B691', 'Cysticercosis of eye', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3096', 'B6981', 'Myositis in cysticercosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3097', 'B6989', 'Cysticercosis of other sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3098', 'B699', 'Cysticercosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3099', 'B700', 'Diphyllobothriasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3100', 'B701', 'Sparganosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3101', 'B710', 'Hymenolepiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3102', 'B711', 'Dipylidiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3103', 'B718', 'Other specified cestode infections', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3104', 'B719', 'Cestode infection, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3105', 'B72', 'Dracunculiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3106', 'B7300', 'Onchocerciasis with eye involvement, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3107', 'B7301', 'Onchocerciasis with endophthalmitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3108', 'B7302', 'Onchocerciasis with glaucoma', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3109', 'B7309', 'Onchocerciasis with other eye involvement', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3110', 'B731', 'Onchocerciasis without eye disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3111', 'B740', 'Filariasis due to Wuchereria bancrofti', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3112', 'B741', 'Filariasis due to Brugia malayi', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3113', 'B742', 'Filariasis due to Brugia timori', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3114', 'B743', 'Loiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3115', 'B744', 'Mansonelliasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3116', 'B748', 'Other filariases', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3117', 'B749', 'Filariasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3118', 'B75', 'Trichinellosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3119', 'B760', 'Ancylostomiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3120', 'B761', 'Necatoriasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3121', 'B768', 'Other hookworm diseases', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3122', 'B769', 'Hookworm disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3123', 'B770', 'Ascariasis with intestinal complications', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3124', 'B7781', 'Ascariasis pneumonia', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3125', 'B7789', 'Ascariasis with other complications', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3126', 'B779', 'Ascariasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3127', 'B780', 'Intestinal strongyloidiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3128', 'B781', 'Cutaneous strongyloidiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3129', 'B787', 'Disseminated strongyloidiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3130', 'B789', 'Strongyloidiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3131', 'B79', 'Trichuriasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3132', 'B80', 'Enterobiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3133', 'B810', 'Anisakiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3134', 'B811', 'Intestinal capillariasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3135', 'B812', 'Trichostrongyliasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3136', 'B813', 'Intestinal angiostrongyliasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3137', 'B814', 'Mixed intestinal helminthiases', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3138', 'B818', 'Other specified intestinal helminthiases', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3139', 'B820', 'Intestinal helminthiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3140', 'B829', 'Intestinal parasitism, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3141', 'B830', 'Visceral larva migrans', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3142', 'B831', 'Gnathostomiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3143', 'B832', 'Angiostrongyliasis due to Parastrongylus cantonensis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3144', 'B833', 'Syngamiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3145', 'B834', 'Internal hirudiniasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3146', 'B838', 'Other specified helminthiases', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3147', 'B839', 'Helminthiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3148', 'B850', 'Pediculosis due to Pediculus humanus capitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3149', 'B851', 'Pediculosis due to Pediculus humanus corporis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3150', 'B852', 'Pediculosis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3151', 'B853', 'Phthiriasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3152', 'B854', 'Mixed pediculosis and phthiriasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3153', 'B86', 'Scabies', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3154', 'B870', 'Cutaneous myiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3155', 'B871', 'Wound myiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3156', 'B872', 'Ocular myiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3157', 'B873', 'Nasopharyngeal myiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3158', 'B874', 'Aural myiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3159', 'B8781', 'Genitourinary myiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3160', 'B8782', 'Intestinal myiasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3161', 'B8789', 'Myiasis of other sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3162', 'B879', 'Myiasis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3163', 'B880', 'Other acariasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3164', 'B881', 'Tungiasis [sandflea infestation]', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3165', 'B882', 'Other arthropod infestations', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3166', 'B883', 'External hirudiniasis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3167', 'B888', 'Other specified infestations', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3168', 'B889', 'Infestation, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3169', 'B89', 'Unspecified parasitic disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3170', 'B900', 'Sequelae of central nervous system tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3171', 'B901', 'Sequelae of genitourinary tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3172', 'B902', 'Sequelae of tuberculosis of bones and joints', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3173', 'B908', 'Sequelae of tuberculosis of other organs', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3174', 'B909', 'Sequelae of respiratory and unspecified tuberculosis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3175', 'B91', 'Sequelae of poliomyelitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3176', 'B92', 'Sequelae of leprosy', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3177', 'B940', 'Sequelae of trachoma', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3178', 'B941', 'Sequelae of viral encephalitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3179', 'B942', 'Sequelae of viral hepatitis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3180', 'B948', 'Sequelae of oth infectious and parasitic diseases', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3181', 'B949', 'Sequelae of unspecified infectious and parasitic disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3182', 'B950', 'Streptococcus, group A, causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3183', 'B951', 'Streptococcus, group B, causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3184', 'B952', 'Enterococcus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3185', 'B953', 'Streptococcus pneumoniae causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3186', 'B954', 'Oth streptococcus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3187', 'B955', 'Unsp streptococcus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3188', 'B9561', 'Methicillin suscep staph infct causing dis classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3189', 'B9562', 'Methicillin resis staph infct causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3190', 'B957', 'Oth staphylococcus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3191', 'B958', 'Unsp staphylococcus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3192', 'B960', 'Mycoplasma pneumoniae as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3193', 'B961', 'Klebsiella pneumoniae as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3194', 'B9620', 'Unsp Escherichia coli as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3195', 'B9621', 'Shig tox E coli [STEC] O157 causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3196', 'B9622', 'Oth shiga toxin E coli [STEC] causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3197', 'B9623', 'Unsp shig tox E coli [STEC] causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3198', 'B9629', 'Oth Escherichia coli as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3199', 'B963', 'Hemophilus influenzae as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3200', 'B964', 'Proteus (mirabilis) (morganii) causing dis classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3201', 'B965', 'Pseudomonas (mallei) causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3202', 'B966', 'Bacteroides fragilis as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3203', 'B967', 'Clostridium perfringens causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3204', 'B9681', 'Helicobacter pylori as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3205', 'B9682', 'Vibrio vulnificus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3206', 'B9683', 'Acinetobacter baumannii causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3207', 'B9689', 'Oth bacterial agents as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3208', 'B970', 'Adenovirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3209', 'B9710', 'Unsp enterovirus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3210', 'B9711', 'Coxsackievirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3211', 'B9712', 'Echovirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3212', 'B9719', 'Oth enterovirus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3213', 'B9721', 'SARS-associated coronavirus causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3214', 'B9729', 'Oth coronavirus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3215', 'B9730', 'Unsp retrovirus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3216', 'B9731', 'Lentivirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3217', 'B9732', 'Oncovirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3218', 'B9733', 'HTLV-I as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3219', 'B9734', 'HTLV-II as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3220', 'B9735', 'HIV 2 as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3221', 'B9739', 'Oth retrovirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3222', 'B974', 'Respiratory syncytial virus causing diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3223', 'B975', 'Reovirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3224', 'B976', 'Parvovirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3225', 'B977', 'Papillomavirus as the cause of diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3226', 'B9781', 'Human metapneumovirus as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3227', 'B9789', 'Oth viral agents as the cause of diseases classd elswhr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3228', 'B998', 'Other infectious disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3229', 'B999', 'Unspecified infectious disease', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3230', 'C000', 'Malignant neoplasm of external upper lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3231', 'C001', 'Malignant neoplasm of external lower lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3232', 'C002', 'Malignant neoplasm of external lip, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3233', 'C003', 'Malignant neoplasm of upper lip, inner aspect', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3234', 'C004', 'Malignant neoplasm of lower lip, inner aspect', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3235', 'C005', 'Malignant neoplasm of lip, unspecified, inner aspect', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3236', 'C006', 'Malignant neoplasm of commissure of lip, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3237', 'C008', 'Malignant neoplasm of overlapping sites of lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3238', 'C009', 'Malignant neoplasm of lip, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3239', 'C01', 'Malignant neoplasm of base of tongue', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3240', 'C020', 'Malignant neoplasm of dorsal surface of tongue', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3241', 'C021', 'Malignant neoplasm of border of tongue', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3242', 'C022', 'Malignant neoplasm of ventral surface of tongue', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3243', 'C023', 'Malig neoplasm of anterior two-thirds of tongue, part unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3244', 'C024', 'Malignant neoplasm of lingual tonsil', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3245', 'C028', 'Malignant neoplasm of overlapping sites of tongue', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3246', 'C029', 'Malignant neoplasm of tongue, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3247', 'C030', 'Malignant neoplasm of upper gum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3248', 'C031', 'Malignant neoplasm of lower gum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3249', 'C039', 'Malignant neoplasm of gum, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3250', 'C040', 'Malignant neoplasm of anterior floor of mouth', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3251', 'C041', 'Malignant neoplasm of lateral floor of mouth', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3252', 'C048', 'Malignant neoplasm of overlapping sites of floor of mouth', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3253', 'C049', 'Malignant neoplasm of floor of mouth, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3254', 'C050', 'Malignant neoplasm of hard palate', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3255', 'C051', 'Malignant neoplasm of soft palate', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3256', 'C052', 'Malignant neoplasm of uvula', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3257', 'C058', 'Malignant neoplasm of overlapping sites of palate', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3258', 'C059', 'Malignant neoplasm of palate, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3259', 'C060', 'Malignant neoplasm of cheek mucosa', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3260', 'C061', 'Malignant neoplasm of vestibule of mouth', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3261', 'C062', 'Malignant neoplasm of retromolar area', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3262', 'C0680', 'Malignant neoplasm of ovrlp sites of unsp parts of mouth', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3263', 'C0689', 'Malignant neoplasm of overlapping sites of oth prt mouth', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3264', 'C069', 'Malignant neoplasm of mouth, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3265', 'C07', 'Malignant neoplasm of parotid gland', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3266', 'C080', 'Malignant neoplasm of submandibular gland', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3267', 'C081', 'Malignant neoplasm of sublingual gland', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3268', 'C089', 'Malignant neoplasm of major salivary gland, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3269', 'C090', 'Malignant neoplasm of tonsillar fossa', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3270', 'C091', 'Malig neoplasm of tonsillar pillar (anterior) (posterior)', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3271', 'C098', 'Malignant neoplasm of overlapping sites of tonsil', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3272', 'C099', 'Malignant neoplasm of tonsil, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3273', 'C100', 'Malignant neoplasm of vallecula', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3274', 'C101', 'Malignant neoplasm of anterior surface of epiglottis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3275', 'C102', 'Malignant neoplasm of lateral wall of oropharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3276', 'C103', 'Malignant neoplasm of posterior wall of oropharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3277', 'C104', 'Malignant neoplasm of branchial cleft', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3278', 'C108', 'Malignant neoplasm of overlapping sites of oropharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3279', 'C109', 'Malignant neoplasm of oropharynx, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3280', 'C110', 'Malignant neoplasm of superior wall of nasopharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3281', 'C111', 'Malignant neoplasm of posterior wall of nasopharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3282', 'C112', 'Malignant neoplasm of lateral wall of nasopharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3283', 'C113', 'Malignant neoplasm of anterior wall of nasopharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3284', 'C118', 'Malignant neoplasm of overlapping sites of nasopharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3285', 'C119', 'Malignant neoplasm of nasopharynx, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3286', 'C12', 'Malignant neoplasm of pyriform sinus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3287', 'C130', 'Malignant neoplasm of postcricoid region', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3288', 'C131', 'Malig neoplasm of aryepiglottic fold, hypopharyngeal aspect', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3289', 'C132', 'Malignant neoplasm of posterior wall of hypopharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3290', 'C138', 'Malignant neoplasm of overlapping sites of hypopharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3291', 'C139', 'Malignant neoplasm of hypopharynx, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3292', 'C140', 'Malignant neoplasm of pharynx, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3293', 'C142', 'Malignant neoplasm of Waldeyer\'s ring', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3294', 'C148', 'Malig neoplm of ovrlp sites of lip, oral cavity and pharynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3295', 'C153', 'Malignant neoplasm of upper third of esophagus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3296', 'C154', 'Malignant neoplasm of middle third of esophagus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3297', 'C155', 'Malignant neoplasm of lower third of esophagus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3298', 'C158', 'Malignant neoplasm of overlapping sites of esophagus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3299', 'C159', 'Malignant neoplasm of esophagus, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3300', 'C160', 'Malignant neoplasm of cardia', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3301', 'C161', 'Malignant neoplasm of fundus of stomach', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3302', 'C162', 'Malignant neoplasm of body of stomach', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3303', 'C163', 'Malignant neoplasm of pyloric antrum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3304', 'C164', 'Malignant neoplasm of pylorus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3305', 'C165', 'Malignant neoplasm of lesser curvature of stomach, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3306', 'C166', 'Malignant neoplasm of greater curvature of stomach, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3307', 'C168', 'Malignant neoplasm of overlapping sites of stomach', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3308', 'C169', 'Malignant neoplasm of stomach, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3309', 'C170', 'Malignant neoplasm of duodenum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3310', 'C171', 'Malignant neoplasm of jejunum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3311', 'C172', 'Malignant neoplasm of ileum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3312', 'C173', 'Meckel\'s diverticulum, malignant', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3313', 'C178', 'Malignant neoplasm of overlapping sites of small intestine', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3314', 'C179', 'Malignant neoplasm of small intestine, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3315', 'C180', 'Malignant neoplasm of cecum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3316', 'C181', 'Malignant neoplasm of appendix', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3317', 'C182', 'Malignant neoplasm of ascending colon', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3318', 'C183', 'Malignant neoplasm of hepatic flexure', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3319', 'C184', 'Malignant neoplasm of transverse colon', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3320', 'C185', 'Malignant neoplasm of splenic flexure', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3321', 'C186', 'Malignant neoplasm of descending colon', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3322', 'C187', 'Malignant neoplasm of sigmoid colon', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3323', 'C188', 'Malignant neoplasm of overlapping sites of colon', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3324', 'C189', 'Malignant neoplasm of colon, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3325', 'C19', 'Malignant neoplasm of rectosigmoid junction', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3326', 'C20', 'Malignant neoplasm of rectum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3327', 'C210', 'Malignant neoplasm of anus, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3328', 'C211', 'Malignant neoplasm of anal canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3329', 'C212', 'Malignant neoplasm of cloacogenic zone', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3330', 'C218', 'Malig neoplasm of ovrlp sites of rectum, anus and anal canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3331', 'C220', 'Liver cell carcinoma', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3332', 'C221', 'Intrahepatic bile duct carcinoma', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3333', 'C222', 'Hepatoblastoma', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3334', 'C223', 'Angiosarcoma of liver', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3335', 'C224', 'Other sarcomas of liver', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3336', 'C227', 'Other specified carcinomas of liver', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3337', 'C228', 'Malignant neoplasm of liver, primary, unspecified as to type', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3338', 'C229', 'Malig neoplasm of liver, not specified as primary or sec', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3339', 'C23', 'Malignant neoplasm of gallbladder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3340', 'C240', 'Malignant neoplasm of extrahepatic bile duct', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3341', 'C241', 'Malignant neoplasm of ampulla of Vater', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3342', 'C248', 'Malignant neoplasm of overlapping sites of biliary tract', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3343', 'C249', 'Malignant neoplasm of biliary tract, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3344', 'C250', 'Malignant neoplasm of head of pancreas', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3345', 'C251', 'Malignant neoplasm of body of pancreas', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3346', 'C252', 'Malignant neoplasm of tail of pancreas', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3347', 'C253', 'Malignant neoplasm of pancreatic duct', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3348', 'C254', 'Malignant neoplasm of endocrine pancreas', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3349', 'C257', 'Malignant neoplasm of other parts of pancreas', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3350', 'C258', 'Malignant neoplasm of overlapping sites of pancreas', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3351', 'C259', 'Malignant neoplasm of pancreas, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3352', 'C260', 'Malignant neoplasm of intestinal tract, part unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3353', 'C261', 'Malignant neoplasm of spleen', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3354', 'C269', 'Malignant neoplasm of ill-defined sites within the dgstv sys', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3355', 'C300', 'Malignant neoplasm of nasal cavity', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3356', 'C301', 'Malignant neoplasm of middle ear', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3357', 'C310', 'Malignant neoplasm of maxillary sinus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3358', 'C311', 'Malignant neoplasm of ethmoidal sinus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3359', 'C312', 'Malignant neoplasm of frontal sinus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3360', 'C313', 'Malignant neoplasm of sphenoid sinus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3361', 'C318', 'Malignant neoplasm of overlapping sites of accessory sinuses', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3362', 'C319', 'Malignant neoplasm of accessory sinus, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3363', 'C320', 'Malignant neoplasm of glottis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3364', 'C321', 'Malignant neoplasm of supraglottis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3365', 'C322', 'Malignant neoplasm of subglottis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3366', 'C323', 'Malignant neoplasm of laryngeal cartilage', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3367', 'C328', 'Malignant neoplasm of overlapping sites of larynx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3368', 'C329', 'Malignant neoplasm of larynx, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3369', 'C33', 'Malignant neoplasm of trachea', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3370', 'C3400', 'Malignant neoplasm of unspecified main bronchus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3371', 'C3401', 'Malignant neoplasm of right main bronchus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3372', 'C3402', 'Malignant neoplasm of left main bronchus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3373', 'C3410', 'Malignant neoplasm of upper lobe, unsp bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3374', 'C3411', 'Malignant neoplasm of upper lobe, right bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3375', 'C3412', 'Malignant neoplasm of upper lobe, left bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3376', 'C342', 'Malignant neoplasm of middle lobe, bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3377', 'C3430', 'Malignant neoplasm of lower lobe, unsp bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3378', 'C3431', 'Malignant neoplasm of lower lobe, right bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3379', 'C3432', 'Malignant neoplasm of lower lobe, left bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3380', 'C3480', 'Malignant neoplasm of ovrlp sites of unsp bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3381', 'C3481', 'Malignant neoplasm of ovrlp sites of right bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3382', 'C3482', 'Malignant neoplasm of ovrlp sites of left bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3383', 'C3490', 'Malignant neoplasm of unsp part of unsp bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3384', 'C3491', 'Malignant neoplasm of unsp part of right bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3385', 'C3492', 'Malignant neoplasm of unsp part of left bronchus or lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3386', 'C37', 'Malignant neoplasm of thymus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3387', 'C380', 'Malignant neoplasm of heart', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3388', 'C381', 'Malignant neoplasm of anterior mediastinum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3389', 'C382', 'Malignant neoplasm of posterior mediastinum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3390', 'C383', 'Malignant neoplasm of mediastinum, part unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3391', 'C384', 'Malignant neoplasm of pleura', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3392', 'C388', 'Malig neoplm of ovrlp sites of heart, mediastinum and pleura', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3393', 'C390', 'Malignant neoplasm of upper respiratory tract, part unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3394', 'C399', 'Malignant neoplasm of lower respiratory tract, part unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3395', 'C4000', 'Malig neoplasm of scapula and long bones of unsp upper limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3396', 'C4001', 'Malig neoplasm of scapula and long bones of right upper limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3397', 'C4002', 'Malig neoplasm of scapula and long bones of left upper limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3398', 'C4010', 'Malignant neoplasm of short bones of unspecified upper limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3399', 'C4011', 'Malignant neoplasm of short bones of right upper limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3400', 'C4012', 'Malignant neoplasm of short bones of left upper limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3401', 'C4020', 'Malignant neoplasm of long bones of unspecified lower limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3402', 'C4021', 'Malignant neoplasm of long bones of right lower limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3403', 'C4022', 'Malignant neoplasm of long bones of left lower limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3404', 'C4030', 'Malignant neoplasm of short bones of unspecified lower limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3405', 'C4031', 'Malignant neoplasm of short bones of right lower limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3406', 'C4032', 'Malignant neoplasm of short bones of left lower limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3407', 'C4080', 'Malig neoplm of ovrlp sites of bone/artic cartl of unsp limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3408', 'C4081', 'Malig neoplm of ovrlp sites of bone/artic cartl of r limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3409', 'C4082', 'Malig neoplm of ovrlp sites of bone/artic cartl of left limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3410', 'C4090', 'Malig neoplasm of unsp bones and artic cartlg of unsp limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3411', 'C4091', 'Malig neoplasm of unsp bones and artic cartlg of right limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3412', 'C4092', 'Malig neoplasm of unsp bones and artic cartlg of left limb', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3413', 'C410', 'Malignant neoplasm of bones of skull and face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3414', 'C411', 'Malignant neoplasm of mandible', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3415', 'C412', 'Malignant neoplasm of vertebral column', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3416', 'C413', 'Malignant neoplasm of ribs, sternum and clavicle', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3417', 'C414', 'Malignant neoplasm of pelvic bones, sacrum and coccyx', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3418', 'C419', 'Malignant neoplasm of bone and articular cartilage, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3419', 'C430', 'Malignant melanoma of lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3420', 'C4310', 'Malignant melanoma of unspecified eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3421', 'C4311', 'Malignant melanoma of right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3422', 'C43111', 'Malignant melanoma of right upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3423', 'C43112', 'Malignant melanoma of right lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3424', 'C4312', 'Malignant melanoma of left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3425', 'C43121', 'Malignant melanoma of left upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3426', 'C43122', 'Malignant melanoma of left lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3427', 'C4320', 'Malignant melanoma of unsp ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3428', 'C4321', 'Malignant melanoma of right ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3429', 'C4322', 'Malignant melanoma of left ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3430', 'C4330', 'Malignant melanoma of unspecified part of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3431', 'C4331', 'Malignant melanoma of nose', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3432', 'C4339', 'Malignant melanoma of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3433', 'C434', 'Malignant melanoma of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3434', 'C4351', 'Malignant melanoma of anal skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3435', 'C4352', 'Malignant melanoma of skin of breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3436', 'C4359', 'Malignant melanoma of other part of trunk', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3437', 'C4360', 'Malignant melanoma of unsp upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3438', 'C4361', 'Malignant melanoma of right upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3439', 'C4362', 'Malignant melanoma of left upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3440', 'C4370', 'Malignant melanoma of unspecified lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3441', 'C4371', 'Malignant melanoma of right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3442', 'C4372', 'Malignant melanoma of left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3443', 'C438', 'Malignant melanoma of overlapping sites of skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3444', 'C439', 'Malignant melanoma of skin, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3445', 'C4400', 'Unspecified malignant neoplasm of skin of lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3446', 'C4401', 'Basal cell carcinoma of skin of lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3447', 'C4402', 'Squamous cell carcinoma of skin of lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3448', 'C4409', 'Other specified malignant neoplasm of skin of lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3449', 'C44101', 'Unsp malignant neoplasm skin/ unsp eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3450', 'C44102', 'Unsp malignant neoplasm skin/ right eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3451', 'C441021', 'Unsp malig neoplasm skin/ right upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3452', 'C441022', 'Unsp malig neoplasm skin/ right lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3453', 'C44109', 'Unsp malignant neoplasm skin/ left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3454', 'C441091', 'Unsp malignant neoplasm skin/ left upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3455', 'C441092', 'Unsp malignant neoplasm skin/ left lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3456', 'C44111', 'Basal cell carcinoma skin/ unsp eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3457', 'C44112', 'Basal cell carcinoma skin/ right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3458', 'C441121', 'Basal cell carcinoma skin/ right upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3459', 'C441122', 'Basal cell carcinoma skin/ right lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3460', 'C44119', 'Basal cell carcinoma skin/ left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3461', 'C441191', 'Basal cell carcinoma skin/ left upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3462', 'C441192', 'Basal cell carcinoma skin/ left lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3463', 'C44121', 'Squamous cell carcinoma skin/ unsp eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3464', 'C44122', 'Squamous cell carcinoma skin/ right eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3465', 'C441221', 'Squamous cell carcinoma skin/ r upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3466', 'C441222', 'Squamous cell carcinoma skin/ right low eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3467', 'C44129', 'Squamous cell carcinoma skin/ left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3468', 'C441291', 'Squamous cell carcinoma skin/ left upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3469', 'C441292', 'Squamous cell carcinoma skin/ left lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3470', 'C44131', 'Sebaceous cell carcinoma skin/ unsplid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3471', 'C441321', 'Sebaceous cell carcinoma skin/ r upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3472', 'C441322', 'Sebaceous cell carcinoma skin/ right low eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3473', 'C441391', 'Sebaceous cell carcinoma skin/ left upr eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3474', 'C441392', 'Sebaceous cell carcinoma skin/ left low eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3475', 'C44191', 'Oth malignant neoplasm skin/ unsp eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3476', 'C44192', 'Oth malignant neoplasm skin/ right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3477', 'C441921', 'Oth malignant neoplasm skin/ right upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3478', 'C441922', 'Oth malignant neoplasm skin/ right lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3479', 'C44199', 'Oth malignant neoplasm skin/ left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3480', 'C441991', 'Oth malignant neoplasm skin/ left upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3481', 'C441992', 'Oth malignant neoplasm skin/ left lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3482', 'C44201', 'Unsp malig neoplasm skin/ unsp ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3483', 'C44202', 'Unsp malig neoplasm skin/ right ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3484', 'C44209', 'Unsp malig neoplasm skin/ left ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3485', 'C44211', 'Basal cell carcinoma skin/ unsp ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3486', 'C44212', 'Basal cell carcinoma skin/ r ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3487', 'C44219', 'Basal cell carcinoma skin/ left ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3488', 'C44221', 'Squamous cell carcinoma skin/ unsp ear and extrn auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3489', 'C44222', 'Squamous cell carcinoma skin/ r ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3490', 'C44229', 'Squamous cell carcinoma skin/ left ear and extrn auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3491', 'C44291', 'Oth malig neoplasm skin/ unsp ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3492', 'C44292', 'Oth malig neoplasm skin/ right ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3493', 'C44299', 'Oth malig neoplasm skin/ left ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3494', 'C44300', 'Unsp malignant neoplasm of skin of unspecified part of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3495', 'C44301', 'Unspecified malignant neoplasm of skin of nose', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3496', 'C44309', 'Unsp malignant neoplasm of skin of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3497', 'C44310', 'Basal cell carcinoma of skin of unspecified parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3498', 'C44311', 'Basal cell carcinoma of skin of nose', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3499', 'C44319', 'Basal cell carcinoma of skin of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3500', 'C44320', 'Squamous cell carcinoma of skin of unspecified parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3501', 'C44321', 'Squamous cell carcinoma of skin of nose', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3502', 'C44329', 'Squamous cell carcinoma of skin of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3503', 'C44390', 'Oth malignant neoplasm of skin of unspecified parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3504', 'C44391', 'Other specified malignant neoplasm of skin of nose', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3505', 'C44399', 'Oth malignant neoplasm of skin of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3506', 'C4440', 'Unspecified malignant neoplasm of skin of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3507', 'C4441', 'Basal cell carcinoma of skin of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3508', 'C4442', 'Squamous cell carcinoma of skin of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3509', 'C4449', 'Other specified malignant neoplasm of skin of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3510', 'C44500', 'Unspecified malignant neoplasm of anal skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3511', 'C44501', 'Unspecified malignant neoplasm of skin of breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3512', 'C44509', 'Unsp malignant neoplasm of skin of other part of trunk', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3513', 'C44510', 'Basal cell carcinoma of anal skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3514', 'C44511', 'Basal cell carcinoma of skin of breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3515', 'C44519', 'Basal cell carcinoma of skin of other part of trunk', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3516', 'C44520', 'Squamous cell carcinoma of anal skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3517', 'C44521', 'Squamous cell carcinoma of skin of breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3518', 'C44529', 'Squamous cell carcinoma of skin of other part of trunk', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3519', 'C44590', 'Other specified malignant neoplasm of anal skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3520', 'C44591', 'Other specified malignant neoplasm of skin of breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3521', 'C44599', 'Oth malignant neoplasm of skin of other part of trunk', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3522', 'C44601', 'Unsp malignant neoplasm skin/ unsp upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3523', 'C44602', 'Unsp malignant neoplasm skin/ right upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3524', 'C44609', 'Unsp malignant neoplasm skin/ left upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3525', 'C44611', 'Basal cell carcinoma skin/ unsp upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3526', 'C44612', 'Basal cell carcinoma skin/ right upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3527', 'C44619', 'Basal cell carcinoma skin/ left upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3528', 'C44621', 'Squamous cell carcinoma skin/ unsp upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3529', 'C44622', 'Squamous cell carcinoma skin/ right upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3530', 'C44629', 'Squamous cell carcinoma skin/ left upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3531', 'C44691', 'Oth malignant neoplasm skin/ unsp upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3532', 'C44692', 'Oth malignant neoplasm skin/ right upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3533', 'C44699', 'Oth malignant neoplasm skin/ left upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3534', 'C44701', 'Unsp malignant neoplasm skin/ unsp lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3535', 'C44702', 'Unsp malignant neoplasm skin/ right lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3536', 'C44709', 'Unsp malignant neoplasm skin/ left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3537', 'C44711', 'Basal cell carcinoma skin/ unsp lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3538', 'C44712', 'Basal cell carcinoma skin/ right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3539', 'C44719', 'Basal cell carcinoma skin/ left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3540', 'C44721', 'Squamous cell carcinoma skin/ unsp lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3541', 'C44722', 'Squamous cell carcinoma skin/ right lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3542', 'C44729', 'Squamous cell carcinoma skin/ left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3543', 'C44791', 'Oth malignant neoplasm skin/ unsp lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3544', 'C44792', 'Oth malignant neoplasm skin/ right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3545', 'C44799', 'Oth malignant neoplasm skin/ left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3546', 'C4480', 'Unspecified malignant neoplasm of overlapping sites of skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3547', 'C4481', 'Basal cell carcinoma of overlapping sites of skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3548', 'C4482', 'Squamous cell carcinoma of overlapping sites of skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3549', 'C4489', 'Oth malignant neoplasm of overlapping sites of skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3550', 'C4490', 'Unspecified malignant neoplasm of skin, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3551', 'C4491', 'Basal cell carcinoma of skin, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3552', 'C4492', 'Squamous cell carcinoma of skin, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3553', 'C4499', 'Other specified malignant neoplasm of skin, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3554', 'C450', 'Mesothelioma of pleura', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3555', 'C451', 'Mesothelioma of peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3556', 'C452', 'Mesothelioma of pericardium', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3557', 'C457', 'Mesothelioma of other sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3558', 'C459', 'Mesothelioma, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3559', 'C460', 'Kaposi\'s sarcoma of skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3560', 'C461', 'Kaposi\'s sarcoma of soft tissue', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3561', 'C462', 'Kaposi\'s sarcoma of palate', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3562', 'C463', 'Kaposi\'s sarcoma of lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3563', 'C464', 'Kaposi\'s sarcoma of gastrointestinal sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3564', 'C4650', 'Kaposi\'s sarcoma of unspecified lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3565', 'C4651', 'Kaposi\'s sarcoma of right lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3566', 'C4652', 'Kaposi\'s sarcoma of left lung', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3567', 'C467', 'Kaposi\'s sarcoma of other sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3568', 'C469', 'Kaposi\'s sarcoma, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3569', 'C470', 'Malignant neoplasm of prph nerves of head, face and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3570', 'C4710', 'Malig neoplm of prph nerves of unsp upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3571', 'C4711', 'Malig neoplm of prph nerves of right upper limb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3572', 'C4712', 'Malig neoplm of prph nerves of left upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3573', 'C4720', 'Malig neoplasm of prph nerves of unsp lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3574', 'C4721', 'Malig neoplasm of prph nerves of right lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3575', 'C4722', 'Malig neoplasm of prph nerves of left lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3576', 'C473', 'Malignant neoplasm of peripheral nerves of thorax', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3577', 'C474', 'Malignant neoplasm of peripheral nerves of abdomen', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3578', 'C475', 'Malignant neoplasm of peripheral nerves of pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3579', 'C476', 'Malignant neoplasm of peripheral nerves of trunk, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3580', 'C478', 'Malig neoplm of ovrlp sites of prph nrv and autonm nrv sys', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3581', 'C479', 'Malig neoplasm of prph nerves and autonm nervous sys, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3582', 'C480', 'Malignant neoplasm of retroperitoneum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3583', 'C481', 'Malignant neoplasm of specified parts of peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3584', 'C482', 'Malignant neoplasm of peritoneum, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3585', 'C488', 'Malig neoplasm of ovrlp sites of retroperiton and peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3586', 'C490', 'Malig neoplm of conn and soft tissue of head, face and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3587', 'C4910', 'Malig neoplm of conn & soft tiss of unsp upr lmb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3588', 'C4911', 'Malig neoplm of conn and soft tiss of r upr limb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3589', 'C4912', 'Malig neoplm of conn and soft tiss of l upr limb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3590', 'C4920', 'Malig neoplm of conn and soft tiss of unsp low limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3591', 'C4921', 'Malig neoplm of conn and soft tiss of r low limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3592', 'C4922', 'Malig neoplm of conn and soft tiss of left low limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3593', 'C493', 'Malignant neoplasm of connective and soft tissue of thorax', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3594', 'C494', 'Malignant neoplasm of connective and soft tissue of abdomen', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3595', 'C495', 'Malignant neoplasm of connective and soft tissue of pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3596', 'C496', 'Malignant neoplasm of conn and soft tissue of trunk, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3597', 'C498', 'Malignant neoplasm of ovrlp sites of conn and soft tissue', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3598', 'C499', 'Malignant neoplasm of connective and soft tissue, unsp', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3599', 'C49A0', 'Gastrointestinal stromal tumor, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3600', 'C49A1', 'Gastrointestinal stromal tumor of esophagus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3601', 'C49A2', 'Gastrointestinal stromal tumor of stomach', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3602', 'C49A3', 'Gastrointestinal stromal tumor of small intestine', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3603', 'C49A4', 'Gastrointestinal stromal tumor of large intestine', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3604', 'C49A5', 'Gastrointestinal stromal tumor of rectum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3605', 'C49A9', 'Gastrointestinal stromal tumor of other sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3606', 'C4A0', 'Merkel cell carcinoma of lip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3607', 'C4A10', 'Merkel cell carcinoma of unsp eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3608', 'C4A11', 'Merkel cell carcinoma of right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3609', 'C4A111', 'Merkel cell carcinoma of right upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3610', 'C4A112', 'Merkel cell carcinoma of right lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3611', 'C4A12', 'Merkel cell carcinoma of left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3612', 'C4A121', 'Merkel cell carcinoma of left upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3613', 'C4A122', 'Merkel cell carcinoma of left lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3614', 'C4A20', 'Merkel cell carcinoma of unsp ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3615', 'C4A21', 'Merkel cell carcinoma of right ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3616', 'C4A22', 'Merkel cell carcinoma of left ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3617', 'C4A30', 'Merkel cell carcinoma of unspecified part of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3618', 'C4A31', 'Merkel cell carcinoma of nose', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3619', 'C4A39', 'Merkel cell carcinoma of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3620', 'C4A4', 'Merkel cell carcinoma of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3621', 'C4A51', 'Merkel cell carcinoma of anal skin', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3622', 'C4A52', 'Merkel cell carcinoma of skin of breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3623', 'C4A59', 'Merkel cell carcinoma of other part of trunk', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3624', 'C4A60', 'Merkel cell carcinoma of unsp upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3625', 'C4A61', 'Merkel cell carcinoma of right upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3626', 'C4A62', 'Merkel cell carcinoma of left upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3627', 'C4A70', 'Merkel cell carcinoma of unsp lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3628', 'C4A71', 'Merkel cell carcinoma of right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3629', 'C4A72', 'Merkel cell carcinoma of left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3630', 'C4A8', 'Merkel cell carcinoma of overlapping sites', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3631', 'C4A9', 'Merkel cell carcinoma, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3632', 'C50011', 'Malignant neoplasm of nipple and areola, right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3633', 'C50012', 'Malignant neoplasm of nipple and areola, left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3634', 'C50019', 'Malignant neoplasm of nipple and areola, unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3635', 'C50021', 'Malignant neoplasm of nipple and areola, right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3636', 'C50022', 'Malignant neoplasm of nipple and areola, left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3637', 'C50029', 'Malignant neoplasm of nipple and areola, unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3638', 'C50111', 'Malignant neoplasm of central portion of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3639', 'C50112', 'Malignant neoplasm of central portion of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3640', 'C50119', 'Malignant neoplasm of central portion of unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3641', 'C50121', 'Malignant neoplasm of central portion of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3642', 'C50122', 'Malignant neoplasm of central portion of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3643', 'C50129', 'Malignant neoplasm of central portion of unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3644', 'C50211', 'Malig neoplm of upper-inner quadrant of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3645', 'C50212', 'Malig neoplasm of upper-inner quadrant of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3646', 'C50219', 'Malig neoplasm of upper-inner quadrant of unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3647', 'C50221', 'Malig neoplasm of upper-inner quadrant of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3648', 'C50222', 'Malig neoplasm of upper-inner quadrant of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3649', 'C50229', 'Malig neoplasm of upper-inner quadrant of unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3650', 'C50311', 'Malig neoplm of lower-inner quadrant of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3651', 'C50312', 'Malig neoplasm of lower-inner quadrant of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3652', 'C50319', 'Malig neoplasm of lower-inner quadrant of unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3653', 'C50321', 'Malig neoplasm of lower-inner quadrant of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3654', 'C50322', 'Malig neoplasm of lower-inner quadrant of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3655', 'C50329', 'Malig neoplasm of lower-inner quadrant of unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3656', 'C50411', 'Malig neoplm of upper-outer quadrant of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3657', 'C50412', 'Malig neoplasm of upper-outer quadrant of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3658', 'C50419', 'Malig neoplasm of upper-outer quadrant of unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3659', 'C50421', 'Malig neoplasm of upper-outer quadrant of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3660', 'C50422', 'Malig neoplasm of upper-outer quadrant of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3661', 'C50429', 'Malig neoplasm of upper-outer quadrant of unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3662', 'C50511', 'Malig neoplm of lower-outer quadrant of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3663', 'C50512', 'Malig neoplasm of lower-outer quadrant of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3664', 'C50519', 'Malig neoplasm of lower-outer quadrant of unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3665', 'C50521', 'Malig neoplasm of lower-outer quadrant of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3666', 'C50522', 'Malig neoplasm of lower-outer quadrant of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3667', 'C50529', 'Malig neoplasm of lower-outer quadrant of unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3668', 'C50611', 'Malignant neoplasm of axillary tail of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3669', 'C50612', 'Malignant neoplasm of axillary tail of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3670', 'C50619', 'Malignant neoplasm of axillary tail of unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3671', 'C50621', 'Malignant neoplasm of axillary tail of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3672', 'C50622', 'Malignant neoplasm of axillary tail of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3673', 'C50629', 'Malignant neoplasm of axillary tail of unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3674', 'C50811', 'Malignant neoplasm of ovrlp sites of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3675', 'C50812', 'Malignant neoplasm of ovrlp sites of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3676', 'C50819', 'Malignant neoplasm of ovrlp sites of unsp female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3677', 'C50821', 'Malignant neoplasm of overlapping sites of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3678', 'C50822', 'Malignant neoplasm of overlapping sites of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3679', 'C50829', 'Malignant neoplasm of overlapping sites of unsp male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3680', 'C50911', 'Malignant neoplasm of unsp site of right female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3681', 'C50912', 'Malignant neoplasm of unspecified site of left female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3682', 'C50919', 'Malignant neoplasm of unsp site of unspecified female breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3683', 'C50921', 'Malignant neoplasm of unspecified site of right male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3684', 'C50922', 'Malignant neoplasm of unspecified site of left male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3685', 'C50929', 'Malignant neoplasm of unsp site of unspecified male breast', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3686', 'C510', 'Malignant neoplasm of labium majus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3687', 'C511', 'Malignant neoplasm of labium minus', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3688', 'C512', 'Malignant neoplasm of clitoris', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3689', 'C518', 'Malignant neoplasm of overlapping sites of vulva', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3690', 'C519', 'Malignant neoplasm of vulva, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3691', 'C52', 'Malignant neoplasm of vagina', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3692', 'C530', 'Malignant neoplasm of endocervix', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3693', 'C531', 'Malignant neoplasm of exocervix', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3694', 'C538', 'Malignant neoplasm of overlapping sites of cervix uteri', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3695', 'C539', 'Malignant neoplasm of cervix uteri, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3696', 'C540', 'Malignant neoplasm of isthmus uteri', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3697', 'C541', 'Malignant neoplasm of endometrium', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3698', 'C542', 'Malignant neoplasm of myometrium', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3699', 'C543', 'Malignant neoplasm of fundus uteri', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3700', 'C548', 'Malignant neoplasm of overlapping sites of corpus uteri', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3701', 'C549', 'Malignant neoplasm of corpus uteri, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3702', 'C55', 'Malignant neoplasm of uterus, part unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3703', 'C561', 'Malignant neoplasm of right ovary', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3704', 'C562', 'Malignant neoplasm of left ovary', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3705', 'C563', 'Malignant neoplasm of bilateral ovaries', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3706', 'C569', 'Malignant neoplasm of unspecified ovary', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3707', 'C5700', 'Malignant neoplasm of unspecified fallopian tube', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3708', 'C5701', 'Malignant neoplasm of right fallopian tube', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3709', 'C5702', 'Malignant neoplasm of left fallopian tube', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3710', 'C5710', 'Malignant neoplasm of unspecified broad ligament', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3711', 'C5711', 'Malignant neoplasm of right broad ligament', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3712', 'C5712', 'Malignant neoplasm of left broad ligament', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3713', 'C5720', 'Malignant neoplasm of unspecified round ligament', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3714', 'C5721', 'Malignant neoplasm of right round ligament', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3715', 'C5722', 'Malignant neoplasm of left round ligament', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3716', 'C573', 'Malignant neoplasm of parametrium', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3717', 'C574', 'Malignant neoplasm of uterine adnexa, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3718', 'C577', 'Malignant neoplasm of other specified female genital organs', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3719', 'C578', 'Malignant neoplasm of ovrlp sites of female genital organs', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3720', 'C579', 'Malignant neoplasm of female genital organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3721', 'C58', 'Malignant neoplasm of placenta', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3722', 'C600', 'Malignant neoplasm of prepuce', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3723', 'C601', 'Malignant neoplasm of glans penis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3724', 'C602', 'Malignant neoplasm of body of penis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3725', 'C608', 'Malignant neoplasm of overlapping sites of penis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3726', 'C609', 'Malignant neoplasm of penis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3727', 'C61', 'Malignant neoplasm of prostate', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3728', 'C6200', 'Malignant neoplasm of unspecified undescended testis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3729', 'C6201', 'Malignant neoplasm of undescended right testis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3730', 'C6202', 'Malignant neoplasm of undescended left testis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3731', 'C6210', 'Malignant neoplasm of unspecified descended testis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3732', 'C6211', 'Malignant neoplasm of descended right testis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3733', 'C6212', 'Malignant neoplasm of descended left testis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3734', 'C6290', 'Malig neoplasm of unsp testis, unsp descended or undescended', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3735', 'C6291', 'Malig neoplm of right testis, unsp descended or undescended', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3736', 'C6292', 'Malig neoplasm of left testis, unsp descended or undescended', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3737', 'C6300', 'Malignant neoplasm of unspecified epididymis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3738', 'C6301', 'Malignant neoplasm of right epididymis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3739', 'C6302', 'Malignant neoplasm of left epididymis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3740', 'C6310', 'Malignant neoplasm of unspecified spermatic cord', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3741', 'C6311', 'Malignant neoplasm of right spermatic cord', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3742', 'C6312', 'Malignant neoplasm of left spermatic cord', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3743', 'C632', 'Malignant neoplasm of scrotum', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3744', 'C637', 'Malignant neoplasm of other specified male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3745', 'C638', 'Malignant neoplasm of ovrlp sites of male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3746', 'C639', 'Malignant neoplasm of male genital organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3747', 'C641', 'Malignant neoplasm of right kidney, except renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3748', 'C642', 'Malignant neoplasm of left kidney, except renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3749', 'C649', 'Malignant neoplasm of unsp kidney, except renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3750', 'C651', 'Malignant neoplasm of right renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3751', 'C652', 'Malignant neoplasm of left renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3752', 'C659', 'Malignant neoplasm of unspecified renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3753', 'C661', 'Malignant neoplasm of right ureter', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3754', 'C662', 'Malignant neoplasm of left ureter', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3755', 'C669', 'Malignant neoplasm of unspecified ureter', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3756', 'C670', 'Malignant neoplasm of trigone of bladder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('3757', 'C671', 'Malignant neoplasm of dome of bladder', NULL, NULL, '1', '1', '2025-01-16 19:52:00', NULL, NULL),
('5156', 'C672', 'Malignant neoplasm of lateral wall of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5157', 'C673', 'Malignant neoplasm of anterior wall of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5158', 'C674', 'Malignant neoplasm of posterior wall of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5159', 'C675', 'Malignant neoplasm of bladder neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5160', 'C676', 'Malignant neoplasm of ureteric orifice', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5161', 'C677', 'Malignant neoplasm of urachus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5162', 'C678', 'Malignant neoplasm of overlapping sites of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5163', 'C679', 'Malignant neoplasm of bladder, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5164', 'C680', 'Malignant neoplasm of urethra', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5165', 'C681', 'Malignant neoplasm of paraurethral glands', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5166', 'C688', 'Malignant neoplasm of overlapping sites of urinary organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5167', 'C689', 'Malignant neoplasm of urinary organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5168', 'C6900', 'Malignant neoplasm of unspecified conjunctiva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5169', 'C6901', 'Malignant neoplasm of right conjunctiva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5170', 'C6902', 'Malignant neoplasm of left conjunctiva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5171', 'C6910', 'Malignant neoplasm of unspecified cornea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5172', 'C6911', 'Malignant neoplasm of right cornea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5173', 'C6912', 'Malignant neoplasm of left cornea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5174', 'C6920', 'Malignant neoplasm of unspecified retina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5175', 'C6921', 'Malignant neoplasm of right retina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5176', 'C6922', 'Malignant neoplasm of left retina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5177', 'C6930', 'Malignant neoplasm of unspecified choroid', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5178', 'C6931', 'Malignant neoplasm of right choroid', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5179', 'C6932', 'Malignant neoplasm of left choroid', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5180', 'C6940', 'Malignant neoplasm of unspecified ciliary body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5181', 'C6941', 'Malignant neoplasm of right ciliary body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5182', 'C6942', 'Malignant neoplasm of left ciliary body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5183', 'C6950', 'Malignant neoplasm of unspecified lacrimal gland and duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5184', 'C6951', 'Malignant neoplasm of right lacrimal gland and duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5185', 'C6952', 'Malignant neoplasm of left lacrimal gland and duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5186', 'C6960', 'Malignant neoplasm of unspecified orbit', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5187', 'C6961', 'Malignant neoplasm of right orbit', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5188', 'C6962', 'Malignant neoplasm of left orbit', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5189', 'C6980', 'Malignant neoplasm of ovrlp sites of unsp eye and adnexa', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5190', 'C6981', 'Malignant neoplasm of ovrlp sites of right eye and adnexa', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5191', 'C6982', 'Malignant neoplasm of ovrlp sites of left eye and adnexa', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5192', 'C6990', 'Malignant neoplasm of unspecified site of unspecified eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5193', 'C6991', 'Malignant neoplasm of unspecified site of right eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5194', 'C6992', 'Malignant neoplasm of unspecified site of left eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5195', 'C700', 'Malignant neoplasm of cerebral meninges', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5196', 'C701', 'Malignant neoplasm of spinal meninges', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5197', 'C709', 'Malignant neoplasm of meninges, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5198', 'C710', 'Malignant neoplasm of cerebrum, except lobes and ventricles', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5199', 'C711', 'Malignant neoplasm of frontal lobe', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5200', 'C712', 'Malignant neoplasm of temporal lobe', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5201', 'C713', 'Malignant neoplasm of parietal lobe', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5202', 'C714', 'Malignant neoplasm of occipital lobe', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5203', 'C715', 'Malignant neoplasm of cerebral ventricle', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5204', 'C716', 'Malignant neoplasm of cerebellum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5205', 'C717', 'Malignant neoplasm of brain stem', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5206', 'C718', 'Malignant neoplasm of overlapping sites of brain', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5207', 'C719', 'Malignant neoplasm of brain, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5208', 'C720', 'Malignant neoplasm of spinal cord', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5209', 'C721', 'Malignant neoplasm of cauda equina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5210', 'C7220', 'Malignant neoplasm of unspecified olfactory nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5211', 'C7221', 'Malignant neoplasm of right olfactory nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5212', 'C7222', 'Malignant neoplasm of left olfactory nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5213', 'C7230', 'Malignant neoplasm of unspecified optic nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5214', 'C7231', 'Malignant neoplasm of right optic nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5215', 'C7232', 'Malignant neoplasm of left optic nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5216', 'C7240', 'Malignant neoplasm of unspecified acoustic nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5217', 'C7241', 'Malignant neoplasm of right acoustic nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5218', 'C7242', 'Malignant neoplasm of left acoustic nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5219', 'C7250', 'Malignant neoplasm of unspecified cranial nerve', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5220', 'C7259', 'Malignant neoplasm of other cranial nerves', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5221', 'C729', 'Malignant neoplasm of central nervous system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5222', 'C73', 'Malignant neoplasm of thyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5223', 'C7400', 'Malignant neoplasm of cortex of unspecified adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5224', 'C7401', 'Malignant neoplasm of cortex of right adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5225', 'C7402', 'Malignant neoplasm of cortex of left adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5226', 'C7410', 'Malignant neoplasm of medulla of unspecified adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5227', 'C7411', 'Malignant neoplasm of medulla of right adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5228', 'C7412', 'Malignant neoplasm of medulla of left adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5229', 'C7490', 'Malignant neoplasm of unsp part of unspecified adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5230', 'C7491', 'Malignant neoplasm of unsp part of right adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5231', 'C7492', 'Malignant neoplasm of unspecified part of left adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5232', 'C750', 'Malignant neoplasm of parathyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5233', 'C751', 'Malignant neoplasm of pituitary gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5234', 'C752', 'Malignant neoplasm of craniopharyngeal duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5235', 'C753', 'Malignant neoplasm of pineal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5236', 'C754', 'Malignant neoplasm of carotid body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5237', 'C755', 'Malignant neoplasm of aortic body and other paraganglia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5238', 'C758', 'Malignant neoplasm with pluriglandular involvement, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5239', 'C759', 'Malignant neoplasm of endocrine gland, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5240', 'C760', 'Malignant neoplasm of head, face and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5241', 'C761', 'Malignant neoplasm of thorax', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5242', 'C762', 'Malignant neoplasm of abdomen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5243', 'C763', 'Malignant neoplasm of pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5244', 'C7640', 'Malignant neoplasm of unspecified upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5245', 'C7641', 'Malignant neoplasm of right upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5246', 'C7642', 'Malignant neoplasm of left upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5247', 'C7650', 'Malignant neoplasm of unspecified lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5248', 'C7651', 'Malignant neoplasm of right lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5249', 'C7652', 'Malignant neoplasm of left lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5250', 'C768', 'Malignant neoplasm of other specified ill-defined sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5251', 'C770', 'Sec and unsp malig neoplasm of nodes of head, face and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5252', 'C771', 'Secondary and unsp malignant neoplasm of intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5253', 'C772', 'Secondary and unsp malignant neoplasm of intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5254', 'C773', 'Sec and unsp malig neoplasm of axilla and upper limb nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5255', 'C774', 'Sec and unsp malig neoplasm of inguinal and lower limb nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5256', 'C775', 'Secondary and unsp malignant neoplasm of intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5257', 'C778', 'Sec and unsp malig neoplasm of nodes of multiple regions', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5258', 'C779', 'Secondary and unsp malignant neoplasm of lymph node, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5259', 'C7800', 'Secondary malignant neoplasm of unspecified lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5260', 'C7801', 'Secondary malignant neoplasm of right lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5261', 'C7802', 'Secondary malignant neoplasm of left lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5262', 'C781', 'Secondary malignant neoplasm of mediastinum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5263', 'C782', 'Secondary malignant neoplasm of pleura', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5264', 'C7830', 'Secondary malignant neoplasm of unsp respiratory organ', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5265', 'C7839', 'Secondary malignant neoplasm of other respiratory organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5266', 'C784', 'Secondary malignant neoplasm of small intestine', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5267', 'C785', 'Secondary malignant neoplasm of large intestine and rectum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5268', 'C786', 'Secondary malignant neoplasm of retroperiton and peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5269', 'C787', 'Secondary malig neoplasm of liver and intrahepatic bile duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5270', 'C7880', 'Secondary malignant neoplasm of unspecified digestive organ', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5271', 'C7889', 'Secondary malignant neoplasm of other digestive organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5272', 'C7900', 'Secondary malignant neoplasm of unsp kidney and renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5273', 'C7901', 'Secondary malignant neoplasm of r kidney and renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5274', 'C7902', 'Secondary malignant neoplasm of left kidney and renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5275', 'C7910', 'Secondary malignant neoplasm of unspecified urinary organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5276', 'C7911', 'Secondary malignant neoplasm of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5277', 'C7919', 'Secondary malignant neoplasm of other urinary organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5278', 'C792', 'Secondary malignant neoplasm of skin', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5279', 'C7931', 'Secondary malignant neoplasm of brain', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5280', 'C7932', 'Secondary malignant neoplasm of cerebral meninges', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5281', 'C7940', 'Secondary malignant neoplasm of unsp part of nervous system', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5282', 'C7949', 'Secondary malignant neoplasm of oth parts of nervous system', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5283', 'C7951', 'Secondary malignant neoplasm of bone', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5284', 'C7952', 'Secondary malignant neoplasm of bone marrow', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5285', 'C7960', 'Secondary malignant neoplasm of unspecified ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5286', 'C7961', 'Secondary malignant neoplasm of right ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5287', 'C7962', 'Secondary malignant neoplasm of left ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5288', 'C7963', 'Secondary malignant neoplasm of bilateral ovaries', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5289', 'C7970', 'Secondary malignant neoplasm of unspecified adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5290', 'C7971', 'Secondary malignant neoplasm of right adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5291', 'C7972', 'Secondary malignant neoplasm of left adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5292', 'C7981', 'Secondary malignant neoplasm of breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5293', 'C7982', 'Secondary malignant neoplasm of genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5294', 'C7989', 'Secondary malignant neoplasm of other specified sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5295', 'C799', 'Secondary malignant neoplasm of unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5296', 'C7A00', 'Malignant carcinoid tumor of unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5297', 'C7A010', 'Malignant carcinoid tumor of the duodenum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5298', 'C7A011', 'Malignant carcinoid tumor of the jejunum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5299', 'C7A012', 'Malignant carcinoid tumor of the ileum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5300', 'C7A019', 'Malignant carcinoid tumor of the sm int, unsp portion', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5301', 'C7A020', 'Malignant carcinoid tumor of the appendix', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5302', 'C7A021', 'Malignant carcinoid tumor of the cecum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5303', 'C7A022', 'Malignant carcinoid tumor of the ascending colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5304', 'C7A023', 'Malignant carcinoid tumor of the transverse colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5305', 'C7A024', 'Malignant carcinoid tumor of the descending colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5306', 'C7A025', 'Malignant carcinoid tumor of the sigmoid colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5307', 'C7A026', 'Malignant carcinoid tumor of the rectum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5308', 'C7A029', 'Malignant carcinoid tumor of the lg int, unsp portion', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5309', 'C7A090', 'Malignant carcinoid tumor of the bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5310', 'C7A091', 'Malignant carcinoid tumor of the thymus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5311', 'C7A092', 'Malignant carcinoid tumor of the stomach', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5312', 'C7A093', 'Malignant carcinoid tumor of the kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5313', 'C7A094', 'Malignant carcinoid tumor of the foregut unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5314', 'C7A095', 'Malignant carcinoid tumor of the midgut unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5315', 'C7A096', 'Malignant carcinoid tumor of the hindgut unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5316', 'C7A098', 'Malignant carcinoid tumors of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5317', 'C7A1', 'Malignant poorly differentiated neuroendocrine tumors', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5318', 'C7A8', 'Other malignant neuroendocrine tumors', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5319', 'C7B00', 'Secondary carcinoid tumors, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5320', 'C7B01', 'Secondary carcinoid tumors of distant lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5321', 'C7B02', 'Secondary carcinoid tumors of liver', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5322', 'C7B03', 'Secondary carcinoid tumors of bone', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5323', 'C7B04', 'Secondary carcinoid tumors of peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5324', 'C7B09', 'Secondary carcinoid tumors of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5325', 'C7B1', 'Secondary Merkel cell carcinoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5326', 'C7B8', 'Other secondary neuroendocrine tumors', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5327', 'C800', 'Disseminated malignant neoplasm, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5328', 'C801', 'Malignant (primary) neoplasm, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5329', 'C802', 'Malignant neoplasm associated with transplanted organ', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5330', 'C8100', 'Nodular lymphocyte predominant Hodgkin lymphoma, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5331', 'C8101', 'Nodlr lymphocy predom Hdgkn lymph, nodes of head, face, & nk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5332', 'C8102', 'Nodular lymphocy predom Hodgkin lymphoma, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5333', 'C8103', 'Nodular lymphocyte predom Hodgkin lymphoma, intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5334', 'C8104', 'Nodlr lymphocy predom Hdgkn lymph, nodes of axla and upr lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5335', 'C8105', 'Nodlr lymphocy predom Hdgkn lymph,nodes of ing rgn & low lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5336', 'C8106', 'Nodular lymphocyte predom Hodgkin lymphoma, intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5337', 'C8107', 'Nodular lymphocyte predominant Hodgkin lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5338', 'C8108', 'Nodular lymphocyte predom Hodgkin lymphoma, nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5339', 'C8109', 'Nodlr lymphocy predom Hdgkn lymph, extrnod & solid org site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5340', 'C810A', 'Nodular lymphocyte predom Hodgkin lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5341', 'C8110', 'Nodular sclerosis Hodgkin lymphoma, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5342', 'C8111', 'Nodlr scler Hdgkn lymph, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5343', 'C8112', 'Nodular sclerosis Hodgkin lymphoma, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5344', 'C8113', 'Nodular sclerosis Hodgkin lymphoma, intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5345', 'C8114', 'Nodlr scler Hdgkn lymph, nodes of axla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5346', 'C8115', 'Nodlr scler Hdgkn lymph, nodes of ing rgn and low limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5347', 'C8116', 'Nodular sclerosis Hodgkin lymphoma, intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5348', 'C8117', 'Nodular sclerosis Hodgkin lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5349', 'C8118', 'Nodular sclerosis Hodgkin lymphoma, nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5350', 'C8119', 'Nodlr scler Hdgkn lymph, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5351', 'C811A', 'Nodular sclerosis Hodgkin lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5352', 'C8120', 'Mixed cellularity Hodgkin lymphoma, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5353', 'C8121', 'Mix cellular Hdgkn lymph, nodes of head, face, and nk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5354', 'C8122', 'Mixed cellular Hodgkin lymphoma, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5355', 'C8123', 'Mixed cellular Hodgkin lymphoma, intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5356', 'C8124', 'Mix cellular Hdgkn lymph, nodes of axla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5357', 'C8125', 'Mix cellular Hdgkn lymph, nodes of ing rgn and low lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5358', 'C8126', 'Mixed cellular Hodgkin lymphoma, intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5359', 'C8127', 'Mixed cellularity Hodgkin lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5360', 'C8128', 'Mixed cellular Hodgkin lymphoma, nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5361', 'C8129', 'Mix cellular Hdgkn lymph, extrnod and solid org sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5362', 'C812A', 'Mixed cellularity Hodgkin lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5363', 'C8130', 'Lymphocyte depleted Hodgkin lymphoma, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5364', 'C8131', 'Lymphocy deplet Hdgkn lymph, nodes of head, face, & nk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5365', 'C8132', 'Lymphocy depleted Hodgkin lymphoma, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5366', 'C8133', 'Lymphocy depleted Hodgkin lymphoma, intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5367', 'C8134', 'Lymphocy deplet Hdgkn lymph, nodes of axla and upr lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5368', 'C8135', 'Lymphocy deplet Hdgkn lymph,nodes of ing rgn & low lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5369', 'C8136', 'Lymphocy depleted Hodgkin lymphoma, intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5370', 'C8137', 'Lymphocyte depleted Hodgkin lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5371', 'C8138', 'Lymphocy depleted Hodgkin lymphoma, nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5372', 'C8139', 'Lymphocy deplet Hdgkn lymph, extrnod & solid org site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5373', 'C813A', 'Lymphocyte depleted Hodgkin lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5374', 'C8140', 'Lymphocyte-rich Hodgkin lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5375', 'C8141', 'Lymp-rich Hodgkin lymph, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5376', 'C8142', 'Lymp-rich Hodgkin lymphoma, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5377', 'C8143', 'Lymp-rich Hodgkin lymphoma, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5378', 'C8144', 'Lymp-rich Hdgkn lymph, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5379', 'C8145', 'Lymp-rich Hdgkn lymph, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5380', 'C8146', 'Lymp-rich Hodgkin lymphoma, intrapelv lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5381', 'C8147', 'Lymphocyte-rich Hodgkin lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5382', 'C8148', 'Lymp-rich Hodgkin lymphoma, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5383', 'C8149', 'Lymp-rich Hodgkin lymph, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5384', 'C814A', 'Lymphocyte-rich Hodgkin lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5385', 'C8170', 'Other Hodgkin lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5386', 'C8171', 'Oth Hodgkin lymphoma, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5387', 'C8172', 'Other Hodgkin lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5388', 'C8173', 'Oth Hodgkin lymphoma, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5389', 'C8174', 'Oth Hodgkin lymphoma, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5390', 'C8175', 'Oth Hodgkin lymph, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5391', 'C8176', 'Other Hodgkin lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5392', 'C8177', 'Other Hodgkin lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5393', 'C8178', 'Oth Hodgkin lymphoma, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5394', 'C8179', 'Oth Hodgkin lymphoma, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5395', 'C817A', 'Other Hodgkin lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5396', 'C8190', 'Hodgkin lymphoma, unspecified, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5397', 'C8191', 'Hodgkin lymphoma, unsp, lymph nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5398', 'C8192', 'Hodgkin lymphoma, unspecified, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5399', 'C8193', 'Hodgkin lymphoma, unspecified, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5400', 'C8194', 'Hodgkin lymphoma, unsp, lymph nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5401', 'C8195', 'Hodgkin lymphoma, unsp, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5402', 'C8196', 'Hodgkin lymphoma, unspecified, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5403', 'C8197', 'Hodgkin lymphoma, unspecified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5404', 'C8198', 'Hodgkin lymphoma, unspecified, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5405', 'C8199', 'Hodgkin lymphoma, unsp, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5406', 'C819A', 'Hodgkin lymphoma, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5407', 'C8200', 'Follicular lymphoma grade I, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5408', 'C8201', 'Follicular lymphoma grade I, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5409', 'C8202', 'Follicular lymphoma grade I, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5410', 'C8203', 'Follicular lymphoma grade I, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5411', 'C8204', 'Follicular lymphoma grade I, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5412', 'C8205', 'Foliclar lymph grade I, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5413', 'C8206', 'Follicular lymphoma grade I, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5414', 'C8207', 'Follicular lymphoma grade I, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5415', 'C8208', 'Follicular lymphoma grade I, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5416', 'C8209', 'Follicular lymphoma grade I, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5417', 'C820A', 'Follicular lymphoma grade I, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5418', 'C8210', 'Follicular lymphoma grade II, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5419', 'C8211', 'Follicular lymphoma grade II, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5420', 'C8212', 'Follicular lymphoma grade II, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5421', 'C8213', 'Follicular lymphoma grade II, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5422', 'C8214', 'Follicular lymphoma grade II, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5423', 'C8215', 'Foliclar lymph grade II, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5424', 'C8216', 'Follicular lymphoma grade II, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5425', 'C8217', 'Follicular lymphoma grade II, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5426', 'C8218', 'Follicular lymphoma grade II, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5427', 'C8219', 'Follicular lymphoma grade II, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5428', 'C821A', 'Follicular lymphoma grade II, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5429', 'C8220', 'Follicular lymphoma grade III, unspecified, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5430', 'C8221', 'Foliclar lymph grade III, unsp, nodes of head, face, and nk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5431', 'C8222', 'Follicular lymphoma grade III, unsp, intrathorac lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5432', 'C8223', 'Follicular lymphoma grade III, unsp, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5433', 'C8224', 'Foliclar lymph grade III, unsp, nodes of axla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5434', 'C8225', 'Foliclar lymph grade III, unsp, nodes of ing rgn and low lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5435', 'C8226', 'Follicular lymphoma grade III, unsp, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5436', 'C8227', 'Follicular lymphoma grade III, unspecified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5437', 'C8228', 'Follicular lymphoma grade III, unsp, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5438', 'C8229', 'Foliclar lymph grade III, unsp, extrnod and solid org sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5439', 'C822A', 'Follicular lymphoma grade III, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5440', 'C8230', 'Follicular lymphoma grade IIIa, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5441', 'C8231', 'Foliclar lymphoma grade IIIa, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5442', 'C8232', 'Follicular lymphoma grade IIIa, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5443', 'C8233', 'Follicular lymphoma grade IIIa, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5444', 'C8234', 'Foliclar lymphoma grade IIIa, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5445', 'C8235', 'Foliclar lymph grade IIIa, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5446', 'C8236', 'Follicular lymphoma grade IIIa, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5447', 'C8237', 'Follicular lymphoma grade IIIa, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5448', 'C8238', 'Follicular lymphoma grade IIIa, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5449', 'C8239', 'Foliclar lymphoma grade IIIa, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5450', 'C823A', 'Follicular lymphoma grade IIIa, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5451', 'C8240', 'Follicular lymphoma grade IIIb, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5452', 'C8241', 'Foliclar lymphoma grade IIIb, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5453', 'C8242', 'Follicular lymphoma grade IIIb, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5454', 'C8243', 'Follicular lymphoma grade IIIb, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5455', 'C8244', 'Foliclar lymphoma grade IIIb, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5456', 'C8245', 'Foliclar lymph grade IIIb, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5457', 'C8246', 'Follicular lymphoma grade IIIb, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5458', 'C8247', 'Follicular lymphoma grade IIIb, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5459', 'C8248', 'Follicular lymphoma grade IIIb, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5460', 'C8249', 'Foliclar lymphoma grade IIIb, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5461', 'C824A', 'Follicular lymphoma grade IIIb, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5462', 'C8250', 'Diffuse follicle center lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5463', 'C8251', 'Diffuse folicl center lymph, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5464', 'C8252', 'Diffuse follicle center lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5465', 'C8253', 'Diffuse follicle center lymphoma, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5466', 'C8254', 'Diffuse folicl center lymph, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5467', 'C8255', 'Diffus folicl cntr lymph, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5468', 'C8256', 'Diffuse follicle center lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5469', 'C8257', 'Diffuse follicle center lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5470', 'C8258', 'Diffuse follicle center lymphoma, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5471', 'C8259', 'Diffuse folicl center lymph, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5472', 'C825A', 'Diffuse follicle center lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5473', 'C8260', 'Cutaneous follicle center lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5474', 'C8261', 'Cutan folicl center lymphoma, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5475', 'C8262', 'Cutaneous follicle center lymphoma, intrathorac lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5476', 'C8263', 'Cutaneous follicle center lymphoma, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5477', 'C8264', 'Cutan folicl center lymphoma, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5478', 'C8265', 'Cutan folicl cntr lymph, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5479', 'C8266', 'Cutaneous follicle center lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5480', 'C8267', 'Cutaneous follicle center lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5481', 'C8268', 'Cutaneous follicle center lymphoma, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5482', 'C8269', 'Cutan folicl center lymphoma, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5483', 'C826A', 'Cutaneous follicle center lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5484', 'C8280', 'Other types of follicular lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5485', 'C8281', 'Oth types of foliclar lymph, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5486', 'C8282', 'Oth types of follicular lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5487', 'C8283', 'Oth types of follicular lymphoma, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5488', 'C8284', 'Oth types of foliclar lymph, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5489', 'C8285', 'Oth types of foliclar lymph, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5490', 'C8286', 'Other types of follicular lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5491', 'C8287', 'Other types of follicular lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5492', 'C8288', 'Oth types of follicular lymphoma, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5493', 'C8289', 'Oth types of foliclar lymph, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5494', 'C828A', 'Other types of follicular lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5495', 'C8290', 'Follicular lymphoma, unspecified, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5496', 'C8291', 'Follicular lymphoma, unsp, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5497', 'C8292', 'Follicular lymphoma, unspecified, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5498', 'C8293', 'Follicular lymphoma, unsp, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5499', 'C8294', 'Follicular lymphoma, unsp, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5500', 'C8295', 'Foliclar lymphoma, unsp, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5501', 'C8296', 'Follicular lymphoma, unspecified, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5502', 'C8297', 'Follicular lymphoma, unspecified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5503', 'C8298', 'Follicular lymphoma, unsp, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5504', 'C8299', 'Follicular lymphoma, unsp, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5505', 'C829A', 'Follicular lymphoma, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5506', 'C8300', 'Small cell B-cell lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5507', 'C8301', 'Small cell B-cell lymphoma, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5508', 'C8302', 'Small cell B-cell lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5509', 'C8303', 'Small cell B-cell lymphoma, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5510', 'C8304', 'Small cell B-cell lymphoma, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5511', 'C8305', 'Small cell B-cell lymph, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5512', 'C8306', 'Small cell B-cell lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5513', 'C8307', 'Small cell B-cell lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5514', 'C8308', 'Small cell B-cell lymphoma, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5515', 'C8309', 'Small cell B-cell lymphoma, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5516', 'C830A', 'Small cell B-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5517', 'C8310', 'Mantle cell lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5518', 'C8311', 'Mantle cell lymphoma, lymph nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5519', 'C8312', 'Mantle cell lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5520', 'C8313', 'Mantle cell lymphoma, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5521', 'C8314', 'Mantle cell lymphoma, lymph nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5522', 'C8315', 'Mantle cell lymphoma, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5523', 'C8316', 'Mantle cell lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5524', 'C8317', 'Mantle cell lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5525', 'C8318', 'Mantle cell lymphoma, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5526', 'C8319', 'Mantle cell lymphoma, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5527', 'C831A', 'Mantle cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5528', 'C8330', 'Diffuse large B-cell lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5529', 'C8331', 'Diffuse large B-cell lymphoma, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5530', 'C8332', 'Diffuse large B-cell lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5531', 'C8333', 'Diffuse large B-cell lymphoma, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5532', 'C8334', 'Diffuse large B-cell lymph, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5533', 'C8335', 'Diffus large B-cell lymph, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5534', 'C8336', 'Diffuse large B-cell lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5535', 'C8337', 'Diffuse large B-cell lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5536', 'C8338', 'Diffuse large B-cell lymphoma, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5537', 'C8339', 'Diffuse large B-cell lymphoma, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5538', 'C83390', 'Primary central nervous system lymphoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5539', 'C83398', 'Diffuse large B-cell lymph of extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5540', 'C833A', 'Diffuse large B-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5541', 'C8350', 'Lymphoblastic (diffuse) lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5542', 'C8351', 'Lymphoblastic lymphoma, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5543', 'C8352', 'Lymphoblastic (diffuse) lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5544', 'C8353', 'Lymphoblastic (diffuse) lymphoma, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5545', 'C8354', 'Lymphoblastic lymphoma, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5546', 'C8355', 'Lymphoblastic lymphoma, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5547', 'C8356', 'Lymphoblastic (diffuse) lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5548', 'C8357', 'Lymphoblastic (diffuse) lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5549', 'C8358', 'Lymphoblastic (diffuse) lymphoma, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5550', 'C8359', 'Lymphoblastic lymphoma, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5551', 'C835A', 'Lymphoblastic (diffuse) lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5552', 'C8370', 'Burkitt lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5553', 'C8371', 'Burkitt lymphoma, lymph nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5554', 'C8372', 'Burkitt lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5555', 'C8373', 'Burkitt lymphoma, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5556', 'C8374', 'Burkitt lymphoma, lymph nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5557', 'C8375', 'Burkitt lymphoma, nodes of inguinal region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5558', 'C8376', 'Burkitt lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5559', 'C8377', 'Burkitt lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5560', 'C8378', 'Burkitt lymphoma, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5561', 'C8379', 'Burkitt lymphoma, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5562', 'C837A', 'Burkitt lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5563', 'C8380', 'Other non-follicular lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5564', 'C8381', 'Oth non-follic lymphoma, lymph nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5565', 'C8382', 'Other non-follicular lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5566', 'C8383', 'Other non-follicular lymphoma, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5567', 'C8384', 'Oth non-follic lymphoma, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5568', 'C8385', 'Oth non-follic lymphoma, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5569', 'C8386', 'Other non-follicular lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5570', 'C8387', 'Other non-follicular lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5571', 'C8388', 'Other non-follicular lymphoma, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5572', 'C8389', 'Oth non-follic lymphoma, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5573', 'C838A', 'Other non-follicular lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5574', 'C8390', 'Non-follicular (diffuse) lymphoma, unsp, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5575', 'C8391', 'Non-follic lymphoma, unsp, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5576', 'C8392', 'Non-follic (diffuse) lymphoma, unsp, intrathorac lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5577', 'C8393', 'Non-follic (diffuse) lymphoma, unsp, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5578', 'C8394', 'Non-follic lymphoma, unsp, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5579', 'C8395', 'Non-follic lymph, unsp, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5580', 'C8396', 'Non-follic (diffuse) lymphoma, unsp, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5581', 'C8397', 'Non-follicular (diffuse) lymphoma, unspecified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5582', 'C8398', 'Non-follic (diffuse) lymphoma, unsp, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5583', 'C8399', 'Non-follic lymphoma, unsp, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5584', 'C839A', 'Non-follicular (diffuse) lymphoma, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5585', 'C8400', 'Mycosis fungoides, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5586', 'C8401', 'Mycosis fungoides, lymph nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5587', 'C8402', 'Mycosis fungoides, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5588', 'C8403', 'Mycosis fungoides, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5589', 'C8404', 'Mycosis fungoides, lymph nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5590', 'C8405', 'Mycosis fungoides, nodes of inguinal region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5591', 'C8406', 'Mycosis fungoides, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5592', 'C8407', 'Mycosis fungoides, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5593', 'C8408', 'Mycosis fungoides, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5594', 'C8409', 'Mycosis fungoides, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5595', 'C840A', 'Mycosis fungoides, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5596', 'C8410', 'Sezary disease, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5597', 'C8411', 'Sezary disease, lymph nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5598', 'C8412', 'Sezary disease, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5599', 'C8413', 'Sezary disease, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5600', 'C8414', 'Sezary disease, lymph nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5601', 'C8415', 'Sezary disease, nodes of inguinal region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5602', 'C8416', 'Sezary disease, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5603', 'C8417', 'Sezary disease, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5604', 'C8418', 'Sezary disease, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5605', 'C8419', 'Sezary disease, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5606', 'C841A', 'Sezary disease, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5607', 'C8440', 'Peripheral T-cell lymphoma, NEC, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5608', 'C8441', 'Prph T-cell lymphoma, NEC, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5609', 'C8442', 'Peripheral T-cell lymphoma, NEC, intrathoracic lympth nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5610', 'C8443', 'Peripheral T-cell lymphoma, NEC, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5611', 'C8444', 'Prph T-cell lymphoma, NEC, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5612', 'C8445', 'Prph T-cell lymph, NEC, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5613', 'C8446', 'Peripheral T-cell lymphoma, NEC, intrapelvic nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5614', 'C8447', 'Peripheral T-cell lymphoma, not elsewhere classified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5615', 'C8448', 'Peripheral T-cell lymphoma, NEC, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5616', 'C8449', 'Prph T-cell lymphoma, NEC, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5617', 'C844A', 'Peripheral T-cell lymphoma, NEC, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5618', 'C8460', 'Anaplastic large cell lymphoma, ALK-positive, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5619', 'C8461', 'Anaplstc lg cell lymph, ALK-pos, nodes of head, face, and nk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5620', 'C8462', 'Anaplastic large cell lymphoma, ALK-pos, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5621', 'C8463', 'Anaplastic large cell lymphoma, ALK-pos, intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5622', 'C8464', 'Anaplstc lg cell lymph, ALK-pos, nodes of axla and upr limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5623', 'C8465', 'Anaplstc lg cell lymph, ALK-pos, nodes of ing rgn & low lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5624', 'C8466', 'Anaplastic large cell lymphoma, ALK-pos, intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5625', 'C8467', 'Anaplastic large cell lymphoma, ALK-positive, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5626', 'C8468', 'Anaplastic large cell lymphoma, ALK-pos, nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5627', 'C8469', 'Anaplstc lg cell lymph, ALK-pos, extrnod and solid org sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5628', 'C846A', 'Anaplastic large cell lymphoma, ALK-positive, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5629', 'C8470', 'Anaplastic large cell lymphoma, ALK-negative, unsp site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5630', 'C8471', 'Anaplstc lg cell lymph, ALK-neg, nodes of head, face, and nk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5631', 'C8472', 'Anaplastic large cell lymphoma, ALK-neg, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5632', 'C8473', 'Anaplastic large cell lymphoma, ALK-neg, intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5633', 'C8474', 'Anaplstc lg cell lymph, ALK-neg, nodes of axla and upr limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5634', 'C8475', 'Anaplstc lg cell lymph, ALK-neg, nodes of ing rgn & low lmb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5635', 'C8476', 'Anaplastic large cell lymphoma, ALK-neg, intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5636', 'C8477', 'Anaplastic large cell lymphoma, ALK-negative, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5637', 'C8478', 'Anaplastic large cell lymphoma, ALK-neg, nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5638', 'C8479', 'Anaplstc lg cell lymph, ALK-neg, extrnod and solid org sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5639', 'C847A', 'Anaplastic large cell lymphoma, ALK-negative, breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5640', 'C847B', 'Anaplastic large cell lymphoma, ALK-negative, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5641', 'C8490', 'Mature T/NK-cell lymphomas, unspecified, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5642', 'C8491', 'Mature T/NK-cell lymph, unsp, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5643', 'C8492', 'Mature T/NK-cell lymphomas, unsp, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5644', 'C8493', 'Mature T/NK-cell lymphomas, unsp, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5645', 'C8494', 'Mature T/NK-cell lymph, unsp, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5646', 'C8495', 'Mature T/NK-cell lymph, unsp, nodes of ing rgn and low limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5647', 'C8496', 'Mature T/NK-cell lymphomas, unsp, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5648', 'C8497', 'Mature T/NK-cell lymphomas, unspecified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5649', 'C8498', 'Mature T/NK-cell lymphomas, unsp, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5650', 'C8499', 'Mature T/NK-cell lymph, unsp, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5651', 'C849A', 'Mature T/NK-cell lymphomas, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5652', 'C84A0', 'Cutaneous T-cell lymphoma, unspecified, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5653', 'C84A1', 'Cutan T-cell lymphoma, unsp nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5654', 'C84A2', 'Cutaneous T-cell lymphoma, unsp, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5655', 'C84A3', 'Cutaneous T-cell lymphoma, unsp, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5656', 'C84A4', 'Cutan T-cell lymphoma, unsp, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5657', 'C84A5', 'Cutan T-cell lymph, unsp, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5658', 'C84A6', 'Cutaneous T-cell lymphoma, unsp, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5659', 'C84A7', 'Cutaneous T-cell lymphoma, unspecified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5660', 'C84A8', 'Cutaneous T-cell lymphoma, unsp, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5661', 'C84A9', 'Cutan T-cell lymphoma, unsp, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5662', 'C84AA', 'Cutaneous T-cell lymphoma, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5663', 'C84Z0', 'Other mature T/NK-cell lymphomas, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5664', 'C84Z1', 'Oth mature T/NK-cell lymph, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5665', 'C84Z2', 'Other mature T/NK-cell lymphomas, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5666', 'C84Z3', 'Oth mature T/NK-cell lymphomas, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5667', 'C84Z4', 'Oth mature T/NK-cell lymph, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5668', 'C84Z5', 'Oth mature T/NK-cell lymph, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5669', 'C84Z6', 'Other mature T/NK-cell lymphomas, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5670', 'C84Z7', 'Other mature T/NK-cell lymphomas, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5671', 'C84Z8', 'Oth mature T/NK-cell lymphomas, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5672', 'C84Z9', 'Oth mature T/NK-cell lymph, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5673', 'C84ZA', 'Other mature T/NK-cell lymphomas, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5674', 'C8510', 'Unspecified B-cell lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5675', 'C8511', 'Unsp B-cell lymphoma, lymph nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5676', 'C8512', 'Unspecified B-cell lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5677', 'C8513', 'Unspecified B-cell lymphoma, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5678', 'C8514', 'Unsp B-cell lymphoma, lymph nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5679', 'C8515', 'Unsp B-cell lymphoma, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5680', 'C8516', 'Unspecified B-cell lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5681', 'C8517', 'Unspecified B-cell lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5682', 'C8518', 'Unspecified B-cell lymphoma, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5683', 'C8519', 'Unsp B-cell lymphoma, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5684', 'C851A', 'Unspecified B-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5685', 'C8520', 'Mediastinal (thymic) large B-cell lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5686', 'C8521', 'Mediastnl large B-cell lymph, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5687', 'C8522', 'Mediastnl (thymic) large B-cell lymphoma, intrathorac nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5688', 'C8523', 'Mediastinal (thymic) large B-cell lymphoma, intra-abd nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5689', 'C8524', 'Mediastnl large B-cell lymph, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5690', 'C8525', 'Mediastnl lg B-cell lymph, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5691', 'C8526', 'Mediastinal (thymic) large B-cell lymphoma, intrapelv nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5692', 'C8527', 'Mediastinal (thymic) large B-cell lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5693', 'C8528', 'Mediastinal (thymic) large B-cell lymphoma, nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5694', 'C8529', 'Mediastnl large B-cell lymph, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5695', 'C852A', 'Mediastinal (thymic) large B-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5696', 'C8580', 'Oth types of non-Hodgkin lymphoma, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5697', 'C8581', 'Oth types of non-hodg lymph, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5698', 'C8582', 'Oth types of non-Hodgkin lymphoma, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5699', 'C8583', 'Oth types of non-Hodgkin lymphoma, intra-abd lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5700', 'C8584', 'Oth types of non-hodg lymph, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5701', 'C8585', 'Oth types of non-hodg lymph, nodes of ing rgn and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5702', 'C8586', 'Oth types of non-Hodgkin lymphoma, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5703', 'C8587', 'Other specified types of non-Hodgkin lymphoma, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5704', 'C8588', 'Oth types of non-Hodgkin lymphoma, lymph nodes mult site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5705', 'C8589', 'Oth types of non-hodg lymph, extrnod and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5706', 'C858A', 'Other specified types of non-Hodgkin lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5707', 'C8590', 'Non-Hodgkin lymphoma, unspecified, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5708', 'C8591', 'Non-Hodgkin lymphoma, unsp, nodes of head, face, and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5709', 'C8592', 'Non-Hodgkin lymphoma, unspecified, intrathoracic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5710', 'C8593', 'Non-Hodgkin lymphoma, unsp, intra-abdominal lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5711', 'C8594', 'Non-Hodgkin lymphoma, unsp, nodes of axilla and upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5712', 'C8595', 'Non-hodg lymphoma, unsp, nodes of ing region and lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5713', 'C8596', 'Non-Hodgkin lymphoma, unspecified, intrapelvic lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5714', 'C8597', 'Non-Hodgkin lymphoma, unspecified, spleen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5715', 'C8598', 'Non-Hodgkin lymphoma, unsp, lymph nodes of multiple sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5716', 'C8599', 'Non-Hodgkin lymphoma, unsp, extranodal and solid organ sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5717', 'C859A', 'Non-Hodgkin lymphoma, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5718', 'C860', 'Extranodal NK/T-cell lymphoma, nasal type', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5719', 'C8600', 'Extranodal NK/T-cell lymphoma, nasal type not remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5720', 'C8601', 'Extranodal NK/T-cell lymphoma, nasal type, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5721', 'C861', 'Hepatosplenic T-cell lymphoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5722', 'C8610', 'Hepatosplenic T-cell lymphoma not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5723', 'C8611', 'Hepatosplenic T-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5724', 'C862', 'Enteropathy-type (intestinal) T-cell lymphoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5725', 'C8620', 'Enteropathy-type (intestinal) T-cell lymphoma not remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5726', 'C8621', 'Enteropathy-type (intestinal) T-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5727', 'C863', 'Subcutaneous panniculitis-like T-cell lymphoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5728', 'C8630', 'Subcutaneous panniculitis-like T-cell lymphoma not remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5729', 'C8631', 'Subcutaneous panniculitis-like T-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5730', 'C864', 'Blastic NK-cell lymphoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5731', 'C8640', 'Blastic NK-cell lymphoma not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5732', 'C8641', 'Blastic NK-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5733', 'C865', 'Angioimmunoblastic T-cell lymphoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5734', 'C8650', 'Angioimmunoblastic T-cell lymphoma not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5735', 'C8651', 'Angioimmunoblastic T-cell lymphoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5736', 'C866', 'Primary cutaneous CD30-positive T-cell proliferations', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5737', 'C8660', 'Primary cutaneous CD30-positive T-cell prolif not remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5738', 'C8661', 'Primary cutaneous CD30-positive T-cell prolif, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5739', 'C880', 'Waldenstrom macroglobulinemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5740', 'C8800', 'Waldenstrom macroglobulinemia not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5741', 'C8801', 'Waldenstrom macroglobulinemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5742', 'C882', 'Heavy chain disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5743', 'C8820', 'Heavy chain disease not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5744', 'C8821', 'Heavy chain disease, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5745', 'C883', 'Immunoproliferative small intestinal disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5746', 'C8830', 'Immunoproliferative small intestinal disease not remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5747', 'C8831', 'Immunoproliferative small intestinal disease, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5748', 'C884', 'Extrnod mrgnl zn B-cell lymph of mucosa-assoc lymphoid tiss', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5749', 'C8840', 'Extrnod mrgnl B-cell lymph mucosa-assoc lym tiss not remis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5750', 'C8841', 'Extrnod mrgnl B-cell lymph mucosa-assoc lym tiss, in remis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5751', 'C888', 'Other malignant immunoproliferative diseases', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5752', 'C8880', 'Other malignant immunoproliferative diseases not remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5753', 'C8881', 'Other malignant immunoproliferative diseases, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5754', 'C889', 'Malignant immunoproliferative disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5755', 'C8890', 'Malignant immunoproliferative disease, unsp not remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5756', 'C8891', 'Malignant immunoproliferative disease, unsp, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5757', 'C9000', 'Multiple myeloma not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5758', 'C9001', 'Multiple myeloma in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5759', 'C9002', 'Multiple myeloma in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5760', 'C9010', 'Plasma cell leukemia not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5761', 'C9011', 'Plasma cell leukemia in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5762', 'C9012', 'Plasma cell leukemia in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5763', 'C9020', 'Extramedullary plasmacytoma not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5764', 'C9021', 'Extramedullary plasmacytoma in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5765', 'C9022', 'Extramedullary plasmacytoma in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5766', 'C9030', 'Solitary plasmacytoma not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5767', 'C9031', 'Solitary plasmacytoma in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5768', 'C9032', 'Solitary plasmacytoma in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5769', 'C9100', 'Acute lymphoblastic leukemia not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5770', 'C9101', 'Acute lymphoblastic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5771', 'C9102', 'Acute lymphoblastic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5772', 'C9110', 'Chronic lymphocytic leuk of B-cell type not achieve remis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5773', 'C9111', 'Chronic lymphocytic leukemia of B-cell type in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5774', 'C9112', 'Chronic lymphocytic leukemia of B-cell type in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5775', 'C9130', 'Prolymphocytic leukemia of B-cell type not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5776', 'C9131', 'Prolymphocytic leukemia of B-cell type, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5777', 'C9132', 'Prolymphocytic leukemia of B-cell type, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5778', 'C9140', 'Hairy cell leukemia not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5779', 'C9141', 'Hairy cell leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5780', 'C9142', 'Hairy cell leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5781', 'C9150', 'Adult T-cell lymph/leuk (HTLV-1-assoc) not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5782', 'C9151', 'Adult T-cell lymphoma/leukemia (HTLV-1-assoc), in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5783', 'C9152', 'Adult T-cell lymphoma/leukemia (HTLV-1-assoc), in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5784', 'C9160', 'Prolymphocytic leukemia of T-cell type not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5785', 'C9161', 'Prolymphocytic leukemia of T-cell type, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5786', 'C9162', 'Prolymphocytic leukemia of T-cell type, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5787', 'C9190', 'Lymphoid leukemia, unspecified not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5788', 'C9191', 'Lymphoid leukemia, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5789', 'C9192', 'Lymphoid leukemia, unspecified, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5790', 'C91A0', 'Mature B-cell leukemia Burkitt-type not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5791', 'C91A1', 'Mature B-cell leukemia Burkitt-type, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5792', 'C91A2', 'Mature B-cell leukemia Burkitt-type, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5793', 'C91Z0', 'Other lymphoid leukemia not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5794', 'C91Z1', 'Other lymphoid leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5795', 'C91Z2', 'Other lymphoid leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5796', 'C9200', 'Acute myeloblastic leukemia, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5797', 'C9201', 'Acute myeloblastic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5798', 'C9202', 'Acute myeloblastic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5799', 'C9210', 'Chronic myeloid leuk, BCR/ABL-positive, not achieve remis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5800', 'C9211', 'Chronic myeloid leukemia, BCR/ABL-positive, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5801', 'C9212', 'Chronic myeloid leukemia, BCR/ABL-positive, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5802', 'C9220', 'Atyp chronic myeloid leuk, BCR/ABL-neg, not achieve remis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5803', 'C9221', 'Atypical chronic myeloid leukemia, BCR/ABL-neg, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5804', 'C9222', 'Atypical chronic myeloid leukemia, BCR/ABL-neg, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5805', 'C9230', 'Myeloid sarcoma, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5806', 'C9231', 'Myeloid sarcoma, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5807', 'C9232', 'Myeloid sarcoma, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5808', 'C9240', 'Acute promyelocytic leukemia, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5809', 'C9241', 'Acute promyelocytic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5810', 'C9242', 'Acute promyelocytic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5811', 'C9250', 'Acute myelomonocytic leukemia, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5812', 'C9251', 'Acute myelomonocytic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5813', 'C9252', 'Acute myelomonocytic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5814', 'C9260', 'Acute myeloid leukemia w 11q23-abnormality not achieve remis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5815', 'C9261', 'Acute myeloid leukemia with 11q23-abnormality in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5816', 'C9262', 'Acute myeloid leukemia with 11q23-abnormality in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5817', 'C9290', 'Myeloid leukemia, unspecified, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5818', 'C9291', 'Myeloid leukemia, unspecified in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5819', 'C9292', 'Myeloid leukemia, unspecified in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5820', 'C92A0', 'Acute myeloid leuk w multilin dysplasia, not achieve remis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5821', 'C92A1', 'Acute myeloid leukemia w multilin dysplasia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5822', 'C92A2', 'Acute myeloid leukemia w multilineage dysplasia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5823', 'C92Z0', 'Other myeloid leukemia not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5824', 'C92Z1', 'Other myeloid leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5825', 'C92Z2', 'Other myeloid leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5826', 'C9300', 'Acute monoblastic/monocytic leukemia, not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5827', 'C9301', 'Acute monoblastic/monocytic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5828', 'C9302', 'Acute monoblastic/monocytic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5829', 'C9310', 'Chronic myelomonocytic leukemia not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5830', 'C9311', 'Chronic myelomonocytic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5831', 'C9312', 'Chronic myelomonocytic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5832', 'C9330', 'Juvenile myelomonocytic leukemia, not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5833', 'C9331', 'Juvenile myelomonocytic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5834', 'C9332', 'Juvenile myelomonocytic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5835', 'C9390', 'Monocytic leukemia, unsp, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5836', 'C9391', 'Monocytic leukemia, unspecified in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5837', 'C9392', 'Monocytic leukemia, unspecified in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5838', 'C93Z0', 'Other monocytic leukemia, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5839', 'C93Z1', 'Other monocytic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5840', 'C93Z2', 'Other monocytic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5841', 'C9400', 'Acute erythroid leukemia, not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5842', 'C9401', 'Acute erythroid leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5843', 'C9402', 'Acute erythroid leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5844', 'C9420', 'Acute megakaryoblastic leukemia not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5845', 'C9421', 'Acute megakaryoblastic leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5846', 'C9422', 'Acute megakaryoblastic leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5847', 'C9430', 'Mast cell leukemia not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5848', 'C9431', 'Mast cell leukemia, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5849', 'C9432', 'Mast cell leukemia, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5850', 'C9440', 'Acute panmyelosis w myelofibrosis not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5851', 'C9441', 'Acute panmyelosis with myelofibrosis, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5852', 'C9442', 'Acute panmyelosis with myelofibrosis, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5853', 'C946', 'Myelodysplastic disease, not elsewhere classified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5854', 'C9480', 'Other specified leukemias not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5855', 'C9481', 'Other specified leukemias, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5856', 'C9482', 'Other specified leukemias, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5857', 'C9500', 'Acute leukemia of unsp cell type not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5858', 'C9501', 'Acute leukemia of unspecified cell type, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5859', 'C9502', 'Acute leukemia of unspecified cell type, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5860', 'C9510', 'Chronic leukemia of unsp cell type not achieve remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5861', 'C9511', 'Chronic leukemia of unspecified cell type, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5862', 'C9512', 'Chronic leukemia of unspecified cell type, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5863', 'C9590', 'Leukemia, unspecified not having achieved remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5864', 'C9591', 'Leukemia, unspecified, in remission', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5865', 'C9592', 'Leukemia, unspecified, in relapse', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5866', 'C960', 'Multifocal and multisystemic Langerhans-cell histiocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5867', 'C962', 'Malignant mast cell tumor', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5868', 'C9620', 'Malignant mast cell neoplasm, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5869', 'C9621', 'Aggressive systemic mastocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5870', 'C9622', 'Mast cell sarcoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5871', 'C9629', 'Other malignant mast cell neoplasm', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5872', 'C964', 'Sarcoma of dendritic cells (accessory cells)', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5873', 'C965', 'Multifocal and unisystemic Langerhans-cell histiocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5874', 'C966', 'Unifocal Langerhans-cell histiocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5875', 'C969', 'Malig neoplm of lymphoid, hematpoetc and rel tissue, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5876', 'C96A', 'Histiocytic sarcoma', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5877', 'C96Z', 'Oth malig neoplm of lymphoid, hematpoetc and related tissue', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5878', 'D0000', 'Carcinoma in situ of oral cavity, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5879', 'D0001', 'Carcinoma in situ of labial mucosa and vermilion border', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5880', 'D0002', 'Carcinoma in situ of buccal mucosa', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5881', 'D0003', 'Carcinoma in situ of gingiva and edentulous alveolar ridge', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5882', 'D0004', 'Carcinoma in situ of soft palate', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5883', 'D0005', 'Carcinoma in situ of hard palate', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5884', 'D0006', 'Carcinoma in situ of floor of mouth', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5885', 'D0007', 'Carcinoma in situ of tongue', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5886', 'D0008', 'Carcinoma in situ of pharynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5887', 'D001', 'Carcinoma in situ of esophagus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5888', 'D002', 'Carcinoma in situ of stomach', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5889', 'D010', 'Carcinoma in situ of colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5890', 'D011', 'Carcinoma in situ of rectosigmoid junction', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5891', 'D012', 'Carcinoma in situ of rectum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5892', 'D013', 'Carcinoma in situ of anus and anal canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5893', 'D0140', 'Carcinoma in situ of unspecified part of intestine', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5894', 'D0149', 'Carcinoma in situ of other parts of intestine', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5895', 'D015', 'Carcinoma in situ of liver, gallbladder and bile ducts', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5896', 'D017', 'Carcinoma in situ of other specified digestive organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5897', 'D019', 'Carcinoma in situ of digestive organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5898', 'D020', 'Carcinoma in situ of larynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5899', 'D021', 'Carcinoma in situ of trachea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5900', 'D0220', 'Carcinoma in situ of unspecified bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5901', 'D0221', 'Carcinoma in situ of right bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5902', 'D0222', 'Carcinoma in situ of left bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5903', 'D023', 'Carcinoma in situ of other parts of respiratory system', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5904', 'D024', 'Carcinoma in situ of respiratory system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5905', 'D030', 'Melanoma in situ of lip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5906', 'D0310', 'Melanoma in situ of unspecified eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5907', 'D0311', 'Melanoma in situ of right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5908', 'D03111', 'Melanoma in situ of right upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5909', 'D03112', 'Melanoma in situ of right lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5910', 'D0312', 'Melanoma in situ of left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5911', 'D03121', 'Melanoma in situ of left upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5912', 'D03122', 'Melanoma in situ of left lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5913', 'D0320', 'Melanoma in situ of unsp ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5914', 'D0321', 'Melanoma in situ of right ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5915', 'D0322', 'Melanoma in situ of left ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5916', 'D0330', 'Melanoma in situ of unspecified part of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5917', 'D0339', 'Melanoma in situ of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5918', 'D034', 'Melanoma in situ of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5919', 'D0351', 'Melanoma in situ of anal skin', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5920', 'D0352', 'Melanoma in situ of breast (skin) (soft tissue)', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5921', 'D0359', 'Melanoma in situ of other part of trunk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5922', 'D0360', 'Melanoma in situ of unsp upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5923', 'D0361', 'Melanoma in situ of right upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5924', 'D0362', 'Melanoma in situ of left upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5925', 'D0370', 'Melanoma in situ of unspecified lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5926', 'D0371', 'Melanoma in situ of right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5927', 'D0372', 'Melanoma in situ of left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5928', 'D038', 'Melanoma in situ of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5929', 'D039', 'Melanoma in situ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5930', 'D040', 'Carcinoma in situ of skin of lip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5931', 'D0410', 'Carcinoma in situ of skin of unsp eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5932', 'D0411', 'Carcinoma in situ of skin of right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5933', 'D04111', 'Ca in situ skin of right upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5934', 'D04112', 'Ca in situ skin of right lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5935', 'D0412', 'Carcinoma in situ of skin of left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5936', 'D04121', 'Ca in situ skin of left upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5937', 'D04122', 'Ca in situ skin of left lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5938', 'D0420', 'Ca in situ skin of unsp ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5939', 'D0421', 'Ca in situ skin of right ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5940', 'D0422', 'Ca in situ skin of left ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5941', 'D0430', 'Carcinoma in situ of skin of unspecified part of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5942', 'D0439', 'Carcinoma in situ of skin of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5943', 'D044', 'Carcinoma in situ of skin of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5944', 'D045', 'Carcinoma in situ of skin of trunk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5945', 'D0460', 'Ca in situ skin of unsp upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5946', 'D0461', 'Ca in situ skin of right upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5947', 'D0462', 'Ca in situ skin of left upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5948', 'D0470', 'Carcinoma in situ of skin of unsp lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5949', 'D0471', 'Carcinoma in situ of skin of right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5950', 'D0472', 'Carcinoma in situ of skin of left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5951', 'D048', 'Carcinoma in situ of skin of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5952', 'D049', 'Carcinoma in situ of skin, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5953', 'D0500', 'Lobular carcinoma in situ of unspecified breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5954', 'D0501', 'Lobular carcinoma in situ of right breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5955', 'D0502', 'Lobular carcinoma in situ of left breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5956', 'D0510', 'Intraductal carcinoma in situ of unspecified breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5957', 'D0511', 'Intraductal carcinoma in situ of right breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5958', 'D0512', 'Intraductal carcinoma in situ of left breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5959', 'D0580', 'Oth type of carcinoma in situ of unspecified breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5960', 'D0581', 'Other specified type of carcinoma in situ of right breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5961', 'D0582', 'Other specified type of carcinoma in situ of left breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5962', 'D0590', 'Unspecified type of carcinoma in situ of unspecified breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5963', 'D0591', 'Unspecified type of carcinoma in situ of right breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5964', 'D0592', 'Unspecified type of carcinoma in situ of left breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5965', 'D060', 'Carcinoma in situ of endocervix', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5966', 'D061', 'Carcinoma in situ of exocervix', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5967', 'D067', 'Carcinoma in situ of other parts of cervix', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5968', 'D069', 'Carcinoma in situ of cervix, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5969', 'D070', 'Carcinoma in situ of endometrium', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5970', 'D071', 'Carcinoma in situ of vulva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5971', 'D072', 'Carcinoma in situ of vagina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5972', 'D0730', 'Carcinoma in situ of unspecified female genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5973', 'D0739', 'Carcinoma in situ of other female genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5974', 'D074', 'Carcinoma in situ of penis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5975', 'D075', 'Carcinoma in situ of prostate', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5976', 'D0760', 'Carcinoma in situ of unspecified male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5977', 'D0761', 'Carcinoma in situ of scrotum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5978', 'D0769', 'Carcinoma in situ of other male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5979', 'D090', 'Carcinoma in situ of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5980', 'D0910', 'Carcinoma in situ of unspecified urinary organ', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5981', 'D0919', 'Carcinoma in situ of other urinary organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5982', 'D0920', 'Carcinoma in situ of unspecified eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5983', 'D0921', 'Carcinoma in situ of right eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5984', 'D0922', 'Carcinoma in situ of left eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5985', 'D093', 'Carcinoma in situ of thyroid and other endocrine glands', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5986', 'D098', 'Carcinoma in situ of other specified sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5987', 'D099', 'Carcinoma in situ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5988', 'D100', 'Benign neoplasm of lip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5989', 'D101', 'Benign neoplasm of tongue', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5990', 'D102', 'Benign neoplasm of floor of mouth', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5991', 'D1030', 'Benign neoplasm of unspecified part of mouth', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5992', 'D1039', 'Benign neoplasm of other parts of mouth', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5993', 'D104', 'Benign neoplasm of tonsil', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5994', 'D105', 'Benign neoplasm of other parts of oropharynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5995', 'D106', 'Benign neoplasm of nasopharynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5996', 'D107', 'Benign neoplasm of hypopharynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5997', 'D109', 'Benign neoplasm of pharynx, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5998', 'D110', 'Benign neoplasm of parotid gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('5999', 'D117', 'Benign neoplasm of other major salivary glands', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6000', 'D119', 'Benign neoplasm of major salivary gland, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6001', 'D120', 'Benign neoplasm of cecum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6002', 'D121', 'Benign neoplasm of appendix', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6003', 'D122', 'Benign neoplasm of ascending colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6004', 'D123', 'Benign neoplasm of transverse colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6005', 'D124', 'Benign neoplasm of descending colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6006', 'D125', 'Benign neoplasm of sigmoid colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6007', 'D126', 'Benign neoplasm of colon, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6008', 'D127', 'Benign neoplasm of rectosigmoid junction', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6009', 'D128', 'Benign neoplasm of rectum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6010', 'D129', 'Benign neoplasm of anus and anal canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6011', 'D130', 'Benign neoplasm of esophagus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6012', 'D131', 'Benign neoplasm of stomach', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6013', 'D132', 'Benign neoplasm of duodenum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6014', 'D1330', 'Benign neoplasm of unspecified part of small intestine', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6015', 'D1339', 'Benign neoplasm of other parts of small intestine', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6016', 'D134', 'Benign neoplasm of liver', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6017', 'D135', 'Benign neoplasm of extrahepatic bile ducts', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6018', 'D136', 'Benign neoplasm of pancreas', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6019', 'D137', 'Benign neoplasm of endocrine pancreas', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6020', 'D139', 'Benign neoplasm of ill-defined sites within the dgstv sys', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6021', 'D1391', 'Familial adenomatous polyposis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6022', 'D1399', 'Benign neoplasm of ill-defined sites within the dgstv sys', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6023', 'D140', 'Benign neoplasm of mid ear, nasl cav and accessory sinuses', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6024', 'D141', 'Benign neoplasm of larynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6025', 'D142', 'Benign neoplasm of trachea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6026', 'D1430', 'Benign neoplasm of unspecified bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6027', 'D1431', 'Benign neoplasm of right bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6028', 'D1432', 'Benign neoplasm of left bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6029', 'D144', 'Benign neoplasm of respiratory system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6030', 'D150', 'Benign neoplasm of thymus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6031', 'D151', 'Benign neoplasm of heart', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6032', 'D152', 'Benign neoplasm of mediastinum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6033', 'D157', 'Benign neoplasm of other specified intrathoracic organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6034', 'D159', 'Benign neoplasm of intrathoracic organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6035', 'D1600', 'Benign neoplasm of scapula and long bones of unsp upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6036', 'D1601', 'Benign neoplm of scapula and long bones of right upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6037', 'D1602', 'Benign neoplasm of scapula and long bones of left upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6038', 'D1610', 'Benign neoplasm of short bones of unspecified upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6039', 'D1611', 'Benign neoplasm of short bones of right upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6040', 'D1612', 'Benign neoplasm of short bones of left upper limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6041', 'D1620', 'Benign neoplasm of long bones of unspecified lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6042', 'D1621', 'Benign neoplasm of long bones of right lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6043', 'D1622', 'Benign neoplasm of long bones of left lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6044', 'D1630', 'Benign neoplasm of short bones of unspecified lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6045', 'D1631', 'Benign neoplasm of short bones of right lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6046', 'D1632', 'Benign neoplasm of short bones of left lower limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6047', 'D164', 'Benign neoplasm of bones of skull and face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6048', 'D165', 'Benign neoplasm of lower jaw bone', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6049', 'D166', 'Benign neoplasm of vertebral column', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6050', 'D167', 'Benign neoplasm of ribs, sternum and clavicle', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6051', 'D168', 'Benign neoplasm of pelvic bones, sacrum and coccyx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6052', 'D169', 'Benign neoplasm of bone and articular cartilage, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6053', 'D170', 'Ben lipomatous neoplm of skin, subcu of head, face and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6054', 'D171', 'Benign lipomatous neoplasm of skin, subcu of trunk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6055', 'D1720', 'Benign lipomatous neoplasm of skin, subcu of unsp limb', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6056', 'D1721', 'Benign lipomatous neoplasm of skin, subcu of right arm', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6057', 'D1722', 'Benign lipomatous neoplasm of skin, subcu of left arm', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6058', 'D1723', 'Benign lipomatous neoplasm of skin, subcu of right leg', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6059', 'D1724', 'Benign lipomatous neoplasm of skin, subcu of left leg', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6060', 'D1730', 'Benign lipomatous neoplasm of skin, subcu of unsp sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6061', 'D1739', 'Benign lipomatous neoplasm of skin, subcu of sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6062', 'D174', 'Benign lipomatous neoplasm of intrathoracic organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6063', 'D175', 'Benign lipomatous neoplasm of intra-abdominal organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6064', 'D176', 'Benign lipomatous neoplasm of spermatic cord', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6065', 'D1771', 'Benign lipomatous neoplasm of kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6066', 'D1772', 'Benign lipomatous neoplasm of other genitourinary organ', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6067', 'D1779', 'Benign lipomatous neoplasm of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6068', 'D179', 'Benign lipomatous neoplasm, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6069', 'D1800', 'Hemangioma unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6070', 'D1801', 'Hemangioma of skin and subcutaneous tissue', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6071', 'D1802', 'Hemangioma of intracranial structures', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6072', 'D1803', 'Hemangioma of intra-abdominal structures', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6073', 'D1809', 'Hemangioma of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6074', 'D181', 'Lymphangioma, any site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6075', 'D190', 'Benign neoplasm of mesothelial tissue of pleura', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6076', 'D191', 'Benign neoplasm of mesothelial tissue of peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6077', 'D197', 'Benign neoplasm of mesothelial tissue of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6078', 'D199', 'Benign neoplasm of mesothelial tissue, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6079', 'D200', 'Benign neoplasm of soft tissue of retroperitoneum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6080', 'D201', 'Benign neoplasm of soft tissue of peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6081', 'D210', 'Benign neoplasm of connctv/soft tiss of head, face and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6082', 'D2110', 'Ben neoplm of connctv/soft tiss of unsp upr limb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6083', 'D2111', 'Ben neoplm of connctv/soft tiss of r upper limb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6084', 'D2112', 'Ben neoplm of connctv/soft tiss of left upr limb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6085', 'D2120', 'Ben neoplm of connctv/soft tiss of unsp lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6086', 'D2121', 'Ben neoplm of connctv/soft tiss of right lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6087', 'D2122', 'Ben neoplm of connctv/soft tiss of left lower limb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6088', 'D213', 'Benign neoplasm of connective and oth soft tissue of thorax', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6089', 'D214', 'Benign neoplasm of connective and oth soft tissue of abdomen', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6090', 'D215', 'Benign neoplasm of connective and oth soft tissue of pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6091', 'D216', 'Benign neoplasm of connctv/soft tiss of trunk, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6092', 'D219', 'Benign neoplasm of connective and other soft tissue, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6093', 'D220', 'Melanocytic nevi of lip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6094', 'D2210', 'Melanocytic nevi of unspecified eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6095', 'D2211', 'Melanocytic nevi of right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6096', 'D22111', 'Melanocytic nevi of right upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6097', 'D22112', 'Melanocytic nevi of right lower eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6098', 'D2212', 'Melanocytic nevi of left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6099', 'D22121', 'Melanocytic nevi of left upper eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6100', 'D22122', 'Melanocytic nevi of left lower eyelid, including canthu', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6101', 'D2220', 'Melanocytic nevi of unsp ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6102', 'D2221', 'Melanocytic nevi of right ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6103', 'D2222', 'Melanocytic nevi of left ear and external auricular canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6104', 'D2230', 'Melanocytic nevi of unspecified part of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6105', 'D2239', 'Melanocytic nevi of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6106', 'D224', 'Melanocytic nevi of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6107', 'D225', 'Melanocytic nevi of trunk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6108', 'D2260', 'Melanocytic nevi of unsp upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6109', 'D2261', 'Melanocytic nevi of right upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6110', 'D2262', 'Melanocytic nevi of left upper limb, including shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6111', 'D2270', 'Melanocytic nevi of unspecified lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6112', 'D2271', 'Melanocytic nevi of right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6113', 'D2272', 'Melanocytic nevi of left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6114', 'D229', 'Melanocytic nevi, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6115', 'D230', 'Other benign neoplasm of skin of lip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6116', 'D2310', 'Oth benign neoplasm skin/ unsp eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6117', 'D2311', 'Oth benign neoplasm skin/ right eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6118', 'D23111', 'Other benign neoplasm skin/ right upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6119', 'D23112', 'Other benign neoplasm skin/ right lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6120', 'D2312', 'Oth benign neoplasm skin/ left eyelid, including canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6121', 'D23121', 'Other benign neoplasm skin/ left upper eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6122', 'D23122', 'Other benign neoplasm skin/ left lower eyelid, inc canthus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6123', 'D2320', 'Oth benign neoplasm skin/ unsp ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6124', 'D2321', 'Oth benign neoplasm skin/ right ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6125', 'D2322', 'Oth benign neoplasm skin/ left ear and external auric canal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6126', 'D2330', 'Other benign neoplasm of skin of unspecified part of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6127', 'D2339', 'Other benign neoplasm of skin of other parts of face', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6128', 'D234', 'Other benign neoplasm of skin of scalp and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6129', 'D235', 'Other benign neoplasm of skin of trunk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6130', 'D2360', 'Oth benign neoplasm skin/ unsp upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6131', 'D2361', 'Oth benign neoplasm skin/ right upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6132', 'D2362', 'Oth benign neoplasm skin/ left upper limb, inc shoulder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6133', 'D2370', 'Oth benign neoplasm skin/ unsp lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6134', 'D2371', 'Oth benign neoplasm skin/ right lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6135', 'D2372', 'Oth benign neoplasm skin/ left lower limb, including hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6136', 'D239', 'Other benign neoplasm of skin, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6137', 'D241', 'Benign neoplasm of right breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6138', 'D242', 'Benign neoplasm of left breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6139', 'D249', 'Benign neoplasm of unspecified breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6140', 'D250', 'Submucous leiomyoma of uterus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6141', 'D251', 'Intramural leiomyoma of uterus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6142', 'D252', 'Subserosal leiomyoma of uterus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6143', 'D259', 'Leiomyoma of uterus, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6144', 'D260', 'Other benign neoplasm of cervix uteri', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6145', 'D261', 'Other benign neoplasm of corpus uteri', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6146', 'D267', 'Other benign neoplasm of other parts of uterus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6147', 'D269', 'Other benign neoplasm of uterus, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6148', 'D270', 'Benign neoplasm of right ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6149', 'D271', 'Benign neoplasm of left ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6150', 'D279', 'Benign neoplasm of unspecified ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6151', 'D280', 'Benign neoplasm of vulva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6152', 'D281', 'Benign neoplasm of vagina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6153', 'D282', 'Benign neoplasm of uterine tubes and ligaments', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6154', 'D287', 'Benign neoplasm of other specified female genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6155', 'D289', 'Benign neoplasm of female genital organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6156', 'D290', 'Benign neoplasm of penis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6157', 'D291', 'Benign neoplasm of prostate', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6158', 'D2920', 'Benign neoplasm of unspecified testis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6159', 'D2921', 'Benign neoplasm of right testis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6160', 'D2922', 'Benign neoplasm of left testis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6161', 'D2930', 'Benign neoplasm of unspecified epididymis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6162', 'D2931', 'Benign neoplasm of right epididymis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6163', 'D2932', 'Benign neoplasm of left epididymis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6164', 'D294', 'Benign neoplasm of scrotum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6165', 'D298', 'Benign neoplasm of other specified male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6166', 'D299', 'Benign neoplasm of male genital organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6167', 'D3000', 'Benign neoplasm of unspecified kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6168', 'D3001', 'Benign neoplasm of right kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6169', 'D3002', 'Benign neoplasm of left kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6170', 'D3010', 'Benign neoplasm of unspecified renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6171', 'D3011', 'Benign neoplasm of right renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6172', 'D3012', 'Benign neoplasm of left renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6173', 'D3020', 'Benign neoplasm of unspecified ureter', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6174', 'D3021', 'Benign neoplasm of right ureter', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6175', 'D3022', 'Benign neoplasm of left ureter', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6176', 'D303', 'Benign neoplasm of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6177', 'D304', 'Benign neoplasm of urethra', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6178', 'D308', 'Benign neoplasm of other specified urinary organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6179', 'D309', 'Benign neoplasm of urinary organ, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6180', 'D3100', 'Benign neoplasm of unspecified conjunctiva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6181', 'D3101', 'Benign neoplasm of right conjunctiva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6182', 'D3102', 'Benign neoplasm of left conjunctiva', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6183', 'D3110', 'Benign neoplasm of unspecified cornea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6184', 'D3111', 'Benign neoplasm of right cornea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6185', 'D3112', 'Benign neoplasm of left cornea', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6186', 'D3120', 'Benign neoplasm of unspecified retina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6187', 'D3121', 'Benign neoplasm of right retina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6188', 'D3122', 'Benign neoplasm of left retina', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6189', 'D3130', 'Benign neoplasm of unspecified choroid', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6190', 'D3131', 'Benign neoplasm of right choroid', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6191', 'D3132', 'Benign neoplasm of left choroid', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6192', 'D3140', 'Benign neoplasm of unspecified ciliary body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6193', 'D3141', 'Benign neoplasm of right ciliary body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6194', 'D3142', 'Benign neoplasm of left ciliary body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6195', 'D3150', 'Benign neoplasm of unspecified lacrimal gland and duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6196', 'D3151', 'Benign neoplasm of right lacrimal gland and duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6197', 'D3152', 'Benign neoplasm of left lacrimal gland and duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6198', 'D3160', 'Benign neoplasm of unspecified site of unspecified orbit', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6199', 'D3161', 'Benign neoplasm of unspecified site of right orbit', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6200', 'D3162', 'Benign neoplasm of unspecified site of left orbit', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6201', 'D3190', 'Benign neoplasm of unspecified part of unspecified eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6202', 'D3191', 'Benign neoplasm of unspecified part of right eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6203', 'D3192', 'Benign neoplasm of unspecified part of left eye', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6204', 'D320', 'Benign neoplasm of cerebral meninges', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6205', 'D321', 'Benign neoplasm of spinal meninges', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6206', 'D329', 'Benign neoplasm of meninges, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6207', 'D330', 'Benign neoplasm of brain, supratentorial', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6208', 'D331', 'Benign neoplasm of brain, infratentorial', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6209', 'D332', 'Benign neoplasm of brain, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6210', 'D333', 'Benign neoplasm of cranial nerves', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6211', 'D334', 'Benign neoplasm of spinal cord', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6212', 'D337', 'Benign neoplasm of oth parts of central nervous system', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6213', 'D339', 'Benign neoplasm of central nervous system, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6214', 'D34', 'Benign neoplasm of thyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6215', 'D3500', 'Benign neoplasm of unspecified adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6216', 'D3501', 'Benign neoplasm of right adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6217', 'D3502', 'Benign neoplasm of left adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6218', 'D351', 'Benign neoplasm of parathyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6219', 'D352', 'Benign neoplasm of pituitary gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6220', 'D353', 'Benign neoplasm of craniopharyngeal duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6221', 'D354', 'Benign neoplasm of pineal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6222', 'D355', 'Benign neoplasm of carotid body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6223', 'D356', 'Benign neoplasm of aortic body and other paraganglia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6224', 'D357', 'Benign neoplasm of other specified endocrine glands', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6225', 'D359', 'Benign neoplasm of endocrine gland, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6226', 'D360', 'Benign neoplasm of lymph nodes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6227', 'D3610', 'Benign neoplasm of prph nerves and autonm nervous sys, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6228', 'D3611', 'Ben neoplm of prph nerves and autonm nrv sys of face/hed/nk', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6229', 'D3612', 'Ben neoplm of prph nrv & autonm nrv sys, upr lmb, inc shldr', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6230', 'D3613', 'Ben neoplm of prph nrv & autonm nrv sys of low lmb, inc hip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6231', 'D3614', 'Benign neoplm of prph nerves and autonm nrv sys of thorax', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6232', 'D3615', 'Benign neoplm of prph nerves and autonm nervous sys of abd', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6233', 'D3616', 'Benign neoplm of prph nerves and autonm nrv sys of pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6234', 'D3617', 'Ben neoplm of prph nerves and autonm nrv sys of trunk, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6235', 'D367', 'Benign neoplasm of other specified sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6236', 'D369', 'Benign neoplasm, unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6237', 'D3701', 'Neoplasm of uncertain behavior of lip', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6238', 'D3702', 'Neoplasm of uncertain behavior of tongue', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6239', 'D37030', 'Neoplasm of uncertain behavior of the parotid salivary gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6240', 'D37031', 'Neoplasm of uncrt behavior of the sublingual salivary gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6241', 'D37032', 'Neoplasm of uncrt behav of the submandibular salivary gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6242', 'D37039', 'Neoplasm of uncrt behavior of the major salivary gland, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6243', 'D3704', 'Neoplasm of uncertain behavior of the minor salivary glands', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6244', 'D3705', 'Neoplasm of uncertain behavior of pharynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6245', 'D3709', 'Neoplasm of uncertain behavior of sites of the oral cavity', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6246', 'D371', 'Neoplasm of uncertain behavior of stomach', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6247', 'D372', 'Neoplasm of uncertain behavior of small intestine', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6248', 'D373', 'Neoplasm of uncertain behavior of appendix', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6249', 'D374', 'Neoplasm of uncertain behavior of colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6250', 'D375', 'Neoplasm of uncertain behavior of rectum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6251', 'D376', 'Neoplasm of uncertain behavior of liver, GB & bile duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6252', 'D378', 'Neoplasm of uncertain behavior of oth digestive organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6253', 'D379', 'Neoplasm of uncertain behavior of digestive organ, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6254', 'D380', 'Neoplasm of uncertain behavior of larynx', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6255', 'D381', 'Neoplasm of uncertain behavior of trachea, bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6256', 'D382', 'Neoplasm of uncertain behavior of pleura', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6257', 'D383', 'Neoplasm of uncertain behavior of mediastinum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6258', 'D384', 'Neoplasm of uncertain behavior of thymus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6259', 'D385', 'Neoplasm of uncertain behavior of other respiratory organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6260', 'D386', 'Neoplasm of uncertain behavior of respiratory organ, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6261', 'D390', 'Neoplasm of uncertain behavior of uterus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6262', 'D3910', 'Neoplasm of uncertain behavior of unspecified ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6263', 'D3911', 'Neoplasm of uncertain behavior of right ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6264', 'D3912', 'Neoplasm of uncertain behavior of left ovary', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6265', 'D392', 'Neoplasm of uncertain behavior of placenta', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6266', 'D398', 'Neoplasm of uncertain behavior of oth female genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6267', 'D399', 'Neoplasm of uncertain behavior of female genital organ, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6268', 'D3A00', 'Benign carcinoid tumor of unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6269', 'D3A010', 'Benign carcinoid tumor of the duodenum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6270', 'D3A011', 'Benign carcinoid tumor of the jejunum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6271', 'D3A012', 'Benign carcinoid tumor of the ileum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6272', 'D3A019', 'Benign carcinoid tumor of the small intestine, unsp portion', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6273', 'D3A020', 'Benign carcinoid tumor of the appendix', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6274', 'D3A021', 'Benign carcinoid tumor of the cecum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6275', 'D3A022', 'Benign carcinoid tumor of the ascending colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6276', 'D3A023', 'Benign carcinoid tumor of the transverse colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6277', 'D3A024', 'Benign carcinoid tumor of the descending colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6278', 'D3A025', 'Benign carcinoid tumor of the sigmoid colon', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6279', 'D3A026', 'Benign carcinoid tumor of the rectum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6280', 'D3A029', 'Benign carcinoid tumor of the large intestine, unsp portion', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6281', 'D3A090', 'Benign carcinoid tumor of the bronchus and lung', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6282', 'D3A091', 'Benign carcinoid tumor of the thymus', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6283', 'D3A092', 'Benign carcinoid tumor of the stomach', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6284', 'D3A093', 'Benign carcinoid tumor of the kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6285', 'D3A094', 'Benign carcinoid tumor of the foregut unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6286', 'D3A095', 'Benign carcinoid tumor of the midgut unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6287', 'D3A096', 'Benign carcinoid tumor of the hindgut unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6288', 'D3A098', 'Benign carcinoid tumors of other sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6289', 'D3A8', 'Other benign neuroendocrine tumors', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6290', 'D400', 'Neoplasm of uncertain behavior of prostate', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6291', 'D4010', 'Neoplasm of uncertain behavior of unspecified testis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6292', 'D4011', 'Neoplasm of uncertain behavior of right testis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6293', 'D4012', 'Neoplasm of uncertain behavior of left testis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6294', 'D408', 'Neoplasm of uncertain behavior of oth male genital organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6295', 'D409', 'Neoplasm of uncertain behavior of male genital organ, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6296', 'D4100', 'Neoplasm of uncertain behavior of unspecified kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6297', 'D4101', 'Neoplasm of uncertain behavior of right kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6298', 'D4102', 'Neoplasm of uncertain behavior of left kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6299', 'D4110', 'Neoplasm of uncertain behavior of unspecified renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6300', 'D4111', 'Neoplasm of uncertain behavior of right renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6301', 'D4112', 'Neoplasm of uncertain behavior of left renal pelvis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6302', 'D4120', 'Neoplasm of uncertain behavior of unspecified ureter', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6303', 'D4121', 'Neoplasm of uncertain behavior of right ureter', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6304', 'D4122', 'Neoplasm of uncertain behavior of left ureter', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6305', 'D413', 'Neoplasm of uncertain behavior of urethra', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6306', 'D414', 'Neoplasm of uncertain behavior of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6307', 'D418', 'Neoplasm of uncertain behavior of oth urinary organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6308', 'D419', 'Neoplasm of uncertain behavior of unspecified urinary organ', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6309', 'D420', 'Neoplasm of uncertain behavior of cerebral meninges', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6310', 'D421', 'Neoplasm of uncertain behavior of spinal meninges', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6311', 'D429', 'Neoplasm of uncertain behavior of meninges, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6312', 'D430', 'Neoplasm of uncertain behavior of brain, supratentorial', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6313', 'D431', 'Neoplasm of uncertain behavior of brain, infratentorial', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6314', 'D432', 'Neoplasm of uncertain behavior of brain, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6315', 'D433', 'Neoplasm of uncertain behavior of cranial nerves', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6316', 'D434', 'Neoplasm of uncertain behavior of spinal cord', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6317', 'D438', 'Neoplasm of uncertain behavior of prt central nervous system', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6318', 'D439', 'Neoplasm of uncertain behavior of cnsl, unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6319', 'D440', 'Neoplasm of uncertain behavior of thyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6320', 'D4410', 'Neoplasm of uncertain behavior of unspecified adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6321', 'D4411', 'Neoplasm of uncertain behavior of right adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6322', 'D4412', 'Neoplasm of uncertain behavior of left adrenal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6323', 'D442', 'Neoplasm of uncertain behavior of parathyroid gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6324', 'D443', 'Neoplasm of uncertain behavior of pituitary gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6325', 'D444', 'Neoplasm of uncertain behavior of craniopharyngeal duct', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6326', 'D445', 'Neoplasm of uncertain behavior of pineal gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6327', 'D446', 'Neoplasm of uncertain behavior of carotid body', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6328', 'D447', 'Neoplasm of uncrt behav of aortic body and oth paraganglia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6329', 'D449', 'Neoplasm of uncertain behavior of unsp endocrine gland', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6330', 'D45', 'Polycythemia vera', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6331', 'D460', 'Refractory anemia without ring sideroblasts, so stated', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6332', 'D461', 'Refractory anemia with ring sideroblasts', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6333', 'D4620', 'Refractory anemia with excess of blasts, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6334', 'D4621', 'Refractory anemia with excess of blasts 1', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6335', 'D4622', 'Refractory anemia with excess of blasts 2', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6336', 'D464', 'Refractory anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6337', 'D469', 'Myelodysplastic syndrome, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6338', 'D46A', 'Refractory cytopenia with multilineage dysplasia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6339', 'D46B', 'Refract cytopenia w multilin dysplasia and ring sideroblasts', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6340', 'D46C', 'Myelodysplastic syndrome w isolated del(5q) chromsoml abnlt', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6341', 'D46Z', 'Other myelodysplastic syndromes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6342', 'D470', 'Histiocytic and mast cell tumors of uncertain behavior', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6343', 'D4701', 'Cutaneous mastocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6344', 'D4702', 'Systemic mastocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6345', 'D4709', 'Other mast cell neoplasms of uncertain behavior', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6346', 'D471', 'Chronic myeloproliferative disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6347', 'D472', 'Monoclonal gammopathy', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6348', 'D473', 'Essential (hemorrhagic) thrombocythemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6349', 'D474', 'Osteomyelofibrosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6350', 'D479', 'Neoplm of uncrt behav of lymphoid,hematpoetc & rel tiss,unsp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6351', 'D47Z1', 'Post-transplant lymphoproliferative disorder (PTLD)', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6352', 'D47Z2', 'Castleman disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6353', 'D47Z9', 'Oth neoplm of uncrt behav of lymphoid, hematpoetc & rel tiss', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6354', 'D480', 'Neoplasm of uncertain behavior of bone/artic cartl', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6355', 'D481', 'Neoplasm of uncertain behavior of connctv/soft tiss', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6356', 'D48110', 'Desmoid tumor of head and neck', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6357', 'D48111', 'Desmoid tumor of chest wall', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6358', 'D48112', 'Desmoid tumor, intrathoracic', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6359', 'D48113', 'Desmoid tumor of abdominal wall', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6360', 'D48114', 'Desmoid tumor, intraabdominal', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6361', 'D48115', 'Desmoid tumor of upper extremity and shoulder girdle', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6362', 'D48116', 'Desmoid tumor of lower extremity and pelvic girdle', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6363', 'D48117', 'Desmoid tumor of back', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6364', 'D48118', 'Desmoid tumor of other site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6365', 'D48119', 'Desmoid tumor of unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6366', 'D4819', 'Oth neoplasm of uncertain behavior of connctv/soft tiss', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6367', 'D482', 'Neoplm of uncrt behav of prph nerves and autonm nervous sys', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6368', 'D483', 'Neoplasm of uncertain behavior of retroperitoneum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6369', 'D484', 'Neoplasm of uncertain behavior of peritoneum', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6370', 'D485', 'Neoplasm of uncertain behavior of skin', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6371', 'D4860', 'Neoplasm of uncertain behavior of unspecified breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6372', 'D4861', 'Neoplasm of uncertain behavior of right breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6373', 'D4862', 'Neoplasm of uncertain behavior of left breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6374', 'D487', 'Neoplasm of uncertain behavior of other specified sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6375', 'D489', 'Neoplasm of uncertain behavior, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6376', 'D490', 'Neoplasm of unspecified behavior of digestive system', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6377', 'D491', 'Neoplasm of unspecified behavior of respiratory system', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6378', 'D492', 'Neoplasm of unsp behavior of bone, soft tissue, and skin', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6379', 'D493', 'Neoplasm of unspecified behavior of breast', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6380', 'D494', 'Neoplasm of unspecified behavior of bladder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6381', 'D495', 'Neoplasm of unsp behavior of other genitourinary organs', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6382', 'D49511', 'Neoplasm of unspecified behavior of right kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6383', 'D49512', 'Neoplasm of unspecified behavior of left kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6384', 'D49519', 'Neoplasm of unspecified behavior of unspecified kidney', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6385', 'D4959', 'Neoplasm of unspecified behavior of other GU organ', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6386', 'D496', 'Neoplasm of unspecified behavior of brain', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6387', 'D497', 'Neoplm of unsp behav of endo glands and oth prt nervous sys', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6388', 'D4981', 'Neoplasm of unspecified behavior of retina and choroid', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6389', 'D4989', 'Neoplasm of unspecified behavior of other specified sites', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6390', 'D499', 'Neoplasm of unspecified behavior of unspecified site', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6391', 'D500', 'Iron deficiency anemia secondary to blood loss (chronic)', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6392', 'D501', 'Sideropenic dysphagia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6393', 'D508', 'Other iron deficiency anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6394', 'D509', 'Iron deficiency anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6395', 'D510', 'Vitamin B12 defic anemia due to intrinsic factor deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6396', 'D511', 'Vit B12 defic anemia d/t slctv vit B12 malabsorp w protein', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6397', 'D512', 'Transcobalamin II deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6398', 'D513', 'Other dietary vitamin B12 deficiency anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6399', 'D518', 'Other vitamin B12 deficiency anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6400', 'D519', 'Vitamin B12 deficiency anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6401', 'D520', 'Dietary folate deficiency anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6402', 'D521', 'Drug-induced folate deficiency anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6403', 'D528', 'Other folate deficiency anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6404', 'D529', 'Folate deficiency anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6405', 'D530', 'Protein deficiency anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6406', 'D531', 'Other megaloblastic anemias, not elsewhere classified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6407', 'D532', 'Scorbutic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6408', 'D538', 'Other specified nutritional anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6409', 'D539', 'Nutritional anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6410', 'D550', 'Anemia due to glucose-6-phosphate dehydrogenase deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6411', 'D551', 'Anemia due to other disorders of glutathione metabolism', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6412', 'D552', 'Anemia due to disorders of glycolytic enzymes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6413', 'D5521', 'Anemia due to pyruvate kinase deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6414', 'D5529', 'Anemia due to other disorders of glycolytic enzymes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6415', 'D553', 'Anemia due to disorders of nucleotide metabolism', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6416', 'D558', 'Other anemias due to enzyme disorders', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6417', 'D559', 'Anemia due to enzyme disorder, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6418', 'D560', 'Alpha thalassemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6419', 'D561', 'Beta thalassemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6420', 'D562', 'Delta-beta thalassemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6421', 'D563', 'Thalassemia minor', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6422', 'D564', 'Hereditary persistence of fetal hemoglobin [HPFH]', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6423', 'D565', 'Hemoglobin E-beta thalassemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6424', 'D568', 'Other thalassemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6425', 'D569', 'Thalassemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6426', 'D5700', 'Hb-SS disease with crisis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6427', 'D5701', 'Hb-SS disease with acute chest syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6428', 'D5702', 'Hb-SS disease with splenic sequestration', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6429', 'D5703', 'Hb-SS disease with cerebral vascular involvement', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6430', 'D5704', 'Hb-SS disease with dactylitis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6431', 'D5709', 'Hb-SS disease with crisis with other specified complication', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6432', 'D571', 'Sickle-cell disease without crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6433', 'D5720', 'Sickle-cell/Hb-C disease without crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6434', 'D57211', 'Sickle-cell/Hb-C disease with acute chest syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6435', 'D57212', 'Sickle-cell/Hb-C disease with splenic sequestration', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6436', 'D57213', 'Sickle-cell/Hb-C disease with cerebral vascular involvement', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6437', 'D57214', 'Sickle-cell/Hb-C disease with dactylitis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6438', 'D57218', 'Sickle-cell/Hb-C disease with crisis with oth complication', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6439', 'D57219', 'Sickle-cell/Hb-C disease with crisis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6440', 'D573', 'Sickle-cell trait', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6441', 'D5740', 'Sickle-cell thalassemia without crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6442', 'D5741', 'Sickle-cell thalassemia, unspecified, with crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6443', 'D57411', 'Sickle-cell thalassemia, unsp, with acute chest syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6444', 'D57412', 'Sickle-cell thalassemia, unsp, with splenic sequestration', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6445', 'D57413', 'Sickle-cell thalassemia, unsp, with cerebral vascular invl', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6446', 'D57414', 'Sickle-cell thalassemia, unspecified, with dactylitis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6447', 'D57418', 'Sickle-cell thalassemia, unsp, with crisis with oth comp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6448', 'D57419', 'Sickle-cell thalassemia, unspecified, with crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6449', 'D5742', 'Sickle-cell thalassemia beta zero without crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6450', 'D57431', 'Sickle-cell thalassemia beta zero with acute chest syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6451', 'D57432', 'Sickle-cell thalassemia beta zero with splenic sequestration', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6452', 'D57433', 'Sickle-cell thalassemia beta zero with cereb vascular invl', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6453', 'D57434', 'Sickle-cell thalassemia beta zero with dactylitis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6454', 'D57438', 'Sickle-cell thalassemia beta zero with crisis with oth comp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6455', 'D57439', 'Sickle-cell thalassemia beta zero with crisis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6456', 'D5744', 'Sickle-cell thalassemia beta plus without crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6457', 'D57451', 'Sickle-cell thalassemia beta plus with acute chest syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6458', 'D57452', 'Sickle-cell thalassemia beta plus with splenic sequestration', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6459', 'D57453', 'Sickle-cell thalassemia beta plus with cereb vascular invl', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6460', 'D57454', 'Sickle-cell thalassemia beta plus with dactylitis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6461', 'D57458', 'Sickle-cell thalassemia beta plus with crisis with oth comp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6462', 'D57459', 'Sickle-cell thalassemia beta plus with crisis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6463', 'D5780', 'Other sickle-cell disorders without crisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6464', 'D57811', 'Other sickle-cell disorders with acute chest syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6465', 'D57812', 'Other sickle-cell disorders with splenic sequestration', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6466', 'D57813', 'Other sickle-cell disorders with cerebral vascular invl', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6467', 'D57814', 'Other sickle-cell disorders with dactylitis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6468', 'D57818', 'Other sickle-cell disorders with crisis with oth comp', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6469', 'D57819', 'Other sickle-cell disorders with crisis, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6470', 'D580', 'Hereditary spherocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6471', 'D581', 'Hereditary elliptocytosis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6472', 'D582', 'Other hemoglobinopathies', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6473', 'D588', 'Other specified hereditary hemolytic anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6474', 'D589', 'Hereditary hemolytic anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6475', 'D590', 'Drug-induced autoimmune hemolytic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6476', 'D591', 'Other autoimmune hemolytic anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6477', 'D5910', 'Autoimmune hemolytic anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6478', 'D5911', 'Warm autoimmune hemolytic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6479', 'D5912', 'Cold autoimmune hemolytic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6480', 'D5913', 'Mixed type autoimmune hemolytic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6481', 'D5919', 'Other autoimmune hemolytic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6482', 'D592', 'Drug-induced nonautoimmune hemolytic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6483', 'D593', 'Hemolytic-uremic syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6484', 'D5930', 'Hemolytic-uremic syndrome, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6485', 'D5931', 'Infection-associated hemolytic-uremic syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6486', 'D5932', 'Hereditary hemolytic-uremic syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6487', 'D5939', 'Other hemolytic-uremic syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6488', 'D594', 'Other nonautoimmune hemolytic anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6489', 'D595', 'Paroxysmal nocturnal hemoglobinuria [Marchiafava-Micheli]', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6490', 'D596', 'Hemoglobinuria due to hemolysis from other external causes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6491', 'D598', 'Other acquired hemolytic anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6492', 'D599', 'Acquired hemolytic anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6493', 'D600', 'Chronic acquired pure red cell aplasia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6494', 'D601', 'Transient acquired pure red cell aplasia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6495', 'D608', 'Other acquired pure red cell aplasias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6496', 'D609', 'Acquired pure red cell aplasia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6497', 'D6101', 'Constitutional (pure) red blood cell aplasia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6498', 'D6102', 'Shwachman-Diamond syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6499', 'D6103', 'Fanconi anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6500', 'D6109', 'Other constitutional aplastic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6501', 'D611', 'Drug-induced aplastic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6502', 'D612', 'Aplastic anemia due to other external agents', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6503', 'D613', 'Idiopathic aplastic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6504', 'D61810', 'Antineoplastic chemotherapy induced pancytopenia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6505', 'D61811', 'Other drug-induced pancytopenia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6506', 'D61818', 'Other pancytopenia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6507', 'D6182', 'Myelophthisis', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6508', 'D6189', 'Oth aplastic anemias and other bone marrow failure syndromes', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6509', 'D619', 'Aplastic anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6510', 'D62', 'Acute posthemorrhagic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6511', 'D630', 'Anemia in neoplastic disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6512', 'D631', 'Anemia in chronic kidney disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6513', 'D638', 'Anemia in other chronic diseases classified elsewhere', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6514', 'D640', 'Hereditary sideroblastic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6515', 'D641', 'Secondary sideroblastic anemia due to disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6516', 'D642', 'Secondary sideroblastic anemia due to drugs and toxins', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6517', 'D643', 'Other sideroblastic anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6518', 'D644', 'Congenital dyserythropoietic anemia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6519', 'D6481', 'Anemia due to antineoplastic chemotherapy', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6520', 'D6489', 'Other specified anemias', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6521', 'D649', 'Anemia, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6522', 'D65', 'Disseminated intravascular coagulation', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6523', 'D66', 'Hereditary factor VIII deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6524', 'D67', 'Hereditary factor IX deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6525', 'D680', 'Von Willebrand\'s disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6526', 'D6800', 'Von Willebrand disease, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6527', 'D6801', 'Von Willebrand disease, type 1', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6528', 'D68020', 'Von Willebrand disease, type 2A', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6529', 'D68021', 'Von Willebrand disease, type 2B', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6530', 'D68022', 'Von Willebrand disease, type 2M', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6531', 'D68023', 'Von Willebrand disease, type 2N', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6532', 'D68029', 'Von Willebrand disease, type 2, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6533', 'D6803', 'Von Willebrand disease, type 3', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6534', 'D6804', 'Acquired von Willebrand disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6535', 'D6809', 'Other von Willebrand disease', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6536', 'D681', 'Hereditary factor XI deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6537', 'D682', 'Hereditary deficiency of other clotting factors', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6538', 'D68311', 'Acquired hemophilia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6539', 'D68312', 'Antiphospholipid antibody with hemorrhagic disorder', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6540', 'D68318', 'Oth hemorrhagic disord d/t intrns circ anticoag,antib,inhib', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6541', 'D6832', 'Hemorrhagic disord d/t extrinsic circulating anticoagulants', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6542', 'D684', 'Acquired coagulation factor deficiency', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6543', 'D6851', 'Activated protein C resistance', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6544', 'D6852', 'Prothrombin gene mutation', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6545', 'D6859', 'Other primary thrombophilia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6546', 'D6861', 'Antiphospholipid syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6547', 'D6862', 'Lupus anticoagulant syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6548', 'D6869', 'Other thrombophilia', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6549', 'D688', 'Other specified coagulation defects', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6550', 'D689', 'Coagulation defect, unspecified', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6551', 'D690', 'Allergic purpura', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6552', 'D691', 'Qualitative platelet defects', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6553', 'D692', 'Other nonthrombocytopenic purpura', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6554', 'D693', 'Immune thrombocytopenic purpura', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL),
('6555', 'D6941', 'Evans syndrome', NULL, NULL, '1', '1', '2025-01-16 19:59:34', NULL, NULL);


INSERT INTO `insurer` VALUES
('1', 'Madison Insurance'),
('2', 'AAR Insurance');

INSERT INTO `insuring_rates` VALUES
('2', 'Rate 2 AAR', '18', '1000000.00', 'M', '5000.00', '0', '1', '1', '3'),
('3', 'Rate 3 AAR', '2', '100000.00', '0', '5000.00', '0', '1', '2', '3'),
('4', 'Rate 1 SSL', '2', '100000.00', '0', '5000.00', '0', '1', '2', '4'),
('5', 'Rate 2 SSL', '1', '1000000.00', '2', '5500.00', '0', '1', '2', '4'),
('6', 'HSJUTLEY', '1', '1000000.00', '1', '26754.00', '0', '1', '2', '7'),
('7', 'Tester', '2', '500000.00', '0', '15000.00', '0', '1', '1', '7'),
('8', 'Tester 2', '18', '50000.00', 'M', '5000.00', '0', '1', '1', '8'),
('9', 'Rate', '1', '1500000.00', 'M', '23164.00', '0', '1', '1', '8'),
('10', 'Rate', '2', '150000.00', 'M', '15690.00', '0', '1', '1', '8'),
('11', 'Rate', '3', '100000.00', 'M', '21387.00', '0', '1', '1', '8'),
('12', 'Rate', '1', '2000000.00', 'M', '28764.00', '0', '1', '1', '8'),
('13', 'Rate', '2', '200000.00', 'M', '23690.00', '0', '1', '1', '8'),
('14', 'Rate', '3', '150000.00', 'M', '29387.00', '0', '1', '1', '8'),
('15', 'Rate', '1', '2500000.00', 'M + 1', '36789.00', '0', '1', '1', '8'),
('16', 'Rate', '2', '250000.00', 'M + 1', '31690.00', '0', '1', '1', '8'),
('17', 'Rate', '3', '200000.00', 'M + 1', '37689.00', '0', '1', '1', '8');

INSERT INTO `liability_limits` VALUES
('5', '3', '3', '5000.00', '', '1', '2025-01-21 09:03:12', '1', '2025-01-21 09:03:12');

INSERT INTO `member_anniversary` VALUES
('PTL-001-00', '2024-11-11', '2025-11-10', '2025-11-11', '1', '1', '0000-00-00', '0', '0', NULL, '0', NULL, NULL, '3'),
('PTL-002-00', '2024-11-11', '2025-11-10', '2025-11-11', '99', '1', '0000-00-00', '0', '0', NULL, '0', NULL, NULL, '3'),
('RI-001-00', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, '0', NULL, NULL, '8'),
('RI-002-00', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, '0', NULL, NULL, '8'),
('RI-002-01', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, '0', NULL, NULL, '8'),
('RI-003-00', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, '0', NULL, NULL, '8'),
('RI-003-01', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, '0', NULL, NULL, '8'),
('RI-004-00', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, NULL, NULL, NULL, '8'),
('RI-005-00', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, NULL, NULL, NULL, '8'),
('RI-005-01', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, NULL, NULL, NULL, '8'),
('RI-006-00', '2024-12-01', '2025-11-30', '2025-12-01', '1', '1', '0000-00-00', '0', '0', NULL, NULL, NULL, NULL, '8'),
('SHL-001-00', '2025-01-12', '2026-01-11', '2026-01-12', '1', '1', '2025-01-13', '0', '0', NULL, '0', NULL, NULL, '5'),
('SHL-002-00', '2025-01-12', '2026-01-11', '2026-01-12', '1', '1', '2025-01-13', '0', '0', NULL, '0', NULL, NULL, '5'),
('SHL-003-00', '2025-01-12', '2026-01-11', '2026-01-12', '1', '1', '2025-01-13', '0', '0', NULL, '0', NULL, NULL, '5');

INSERT INTO `member_benefits` VALUES
('PTL-001-00', '1', '1000000.00', '0', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'IP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '3'),
('PTL-001-00', '2', '100000.00', '0', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '3'),
('PTL-002-00', '1', '1000000.00', '0', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'IP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '3'),
('PTL-002-00', '2', '100000.00', '0', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '3'),
('RI-001-00', '1', '2000000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-001-00', '2', '150000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-002-00', '1', '2500000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-002-00', '2', '200000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-002-01', '1', '2500000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-002-01', '2', '200000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-003-00', '1', '1500000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-003-00', '2', '100000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-003-01', '1', '1500000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-003-01', '2', '100000.00', '1', '1', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'CAT B', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-003-01', '3', '100000.00', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Maternity', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8'),
('RI-004-00', '1', '1000000.00', '1', '1', '0', NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '1000000.00', '0.00', '1', NULL, NULL, '0', NULL, NULL, '0', '0', 'CAT A', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-004-00', '2', '100000.00', '1', '1', '0', NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '100000.00', '0.00', '1', NULL, NULL, '0', NULL, NULL, '0', '0', 'CAT A', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-005-00', '1', '1500000.00', '1', '1', '0', NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '1500000.00', '0.00', '1', NULL, NULL, '0', NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-005-00', '2', '150000.00', '1', '1', '0', NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '150000.00', '0.00', '1', NULL, NULL, '0', NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-005-00', '3', '100000.00', '0', '1', '0', NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '100000.00', '0.00', '1', NULL, NULL, '0', NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-005-01', '1', '1500000.00', '1', '1', '0', NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '1500000.00', '0.00', '1', NULL, NULL, '0', NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-005-01', '2', '150000.00', '1', '1', '0', NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '150000.00', '0.00', '1', NULL, NULL, '0', NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-006-00', '1', '1500000.00', '1', '1', NULL, NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '1500000.00', '0.00', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-006-00', '2', '150000.00', '1', '1', NULL, NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '150000.00', '0.00', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('RI-006-00', '3', '100000.00', '0', '1', NULL, NULL, '0', NULL, NULL, NULL, NULL, '0.00', '0.00', '0.00', '100000.00', '0.00', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', 'CAT B', NULL, '0.00', NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, '8'),
('SHL-001-00', '1', '1000000.00', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'IP', NULL, NULL, NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '5'),
('SHL-001-00', '2', '500000.00', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OP', NULL, NULL, NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '5'),
('SHL-002-00', '1', '1000000.00', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'IP', NULL, NULL, NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '5'),
('SHL-002-00', '2', '500000.00', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OP', NULL, NULL, NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '5'),
('SHL-003-00', '1', '1000000.00', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'IP', NULL, NULL, NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '5'),
('SHL-003-00', '2', '500000.00', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'OP', NULL, NULL, NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '5');

INSERT INTO `member_cancellation` VALUES
('PTL-001-00', '0', '2025-01-17', NULL, '0', '1', '2025-01-17', NULL, NULL, NULL),
('PTL-001-00', '0', '2025-01-18', NULL, '3', '1', '2025-01-18', NULL, NULL, NULL),
('PTL-001-00', '1', '2025-01-18', NULL, '3', '1', '2025-01-18', NULL, NULL, NULL),
('RI-003-01', '0', '2025-04-30', NULL, '3', '1', '2025-04-30', NULL, NULL, NULL),
('RI-003-01', '0', '2025-05-25', NULL, '3', '1', '2025-05-25', NULL, NULL, NULL),
('RI-003-01', '1', '2025-04-29', NULL, '0', '1', '2025-04-29', NULL, NULL, NULL),
('RI-003-01', '1', '2025-04-30', NULL, '0', '1', '2025-04-30', NULL, NULL, NULL);




INSERT INTO `member_info` VALUES
('PTL-001', 'PTL-001-00', 'Nujoma', 'Sam', '', '1990-03-21', '', NULL, '1', NULL, NULL, NULL, '0', NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '3', NULL, NULL, '0', '0', '0', NULL, '1', NULL, NULL, '0', NULL),
('PTL-001', 'PTL-001-01', '', 'What', 'is my name', '1992-09-07', '', NULL, '0', NULL, NULL, NULL, '0', NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '3', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, '0', NULL),
('RI-001', 'RI-001-00', 'Aurelius', 'Commodus', '', '1980-06-18', '123456678', NULL, '1', NULL, NULL, NULL, '0', NULL, '1', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, '0', NULL),
('RI-002', 'RI-002-00', 'Antoninus', 'Marcus', 'Aurelius', '1960-03-17', '1234566789', NULL, '1', NULL, NULL, NULL, '0', NULL, '1', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, '0', NULL),
('RI-002', 'RI-002-01', 'Galeria', 'Annia', 'Faustina Minor', '1970-01-01', '', NULL, '2', NULL, '2025-04-15', NULL, '0', NULL, '2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, '55', NULL),
('RI-003', 'RI-003-00', 'Test', 'Test', '', '1990-03-21', '', NULL, '1', NULL, NULL, NULL, '0', NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, '0', NULL),
('RI-003', 'RI-003-01', 'Sally', 'H', 'Wally', '1998-03-01', '', NULL, '2', NULL, '2025-04-16', NULL, '0', NULL, '2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, '27', NULL),
('RI-004', 'RI-004-00', 'Daniel', 'Sanny', '', '1990-04-21', '0', NULL, '1', '1', '2025-05-26', '1', '0', '', '1', NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0000-00-00', '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, 'M', 'A003457047H', NULL, '35', NULL),
('RI-005', 'RI-005-00', 'Toby', 'Mwani', '', '1998-01-01', '0', NULL, '1', '1', '2025-05-26', '1', '0', '', '1', NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0000-00-00', '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, 'M + 1', 'A003457047Z', NULL, '27', NULL),
('RI-005', 'RI-005-01', 'Mwani', 'Sandy', '', '2000-01-01', '0', NULL, '2', '1', '2025-05-26', '2', '0', '', '2', NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0000-00-00', '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, 'M + 1', '', NULL, '25', NULL),
('RI-006', 'RI-006-00', 'Sonal', 'Anita', '', '1997-01-01', '123456678', NULL, '1', '1', '2025-05-26', '1', '0', '', '2', NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0000-00-00', '1', NULL, NULL, NULL, '8', NULL, NULL, '0', '0', '0', NULL, 'M', 'A103457047T', NULL, '28', NULL),
('SHL-001', 'SHL-001-00', 'Doe', 'John', NULL, '1990-01-15', NULL, NULL, '1', '1', '2025-01-13', NULL, '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '5', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL),
('SHL-001', 'SHL-002-00', 'Doe', 'Jane', NULL, '1992-03-20', NULL, NULL, '2', '1', '2025-01-13', NULL, '0', '0', '2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '5', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL),
('SHL-001', 'SHL-003-00', 'Doe', 'James', NULL, '2015-06-10', NULL, NULL, '3', '1', '2025-01-13', NULL, '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '5', NULL, NULL, '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL);

INSERT INTO `member_interventions` VALUES
('1', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-01-27 18:15:27', NULL, NULL, NULL),
('2', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-01-27 18:16:08', NULL, NULL, NULL),
('3', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-01-27 18:16:14', NULL, NULL, NULL),
('4', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-01-29 17:18:58', NULL, NULL, NULL),
('5', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-01-29 17:19:07', NULL, NULL, NULL),
('6', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-01-31 14:40:30', NULL, NULL, NULL),
('7', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-01-31 14:41:29', NULL, NULL, NULL),
('8', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-02-11 06:39:29', NULL, NULL, NULL),
('9', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-02-11 06:39:34', NULL, NULL, NULL),
('10', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-02-13 16:40:56', NULL, NULL, NULL),
('11', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-02-13 16:41:02', NULL, NULL, NULL),
('12', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-02-13 16:41:03', NULL, NULL, NULL),
('13', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-03-15 16:08:58', NULL, NULL, NULL),
('14', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-04-02 16:15:10', NULL, NULL, NULL),
('15', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-04-02 16:15:18', NULL, NULL, NULL),
('16', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-04-02 16:15:19', NULL, NULL, NULL),
('17', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-05-15 17:05:01', NULL, NULL, NULL),
('18', 'RI-006-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-05-26 11:19:34', NULL, NULL, NULL),
('19', 'PTL-001-00', 'LIFESTYLE', 'MEDIUM', 'Increase physical activity', 'Join wellness program for guided exercise', 'PENDING', '2025-05-26 11:20:02', NULL, NULL, NULL);


INSERT INTO `member_risk_scores` VALUES
('1', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-27 18:15:27'),
('2', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-27 18:15:27'),
('3', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-27 18:16:08'),
('4', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-27 18:16:08'),
('5', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-27 18:16:14'),
('6', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-27 18:16:14'),
('7', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-29 17:18:58'),
('8', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-29 17:18:58'),
('9', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-29 17:19:07'),
('10', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-29 17:19:07'),
('11', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-31 14:40:30'),
('12', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-31 14:40:30'),
('13', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-31 14:41:29'),
('14', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-01-31 14:41:29'),
('15', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-11 06:39:29'),
('16', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-11 06:39:29'),
('17', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-11 06:39:34'),
('18', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-11 06:39:34'),
('19', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-13 16:40:56'),
('20', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-13 16:40:56'),
('21', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-13 16:41:02'),
('22', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-13 16:41:02'),
('23', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-13 16:41:03'),
('24', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-02-13 16:41:03'),
('25', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-03-15 16:08:58'),
('26', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-03-15 16:08:58'),
('27', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-04-02 16:15:10'),
('28', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-04-02 16:15:10'),
('29', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-04-02 16:15:18'),
('30', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-04-02 16:15:18'),
('31', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-04-02 16:15:19'),
('32', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-04-02 16:15:19'),
('33', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-05-15 17:05:01'),
('34', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-05-15 17:05:01'),
('35', 'RI-006-00', '1.20', '1.00', '3.00', '1.00', '3.00', '1.00', '1.00', '2025-05-26 11:19:34'),
('36', 'RI-006-00', '1.20', '1.00', '3.00', '1.00', '3.00', '1.00', '1.00', '2025-05-26 11:19:34'),
('37', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-05-26 11:20:02'),
('38', 'PTL-001-00', '1.35', '2.00', '3.00', '1.00', '3.00', '1.00', '5.00', '2025-05-26 11:20:02');


INSERT INTO `menu_items` VALUES
('1', NULL, 'Dashboard', 'index.php', 'ri-dashboard-2-line', '1', '1'),
('2', NULL, 'Corporate Management', NULL, 'ri-building-2-line', '2', '1'),
('3', NULL, 'Member Management', NULL, 'ri-pass-valid-line', '3', '1'),
('4', NULL, 'Bills Management', NULL, 'ri-stack-line', '4', '1'),
('5', NULL, 'Finance Management', NULL, 'ri-stack-line', '5', '1'),
('6', NULL, 'General Settings', NULL, 'ri-account-circle-line', '6', '1'),
('7', '2', 'Corporate List', 'all_corporates.php', NULL, '1', '1'),
('8', '2', 'Add New Corporate', 'add_new_corporate.php', NULL, '2', '1'),
('9', '2', 'Query Corporates', 'query_corporate.php', NULL, '3', '1'),
('10', '2', 'Corporate Groups', 'corp_groups.php', NULL, '4', '1'),
('11', '2', 'Corporate Fund', 'fund_management.php', NULL, '5', '1'),
('12', '2', 'Annual Renewal', 'corp_renewal.php', NULL, '6', '1'),
('13', '2', 'Corporate Reports', 'corporate_reports.php', 'ri-file-chart-line', '7', '1'),
('14', '2', 'Annual Renewal Statement', 'annual_renewal_statement.php', NULL, '8', '1'),
('15', '2', 'Quotations', 'quotation.php', NULL, '9', '1'),
('16', '2', 'Comparison Quotation', 'generate_comparison_quote.php', NULL, '10', '1'),
('17', '2', 'All Quotations', 'quotations_list.php', NULL, '11', '1'),
('18', '2', 'Policy Search', 'policy_search.php', NULL, '12', '1'),
('19', '3', 'Membership List', 'all_members.php', NULL, '1', '1'),
('20', '3', 'Add New Member', 'add_new_member.php', NULL, '2', '1'),
('21', '3', 'Add Dependent', 'add_dependent.php', NULL, '3', '1'),
('22', '3', 'Import Member(s)', 'member_importation.php', NULL, '4', '1'),
('24', '3', 'Query Member(s)', 'query_member.php', NULL, '6', '1'),
('25', '3', 'Annual Member Renewal', 'member_renewal.php', NULL, '7', '1'),
('26', '3', 'Membership Reports', 'membership_reports.php', 'ri-file-chart-line', '8', '1'),
('27', '3', 'Policy Documents', 'policy_generator.php', NULL, '9', '1'),
('28', '4', 'Claims List', 'all_claims.php', NULL, '1', '1'),
('29', '4', 'Add New Claim', 'create_claim.php', NULL, '2', '1'),
('30', '4', 'New Reimbursement Claim', 'create_reimbursement.php', NULL, '3', '1'),
('31', '4', 'Vet Claim(s)', 'vet_invoice.php', NULL, '4', '1'),
('32', '4', 'Claims Payment', 'bills_payment.php', NULL, '5', '1'),
('33', '4', 'Query Claim(s)', 'query_claim.php', NULL, '6', '1'),
('34', '4', 'Import Claim(s)', 'bills_import.php', NULL, '7', '1'),
('35', '4', 'Import Reimburse Claim(s)', 'bills_import.php', NULL, '8', '1'),
('36', '4', 'All Reimbursement Claim(s)', 'view_reimbursement.php', NULL, '9', '1'),
('37', '4', 'All Draft Claim(s)', 'view_draft_claims.php', NULL, '10', '1'),
('38', '4', 'View Claim Status', 'view_claim_status.php', NULL, '11', '1'),
('39', '4', 'Claim Reversal', 'reverse_claim.php', NULL, '12', '1'),
('40', '4', 'Pre-Auth', 'preauth.php', NULL, '13', '1'),
('41', '4', 'All Pre-Auths', 'all_preauth.php', NULL, '14', '1'),
('42', '4', 'Bills Recon', 'bills_recon.php', NULL, '15', '1'),
('43', '4', 'Bill Reports', 'bills_report.php', 'ri-funds-box-line', '16', '1'),
('44', '5', 'Debits List', 'view_debits.php', NULL, '1', '1'),
('45', '5', 'Add New Debit', 'add_new_premium.php', NULL, '2', '1'),
('46', '5', 'Add New Credit Note', 'add_new_credit_note.php', NULL, '3', '1'),
('47', '5', 'Add Receipt(s)', 'add_receipt.php', NULL, '4', '1'),
('48', '5', 'View Receipt(s)', 'view_receipts.php', NULL, '5', '1'),
('49', '5', 'Create Commission(s)', 'calculate_commissions.php', NULL, '6', '1'),
('50', '5', 'View Commissions', 'view_all_commissions.php', NULL, '7', '1'),
('51', '5', 'Underwriter Recon', 'underwriter_debit_recon.php', NULL, '8', '1'),
('52', '5', 'Finance Report', 'finance_reports.php', 'ri-funds-box-line', '9', '1'),
('53', '5', 'Financial Ledgers', 'financial_ledgers.php', NULL, '10', '1'),
('54', '6', 'General Settings', 'settings.php', NULL, '1', '1'),
('55', '6', 'Notification Settings', 'notification_settings.php', NULL, '2', '1'),
('56', '6', 'Auto Debit Generator', 'premium_generator.php', NULL, '3', '1'),
('57', '6', 'Fund Configuration', 'fund_config.php', NULL, '4', '1'),
('58', '6', 'EDI Management', 'edi_management.php', NULL, '5', '1'),
('59', '6', 'EDI Operations', 'edi_operations.php', NULL, '6', '1'),
('60', '6', 'Tax Settings', 'tax_settings.php', NULL, '7', '1'),
('61', '6', 'Bank Settings', 'banks.php', NULL, '8', '1'),
('62', '6', 'User Management', 'users.php', NULL, '9', '1'),
('63', '6', 'User Permissions', 'role_permissions.php', NULL, '10', '1'),
('64', '6', 'Manage Menu Items', 'manage_menu_items.php', NULL, '11', '1'),
('65', '6', 'Backup & Restore', 'backup.php', 'ri-database-2-line', '12', '1'),
('66', '6', 'Add Selection Items', 'add_selection.php', NULL, '13', '1'),
('67', '6', 'Corporate Categories', 'corp_groups.php', NULL, '14', '1'),
('68', '6', 'Corporate Benefits', 'create_benefits.php', NULL, '15', '1'),
('69', '6', 'Corporate Policy', 'scheme_policy.php', NULL, '16', '1'),
('70', '6', 'Provider Creation', 'providers.php', NULL, '17', '1'),
('71', '6', 'Liability Limits', 'liability_limits.php', NULL, '18', '1'),
('72', '6', 'Credit Note Rules', 'credit_note_rules.php', NULL, '19', '1'),
('73', '6', 'Payment Plans', 'payment_plans.php', NULL, '20', '1'),
('74', '6', 'Policy Renewal', 'policy_renewal.php', NULL, '21', '1'),
('75', '6', 'ICD10 Management', 'icd10_management.php', NULL, '22', '1'),
('76', '6', 'Add Rate Sheet', 'add_rate_sheet.php', NULL, '23', '1'),
('78', '6', 'System Updates', 'system_update.php', 'ri-database-2-line', '24', '1'),
('79', '5', 'Financial Analytics', 'financial_analytics.php', '', '1', '1'),
('80', '4', 'Claims Analytics', 'claims_analytics.php', 'ri-funds-box-line', '0', '1'),
('81', '3', 'Member Risk Profile', 'member_risk_profile.php', '', '0', '1'),
('82', '4', 'View Pre Auths', 'view_pre_auth.php', '', '10', '1'),
('83', '3', 'Member Benefits', 'member_benefits.php', '', '5', '1'),
('84', '6', 'Manage Updates', 'manage_updates.php', '', '25', '1'),
('85', '2', 'Claims Experience', 'claims_experience_rpt.php', '', '13', '1'),
('87', '5', 'Sales Dashboard', 'sales_dashboard.php', '', '0', '1'),
('88', '5', 'Leads Dashboard', 'lead_dashboard.php', '', '0', '1'),
('89', '5', 'Quotes Management', 'quotes.php', '', '0', '1'),
('90', '2', 'Custom Reports', 'run_report.php', '', '0', '1'),
('91', '6', 'Data Migration', 'data_sources.php', '', '0', '1'),
('94', NULL, 'Agent Management', NULL, 'ri-team-line', '0', '1'),
('96', '94', 'All Agents', 'agents.php', '', '0', '1'),
('97', '4', 'View Payment Vouchers', 'view_payment_voucher.php', '', '0', '1'),
('98', '2', 'Corporate Dashboard', 'corp_dash.php', '', '0', '1'),
('99', '3', 'Membership Dashboard', 'mem_dash.php', '', '0', '1');



INSERT INTO `notification_templates` VALUES
('1', 'BIRTHDAY_REMINDER', 'Member Birthday Reminder', 'Birthday Reminder: {member_name}', 'Dear {member_name},\n\nHappy Birthday! We wish you a wonderful day filled with joy and good health.\n\nBest regards,\n{company_name}', 'Happy Birthday {member_name}! Best wishes from {company_name}', '0', '1', '2025-01-17 18:40:39', NULL),
('2', 'SCHEME_RENEWAL', 'Scheme Renewal Reminder', 'Scheme Renewal Reminder: {corporate_name}', 'Dear {recipient_name},\n\nThis is a reminder that the insurance scheme for {corporate_name} is due for renewal on {renewal_date}.\n\nPlease initiate the renewal process to ensure continued coverage.\n\nBest regards,\n{company_name}', 'Reminder: Insurance scheme renewal for {corporate_name} is due on {renewal_date}', '30', '1', '2025-01-17 18:40:39', NULL),
('3', 'PENDING_DEBIT', 'Pending Debit Notification', 'Pending Debit Notice: {debit_no}', 'Dear {recipient_name},\n\nThis is to notify you of a pending debit note {debit_no} for {corporate_name} with amount {amount}.\n\nPlease review and process accordingly.\n\nBest regards,\n{company_name}', 'Pending debit {debit_no} for {corporate_name}: {amount}', '0', '1', '2025-01-17 18:40:39', NULL);


INSERT INTO `password_resets` VALUES
('10', '19', '063dfa36eeafe792fe201bd20b86bc28e747264719995105554aa68a45e5f4bf', '2025-01-28 07:57:47', '2025-01-28 09:57:47', NULL, NULL),
('11', '19', 'fbdc7fec09522f0beee9eb6e32201fde09b58dac6397db7e85d9caf7c4c6b3d7', '2025-01-28 08:04:47', '2025-01-28 10:04:47', NULL, NULL),
('12', '19', '7b194a2a1e37258c3e876be65f3e5e957e8ded6ee3f3f216a02c37253aefa6b8', '2025-01-28 08:29:50', '2025-01-28 10:29:50', NULL, NULL),
('13', '19', '22eee43554fc7353c209090567f75c3625788f13e6854ed8d0cbc2a9d53a1981', '2025-01-28 08:57:13', '2025-01-28 10:57:13', NULL, NULL),
('14', '19', 'a04b93885c966480b1c538f4e1e23c69b8a803fb1bdc98f64fddef434cce7d3e', '2025-01-28 09:04:25', '2025-01-28 12:04:25', NULL, NULL);

INSERT INTO `payment_credits` VALUES
('3', 'RCP0000003', '3', '4875.00', '1', '2025-01-15 13:22:55', 'ACTIVE');




INSERT INTO `payment_voucher_items` VALUES
('1', '1', 'CLM-0000004', '56554', 'Payment for claim CLM-0000004 / Invoice 56554', '4560.00'),
('2', '2', 'CLM-0000010', 'SHL003', 'Payment for claim CLM-0000010 / Invoice SHL003', '5000.00'),
('3', '3', 'CLM-0000006', 'INVT234', 'Payment for claim CLM-0000006 / Invoice INVT234', '2000.00'),
('4', '4', 'RMB-000002', 'RMB-000002-02', 'Payment for claim RMB-000002 / Invoice RMB-000002-02', '1500.00'),
('5', '4', 'RMB-000002', 'RMB-000002-02', 'Payment for claim RMB-000002 / Invoice RMB-000002-02', '1500.00'),
('6', '5', 'CLM-0000009', 'AK001S', 'Payment for claim CLM-0000009 / Invoice AK001S', '1500.00'),
('7', '6', 'RMB-000001', 'RMB-000001-02', 'Payment for claim RMB-000001 / Invoice RMB-000001-02', '2500.00'),
('8', '7', 'CLM-0000005', 'INV45', 'Payment for claim CLM-0000005 / Invoice INV45', '1500.00'),
('9', '8', 'CLM-0000004', '55354er', 'Payment for claim CLM-0000004 / Invoice 55354er', '200000.00'),
('10', '8', 'CLM-0000007', 'INVTY67', 'Payment for claim CLM-0000007 / Invoice INVTY67', '4000.00');

INSERT INTO `payment_vouchers` VALUES
('1', 'VCH-20250003', '20250003', '2025-01-18', 'PROVIDER', '1', 'Aga Khan University Hospital', '4560.00', 'POSTED', '1', '2025-01-18 07:44:21'),
('2', 'VCH-20250004', '20250004', '2025-01-23', 'PROVIDER', '1', 'Aga Khan University Hospital', '5000.00', 'POSTED', '1', '2025-01-23 11:08:51'),
('3', 'VCH-20250005', '20250005', '2025-01-31', 'PROVIDER', '1', 'Aga Khan University Hospital', '2000.00', 'POSTED', '1', '2025-01-31 15:04:01'),
('4', 'VCH-20250006', '20250006', '2025-04-12', 'PROVIDER', '5', 'Metropolitan Hospital', '3000.00', 'POSTED', '1', '2025-04-12 17:14:26'),
('5', 'VCH-20250007', '20250007', '2025-04-15', 'PROVIDER', '1', 'Aga Khan University Hospital', '1500.00', 'POSTED', '1', '2025-04-15 21:30:00'),
('6', 'VCH-20250008', '20250008', '2025-04-15', 'PROVIDER', '1', 'Aga Khan University Hospital', '2500.00', 'POSTED', '1', '2025-04-15 21:30:38'),
('7', 'VCH-20250009', '20250009', '2025-04-29', 'PROVIDER', '1', 'Aga Khan University Hospital', '1500.00', 'POSTED', '1', '2025-04-29 19:02:19'),
('8', 'VCH-20250010', '20250010', '2025-05-25', 'PROVIDER', '1', 'Aga Khan University Hospital', '204000.00', 'POSTED', '1', '2025-05-25 08:29:12');

INSERT INTO `pre_authorization` VALUES
('1', 'PTL-001-00', '1', '2024-12-24', 'Admin', NULL, NULL, 'pre auth test', '2', '1', '96750.00', '2', '20000.00', '0', NULL, '1', 'Dr. Sally', '2024-12-24', 'PTL-001', 'PA000001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ACTIVE'),
('2', 'PTL-001-00', '1', '2024-12-29', 'Admin', NULL, NULL, 'Testing new preauth', '1', '1', '993940.00', '3', '10000.00', '0', NULL, '1', '0', '2024-12-29', 'PTL-001', 'PA000002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ACTIVE'),
('3', 'PTL-001-00', '1', '2025-02-01', 'Admin', NULL, NULL, 'Test', '2', '1', '65300.00', '3', '5000.00', '0', NULL, '1', 'Dr. Sally', '2025-02-01', 'PTL-001', 'PA000003', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ACTIVE');



INSERT INTO `premium_debit_items` VALUES
('6', '5', '2', 'PTL-001-00', '5062.50', NULL),
('7', '5', '1', 'PTL-001-00', '5062.50', NULL),
('8', '6', '2', 'PTL-001-00', '5062.50', NULL),
('9', '6', '1', 'PTL-001-00', '5062.50', NULL),
('10', '7', '2', 'PTL-001-00', '4154.32', NULL),
('11', '7', '1', 'PTL-001-00', '4154.32', NULL),
('12', '8', '1', 'RI-001-00', '28933.44', NULL),
('13', '8', '2', 'RI-001-00', '15800.61', NULL),
('14', '8', '1', 'RI-002-00', '36994.55', NULL),
('15', '8', '2', 'RI-002-00', '23836.61', NULL),
('16', '8', '1', 'RI-002-01', '36994.55', NULL),
('17', '8', '2', 'RI-002-01', '23836.61', NULL),
('18', '8', '1', 'RI-003-00', '23308.24', NULL),
('19', '8', '2', 'RI-003-00', '15800.61', NULL);

INSERT INTO `premium_debit_notes` VALUES
('5', 'DN/2400001', '2024-12-28', 'SCHEME', '3', NULL, '10125.00', '20816.36', NULL, '2024-12-28', '2025-12-27', '', '1', '2024-12-28 15:23:46', '1', '2025-01-16 22:44:22', NULL, '0', '0', NULL, NULL),
('6', 'DN/2500001', '2025-01-09', 'SCHEME', '3', NULL, '10125.00', '9000.00', NULL, '2025-01-09', '2026-01-08', 'ALLOCATED', '1', '2025-01-09 10:11:06', '1', '2025-01-10 07:05:16', '953.75', '1', '1', '2025-01-10 07:05:16', '1'),
('7', 'DN/252500002', '2025-01-16', 'SCHEME', '3', NULL, '8308.64', '8308.64', NULL, '2025-01-16', '2026-01-15', 'ALLOCATED', '1', '2025-01-16 22:37:58', NULL, '2025-01-16 22:44:22', NULL, '0', '0', NULL, NULL),
('8', 'DN/25252500003', '2025-05-01', 'SCHEME', '8', NULL, '205505.20', NULL, NULL, '2025-05-01', '2026-04-30', '', '1', '2025-05-25 12:44:31', NULL, NULL, NULL, '0', '0', NULL, NULL);

INSERT INTO `premium_invoice` VALUES
('INV0000002', NULL, '3', '2024-12-28', '10125.00', '2024', '1', '2024-12-28', '1', '10125.00', NULL, NULL, '10125.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '80.00', '25.00', '20.00', NULL, NULL, NULL, '11', NULL, NULL, NULL, NULL, NULL, NULL),
('INV0000003', NULL, '3', '2025-01-09', '10125.00', '1', '1', '2025-01-09', '1', '10125.00', NULL, NULL, '10125.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '80.00', '25.00', '20.00', NULL, NULL, NULL, '12', NULL, NULL, NULL, NULL, NULL, NULL),
('INV0000004', NULL, '3', '2025-01-16', '8308.64', '1', '1', '2025-01-16', '2', '8308.64', NULL, NULL, '8308.64', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '80.00', '20.48', '16.38', NULL, NULL, NULL, '13', NULL, NULL, NULL, NULL, NULL, NULL),
('INV0000005', NULL, '8', '2025-05-01', '205505.20', '1', '1', '2025-05-25', '1', '205505.20', NULL, NULL, '205505.20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '320.00', '510.67', '408.53', NULL, NULL, NULL, '14', NULL, NULL, NULL, NULL, NULL, NULL);

INSERT INTO `premium_invoice_details` VALUES
('PTL-001', 'PTL-001-00', '2', '100000.00', '5062.50', 'INV0000002', '0', '1', NULL, '5062.50', NULL, NULL, NULL, NULL, NULL, 'OP', '9', 'SCHEME', NULL, '2024-12-28', NULL, NULL, NULL, NULL, NULL, NULL),
('PTL-001', 'PTL-001-00', '1', '1000000.00', '5062.50', 'INV0000002', '0', '1', NULL, '5062.50', NULL, NULL, NULL, NULL, NULL, 'IP', '10', 'SCHEME', NULL, '2024-12-28', NULL, NULL, NULL, NULL, NULL, NULL),
('PTL-001', 'PTL-001-00', '2', '100000.00', '5062.50', 'INV0000003', '0', '1', NULL, '5062.50', NULL, NULL, NULL, NULL, NULL, 'OP', '11', 'SCHEME', NULL, '2025-01-09', NULL, NULL, NULL, NULL, NULL, NULL),
('PTL-001', 'PTL-001-00', '1', '1000000.00', '5062.50', 'INV0000003', '0', '1', NULL, '5062.50', NULL, NULL, NULL, NULL, NULL, 'IP', '12', 'SCHEME', NULL, '2025-01-09', NULL, NULL, NULL, NULL, NULL, NULL),
('PTL-001', 'PTL-001-00', '2', '100000.00', '4154.32', 'INV0000004', '0', '1', NULL, '4154.32', NULL, NULL, NULL, NULL, NULL, 'OP', '13', 'SCHEME', NULL, '2025-01-16', NULL, NULL, NULL, NULL, NULL, NULL),
('PTL-001', 'PTL-001-00', '1', '1000000.00', '4154.32', 'INV0000004', '0', '1', NULL, '4154.32', NULL, NULL, NULL, NULL, NULL, 'IP', '14', 'SCHEME', NULL, '2025-01-16', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-001', 'RI-001-00', '1', '2000000.00', '28933.44', 'INV0000005', '1', NULL, NULL, '28933.44', NULL, NULL, NULL, NULL, NULL, 'CAT B', '15', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-001', 'RI-001-00', '2', '150000.00', '15800.61', 'INV0000005', '1', NULL, NULL, '15800.61', NULL, NULL, NULL, NULL, NULL, 'CAT B', '16', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-002', 'RI-002-00', '1', '2500000.00', '36994.55', 'INV0000005', '1', NULL, NULL, '36994.55', NULL, NULL, NULL, NULL, NULL, 'CAT C', '17', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-002', 'RI-002-00', '2', '200000.00', '23836.61', 'INV0000005', '1', NULL, NULL, '23836.61', NULL, NULL, NULL, NULL, NULL, 'CAT C', '18', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-002', 'RI-002-01', '1', '2500000.00', '36994.55', 'INV0000005', '1', NULL, NULL, '36994.55', NULL, NULL, NULL, NULL, NULL, 'CAT C', '19', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-002', 'RI-002-01', '2', '200000.00', '23836.61', 'INV0000005', '1', NULL, NULL, '23836.61', NULL, NULL, NULL, NULL, NULL, 'CAT C', '20', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-003', 'RI-003-00', '1', '1500000.00', '23308.24', 'INV0000005', '0', NULL, NULL, '23308.24', NULL, NULL, NULL, NULL, NULL, 'CAT B', '21', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL),
('RI-003', 'RI-003-00', '2', '100000.00', '15800.61', 'INV0000005', '0', NULL, NULL, '15800.61', NULL, NULL, NULL, NULL, NULL, 'CAT B', '22', 'SCHEME', NULL, '2025-05-01', NULL, NULL, NULL, NULL, NULL, NULL);




INSERT INTO `premium_receipt` VALUES
('FND2025016823', '750000.00', '2025-01-13', '2', 'CHQ475A', NULL, '5', NULL, '1', '2025-01-13', NULL, NULL, NULL, NULL, NULL, NULL, '0', 'exact', NULL, NULL, NULL, NULL),
('RCP0000001', '10000.00', '2024-12-31', '2', 'CHQ1234', NULL, '3', NULL, '1', '2024-12-31', '2', NULL, NULL, NULL, NULL, NULL, '0', 'exact', NULL, NULL, NULL, NULL),
('RCP0000002', '9000.00', '2025-01-09', '2', 'chq123', NULL, '3', NULL, '1', '2025-01-09', '3', NULL, NULL, NULL, NULL, NULL, '0', 'exact', NULL, NULL, NULL, NULL),
('RCP0000003', '15000.00', '2025-01-15', '1', NULL, NULL, '3', NULL, '1', '2025-01-15', NULL, NULL, NULL, NULL, NULL, NULL, '0', 'over', '4875.00', NULL, NULL, NULL),
('RCP0000004', '9000.00', '2025-01-16', '1', NULL, NULL, '3', NULL, '1', '2025-01-16', NULL, NULL, NULL, NULL, NULL, NULL, '0', 'exact', '0.00', NULL, NULL, NULL);

INSERT INTO `principal_applicant` VALUES
('PTL-001', 'PTL-001-00', 'Nujoma', 'Sam', '', NULL, '3', NULL, NULL, '+254705004039', 'P.O Box 2238 Eldoret', '1', 'sharcyville@gmail.com', NULL, '4', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'A005635485K', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Nation Center', '0343759001', NULL, NULL, NULL, '123', '123456'),
('PTL-002', 'PTL-002-00', '', 'What', 'is my name', NULL, '3', NULL, NULL, '', '', '0', '', NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', ''),
('RI-001', 'RI-001-00', 'Aurelius', 'Commodus', '', NULL, '8', NULL, NULL, '', '', '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '787876', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', ''),
('RI-002', 'RI-002-00', 'Antoninus', 'Marcus', 'Aurelius', NULL, '8', NULL, NULL, '', '', '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '676756ghtr5', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', ''),
('RI-003', 'RI-003-00', 'Test', 'Test', '', NULL, '8', NULL, NULL, '', '', '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'A003456788H', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', ''),
('RI-004', 'RI-004-00', 'Daniel', 'Sanny', '', '', '8', NULL, '', '', '', '0', '', '', '0', '1', '0', '2025-05-26', '1', '2025-05-26', NULL, NULL, NULL, NULL, NULL, '0', '0000-00-00', '', '', '', '', '', '', '', 'A003457047H', '', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', ''),
('RI-005', 'RI-005-00', 'Toby', 'Mwani', '', '', '8', NULL, '', '', '', '0', '', '', '0', '1', '0', '2025-05-26', '1', '2025-05-26', NULL, NULL, NULL, NULL, NULL, '0', '0000-00-00', '', '', '', '', '', '', '', 'A003457047Z', '', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', ''),
('RI-006', 'RI-006-00', 'Sonal', 'Anita', '', '', '8', NULL, '', '', '', '0', '', '', '0', '1', '0', '2025-05-26', '1', '2025-05-26', NULL, NULL, NULL, NULL, NULL, '0', '0000-00-00', '', '', '', '', '', '', '', 'A103457047T', '', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', ''),
('SHL-001', 'SHL-001-00', 'Doe', 'John', 'Smith', NULL, '5', NULL, NULL, '2.55E+11', 'P.O Box 123', NULL, 'john@example.com', NULL, '1', '1', '0', '2025-01-13', '1', '2025-01-13', '1', NULL, NULL, NULL, NULL, '2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);




INSERT INTO `providers` VALUES
('1', 'AKUH001', 'Aga Khan University Hospital', '+254 20 366 2000', '+254 710 477 477', 'info@aku.edu', 'P.O. Box 30270-00100', '3rd Parklands Avenue, Limuru Road', 'Nairobi', '1', '1', 'BANK', 'Stanbic Bank', 'Westlands Branch', '0100005678910', 'P000123456Z', '2024-12-22', '2025-12-22', 'Admin', '2024-12-22 07:44:50', NULL, NULL),
('2', 'AAR01', 'AAR', '', NULL, '', NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-04-07 14:20:58', NULL, NULL),
('3', 'NAIH01', 'Nairobi Hospital', '', NULL, '', NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-04-07 14:21:33', NULL, NULL),
('4', 'KIJAH001', 'Kijabe Hospital', '', NULL, '', NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-04-07 14:22:04', NULL, NULL),
('5', '002', 'Metropolitan Hospital', '0706812271', NULL, 'info@metropolitan.co.ke', NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-04-12 16:31:42', '2025-04-15 12:21:16', NULL);

INSERT INTO `quotation_member_benefits` VALUES
('1', 'QT202500001', '1', '1', '5500.00', '1000000.00'),
('2', 'QT202500002', '2', '1', '5000.00', '1000000.00'),
('3', 'QT202500002', '2', '2', '5000.00', '100000.00'),
('4', 'QT202500003', '3', '1', '5500.00', '1000000.00'),
('5', 'QT202500003', '3', '2', '5500.00', '100000.00'),
('6', 'QT202500003', '4', '1', '5000.00', '1000000.00'),
('7', 'QT202500003', '4', '2', '5000.00', '100000.00'),
('8', 'QT202500004', '5', '1', '5500.00', '1000000.00'),
('9', 'QT202500004', '5', '2', '5500.00', '100000.00');

INSERT INTO `quotation_members` VALUES
('1', 'QT202500001', 'principal', '40', '5564.75'),
('2', 'QT202500002', 'principal', '34', '10085.00'),
('3', 'QT202500003', 'principal', '40', '11089.50'),
('4', 'QT202500003', 'principal', '35', '10085.00'),
('5', 'QT202500004', 'principal', '40', '11089.50');

INSERT INTO `quotations` VALUES
('1', 'QT202500001', '3', 'ADDITIONAL', '5564.75', '2025-02-13', 'PENDING', '1', '2025-01-14 20:25:48', NULL, NULL),
('2', 'QT202500002', '3', 'ADDITIONAL', '10085.00', '2025-02-13', 'PENDING', '1', '2025-01-14 21:00:20', NULL, NULL),
('3', 'QT202500003', '3', 'ADDITIONAL', '21174.50', '2025-02-14', 'PENDING', '1', '2025-01-15 09:49:02', NULL, NULL),
('4', 'QT202500004', '3', 'ADDITIONAL', '11089.50', '2025-03-02', 'PENDING', '1', '2025-01-31 14:27:05', NULL, NULL);

INSERT INTO `receipt_allocations` VALUES
('1', 'RCP0000001', '5', '10000.00', NULL, '2024-12-31', '1', '2024-12-31 08:44:51'),
('2', 'RCP0000002', '6', '9000.00', NULL, '2025-01-09', '1', '2025-01-09 10:14:38'),
('4', 'RCP0000003', '5', '10125.00', '1', '2025-01-15', '1', '2025-01-15 13:22:55'),
('5', 'RCP0000004', '7', '8308.64', '0', '2025-01-16', '1', '2025-01-16 22:44:22'),
('6', 'RCP0000004', '5', '691.36', '1', '2025-01-16', '1', '2025-01-16 22:44:22');






INSERT INTO `role_permissions` VALUES
('443', '5', '2', '1', '2025-01-25 20:32:29', NULL, NULL),
('444', '5', '7', '1', '2025-01-25 20:32:29', NULL, NULL),
('445', '5', '8', '1', '2025-01-25 20:32:29', NULL, NULL),
('446', '5', '9', '1', '2025-01-25 20:32:29', NULL, NULL),
('447', '5', '10', '1', '2025-01-25 20:32:29', NULL, NULL),
('448', '5', '11', '1', '2025-01-25 20:32:29', NULL, NULL),
('449', '5', '12', '1', '2025-01-25 20:32:29', NULL, NULL),
('450', '5', '13', '1', '2025-01-25 20:32:29', NULL, NULL),
('451', '5', '14', '1', '2025-01-25 20:32:29', NULL, NULL),
('452', '5', '15', '1', '2025-01-25 20:32:29', NULL, NULL),
('453', '5', '16', '1', '2025-01-25 20:32:29', NULL, NULL),
('454', '5', '17', '1', '2025-01-25 20:32:29', NULL, NULL),
('455', '5', '18', '1', '2025-01-25 20:32:29', NULL, NULL),
('456', '5', '4', '1', '2025-01-25 20:32:29', NULL, NULL),
('457', '5', '28', '1', '2025-01-25 20:32:29', NULL, NULL),
('458', '5', '29', '1', '2025-01-25 20:32:29', NULL, NULL),
('459', '5', '30', '1', '2025-01-25 20:32:29', NULL, NULL),
('460', '5', '31', '1', '2025-01-25 20:32:29', NULL, NULL),
('461', '5', '32', '1', '2025-01-25 20:32:29', NULL, NULL),
('462', '5', '33', '1', '2025-01-25 20:32:29', NULL, NULL),
('463', '5', '34', '1', '2025-01-25 20:32:29', NULL, NULL),
('464', '5', '35', '1', '2025-01-25 20:32:29', NULL, NULL),
('465', '5', '36', '1', '2025-01-25 20:32:29', NULL, NULL),
('466', '5', '37', '1', '2025-01-25 20:32:29', NULL, NULL),
('467', '5', '38', '1', '2025-01-25 20:32:29', NULL, NULL),
('468', '5', '39', '1', '2025-01-25 20:32:29', NULL, NULL),
('469', '5', '40', '1', '2025-01-25 20:32:29', NULL, NULL),
('470', '5', '41', '1', '2025-01-25 20:32:29', NULL, NULL),
('471', '5', '42', '1', '2025-01-25 20:32:29', NULL, NULL),
('472', '5', '43', '1', '2025-01-25 20:32:29', NULL, NULL),
('473', '5', '66', '1', '2025-01-25 20:32:29', NULL, NULL),
('474', '5', '68', '1', '2025-01-25 20:32:29', NULL, NULL),
('475', '5', '69', '1', '2025-01-25 20:32:29', NULL, NULL),
('476', '5', '76', '1', '2025-01-25 20:32:29', NULL, NULL),
('479', '2', '1', '1', '2025-01-25 22:02:52', NULL, NULL),
('480', '2', '2', '1', '2025-01-25 22:02:52', NULL, NULL),
('481', '2', '7', '1', '2025-01-25 22:02:52', NULL, NULL),
('482', '2', '8', '1', '2025-01-25 22:02:52', NULL, NULL),
('483', '2', '9', '1', '2025-01-25 22:02:52', NULL, NULL),
('484', '2', '10', '1', '2025-01-25 22:02:52', NULL, NULL),
('485', '2', '11', '1', '2025-01-25 22:02:52', NULL, NULL),
('486', '2', '12', '1', '2025-01-25 22:02:52', NULL, NULL),
('487', '2', '13', '1', '2025-01-25 22:02:52', NULL, NULL),
('488', '2', '14', '1', '2025-01-25 22:02:52', NULL, NULL),
('489', '2', '15', '1', '2025-01-25 22:02:52', NULL, NULL),
('490', '2', '16', '1', '2025-01-25 22:02:52', NULL, NULL),
('491', '2', '17', '1', '2025-01-25 22:02:52', NULL, NULL),
('492', '2', '18', '1', '2025-01-25 22:02:52', NULL, NULL),
('493', '2', '3', '1', '2025-01-25 22:02:52', NULL, NULL),
('494', '2', '19', '1', '2025-01-25 22:02:52', NULL, NULL),
('495', '2', '20', '1', '2025-01-25 22:02:52', NULL, NULL),
('496', '2', '21', '1', '2025-01-25 22:02:52', NULL, NULL),
('497', '2', '22', '1', '2025-01-25 22:02:52', NULL, NULL),
('498', '2', '23', '1', '2025-01-25 22:02:52', NULL, NULL),
('499', '2', '24', '1', '2025-01-25 22:02:52', NULL, NULL),
('500', '2', '25', '1', '2025-01-25 22:02:52', NULL, NULL),
('501', '2', '26', '1', '2025-01-25 22:02:52', NULL, NULL),
('502', '2', '27', '1', '2025-01-25 22:02:52', NULL, NULL),
('503', '2', '4', '1', '2025-01-25 22:02:52', NULL, NULL),
('504', '2', '28', '1', '2025-01-25 22:02:52', NULL, NULL),
('505', '2', '29', '1', '2025-01-25 22:02:52', NULL, NULL),
('506', '2', '30', '1', '2025-01-25 22:02:52', NULL, NULL),
('507', '2', '31', '1', '2025-01-25 22:02:52', NULL, NULL),
('508', '2', '32', '1', '2025-01-25 22:02:52', NULL, NULL),
('509', '2', '33', '1', '2025-01-25 22:02:52', NULL, NULL),
('510', '2', '34', '1', '2025-01-25 22:02:52', NULL, NULL),
('511', '2', '35', '1', '2025-01-25 22:02:52', NULL, NULL),
('512', '2', '36', '1', '2025-01-25 22:02:52', NULL, NULL),
('513', '2', '37', '1', '2025-01-25 22:02:52', NULL, NULL),
('514', '2', '38', '1', '2025-01-25 22:02:52', NULL, NULL),
('515', '2', '39', '1', '2025-01-25 22:02:52', NULL, NULL),
('516', '2', '40', '1', '2025-01-25 22:02:52', NULL, NULL),
('517', '2', '41', '1', '2025-01-25 22:02:52', NULL, NULL),
('518', '2', '42', '1', '2025-01-25 22:02:52', NULL, NULL),
('519', '2', '43', '1', '2025-01-25 22:02:52', NULL, NULL),
('520', '2', '5', '1', '2025-01-25 22:02:52', NULL, NULL),
('521', '2', '44', '1', '2025-01-25 22:02:52', NULL, NULL),
('522', '2', '45', '1', '2025-01-25 22:02:52', NULL, NULL),
('523', '2', '46', '1', '2025-01-25 22:02:52', NULL, NULL),
('524', '2', '47', '1', '2025-01-25 22:02:52', NULL, NULL),
('525', '2', '48', '1', '2025-01-25 22:02:52', NULL, NULL),
('526', '2', '49', '1', '2025-01-25 22:02:52', NULL, NULL),
('527', '2', '50', '1', '2025-01-25 22:02:52', NULL, NULL),
('528', '2', '51', '1', '2025-01-25 22:02:52', NULL, NULL),
('529', '2', '52', '1', '2025-01-25 22:02:52', NULL, NULL),
('530', '2', '53', '1', '2025-01-25 22:02:52', NULL, NULL),
('531', '2', '6', '1', '2025-01-25 22:02:52', NULL, NULL),
('532', '2', '54', '1', '2025-01-25 22:02:52', NULL, NULL),
('533', '2', '55', '1', '2025-01-25 22:02:52', NULL, NULL),
('534', '2', '56', '1', '2025-01-25 22:02:52', NULL, NULL),
('535', '2', '57', '1', '2025-01-25 22:02:52', NULL, NULL),
('536', '2', '58', '1', '2025-01-25 22:02:52', NULL, NULL),
('537', '2', '59', '1', '2025-01-25 22:02:52', NULL, NULL),
('538', '2', '60', '1', '2025-01-25 22:02:52', NULL, NULL),
('539', '2', '61', '1', '2025-01-25 22:02:52', NULL, NULL),
('540', '2', '62', '1', '2025-01-25 22:02:52', NULL, NULL),
('541', '2', '63', '1', '2025-01-25 22:02:52', NULL, NULL),
('542', '2', '64', '1', '2025-01-25 22:02:52', NULL, NULL),
('543', '2', '65', '1', '2025-01-25 22:02:52', NULL, NULL),
('544', '2', '66', '1', '2025-01-25 22:02:52', NULL, NULL),
('545', '2', '67', '1', '2025-01-25 22:02:52', NULL, NULL),
('546', '2', '68', '1', '2025-01-25 22:02:52', NULL, NULL),
('547', '2', '69', '1', '2025-01-25 22:02:52', NULL, NULL),
('548', '2', '70', '1', '2025-01-25 22:02:52', NULL, NULL),
('549', '2', '71', '1', '2025-01-25 22:02:52', NULL, NULL),
('550', '2', '72', '1', '2025-01-25 22:02:52', NULL, NULL),
('551', '2', '73', '1', '2025-01-25 22:02:52', NULL, NULL),
('552', '2', '74', '1', '2025-01-25 22:02:52', NULL, NULL),
('553', '2', '75', '1', '2025-01-25 22:02:52', NULL, NULL),
('554', '2', '76', '1', '2025-01-25 22:02:52', NULL, NULL),
('555', '2', '78', '1', '2025-01-25 22:02:52', NULL, NULL),
('2238', '1', '94', '1', '2025-05-25 19:56:24', NULL, NULL),
('2239', '1', '96', '1', '2025-05-25 19:56:24', NULL, NULL),
('2240', '1', '2', '1', '2025-05-25 19:56:24', NULL, NULL),
('2241', '1', '90', '1', '2025-05-25 19:56:24', NULL, NULL),
('2242', '1', '98', '1', '2025-05-25 19:56:24', NULL, NULL),
('2243', '1', '7', '1', '2025-05-25 19:56:24', NULL, NULL),
('2244', '1', '8', '1', '2025-05-25 19:56:24', NULL, NULL),
('2245', '1', '9', '1', '2025-05-25 19:56:24', NULL, NULL),
('2246', '1', '10', '1', '2025-05-25 19:56:24', NULL, NULL),
('2247', '1', '11', '1', '2025-05-25 19:56:24', NULL, NULL),
('2248', '1', '12', '1', '2025-05-25 19:56:24', NULL, NULL),
('2249', '1', '13', '1', '2025-05-25 19:56:24', NULL, NULL),
('2250', '1', '14', '1', '2025-05-25 19:56:24', NULL, NULL),
('2251', '1', '15', '1', '2025-05-25 19:56:24', NULL, NULL),
('2252', '1', '16', '1', '2025-05-25 19:56:24', NULL, NULL),
('2253', '1', '17', '1', '2025-05-25 19:56:24', NULL, NULL),
('2254', '1', '18', '1', '2025-05-25 19:56:24', NULL, NULL),
('2255', '1', '85', '1', '2025-05-25 19:56:24', NULL, NULL),
('2256', '1', '3', '1', '2025-05-25 19:56:24', NULL, NULL),
('2257', '1', '81', '1', '2025-05-25 19:56:24', NULL, NULL),
('2258', '1', '99', '1', '2025-05-25 19:56:24', NULL, NULL),
('2259', '1', '19', '1', '2025-05-25 19:56:24', NULL, NULL),
('2260', '1', '20', '1', '2025-05-25 19:56:24', NULL, NULL),
('2261', '1', '21', '1', '2025-05-25 19:56:24', NULL, NULL),
('2262', '1', '22', '1', '2025-05-25 19:56:24', NULL, NULL),
('2263', '1', '83', '1', '2025-05-25 19:56:24', NULL, NULL),
('2264', '1', '24', '1', '2025-05-25 19:56:24', NULL, NULL),
('2265', '1', '25', '1', '2025-05-25 19:56:24', NULL, NULL),
('2266', '1', '26', '1', '2025-05-25 19:56:24', NULL, NULL),
('2267', '1', '27', '1', '2025-05-25 19:56:24', NULL, NULL),
('2268', '1', '4', '1', '2025-05-25 19:56:24', NULL, NULL),
('2269', '1', '97', '1', '2025-05-25 19:56:24', NULL, NULL),
('2270', '1', '80', '1', '2025-05-25 19:56:24', NULL, NULL),
('2271', '1', '28', '1', '2025-05-25 19:56:24', NULL, NULL),
('2272', '1', '29', '1', '2025-05-25 19:56:24', NULL, NULL),
('2273', '1', '30', '1', '2025-05-25 19:56:24', NULL, NULL),
('2274', '1', '31', '1', '2025-05-25 19:56:24', NULL, NULL),
('2275', '1', '32', '1', '2025-05-25 19:56:24', NULL, NULL),
('2276', '1', '33', '1', '2025-05-25 19:56:24', NULL, NULL),
('2277', '1', '34', '1', '2025-05-25 19:56:24', NULL, NULL),
('2278', '1', '35', '1', '2025-05-25 19:56:24', NULL, NULL),
('2279', '1', '36', '1', '2025-05-25 19:56:24', NULL, NULL),
('2280', '1', '37', '1', '2025-05-25 19:56:24', NULL, NULL),
('2281', '1', '82', '1', '2025-05-25 19:56:24', NULL, NULL),
('2282', '1', '38', '1', '2025-05-25 19:56:24', NULL, NULL),
('2283', '1', '39', '1', '2025-05-25 19:56:24', NULL, NULL),
('2284', '1', '40', '1', '2025-05-25 19:56:24', NULL, NULL),
('2285', '1', '41', '1', '2025-05-25 19:56:24', NULL, NULL),
('2286', '1', '42', '1', '2025-05-25 19:56:24', NULL, NULL),
('2287', '1', '43', '1', '2025-05-25 19:56:24', NULL, NULL),
('2288', '1', '5', '1', '2025-05-25 19:56:24', NULL, NULL),
('2289', '1', '87', '1', '2025-05-25 19:56:24', NULL, NULL),
('2290', '1', '88', '1', '2025-05-25 19:56:24', NULL, NULL),
('2291', '1', '89', '1', '2025-05-25 19:56:24', NULL, NULL),
('2292', '1', '44', '1', '2025-05-25 19:56:24', NULL, NULL),
('2293', '1', '79', '1', '2025-05-25 19:56:24', NULL, NULL),
('2294', '1', '45', '1', '2025-05-25 19:56:24', NULL, NULL),
('2295', '1', '46', '1', '2025-05-25 19:56:24', NULL, NULL),
('2296', '1', '47', '1', '2025-05-25 19:56:24', NULL, NULL),
('2297', '1', '48', '1', '2025-05-25 19:56:24', NULL, NULL),
('2298', '1', '49', '1', '2025-05-25 19:56:24', NULL, NULL),
('2299', '1', '50', '1', '2025-05-25 19:56:24', NULL, NULL),
('2300', '1', '51', '1', '2025-05-25 19:56:24', NULL, NULL),
('2301', '1', '52', '1', '2025-05-25 19:56:24', NULL, NULL),
('2302', '1', '53', '1', '2025-05-25 19:56:24', NULL, NULL),
('2303', '1', '6', '1', '2025-05-25 19:56:24', NULL, NULL),
('2304', '1', '91', '1', '2025-05-25 19:56:24', NULL, NULL),
('2305', '1', '54', '1', '2025-05-25 19:56:24', NULL, NULL),
('2306', '1', '55', '1', '2025-05-25 19:56:24', NULL, NULL),
('2307', '1', '56', '1', '2025-05-25 19:56:24', NULL, NULL),
('2308', '1', '57', '1', '2025-05-25 19:56:24', NULL, NULL),
('2309', '1', '58', '1', '2025-05-25 19:56:24', NULL, NULL),
('2310', '1', '59', '1', '2025-05-25 19:56:24', NULL, NULL),
('2311', '1', '60', '1', '2025-05-25 19:56:24', NULL, NULL),
('2312', '1', '61', '1', '2025-05-25 19:56:24', NULL, NULL),
('2313', '1', '62', '1', '2025-05-25 19:56:24', NULL, NULL),
('2314', '1', '63', '1', '2025-05-25 19:56:24', NULL, NULL),
('2315', '1', '64', '1', '2025-05-25 19:56:24', NULL, NULL),
('2316', '1', '65', '1', '2025-05-25 19:56:24', NULL, NULL),
('2317', '1', '66', '1', '2025-05-25 19:56:24', NULL, NULL),
('2318', '1', '67', '1', '2025-05-25 19:56:24', NULL, NULL),
('2319', '1', '68', '1', '2025-05-25 19:56:24', NULL, NULL),
('2320', '1', '69', '1', '2025-05-25 19:56:24', NULL, NULL),
('2321', '1', '70', '1', '2025-05-25 19:56:24', NULL, NULL),
('2322', '1', '71', '1', '2025-05-25 19:56:24', NULL, NULL),
('2323', '1', '72', '1', '2025-05-25 19:56:24', NULL, NULL),
('2324', '1', '73', '1', '2025-05-25 19:56:24', NULL, NULL),
('2325', '1', '74', '1', '2025-05-25 19:56:24', NULL, NULL),
('2326', '1', '75', '1', '2025-05-25 19:56:24', NULL, NULL),
('2327', '1', '76', '1', '2025-05-25 19:56:24', NULL, NULL),
('2328', '1', '78', '1', '2025-05-25 19:56:24', NULL, NULL),
('2329', '1', '84', '1', '2025-05-25 19:56:24', NULL, NULL);


INSERT INTO `scheme_copay` VALUES
('1', '3', '15', 'FIXED', '1000.00', 'ACTIVE', '1', '2025-01-19 18:36:31', NULL, NULL),
('2', '7', '2', 'FIXED', '500.00', 'ACTIVE', '1', '2025-04-07 14:17:27', NULL, NULL);


INSERT INTO `scheme_provider_restrictions` VALUES
('1', '3', '15', '1', 'ALLOWED', 'ACTIVE', '1', '2025-01-19 18:36:48', NULL, NULL),
('2', '7', '2', '1', 'NOT_ALLOWED', 'ACTIVE', '1', '2025-04-07 14:18:10', NULL, NULL);

INSERT INTO `services` VALUES
('1', 'Consultation', '1'),
('2', 'Prescription', '1'),
('3', 'Laboratory Services', '1'),
('4', 'C Section', '1'),
('5', 'Pharmacy', '1'),
('6', 'COVID', '1'),
('7', 'Dressing', '1'),
('8', 'Extraction', '1'),
('9', 'X RAY', '1'),
('10', 'CT Scan', '1'),
('11', 'Injection', '1'),
('12', 'M.R.I', '1');

INSERT INTO `settings` VALUES
('1', 'system_name', 'MediSure360 Health Insurance System', NULL),
('2', 'email_host', 'mail.myne.co.ke', NULL),
('3', 'email_port', '587', NULL),
('4', 'email_username', 'mailer@myne.co.ke', NULL),
('5', 'email_password', '#@#2025Wemadeit', NULL),
('6', 'email_sender', 'no-reply@myne.co.ke', NULL),
('7', 'default_currency', 'KES', NULL),
('8', 'address', 'Mageso Chambers, Moi Avenue Nairobi', NULL),
('9', 'tel_1', '+254 798 805 300', NULL),
('10', 'tel_2', '+254 705 004 039', NULL),
('11', 'phcf_percentage', '0.25', NULL),
('12', 'stamp_duty', '40', NULL),
('13', 'training_levy', '0.20', NULL),
('14', 'dkim_private_key', '-----BEGIN RSA PRIVATE KEY-----\r\nMIICXQIBAAKBgQCpAA1ZlyaxZV00mEw7+zWVxbjzcFhszpDcgSZccm+jN1iTWBSy\r\n84cXHB8g37s69lSm9c9DaFE+rBvSN1b9yOmDvTJ63VHcSJBvuoNoNZt3UnZMUxrc\r\nmZMyWKirFpJv+aiqgvvwhQvq1aF9NLrxgi4WCcwqzWsQLF/3dAKon7mzlwIDAQAB\r\nAoGANfOYT3ObnKJZgQLlw3hNAQVgKAdDk2jWgi6Qyo6V6SswEcnawc5Q4CXQIjSK\r\nlyYwnCR5CHHzDejv8MpN8TMEqM8Oh2/W3KMHBVHx5IiFgo/O/8+H8hOPSfgkc2Dy\r\njMaZRAE9o98sdNHlVKnfX2THEYX1hmuiV6t17aZJW4u0KGECQQDWPAqufn8/Fj1y\r\nfdy6ZGaqUpci7KHYEhnGtfyaiyB4ume7gW0hhsLDl0fezTUqKb+Pcl7WoLRbhrP2\r\nlnviTj4fAkEAyfJ3vX4rzQ9+sfII8YLwYwMK4dMgKTlG4Le8GSOBaYK5Y1gXmtKP\r\noYp7oOjyvi5mtvRnvNTwYwYhpIpsjKzriQJBAKLi8egsa8lmun+jrMDXd6vGsf0u\r\n1/s1//0y/4XthFnmuNo7FOOp18no6w8/DU4qgeiqN+uOMrNoXsp9LmIpxVcCQQCv\r\npa80KAuc3f9KcsQIm+TNmZXbeTCd6m2Vgvmdu94RkVwB5lsRlFbNIJALEtIfTGiW\r\ndNnNykATQP/+B1AGw1hRAkAiAsfxYoPh/O9B2PNOGLSgBgVL9mnIjAiH8pHHP5TA\r\nY8fBx5ZtWL9BG2Tu6j6cgxszBExqfYVIvWFD78dP+TDY\r\n-----END RSA PRIVATE KEY-----\r\n', NULL),
('15', 'dkim_domain', 'myne.co.ke', NULL),
('16', 'system_version', '1.0.0', NULL),
('17', 'update_server_url', 'https://updates.myne.co.ke/', NULL),
('18', 'last_update_check', '2025-01-01', NULL);

INSERT INTO `support_tickets` VALUES
('1', '1', 'Issue', 'Issue with the bills screen', 'Done', 'technical', 'urgent', 'CLOSED', '2025-01-25 10:19:54', '2025-01-25 11:43:24'),
('2', '21', 'Error on cPanel', 'Error on accessing the system', 'I have been working on the issue and will have a solution soon', 'technical', 'urgent', 'CLOSED', '2025-01-25 11:14:55', '2025-01-31 15:29:34'),
('3', '1', 'Error on cPanel Access', 'Issue on accessing cPanel', NULL, 'technical', 'urgent', 'OPEN', '2025-01-25 11:45:14', NULL),
('4', '1', 'MySQl Server Potential Issue', 'The system is not responding ', NULL, 'technical', 'urgent', 'OPEN', '2025-01-31 15:28:27', NULL),
('5', '1', 'test', 'fdlan', 'Noted', 'technical', 'high', 'CLOSED', '2025-02-17 22:19:28', '2025-02-17 22:24:10');


INSERT INTO `system_updates` VALUES
('1', '1.1.0', 'Reimbursement Update', '[{\"path\": \"save_reimbursement.php\", \"type\": \"update\", \"backup\": false, \"checksum\": \"sha256-hash-of-file\"}]', '[]', '2025-02-01', NULL, NULL, 'AVAILABLE', NULL),
('2', '1.1.0', 'Pre Auth Updates', '[{\"path\": \"save_reimbursement.php\", \"type\": \"update\", \"backup\": false, \"checksum\": \"sha256-hash-of-file\"}]', '[]', '2025-02-01', NULL, NULL, 'AVAILABLE', NULL);

INSERT INTO `ticket_activity_log` VALUES
('1', '2', '1', 'Status changed from OPEN to IN_PROGRESS', '2025-01-25 11:31:28'),
('2', '1', '1', 'Status changed from OPEN to CLOSED', '2025-01-25 11:43:24'),
('3', '2', '1', 'Status changed from IN_PROGRESS to CLOSED', '2025-01-31 15:29:34'),
('4', '5', '1', 'Status changed from OPEN to CLOSED', '2025-02-17 22:23:17');

INSERT INTO `ticket_attachments` VALUES
('1', '3', 'License.png', 'uploads/tickets/3_License.png', '2025-01-25 11:45:14'),
('2', '4', 'Screenshot 2025-01-31 at 3.21.57 PM.png', 'uploads/tickets/4_Screenshot 2025-01-31 at 3.21.57 PM.png', '2025-01-31 15:28:27');

INSERT INTO `ticket_comments` VALUES
('1', '2', '1', 'Noted and thanks', '2025-01-25 11:42:49'),
('2', '1', '1', 'Issue sorted', '2025-01-25 11:43:16'),
('3', '2', '21', 'Thank you hope you can finalize on it soon', '2025-01-25 11:44:18'),
('4', '2', '1', 'The issue has been sorted', '2025-01-31 15:29:15'),
('5', '5', '1', 'Noted', '2025-02-17 22:20:29'),
('6', '5', '1', 'well', '2025-02-17 22:22:30');


INSERT INTO `user_role` VALUES
('1', 'Administrator'),
('7', 'Care Manager'),
('5', 'Claims Analyst'),
('6', 'Data Entry Clerk'),
('4', 'Finance'),
('2', 'General Manager'),
('3', 'Operations');


INSERT INTO `users` VALUES
('1', 'Admin', 'hi@myne.co.ke', 'MediSure Admin', '$2y$10$Y.5OCS473Vc4NjnwwvU//eLkhc4LP2rBy/2Y9Qqjf0Ai1TB7ItWzi', 'admin', '2023-09-17 10:48:54', '1', '0', '2024-02-11 13:07:14', '2024-07-12 10:15:55', '1', '2025-05-26 11:11:30', 'admin_avatar_1737721735.png'),
('19', 'Sam', 'sharcyville@gmail.com', 'Sam', '$2y$10$btFXXBZIpNzW9I3JVTDhtu.9nQZVDiPVP4vs6vRwoBXuc6LWy0HT.', 'admin', '2024-03-28 10:14:59', '1', '0', '2024-03-28 12:26:35', '2024-03-28 10:14:59', '1', '2025-02-17 20:58:33', NULL),
('21', 'sharcy', 'nujoma@polakis.co.ke', 'Sharcy T', '$2y$10$uG0soIspc99efv/44UP8Ueexsh.g8qAn3gVIVFFDVrsWQtxaOh8GS', NULL, '2025-01-24 15:38:48', '1', '0', NULL, '2025-01-24 15:38:48', '5', '2025-01-30 16:48:38', 'sharcy_avatar_1737724007.png');


SET FOREIGN_KEY_CHECKS=1;
