<?php
session_start();
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user_id = $_SESSION['user_id'];

// Get user details with role
$sql_user = "SELECT u.*, r.role_name 
             FROM users u 
             LEFT JOIN user_role r ON u.role_id = r.role_id 
             WHERE u.user_id = ?";
$stmt = $conn->prepare($sql_user);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Get user's recent claims activity
$sql_recent_activity = "SELECT b.*, m.surname, m.first_name, c.corporate
                       FROM bills b
                       LEFT JOIN member_info m ON b.member_no = m.member_no
                       LEFT JOIN corporate c ON b.corp_id = c.corp_id
                       WHERE b.user_id = ?
                       ORDER BY b.date_entered DESC LIMIT 5";
$stmt = $conn->prepare($sql_recent_activity);
$stmt->bind_param("s", $user_id);
$stmt->execute();
$recent_activity = $stmt->get_result();

// Get user's claims statistics
$sql_user_stats = "SELECT 
                   COUNT(*) as total_claims,
                   SUM(CASE WHEN vet_status = 1 THEN 1 ELSE 0 END) as approved_claims,
                   SUM(CASE WHEN paid = 1 THEN 1 ELSE 0 END) as paid_claims,
                   SUM(CASE WHEN vet_status = 0 THEN 1 ELSE 0 END) as pending_claims
                   FROM bills 
                   WHERE user_id = ?";
$stmt = $conn->prepare($sql_user_stats);
$stmt->bind_param("s", $user_id);
$stmt->execute();
$user_stats = $stmt->get_result()->fetch_assoc();

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Dashboard')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- Welcome Message -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">Welcome, <?php echo htmlspecialchars($user['full_name']); ?>!</h4>
                                    <p class="card-text mb-0">Role: <?php echo htmlspecialchars($user['role_name']); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Activity Stats -->
                    <div class="row">
                        <div class="col-xl-3 col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="text-muted mb-3">Total Claims Processed</h6>
                                            <h2 class="mb-0"><?php echo $user_stats['total_claims']; ?></h2>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-primary-subtle rounded">
                                                <i class="bx bx-file text-primary"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="text-muted mb-3">Approved Claims</h6>
                                            <h2 class="mb-0"><?php echo $user_stats['approved_claims']; ?></h2>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle rounded">
                                                <i class="bx bx-check-circle text-success"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="text-muted mb-3">Pending Claims</h6>
                                            <h2 class="mb-0"><?php echo $user_stats['pending_claims']; ?></h2>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-warning-subtle rounded">
                                                <i class="bx bx-time text-warning"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Activity -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Recent Activity</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Claim No</th>
                                                    <th>Member</th>
                                                    <th>Corporate</th>
                                                    <th>Date</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while($row = $recent_activity->fetch_assoc()): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($row['claim_no']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['surname'] . ' ' . $row['first_name']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['corporate']); ?></td>
                                                    <td><?php echo date('d M Y', strtotime($row['date_entered'])); ?></td>
                                                    <td>Ksh <?php echo number_format($row['invoiced_amount'], 2); ?></td>
                                                    <td>
                                                        <?php if($row['paid']): ?>
                                                            <span class="badge bg-success">Paid</span>
                                                        <?php elseif($row['vet_status']): ?>
                                                            <span class="badge bg-info">Approved</span>
                                                        <?php else: ?>
                                                            <span class="badge bg-warning">Pending</span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
</body>
</html>