<?php
// edi_operations.php
session_start();
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Check if user is admin
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] !== 1) {
    header('Location: login.php');
    exit();
}

?>

<!DOCTYPE html>
<html>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'EDI Operations')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'EDI', 'title' => 'EDI Operations')); ?>

                    <div class="row">
                        <!-- Claims Section -->
                        <div class="col-xl-4 mb-4">
                            <div class="card h-100">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Claims Integration</h4>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex flex-column gap-3">
                                        <a href="edi_claims_fetch.php" class="btn btn-primary">
                                            <i class="ri-download-cloud-line align-middle me-1"></i>
                                            Fetch New Claims
                                        </a>
                                        <a href="edi_claims_pending.php" class="btn btn-info">
                                            <i class="ri-file-list-3-line align-middle me-1"></i>
                                            View Pending Claims
                                        </a>
                                        <a href="edi_claims_processed.php" class="btn btn-success">
                                            <i class="ri-check-double-line align-middle me-1"></i>
                                            View Processed Claims
                                        </a>
                                        <a href="edi_claims_failed.php" class="btn btn-danger">
                                            <i class="ri-error-warning-line align-middle me-1"></i>
                                            View Failed Claims
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Member Management Section -->
                        <div class="col-xl-4 mb-4">
                            <div class="card h-100">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Member Integration</h4>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex flex-column gap-3">
                                        <a href="edi_member_add.php" class="btn btn-primary">
                                            <i class="ri-user-add-line align-middle me-1"></i>
                                            Add New Member
                                        </a>
                                        <a href="edi_member_activate.php" class="btn btn-success">
                                            <i class="ri-user-follow-line align-middle me-1"></i>
                                            Activate Members
                                        </a>
                                        <a href="edi_member_deactivate.php" class="btn btn-warning">
                                            <i class="ri-user-unfollow-line align-middle me-1"></i>
                                            Deactivate Members
                                        </a>
                                        <a href="edi_member_cards.php" class="btn btn-info">
                                            <i class="ri-bank-card-line align-middle me-1"></i>
                                            Member Cards
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Benefits Section -->
                        <div class="col-xl-4 mb-4">
                            <div class="card h-100">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Benefits Integration</h4>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex flex-column gap-3">
                                        <a href="edi_benefit_setup.php" class="btn btn-primary">
                                            <i class="ri-health-book-line align-middle me-1"></i>
                                            Setup Benefits
                                        </a>
                                        <a href="edi_benefit_rules.php" class="btn btn-info">
                                            <i class="ri-book-read-line align-middle me-1"></i>
                                            Benefit Rules
                                        </a>
                                        <a href="edi_benefit_suspend.php" class="btn btn-warning">
                                            <i class="ri-pause-circle-line align-middle me-1"></i>
                                            Suspend Benefits
                                        </a>
                                        <a href="edi_benefit_activate.php" class="btn btn-success">
                                            <i class="ri-play-circle-line align-middle me-1"></i>
                                            Activate Benefits
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- EDI Logs Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Recent EDI Activity</h4>
                                    <div class="flex-shrink-0">
                                        <a href="edi_logs.php" class="btn btn-soft-info btn-sm">
                                            View All Logs
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Date/Time</th>
                                                    <th>Operation</th>
                                                    <th>Status</th>
                                                    <th>Details</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                // Fetch recent EDI logs
                                                $sql = "SELECT * FROM edi_integration_logs 
                                                       ORDER BY created_at DESC LIMIT 5";
                                                $result = $conn->query($sql);
                                                
                                                while ($log = $result->fetch_assoc()):
                                                    $statusClass = $log['status'] === 'SUCCESS' ? 'success' : 
                                                                  ($log['status'] === 'WARNING' ? 'warning' : 'danger');
                                                ?>
                                                <tr>
                                                    <td><?php echo date('d M Y H:i', strtotime($log['created_at'])); ?></td>
                                                    <td><?php echo htmlspecialchars($log['operation']); ?></td>
                                                    <td>
                                                        <span class="badge bg-<?php echo $statusClass; ?>">
                                                            <?php echo $log['status']; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo htmlspecialchars($log['details']); ?></td>
                                                </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet">
<script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

</body>
</html>