<?php
session_start();
include 'layouts/dbconn.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit;
}

try {
    $restriction_id = $_GET['id'] ?? null;
    if (!$restriction_id) {
        throw new Exception('Restriction ID is required');
    }

    $sql = "SELECT spr.*, c.corporate, b.benefit, p.provider_name
            FROM scheme_provider_restrictions spr
            LEFT JOIN corporate c ON spr.corp_id = c.corp_id
            LEFT JOIN benefit b ON spr.benefit_code = b.code
            LEFT JOIN providers p ON spr.provider_id = p.provider_id
            WHERE spr.restriction_id = ?";
            
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('i', $restriction_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $restriction = $result->fetch_assoc();
    if (!$restriction) {
        throw new Exception('Provider restriction not found');
    }
    
    echo json_encode([
        'success' => true,
        'restriction' => $restriction
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

$conn->close();
?>