<?php
session_start();
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
   header('Location: login.php');
   exit();
}

// Get FAQs from database
//$sql = "SELECT category, question, answer FROM help_faqs WHERE is_active = 1 ORDER BY category, display_order";
//$result = $conn->query($sql);

//$faqs = [];
//while ($row = $result->fetch_assoc()) {
//   $faqs[$row['category']][] = $row;
//}

$faqs = [
    'General' => [
        [
            'question' => 'What are the system requirements to access MediSure360?',
            'answer' => 'MediSure360 is a web-based system that can be accessed through any modern web browser (Chrome, Firefox, Safari, Edge). No special software installation is required.',
            'display_order' => 1
        ]
    ],
    'Member Management' => [
        [
            'question' => 'How do I add a new family member to an existing policy?',
            'answer' => '<ol>
                <li>Navigate to Member Management → Add New Member</li>
                <li>Select the existing family number</li>
                <li>Fill in the dependent\'s details</li>
                <li>Select relationship as "Dependent"</li>
                <li>Upload required documents</li>
                <li>Save the member record</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'Claims Processing' => [
        [
            'question' => 'What should I do if a claim is submitted without complete documentation?',
            'answer' => '<ol>
                <li>Mark the claim as "Deferred"</li>
                <li>Add a note specifying the missing documents</li>
                <li>Contact the provider/member requesting the missing documentation</li>
                <li>Once received, update the claim with complete documentation</li>
                <li>Proceed with claim processing</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'Benefits Management' => [
        [
            'question' => 'How do I set up waiting periods for specific benefits?',
            'answer' => '<ol>
                <li>Go to Benefits → Benefit Setup</li>
                <li>Select the benefit type</li>
                <li>Under Benefit Rules, set the waiting period duration</li>
                <li>Specify if it applies to new members only</li>
                <li>Save the configuration</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'EDI Integration' => [
        [
            'question' => 'What should I do if the EDI connection fails?',
            'answer' => '<ol>
                <li>Check network connectivity</li>
                <li>Verify API credentials are valid and not expired</li>
                <li>Review error logs for specific error messages</li>
                <li>Ensure IP whitelisting is configured correctly</li>
                <li>Contact support if issues persist</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'Financial Management' => [
        [
            'question' => 'How do I process a premium refund?',
            'answer' => '<ol>
                <li>Navigate to Finance → Premium Management</li>
                <li>Generate a credit note with refund details</li>
                <li>Get necessary approvals</li>
                <li>Process the refund payment</li>
                <li>Update premium allocation records</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'Reports & Analytics' => [
        [
            'question' => 'Can I schedule reports to be automatically generated and emailed?',
            'answer' => '<ol>
                <li>Go to Reports → Schedule Report</li>
                <li>Select report type and parameters</li>
                <li>Set frequency (daily, weekly, monthly)</li>
                <li>Add email recipients</li>
                <li>Enable scheduling</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'System Administration' => [
        [
            'question' => 'How do I reset a user\'s password?',
            'answer' => '<ol>
                <li>Go to System Administration → User Management</li>
                <li>Locate the user account</li>
                <li>Click "Reset Password"</li>
                <li>System will send reset instructions to user\'s email</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'Pre-Authorization' => [
        [
            'question' => 'What is the process for urgent pre-authorization requests?',
            'answer' => '<ol>
                <li>Use the "Urgent" flag when submitting</li>
                <li>Include clinical justification for urgency</li>
                <li>System prioritizes urgent requests</li>
                <li>Standard processing time is 2 hours</li>
                <li>SMS/email notifications are sent upon approval</li>
            </ol>',
            'display_order' => 1
        ]
    ],
    'Provider Network' => [
        [
            'question' => 'How do I update provider payment details?',
            'answer' => '<ol>
                <li>Access Provider Management</li>
                <li>Select the provider</li>
                <li>Navigate to Payment Details tab</li>
                <li>Update banking/payment information</li>
                <li>Save changes and verify updates</li>
            </ol>',
            'display_order' => 1
        ]
    ]
];
?>

<!DOCTYPE html>
<html>
<head>
   <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Help & Support')); ?>
   <?php include 'layouts/head-css.php'; ?>
   <style>
       .help-section {
           margin-bottom: 2rem;
       }
       .help-card {
           transition: all 0.3s ease;
       }
       .help-card:hover {
           transform: translateY(-5px);
           box-shadow: 0 5px 15px rgba(0,0,0,0.1);
       }
       .accordion-button:not(.collapsed) {
           background-color: #f8f9fa;
       }
   </style>
</head>

<body>
   <div id="layout-wrapper">
       <?php include 'layouts/menu.php'; ?>
       
       <div class="main-content">
           <div class="page-content">
               <div class="container-fluid">
                   <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Support', 'title' => 'Help & Support')); ?>

                   <div class="row">
                       <!-- Quick Links -->
                       <div class="col-xl-12 mb-4">
                           <div class="card">
                               <div class="card-header">
                                   <h4 class="card-title mb-0">Quick Links</h4>
                               </div>
                               <div class="card-body">
                                   <div class="row g-3">
                                       <div class="col-md-3">
                                           <div class="card help-card border">
                                               <div class="card-body text-center">
                                                   <i class="ri-book-open-line fs-1 text-primary mb-2"></i>
                                                   <h5>User Manual</h5>
                                                   <p class="text-muted mb-3">Complete system documentation</p>
                                                   <a href="assets/docs/user-manual.pdf" class="btn btn-primary btn-sm">
                                                       Download PDF
                                                   </a>
                                               </div>
                                           </div>
                                       </div>
                                       <div class="col-md-3">
                                           <div class="card help-card border">
                                               <div class="card-body text-center">
                                                   <i class="ri-video-line fs-1 text-info mb-2"></i>
                                                   <h5>Video Tutorials</h5>
                                                   <p class="text-muted mb-3">Step-by-step video guides</p>
                                                   <a href="tutorials.php" class="btn btn-info btn-sm">
                                                       Watch Videos
                                                   </a>
                                               </div>
                                           </div>
                                       </div>
                                       <div class="col-md-3">
                                           <div class="card help-card border">
                                               <div class="card-body text-center">
                                                   <i class="ri-customer-service-2-line fs-1 text-success mb-2"></i>
                                                   <h5>Contact Support</h5>
                                                   <p class="text-muted mb-3">Get help from our team</p>
                                                   <a href="submit_ticket.php" class="btn btn-success btn-sm">
                                                       Submit Ticket
                                                   </a>
                                               </div>
                                           </div>
                                       </div>
                                       <?php if (isset($_SESSION['user_id']) && $_SESSION['role_id'] === 1): ?>
                                        <div class="col-md-3">
                                            <div class="card help-card border">
                                                <div class="card-body text-center">
                                                    <i class="ri-tools-line fs-1 text-warning mb-2"></i>
                                                    <h5>System Status</h5>
                                                    <p class="text-muted mb-3">Check system health</p>
                                                    <a href="system_status.php" class="btn btn-warning btn-sm">
                                                        View Status
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                   </div>
                               </div>
                           </div>
                       </div>

<!-- FAQs -->
<div class="col-xl-8">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">Frequently Asked Questions</h4>
        </div>
        <div class="card-body">
            <div class="accordion custom-accordionwithicon" id="faqAccordion">
                <?php 
                $categoryCount = 0;
                foreach($faqs as $category => $questions): 
                    $categoryCount++;
                ?>
                    <div class="help-section mb-4">
                        <h5 class="mb-3"><?php echo htmlspecialchars($category); ?></h5>
                        <?php foreach($questions as $index => $faq): ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" 
                                            data-bs-toggle="collapse" 
                                            data-bs-target="#faq<?php echo $categoryCount . '_' . $index; ?>">
                                        <?php echo htmlspecialchars($faq['question']); ?>
                                    </button>
                                </h2>
                                <div id="faq<?php echo $categoryCount . '_' . $index; ?>" 
                                     class="accordion-collapse collapse" 
                                     data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        <?php echo $faq['answer']; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

                       <!-- Support Information -->
                       <div class="col-xl-4">
                           <div class="card">
                               <div class="card-header">
                                   <h4 class="card-title mb-0">Support Information</h4>
                               </div>
                               <div class="card-body">
                                   <div class="d-flex flex-column gap-4">
                                       <div>
                                           <h5><i class="ri-time-line me-2"></i>Support Hours</h5>
                                           <p class="text-muted mb-0">Monday - Friday: 8:00 AM - 6:00 PM<br>
                                           Saturday: 9:00 AM - 1:00 PM<br>
                                           Sunday: Closed</p>
                                       </div>

                                       <div>
                                           <h5><i class="ri-phone-line me-2"></i>Contact Numbers</h5>
                                           <p class="text-muted mb-0">
                                               Support: +254 798 805 300<br>
                                               Emergency: +254 705 004 039
                                           </p>
                                       </div>

                                       <div>
                                           <h5><i class="ri-mail-line me-2"></i>Email Support</h5>
                                           <p class="text-muted mb-0">
                                               General: support@medisure360.com<br>
                                               Technical: tech@medisure360.com
                                           </p>
                                       </div>

                                       <div class="alert alert-info">
                                           <div class="d-flex gap-2">
                                               <div class="flex-shrink-0">
                                                   <i class="ri-information-line fs-4"></i>
                                               </div>
                                               <div class="flex-grow-1">
                                                   <h5 class="alert-heading">Need Urgent Help?</h5>
                                                   <p class="mb-0">For urgent issues outside business hours, please call our emergency support line.</p>
                                               </div>
                                           </div>
                                       </div>
                                   </div>
                               </div>
                           </div>
                       </div>
                   </div>
               </div>
           </div>
           <?php include 'layouts/footer.php'; ?>
       </div>
   </div>

   <?php include 'layouts/vendor-scripts.php'; ?>
   <script src="assets/js/app.js"></script>
</body>
</html>