<?php
require_once 'dbconn.php';

function checkDatabaseHealth() {
    try {
        // Check primary connection
        $primary_result = DatabaseConnection::executeQuery(
            "SELECT 1 AS health_check", 
            [], 
            'primary'
        );
        
        $primary_status = $primary_result ? 'healthy' : 'unhealthy';

        // Check replica connection if available
        try {
            $replica_result = DatabaseConnection::executeQuery(
                "SELECT 1 AS health_check", 
                [], 
                'replica'
            );
            $replica_status = $replica_result ? 'healthy' : 'unhealthy';
        } catch (Exception $e) {
            $replica_status = 'unavailable';
        }

        // Log status
        error_log("Database health check - Primary: $primary_status, Replica: $replica_status");

        return [
            'primary' => $primary_status,
            'replica' => $replica_status,
            'timestamp' => date('Y-m-d H:i:s')
        ];

    } catch (Exception $e) {
        error_log("Database health check failed: " . $e->getMessage());
        return [
            'primary' => 'unhealthy',
            'replica' => 'unknown',
            'error' => $e->getMessage(),
            'timestamp' => date('Y-m-d H:i:s')
        ];
    }
}
?>