<?php
/**
 * Dynamic Sidebar - Ultrasure Insurance Platform
 * Generates menu based on user role
 */

// Include menu configuration
require_once 'includes/menu_config.php';

// Get user role (default to 'guest' if not logged in)
$userRole = 'Super Admin'; // You can replace this with actual user role detection
// $userRole = $_SESSION['user_data']['role_name'] ?? 'guest';

// Get menu configuration for user role
$menuItems = getMenuConfig($userRole);
$currentPage = getCurrentPage();
?>

<!-- Sidebar -->
<div class="sidebar">
    <nav>
        <div class="app-logo">
            <a class="logo d-inline-block" href="index.php">
                <img src="assets/images/logo/ultrasure_logo.png" alt="Hoslink EMR Platform" class="img-fluid" style="max-height: 40px;">
            </a>
            <span class="bg-light-primary toggle-semi-nav ms-2">
                <i class="ti ti-chevrons-right f-s-20"></i>
            </span>
        </div>

        <div class="app-nav" id="app-simple-bar">
            <ul class="main-nav p-0 mt-2">
                <?php foreach ($menuItems as $item): ?>
                    
                    <?php if ($item['type'] === 'header'): ?>
                        <!-- Menu Header -->
                        <li class="menu-title">
                            <span><?php echo htmlspecialchars($item['title']); ?></span>
                        </li>
                    
                    <?php elseif ($item['type'] === 'link'): ?>
                        <!-- Single Link -->
                        <li class="no-sub">
                            <a class="<?php echo isMenuActive($item['url'], $currentPage) ? 'active' : ''; ?> <?php echo isset($item['class']) ? $item['class'] : ''; ?>" 
                               href="<?php echo htmlspecialchars($item['url']); ?>">
                                <i class="ph-duotone <?php echo htmlspecialchars($item['icon']); ?>"></i>
                                <?php echo htmlspecialchars($item['title']); ?>
                            </a>
                        </li>
                    
                    <?php elseif ($item['type'] === 'dropdown'): ?>
                        <!-- Dropdown Menu -->
                        <li>
                            <a class="<?php echo hasActiveItem($item['items'], $currentPage) ? 'active' : ''; ?>" 
                               data-bs-toggle="collapse" 
                               href="#<?php echo htmlspecialchars($item['id']); ?>" 
                               aria-expanded="<?php echo hasActiveItem($item['items'], $currentPage) ? 'true' : 'false'; ?>">
                                <i class="ph-duotone <?php echo htmlspecialchars($item['icon']); ?>"></i>
                                <?php echo htmlspecialchars($item['title']); ?>
                            </a>
                            <ul class="collapse <?php echo hasActiveItem($item['items'], $currentPage) ? 'show' : ''; ?>" 
                                id="<?php echo htmlspecialchars($item['id']); ?>">
                                <?php foreach ($item['items'] as $subItem): ?>
                                    <li>
                                        <a href="<?php echo htmlspecialchars($subItem['url']); ?>" 
                                           class="<?php echo isMenuActive($subItem['url'], $currentPage) ? 'active' : ''; ?>">
                                            <?php echo htmlspecialchars($subItem['title']); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </li>
                    
                    <?php endif; ?>
                    
                <?php endforeach; ?>
            </ul>
        </div>

        <div class="menu-navs">
            <span class="menu-previous"><i class="ti ti-chevron-left"></i></span>
            <span class="menu-next"><i class="ti ti-chevron-right"></i></span>
        </div>
    </nav>
</div>

<style>
/* Custom Sidebar Styles */
.sidebar {
    width: 280px;
    background: #fff;
    box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
    height: 100vh;
    position: fixed;
    left: 0;
    top: 0;
    z-index: 1000;
    overflow-y: auto;
}

.app-logo {
    padding: 1rem;
    border-bottom: 1px solid #e9ecef;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.main-nav {
    list-style: none;
    padding: 0;
    margin: 0;
}

.menu-title {
    padding: 1rem 1.5rem 0.5rem;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
    color: #6c757d;
    letter-spacing: 0.5px;
}

.main-nav > li > a {
    display: flex;
    align-items: center;
    padding: 0.75rem 1.5rem;
    color: #495057;
    text-decoration: none;
    transition: all 0.3s ease;
    border-left: 3px solid transparent;
}

.main-nav > li > a:hover,
.main-nav > li > a.active {
    background-color: #f8f9fa;
    color: #0d6efd;
    border-left-color: #0d6efd;
}

.main-nav > li > a i {
    margin-right: 0.75rem;
    font-size: 1.25rem;
    width: 20px;
}

.main-nav ul {
    list-style: none;
    padding: 0;
    margin: 0;
    background-color: #f8f9fa;
}

.main-nav ul li a {
    display: block;
    padding: 0.5rem 1.5rem 0.5rem 3.5rem;
    color: #6c757d;
    text-decoration: none;
    transition: all 0.3s ease;
}

.main-nav ul li a:hover,
.main-nav ul li a.active {
    color: #0d6efd;
    background-color: #e3f2fd;
}

.toggle-semi-nav {
    cursor: pointer;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
    transition: all 0.3s ease;
}

.toggle-semi-nav:hover {
    background-color: #e9ecef;
}

.menu-navs {
    position: absolute;
    bottom: 1rem;
    left: 50%;
    transform: translateX(-50%);
    display: flex;
    gap: 0.5rem;
}

.menu-navs span {
    cursor: pointer;
    padding: 0.5rem;
    background: #f8f9fa;
    border-radius: 0.25rem;
    transition: all 0.3s ease;
}

.menu-navs span:hover {
    background: #e9ecef;
}

/* Responsive */
@media (max-width: 768px) {
    .sidebar {
        transform: translateX(-100%);
        transition: transform 0.3s ease;
    }
    
    .sidebar.show {
        transform: translateX(0);
    }
}

/* Text danger style for logout */
.text-danger {
    color: #dc3545 !important;
}

.text-danger:hover {
    color: #bb2d3b !important;
}
</style>