<?php
session_start();
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Fetch quotations with corporate details
$sql = "SELECT q.*,
               c.corporate as corporate_name, 
               c.scheme,
               COUNT(qm.member_id) as member_count
        FROM quotations q
        LEFT JOIN corporate c ON q.corp_id = c.corp_id
        LEFT JOIN quotation_members qm ON q.quotation_no = qm.quotation_no
        GROUP BY q.quotation_no
        ORDER BY q.generated_at DESC";
        
$result = $conn->query($sql);
$quotations = $result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Quotations List')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Quotations', 'title' => 'Quotations List')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">All Quotations</h4>
                                    <div class="flex-shrink-0">
                                        <a href="quotation.php" class="btn btn-primary btn-sm">
                                            <i class="ri-add-line align-middle me-1"></i> New Quotation
                                        </a>
                                    </div>
                                </div>
                                
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-borderless table-nowrap align-middle mb-0">
                                            <thead class="table-light text-muted">
                                                <tr>
                                                    <th scope="col">Quotation No</th>
                                                    <th scope="col">Corporate</th>
                                                    <th scope="col">Type</th>
                                                    <th scope="col">Members</th>
                                                    <th scope="col">Total Premium</th>
                                                    <th scope="col">Valid Until</th>
                                                    <th scope="col">Status</th>
                                                    <th scope="col" class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($quotations as $quote): ?>
                                                <tr>
                                                    <td>
                                                        <a href="view_quotation.php?no=<?php echo $quote['quotation_no']; ?>" 
                                                           class="fw-medium link-primary">
                                                            <?php echo $quote['quotation_no']; ?>
                                                        </a>
                                                    </td>
                                                    <td><?php echo htmlspecialchars($quote['corporate_name']); ?></td>
                                                    <td><?php echo $quote['quotation_type']; ?></td>
                                                    <td><?php echo $quote['member_count']; ?></td>
                                                    <td><?php echo number_format($quote['total_premium'], 2); ?></td>
                                                    <td><?php echo date('d M Y', strtotime($quote['valid_until'])); ?></td>
                                                    <td>
                                                        <span class="badge bg-<?php 
                                                            echo $quote['status'] === 'PENDING' ? 'warning' : 
                                                                ($quote['status'] === 'ACCEPTED' ? 'success' : 'danger'); 
                                                            ?>">
                                                            <?php echo $quote['status']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="d-flex gap-2 justify-content-center">
                                                            <a href="view_quotation.php?no=<?php echo $quote['quotation_no']; ?>" 
                                                               class="btn btn-sm btn-soft-primary">
                                                                <i class="ri-eye-fill"></i>
                                                            </a>
                                                            <a href="download_quotation.php?no=<?php echo $quote['quotation_no']; ?>" 
                                                               class="btn btn-sm btn-soft-info">
                                                                <i class="ri-download-2-line"></i>
                                                            </a>
                                                            <?php if ($quote['status'] === 'PENDING'): ?>
                                                            <a href="convert_quotation.php?quotation_no=<?php echo $quote['quotation_no']; ?>" 
                                                               class="btn btn-sm btn-soft-success">
                                                                <i class="ri-arrow-right-line"></i> Convert
                                                            </a>
                                                            <button type="button" class="btn btn-sm btn-soft-danger delete-quote" 
                                                                    data-id="<?php echo $quote['quotation_no']; ?>">
                                                                <i class="ri-delete-bin-line"></i>
                                                            </button>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                                <?php if (empty($quotations)): ?>
                                                <tr>
                                                    <td colspan="8" class="text-center text-muted">
                                                        No quotations found
                                                    </td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet">
<script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Handle delete button clicks
        document.querySelectorAll('.delete-quote').forEach(btn => {
            btn.addEventListener('click', function() {
                const quoteId = this.dataset.id;
                
                Swal.fire({
                    title: 'Are you sure?',
                    text: "This quotation will be deleted",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = 'delete_quotation.php?no=' + quoteId;
                    }
                });
            });
        });
        
        // Show success message if redirected with success param
        const urlParams = new URLSearchParams(window.location.search);
        const successMsg = urlParams.get('success');
        if (successMsg) {
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: decodeURIComponent(successMsg)
            });
        }
    });
    </script>
</body>
</html>