<?php
include 'layouts/dbconn.php';

header('Content-Type: application/json');

try {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['filename'])) {
        throw new Exception('No filename provided');
    }

    $filename = basename($data['filename']); // Sanitize filename
    $filepath = 'uploads/claims/' . $filename;

    if (file_exists($filepath)) {
        if (unlink($filepath)) {
            echo json_encode([
                'success' => true,
                'message' => 'File deleted successfully'
            ]);
        } else {
            throw new Exception('Failed to delete file');
        }
    } else {
        throw new Exception('File not found');
    }

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>