<?php
session_start();
include 'layouts/dbconn.php';

// Verify token
$token = $_GET['token'] ?? '';
if (empty($token)) {
    header('Location: login.php');
    exit;
}

$sql = "SELECT user_id, full_name, reset_token_expires 
        FROM users 
        WHERE reset_token = ? 
        AND reset_token_expires > NOW()";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $token);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if (!$user) {
    $_SESSION['error_msg'] = 'Invalid or expired reset token';
    header('Location: login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Reset Password')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div class="auth-page-wrapper pt-5">
        <div class="auth-one-bg-position auth-one-bg" id="auth-particles">
            <div class="bg-overlay"></div>
            <div class="shape">
                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1440 120">
                    <path d="M 0,36 C 144,53.6 432,123.2 720,124 C 1008,124.8 1296,56.8 1440,40L1440 140L0 140z"></path>
                </svg>
            </div>
        </div>

        <div class="auth-page-content">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-5">
                        <div class="card mt-4">
                            <div class="card-body p-4">
                                <div class="text-center">
                                    <h5 class="text-primary">Reset Password</h5>
                                    <p class="text-muted mt-2">Hello <?php echo htmlspecialchars($user['full_name']); ?>, please set your new password</p>
                                </div>
                                <div class="p-2 mt-4">
                                    <form action="process_password_reset.php" method="POST">
                                        <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                                        
                                        <div class="mb-3">
                                            <label class="form-label" for="password">New Password</label>
                                            <div class="position-relative auth-pass-inputgroup">
                                                <input type="password" class="form-control pe-5" 
                                                       id="password" name="password" 
                                                       placeholder="Enter new password" required>
                                                <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted" 
                                                        type="button" id="password-addon">
                                                    <i class="ri-eye-fill align-middle"></i>
                                                </button>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label" for="confirm_password">Confirm Password</label>
                                            <div class="position-relative auth-pass-inputgroup">
                                                <input type="password" class="form-control pe-5" 
                                                       id="confirm_password" name="confirm_password" 
                                                       placeholder="Confirm new password" required>
                                            </div>
                                        </div>

                                        <div class="mt-4">
                                            <button class="btn btn-success w-100" type="submit">Reset Password</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/libs/particles.js/particles.js"></script>
    <script src="assets/js/pages/particles.app.js"></script>
    <script src="assets/js/pages/password-addon.init.js"></script>
</body>
</html>