<?php
session_start();
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] !== 1) {
    header('Location: login.php');
    exit();
}

$sql = "SELECT * FROM user_role ORDER BY role_name";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Role Management')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Role Management</h4>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addRoleModal">
                                        <i class="ri-add-line align-middle"></i> Add Role
                                    </button>
                                </div>
                                
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Role Name</th>
                                                    <th>Users</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while($role = $result->fetch_assoc()): 
                                                    // Count users in role
                                                    $count_sql = "SELECT COUNT(*) as count FROM users WHERE role_id = " . $role['role_id'];
                                                    $count_result = $conn->query($count_sql);
                                                    $count = $count_result->fetch_assoc()['count'];
                                                ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($role['role_name']); ?></td>
                                                    <td><?php echo $count; ?></td>
                                                    <td>
                                                        <div class="d-flex gap-2">
                                                            <a href="role_permissions.php?role_id=<?php echo $role['role_id']; ?>" 
                                                               class="btn btn-sm btn-primary">
                                                                <i class="ri-lock-line"></i> Permissions
                                                            </a>
                                                            <button class="btn btn-sm btn-info" 
                                                                    onclick="editRole(<?php echo $role['role_id']; ?>)">
                                                                <i class="ri-edit-2-line"></i>
                                                            </button>
                                                            <?php if ($count === 0): ?>
                                                            <button class="btn btn-sm btn-danger" 
                                                                    onclick="deleteRole(<?php echo $role['role_id']; ?>)">
                                                                <i class="ri-delete-bin-line"></i>
                                                            </button>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <!-- Add Role Modal -->
    <div class="modal fade" id="addRoleModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Role</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="addRoleForm">
                        <div class="mb-3">
                            <label class="form-label">Role Name</label>
                            <input type="text" class="form-control" name="role_name" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="saveRole()">Save Role</button>
                </div>
            </div>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
</body>
</html>