<?php
session_start();
include 'layouts/dbconn.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit;
}

try {
    $benefit = $_POST['benefit'] ?? '';
    
    if (!$benefit) {
        throw new Exception('Benefit name is required');
    }

    $sql = "INSERT INTO benefit (benefit) VALUES (?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $benefit);

    if (!$stmt->execute()) {
        throw new Exception($stmt->error);
    }

    echo json_encode([
        'success' => true,
        'message' => 'Benefit saved successfully'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

$conn->close();
?>