<?php
include 'layouts/dbconn.php';

if(isset($_POST['search'])) {
    $search = mysqli_real_escape_string($conn, $_POST['search']);
    
    $sql = "SELECT 
        c.corp_id,
        c.corporate,
        c.scheme,
        c.policy_no,
        c.date_entered,
        CASE 
            WHEN c.cancelled = 1 THEN 'Cancelled'
            WHEN c.cancelled = 0 THEN 'Active'
            ELSE 'Pending'
        END as status,
        u.username as user_name
    FROM corporate c
    LEFT JOIN users u ON c.user_id = u.username
    WHERE 
        c.corporate LIKE '%$search%' OR 
        c.scheme LIKE '%$search%' OR 
        c.policy_no LIKE '%$search%'
    ORDER BY c.date_entered DESC";
    
    $result = $conn->query($sql);
    
    $output = '';
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $statusClass = '';
            switch($row['status']) {
                case 'Active':
                    $statusClass = 'bg-success';
                    break;
                case 'Cancelled':
                    $statusClass = 'bg-danger';
                    break;
                default:
                    $statusClass = 'bg-warning';
                    break;
            }
    
            $output .= '
            <tr>
                <th scope="row">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="checkAll" value="' . $row['corp_id'] . '">
                    </div>
                </th>
                <td class="id">' . htmlspecialchars($row['corp_id']) . '</td>
                <td class="tasks_name">' . htmlspecialchars($row['corporate']) . '</td>
                <td class="client_name">' . htmlspecialchars($row['scheme']) . '</td>
                <td class="assignedto">' . htmlspecialchars($row['policy_no']) . '</td>
                <td class="create_date">' . date('d M, Y', strtotime($row['date_entered'])) . '</td>
                <td class="status"><span class="badge ' . $statusClass . '">' . $row['status'] . '</span></td>
                <td class="priority">' . htmlspecialchars($row['user_name']) . '</td>
                <td class="action">
                    <ul class="list-inline hstack gap-2 mb-0">
                        <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View">
                            <a class="dropdown-item" href="view_corporate_details.php?id=' . $row['corp_id'] . '">
                                <i class="ri-eye-fill align-bottom me-2 text-muted"></i>
                            </a>
                        </li>
                        <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Edit">
                            <a class="dropdown-item" href="edit_corporate.php?id=' . $row['corp_id'] . '">
                                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i>
                            </a>
                        </li>
                        <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Delete">
                            <a class="dropdown-item" href="javascript:void(0);" onclick="deleteCorporate(\'' . htmlspecialchars($row['corp_id'], ENT_QUOTES) . '\')">
                                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i>
                            </a>
                        </li>
                    </ul>
                </td>
            </tr>';
        }
    } else {
        $output .= '<tr><td colspan="9" class="text-center">No records found</td></tr>';
    }
    
    echo $output;
}

$conn->close();
?>