<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Check if user is logged in and has admin access
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] !== 1) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Insufficient permissions. Not Authorized.']);
    exit;
}

// Fetch all settings
$sql = "SELECT * FROM settings ORDER BY id";
$result = $conn->query($sql);
$settings = [];
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

?>

<!DOCTYPE html>
<html>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'System Settings')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Settings', 'title' => 'System Settings')); ?>

                    <div class="row">
                        <div class="col-xl-12">
                            <form id="settingsForm">
                                <!-- General Settings -->
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title mb-0">General Settings</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">System Name</label>
                                                <input type="text" class="form-control" name="system_name" 
                                                       value="<?php echo htmlspecialchars($settings['system_name'] ?? ''); ?>" required>
                                            </div>
                                            <div class="col-md-12 mb-4">
                                                <label class="form-label">Company Logo</label>
                                                <div class="d-flex align-items-center gap-3">
                                                    <?php if (!empty($settings['company_logo'])): ?>
                                                        <div class="logo-preview">
                                                            <img src="<?php echo htmlspecialchars($settings['company_logo']); ?>" 
                                                                 alt="Company Logo" 
                                                                 class="img-fluid" 
                                                                 style="max-height: 100px;">
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="flex-grow-1">
                                                        <input type="file" class="form-control" name="company_logo" 
                                                               accept="image/png,image/jpeg,image/gif"
                                                               id="logoInput">
                                                        <div class="form-text">
                                                            Recommended size: 200x60 pixels. Max file size: 2MB. 
                                                            Supported formats: PNG, JPG, GIF
                                                        </div>
                                                    </div>
                                                    <?php if (!empty($settings['company_logo'])): ?>
                                                        <button type="button" class="btn btn-danger btn-sm" id="removeLogo">
                                                            <i class="ri-delete-bin-line"></i> Remove
                                                        </button>
                                                    <?php endif; ?>
                                                </div>
                                                <div id="logoPreview" class="mt-2" style="display: none;">
                                                    <img src="" alt="Logo Preview" class="img-fluid" style="max-height: 100px;">
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Default Currency</label>
                                                <input type="text" class="form-control" name="default_currency" 
                                                       value="<?php echo htmlspecialchars($settings['default_currency'] ?? ''); ?>" required>
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">Address</label>
                                                <input type="text" class="form-control" name="address" 
                                                       value="<?php echo htmlspecialchars($settings['address'] ?? ''); ?>" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Primary Phone</label>
                                                <input type="text" class="form-control" name="tel_1" 
                                                       value="<?php echo htmlspecialchars($settings['tel_1'] ?? ''); ?>" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Secondary Phone</label>
                                                <input type="text" class="form-control" name="tel_2" 
                                                       value="<?php echo htmlspecialchars($settings['tel_2'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Financial Settings -->
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title mb-0">Financial Settings</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">PHCF Percentage</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" name="phcf_percentage" 
                                                           value="<?php echo htmlspecialchars($settings['phcf_percentage'] ?? ''); ?>" 
                                                           step="0.01" min="0" max="100" required>
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Stamp Duty</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">KES</span>
                                                    <input type="number" class="form-control" name="stamp_duty" 
                                                           value="<?php echo htmlspecialchars($settings['stamp_duty'] ?? ''); ?>" 
                                                           step="0.01" min="0" required>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Training Levy</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" name="training_levy" 
                                                           value="<?php echo htmlspecialchars($settings['training_levy'] ?? ''); ?>" 
                                                           step="0.01" min="0" max="100" required>
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Email Settings -->
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title mb-0">Email Settings</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">SMTP Host</label>
                                                <input type="text" class="form-control" name="email_host" 
                                                       value="<?php echo htmlspecialchars($settings['email_host'] ?? ''); ?>" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">SMTP Port</label>
                                                <input type="number" class="form-control" name="email_port" 
                                                       value="<?php echo htmlspecialchars($settings['email_port'] ?? ''); ?>" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">SMTP Username</label>
                                                <input type="text" class="form-control" name="email_username" 
                                                       value="<?php echo htmlspecialchars($settings['email_username'] ?? ''); ?>" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">SMTP Password</label>
                                                <div class="input-group">
                                                    <input type="password" class="form-control" name="email_password" 
                                                           value="<?php echo htmlspecialchars($settings['email_password'] ?? ''); ?>" required>
                                                    <button class="btn btn-light" type="button" id="togglePassword">
                                                        <i class="ri-eye-line"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Sender Email</label>
                                                <input type="email" class="form-control" name="email_sender" 
                                                       value="<?php echo htmlspecialchars($settings['email_sender'] ?? ''); ?>" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- DKIM Settings -->
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title mb-0">DKIM Settings</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">DKIM Domain</label>
                                                <input type="text" class="form-control" name="dkim_domain" 
                                                       value="<?php echo htmlspecialchars($settings['dkim_domain'] ?? ''); ?>">
                                            </div>
                                            <div class="col-12 mb-3">
                                                <label class="form-label">DKIM Private Key</label>
                                                <textarea class="form-control" name="dkim_private_key" rows="5"><?php 
                                                    echo htmlspecialchars($settings['dkim_private_key'] ?? ''); 
                                                ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="text-end mb-3">
                                    <button type="submit" class="btn btn-primary">
                                        Save Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet">
<script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const settingsForm = document.getElementById('settingsForm');
            const togglePassword = document.getElementById('togglePassword');
            const passwordInput = document.querySelector('input[name="email_password"]');
            const logoInput = document.getElementById('logoInput');
            const logoPreview = document.getElementById('logoPreview');
            const removeLogo = document.getElementById('removeLogo');

            // Toggle password visibility
            togglePassword?.addEventListener('click', function() {
                const type = passwordInput.getAttribute('type');
                passwordInput.setAttribute('type', type === 'password' ? 'text' : 'password');
                this.innerHTML = type === 'password' ? 
                    '<i class="ri-eye-off-line"></i>' : 
                    '<i class="ri-eye-line"></i>';
            });

        logoInput?.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (!file) return;
        
            // Validate file type
            const allowed = ['image/png', 'image/jpeg', 'image/gif'];
            if (!allowed.includes(file.type)) {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid File Type',
                    text: 'Please select a PNG, JPG or GIF file'
                });
                this.value = '';
                return;
            }
        
            // Validate file size (2MB)
            if (file.size > 2097152) {
                Swal.fire({
                    icon: 'error',
                    title: 'File Too Large',
                    text: 'Maximum file size is 2MB'
                });
                this.value = '';
                return;
            }
        
            // Show preview
            const reader = new FileReader();
            reader.onload = function(e) {
                logoPreview.querySelector('img').src = e.target.result;
                logoPreview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        });
        
        removeLogo?.addEventListener('click', function() {
            Swal.fire({
                title: 'Remove Logo?',
                text: 'Are you sure you want to remove the company logo?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, remove it',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Update database to remove logo
                    fetch('save_settings.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            action: 'remove_logo'
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            throw new Error(data.error || 'Failed to remove logo');
                        }
                    })
                    .catch(error => {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: error.message
                        });
                    });
                }
            });
        });
        
        // Modify the existing form submit handler to handle file upload
        settingsForm?.addEventListener('submit', function(e) {
            e.preventDefault();
        
            const formData = new FormData(this);
            
            // Show loading state
            Swal.fire({
                title: 'Saving...',
                text: 'Please wait while we save your settings',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
        
            // Send form data including file
            fetch('save_settings.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    throw new Error(data.error || 'Failed to save settings');
                }
        
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: 'Settings saved successfully'
                }).then(() => {
                    location.reload();
                });
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message
                });
            });
        });
        });
    </script>
</body>
</html>