<?php
// utils/logo.php

function getCompanyLogo($default = true) {
    global $conn;
    
    $sql = "SELECT setting_value FROM settings WHERE setting_key = 'company_logo'";
    $result = $conn->query($sql);
    
    if ($result && $row = $result->fetch_assoc() && !empty($row['setting_value'])) {
        return $row['setting_value'];
    }
    
    return $default ? 'assets/images/logo-sm.png' : null;
}

function getLogoForPDF() {
    $logo = getCompanyLogo();
    
    // Get image dimensions
    list($width, $height) = getimagesize($logo);
    
    // Calculate ratio to maintain aspect ratio while fitting in PDF
    $maxWidth = 50; // Maximum width in PDF
    $ratio = $width / $maxWidth;
    $newHeight = $height / $ratio;
    
    return [
        'path' => $logo,
        'width' => $maxWidth,
        'height' => $newHeight
    ];
}
?>